/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.smartsockets.TipcException;
import com.smartsockets.TipcNotFoundException;
import com.smartsockets.TipcSrv;
import com.smartsockets.TipcSvc;
import com.starbase.starteam.EventHandlerProfile;
import com.starbase.starteam.MPXClient;
import com.starbase.starteam.MPXException;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Vector;

class MPXMessageBroker {
    private static Vector m_brokers = new Vector();
    private static final int SYNC_FREE = 0;
    private static final int SYNC_RUNNING = 1;
    private static final int SYNC_CHANGING = 2;
    private EventHandlerProfile m_profile = null;
    private TipcSrv m_server = null;
    private Thread m_thread = null;
    private Vector m_References = new Vector();
    private Object m_sync = new Object();
    private int m_syncState = 0;
    private int m_syncPending = 0;

    public static synchronized MPXMessageBroker connect(MPXClient mPXClient, EventHandlerProfile eventHandlerProfile) throws MPXException {
        Object object;
        MPXMessageBroker mPXMessageBroker = null;
        Enumeration enumeration = m_brokers.elements();
        while (enumeration.hasMoreElements()) {
            object = (MPXMessageBroker)enumeration.nextElement();
            if (!eventHandlerProfile.isEqualTo(object.m_profile)) continue;
            mPXMessageBroker = object;
            break;
        }
        if (mPXMessageBroker == null) {
            object = TipcSvc.createSrv();
            mPXMessageBroker = new MPXMessageBroker((TipcSrv)object);
            mPXMessageBroker.create(eventHandlerProfile);
            m_brokers.addElement(mPXMessageBroker);
        }
        mPXMessageBroker.addRef(mPXClient);
        return mPXMessageBroker;
    }

    public void ping() throws MPXException {
        TipcSrv tipcSrv = this.m_server;
        if (tipcSrv == null) {
            MPXException.throwNotConnectedException();
        }
        if (this.m_thread == null) {
            MPXException.throwMessageThreadException();
        }
    }

    public synchronized void disconnect(MPXClient mPXClient) {
        if (this.release(mPXClient) == 0) {
            m_brokers.removeElement(this);
        }
    }

    public TipcSrv getServer() {
        return this.m_server;
    }

    protected synchronized void addRef(MPXClient mPXClient) {
        this.m_References.addElement(mPXClient);
    }

    protected synchronized int release(MPXClient mPXClient) {
        this.m_References.removeElement(mPXClient);
        if (this.m_References.size() == 0) {
            if (this.m_server != null) {
                TipcSrv tipcSrv = this.m_server;
                this.m_server = null;
                try {
                    tipcSrv.destroy(2);
                }
                catch (TipcException tipcException) {
                    // empty catch block
                }
            }
            this.m_profile = null;
        }
        return this.m_References.size();
    }

    private void create(EventHandlerProfile eventHandlerProfile) throws MPXException {
        boolean bl = false;
        try {
            Object object;
            this.m_profile = eventHandlerProfile;
            String[] stringArray = eventHandlerProfile.getPropertyNames();
            int n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                Object object2 = eventHandlerProfile.getProperty((String)object);
                try {
                    this.m_server.setOption("ss." + (String)object, object2.toString());
                }
                catch (TipcNotFoundException tipcNotFoundException) {
                    // empty catch block
                }
                if (((String)object).equals("server_names") && object2.toString().startsWith("pgm:")) {
                    bl = true;
                }
                ++n;
            }
            if (!this.m_server.create(2)) {
                MPXException.throwConnectException();
            }
            MPXMessageBroker mPXMessageBroker = this;
            if (mPXMessageBroker == null) {
                throw null;
            }
            Thread thread = new Thread(new Runnable(mPXMessageBroker){
                private final /* synthetic */ MPXMessageBroker this$0;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    while (true) {
                        Object var2_1;
                        block6: {
                            MPXMessageBroker.access$0(this.this$0, true);
                            try {
                                TipcSrv tipcSrv = MPXMessageBroker.access$1(this.this$0);
                                if (tipcSrv != null) {
                                    try {
                                        tipcSrv.mainLoop(1.0);
                                    }
                                    catch (TipcException tipcException) {}
                                    break block6;
                                }
                                var2_1 = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                var2_1 = null;
                                MPXMessageBroker.access$0(this.this$0, false);
                                throw throwable;
                            }
                        }
                        var2_1 = null;
                        MPXMessageBroker.access$0(this.this$0, false);
                    }
                    MPXMessageBroker.access$0(this.this$0, false);
                    MPXMessageBroker.access$3(this.this$0, null);
                }
                {
                    this.this$0 = mPXMessageBroker;
                    this.constructor$0(mPXMessageBroker);
                }

                private final void constructor$0(MPXMessageBroker mPXMessageBroker) {
                }
            });
            thread.setDaemon(true);
            object = Thread.currentThread();
            int n2 = ((Thread)object).getPriority() + 1;
            int n3 = ((Thread)object).getThreadGroup().getMaxPriority();
            if (n2 > n3) {
                n2 = n3;
            }
            thread.setPriority(n2);
            thread.start();
            this.m_thread = thread;
        }
        catch (TipcException tipcException) {
            this.m_thread = null;
            if (bl) {
                MPXException.throwMulticastNotSupportedException();
            }
            MPXException.throwConnectException(tipcException.getErrNum(), tipcException.getMessage());
        }
    }

    private void setRunning(boolean bl) {
        this.setSyncState(1, bl);
    }

    public void setChanging(boolean bl) {
        this.setSyncState(2, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSyncState(int n, boolean bl) {
        while (true) {
            Object object = this.m_sync;
            synchronized (object) {
                if (bl && this.m_syncState == 0) {
                    if (this.m_syncPending == 0 || this.m_syncPending == n) {
                        this.m_syncState = n;
                        this.m_syncPending = 0;
                        return;
                    }
                } else if (!bl) {
                    if (this.m_syncState != n) {
                        Assert.internalError("MPXMessageBroker.setSyncState(), " + n + " != " + this.m_syncState);
                    }
                    this.m_syncState = 0;
                    return;
                }
                if (bl && this.m_syncPending == 0) {
                    this.m_syncPending = n;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static /* synthetic */ void access$0(MPXMessageBroker mPXMessageBroker, boolean bl) {
        mPXMessageBroker.setRunning(bl);
    }

    static /* synthetic */ TipcSrv access$1(MPXMessageBroker mPXMessageBroker) {
        return mPXMessageBroker.m_server;
    }

    static /* synthetic */ Thread access$2(MPXMessageBroker mPXMessageBroker) {
        return mPXMessageBroker.m_thread;
    }

    static /* synthetic */ void access$3(MPXMessageBroker mPXMessageBroker, Thread thread) {
        mPXMessageBroker.m_thread = thread;
    }

    private MPXMessageBroker(TipcSrv tipcSrv) {
        this.m_server = tipcSrv;
    }
}

