/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;

public class MPXException
extends Exception {
    private static final String EMPTY = "";
    private static final int E_FAIL = 0;
    public static final int E_NOT_INSTALLED = 1;
    public static final int E_NO_DEFAULT_PROFILE = 2;
    public static final int E_NO_SUCH_PROFILE = 3;
    public static final int E_CONNECT = 4;
    public static final int E_NOTCONNECTED = 5;
    public static final int E_NORESPONSE = 6;
    public static final int E_MESSAGETHREAD = 7;
    public static final int E_TRANSMITTER = 8;
    public static final int E_UNEXPECTED = 10;
    public static final int E_NOT_SUPPORTED = 11;
    public static final int E_MULTICAST_NOT_SUPPORTED = 12;
    public static final int E_MPX_BASE = 1000;
    private int m_nError = 0;

    private static String messageFor(String string, String string2) {
        if (string == null) {
            string = EMPTY;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        if (string.length() != 0 && string2.length() != 0) {
            string = string + " ";
        }
        return string + string2;
    }

    static void throwNotInstalledException() throws MPXException {
        throw new MPXException(1, Res.getString(ResIDs.MPX_IS_NOT_INSTALLED));
    }

    static void throwNotSupportedException() throws MPXException {
        throw new MPXException(11, Res.getString(ResIDs.MPX_IS_NOT_SUPPORTED));
    }

    static void throwMulticastNotSupportedException() throws MPXException {
        throw new MPXException(12, Res.getString(ResIDs.MPX_MULTICAST_IS_NOT_SUPPORTED));
    }

    static void throwNoDefaultClientProfileException() throws MPXException {
        throw new MPXException(2, Res.getString(ResIDs.DEFAULT_MPX_PROFILE_IS_MISSING));
    }

    static void throwNoSuchProfileException(String string) throws MPXException {
        throw new MPXException(3, Res.formatKey(ResIDs.MPX_PROFILE_IS_MISSING_FMT, new Object[]{string}));
    }

    static void throwConnectException() throws MPXException {
        String string = Res.getString(ResIDs.MPX_MESSAGE_BROKER_PROBLEM);
        throw new MPXException(4, string);
    }

    static void throwConnectException(int n, String string) throws MPXException {
        String string2 = Res.getString(ResIDs.MPX_MESSAGE_BROKER_PROBLEM);
        throw new MPXException(n + 1000, string2, string);
    }

    static void throwNotConnectedException() throws MPXException {
        throw new MPXException(5, Res.getString(ResIDs.MPX_MESSAGE_BROKER_NOT_CONNECTED));
    }

    static void throwNotRespondingException() throws MPXException {
        String string = Res.getString(ResIDs.MPX_MESSAGE_BROKER_NOT_RESPONDING);
        throw new MPXException(6, string);
    }

    static void throwNotRespondingException(int n, String string) throws MPXException {
        String string2 = Res.getString(ResIDs.MPX_MESSAGE_BROKER_NOT_RESPONDING);
        throw new MPXException(n + 1000, string2, string);
    }

    static void throwMessageThreadException() throws MPXException {
        throw new MPXException(7, Res.getString(ResIDs.MPX_MESSAGE_BROKER_THREAD_NOT_RESPONDING));
    }

    static void throwEventTransmitterNotRespondingException() throws MPXException {
        throw new MPXException(8, Res.getString(ResIDs.MPX_EVENT_TRANSMITTER_NOT_RESPONDING));
    }

    static void internalError(String string) throws MPXException {
        throw new MPXException(10, Res.formatKey(ResIDs.MPX_INTERNAL_ERROR_FMT, new Object[]{string}));
    }

    static void throwMPXException(int n, String string) throws MPXException {
        throw new MPXException(n + 1000, string);
    }

    public String getMessage() {
        return super.getMessage();
    }

    public int getErrorCode() {
        return this.m_nError;
    }

    private MPXException() {
    }

    private MPXException(int n, String string) {
        super(string);
        this.m_nError = n;
    }

    private MPXException(int n, String string, String string2) {
        super(MPXException.messageFor(string, string2));
        this.m_nError = n;
    }
}

