/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server_CacheManager;
import java.util.Vector;

class MPXEventQueue {
    private Vector m_events = new Vector();
    private EventThread m_thread = null;
    private int m_nReferences = 0;
    private Server_CacheManager m_source = null;

    public synchronized void start() {
        if (this.m_source != null) {
            if (this.m_thread == null) {
                MPXEventQueue mPXEventQueue = this;
                if (mPXEventQueue == null) {
                    throw null;
                }
                this.m_thread = mPXEventQueue.new EventThread();
                this.m_thread.setDaemon(true);
                this.m_thread.start();
                this.m_source.addEventQueue(this);
            }
            ++this.m_nReferences;
        }
    }

    public synchronized void stop() {
        if (this.m_nReferences > 0 && --this.m_nReferences == 0) {
            this.kill();
        }
    }

    synchronized void kill() {
        if (this.m_source != null) {
            this.m_source.removeEventQueue(this);
            this.m_source = null;
        }
        if (this.m_thread != null) {
            EventThread eventThread = this.m_thread;
            synchronized (eventThread) {
                this.m_thread.m_bRunning = false;
                this.m_thread.notify();
                this.m_thread = null;
            }
        }
    }

    public synchronized void postEvent(Runnable runnable) {
        Vector vector = this.m_events;
        synchronized (vector) {
            this.m_events.addElement(runnable);
        }
        if (this.m_thread != null) {
            EventThread eventThread = this.m_thread;
            synchronized (eventThread) {
                this.m_thread.notify();
            }
        }
    }

    public MPXEventQueue(Server_CacheManager server_CacheManager) {
        this.m_source = server_CacheManager;
    }

    class EventThread
    extends Thread {
        private boolean m_bRunning = true;

        public void run() {
            Runnable runnable;
            while ((runnable = this.getEvent()) != null) {
                try {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        System.out.println(Res.getString(ResIDs.UNCAUGHT_EXCEPTION_IN_EVENT_HANDLER));
                        System.out.println(throwable.getMessage());
                        throwable.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    System.out.println(Res.getString(ResIDs.UNCAUGHT_EXCEPTION_IN_EVENT_HANDLER));
                    System.out.println(exception.get_Message());
                    System.out.println(exception.get_StackTrace());
                }
                Thread.yield();
            }
        }

        private Runnable getEvent() {
            Runnable runnable = null;
            while (this.m_bRunning) {
                Object object = MPXEventQueue.this.m_events;
                synchronized (object) {
                    if (MPXEventQueue.this.m_events.size() > 0) {
                        runnable = (Runnable)MPXEventQueue.this.m_events.elementAt(0);
                        MPXEventQueue.this.m_events.removeElementAt(0);
                        Runnable runnable2 = runnable;
                        Object var3_5 = null;
                        return runnable2;
                    }
                }
                object = this;
                synchronized (object) {
                    if (MPXEventQueue.this.m_events.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            return runnable;
        }

        static /* synthetic */ boolean access$0(EventThread eventThread) {
            return eventThread.m_bRunning;
        }

        EventThread() {
        }
    }
}

