/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Cacheable;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.OLEDate;
import java.io.IOException;

class Label_Data
extends Cacheable {
    static final int ID = 1;
    static final int NAME = 2;
    static final int DESCRIPTION = 4;
    static final int WORKFLOW = 8;
    static final int TIME = 16;
    static final int REVISION_TIME = 32;
    static final int LABEL_TYPE = 256;
    static final int LOCK = 512;
    static final int NON_ITEM = 799;
    static final int ITEM = 819;
    static final int ALL_PROPS = -1;
    private int m_id = -1;
    private String m_name = "";
    private String m_description = "";
    private boolean m_bBuildLabel = false;
    private OLEDate m_time = new OLEDate(0.0);
    private OLEDate m_revTime = new OLEDate(0.0);
    private boolean m_bRevisionLabel = false;
    private boolean m_bDeleted = false;
    private boolean m_bLocked = false;
    private int m_modifiedMask = 0;

    int getID() {
        return this.m_id;
    }

    public boolean isEqualTo(Cacheable cacheable) {
        if (cacheable != null && cacheable instanceof Label_Data) {
            Label_Data label_Data = (Label_Data)cacheable;
            return this.m_id == label_Data.m_id && this.m_name.equals(label_Data.m_name) && this.m_description.equals(label_Data.m_description) && this.m_bBuildLabel == label_Data.m_bBuildLabel && this.m_time.equals(label_Data.m_time) && this.m_revTime.equals(label_Data.m_revTime) && this.m_bRevisionLabel == label_Data.m_bRevisionLabel && this.m_bDeleted == label_Data.m_bDeleted && this.m_bLocked == label_Data.m_bLocked;
        }
        return false;
    }

    void setID(int n) {
        this.m_id = n;
    }

    public boolean isNew() {
        return this.m_id == -1;
    }

    String getName() {
        return this.m_name;
    }

    void setName(String string) {
        this.m_name = string;
        this.m_modifiedMask |= 2;
    }

    String getDescription() {
        return this.m_description;
    }

    void setDescription(String string) {
        this.m_description = string;
        this.m_modifiedMask |= 4;
    }

    boolean isBuildLabel() {
        return this.m_bBuildLabel;
    }

    void setBuildLabel(boolean bl) {
        this.m_bBuildLabel = bl;
        this.m_modifiedMask |= 8;
    }

    OLEDate getTime() {
        return this.m_time;
    }

    void setTime(OLEDate oLEDate) {
        this.m_time = oLEDate;
        this.m_modifiedMask |= 0x10;
    }

    OLEDate getRevisionTime() {
        return this.m_revTime;
    }

    void setRevisionTime(OLEDate oLEDate) {
        this.m_revTime = oLEDate;
    }

    boolean isRevisionLabel() {
        return this.m_bRevisionLabel;
    }

    void setRevisionLabel(boolean bl) {
        this.m_bRevisionLabel = bl;
        this.m_modifiedMask |= 0x100;
    }

    boolean isDeleted() {
        return this.m_bDeleted;
    }

    void setDeleted(boolean bl) {
        this.m_bDeleted = bl;
    }

    boolean isLocked() {
        return this.m_bLocked;
    }

    void setLocked(boolean bl) {
        this.m_bLocked = bl;
        this.m_modifiedMask |= 0x200;
    }

    boolean isModified() {
        return this.m_modifiedMask != 0;
    }

    void clearModifiedMask() {
        this.m_modifiedMask = 0;
    }

    void readGuts(Command command) throws IOException {
        this.readGuts(command, 799);
    }

    void readGuts(Command command, int n) throws IOException {
        if ((n & 1) != 0) {
            this.m_id = command.readInt();
        }
        if ((n & 2) != 0) {
            this.m_name = command.readString();
        }
        if ((n & 4) != 0) {
            this.m_description = command.readString();
        }
        if ((n & 8) != 0) {
            this.m_bBuildLabel = command.readBoolean();
        }
        if ((n & 0x10) != 0) {
            this.m_time = new OLEDate(command.readTime());
        }
        this.m_revTime = (n & 0x20) != 0 ? new OLEDate(command.readTime()) : new OLEDate(this.m_time);
        if ((n & 0x100) != 0) {
            this.m_bRevisionLabel = command.readBoolean();
        }
        if (command.getRevisionLevel() >= 55 && (n & 0x200) != 0) {
            this.m_bLocked = command.readBoolean();
        }
    }

    void writeGuts(Command command) throws IOException {
        this.writeGuts(command, 799);
    }

    void writeGuts(Command command, int n) throws IOException {
        if ((n & 1) != 0) {
            command.writeInt(this.getID());
        }
        if ((n & 2) != 0) {
            command.writeString(this.getName());
        }
        if ((n & 4) != 0) {
            command.writeString(this.getDescription());
        }
        if ((n & 8) != 0) {
            command.writeBoolean(this.isBuildLabel());
        }
        if ((n & 0x10) != 0) {
            command.writeTime(this.getTime().getDoubleValue());
        }
        if ((n & 0x20) != 0) {
            command.writeTime(this.getRevisionTime().getDoubleValue());
        }
        if ((n & 0x100) != 0) {
            command.writeBoolean(this.isRevisionLabel());
        }
        if (command.getRevisionLevel() >= 55 && (n & 0x200) != 0) {
            command.writeBoolean(this.isLocked());
        }
    }

    Label_Data() {
    }
}

