/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ColumnInfo;
import com.starbase.starteam.File;
import com.starbase.starteam.Filter;
import com.starbase.starteam.Folder;
import com.starbase.starteam.FolderEventScope;
import com.starbase.starteam.FolderListManager;
import com.starbase.starteam.GroupNode;
import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.IItemListener;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemEventScope;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.ItemListSortCollection;
import com.starbase.starteam.Items;
import com.starbase.starteam.Label;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Query;
import com.starbase.starteam.QueryInfo;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ItemListManager {
    private static Hashtable m_NotInViewFilePathsToIDs = new Hashtable();
    private static Hashtable m_NotInViewFilePathsToItems = new Hashtable();
    static final int DIRTY_GROUPSORT = 0;
    static final int DIRTY_CONTEXT = 1;
    static final int DIRTY_QUERIES = 2;
    static final int DIRTY_PROPERTIES = 3;
    static final int DIRTY_FOLDERS = 4;
    private int m_nNextNotInViewFileID = -2;
    private boolean m_bIsFileType = false;
    private boolean m_bNotInViewFiles = false;
    private boolean m_bSyncStoredLocally = false;
    private Type m_type = null;
    private Server m_server = null;
    private FolderListManager m_folders = null;
    private Filter m_filter = null;
    private Filter m_previousFilter = null;
    private boolean m_bUserVisibleFoldersOnly = false;
    private Property[] m_extraCachedProperties = new Property[0];
    private String[] m_CachedPropertyNames = new String[0];
    private String m_FileName_propertyName = "";
    private String m_FileStatus_propertyName = "";
    private GroupNode[] m_nodes = new GroupNode[0];
    private ItemList m_items = new ItemList();
    private Hashtable m_itemIDs = new Hashtable();
    private boolean[] m_bDirtyFlags = new boolean[]{true, true, true, true, true};

    public Type getType() {
        return this.m_type;
    }

    public int getItemID(Item item) {
        if (this.m_bNotInViewFiles && item.isNew()) {
            Integer n = (Integer)m_NotInViewFilePathsToIDs.get(((File)item).getFullName());
            return n != null ? n : -1;
        }
        return item.getItemID();
    }

    public FolderListManager getFolderListManager() {
        return this.m_folders;
    }

    public void setFilter(Filter filter) {
        if (filter == null || filter.getType().isEqualTo(this.m_type)) {
            this.m_filter = filter;
            if (this.m_filter != null) {
                this.m_filter.registerIlm(this);
            }
        } else {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.FILTER_TYPE_MISMATCH_FMT, new Object[]{filter.getType().getDisplayName(), this.m_type.getDisplayName()}));
        }
        this.setDirtyFlag(0, true);
        this.setDirtyFlag(1, true);
        this.setDirtyFlag(2, true);
        this.setDirtyFlag(3, true);
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public void setExtraCachedProperties(Property[] propertyArray) {
        this.m_extraCachedProperties = propertyArray;
        this.setDirtyFlag(3, true);
    }

    public Property[] getExtraCachedProperties() {
        return this.m_extraCachedProperties;
    }

    public Property[] getCachedPropertiesForFilter() {
        if (this.m_filter == null) {
            return new Property[0];
        }
        return this.m_filter.getProperties();
    }

    public Property[] getAllCachedProperties() {
        Property[] propertyArray = this.getCachedPropertiesForFilter();
        Property[] propertyArray2 = this.getExtraCachedProperties();
        Property[] propertyArray3 = new Property[propertyArray.length + propertyArray2.length];
        System.arraycopy(propertyArray, 0, propertyArray3, 0, propertyArray.length);
        System.arraycopy(propertyArray2, 0, propertyArray3, propertyArray.length, propertyArray2.length);
        return Property.resolveAllDependencies(propertyArray3);
    }

    public Items getItems() {
        this.applyFilter();
        return this.m_items;
    }

    public Items getItemsForFolder(Folder folder, boolean bl) {
        ItemList itemList = new ItemList();
        Vector vector = new Vector();
        Folder.flattenFolderTree(folder, vector, bl ? -1 : 0);
        Enumeration enumeration = this.m_items.elements();
        while (enumeration.hasMoreElements()) {
            Item item = (Item)enumeration.nextElement();
            if (!vector.contains(item.getParentFolder())) continue;
            itemList.addItem(item);
        }
        return itemList;
    }

    public Item[] getItemsArray() {
        return ((ItemList)this.getItems()).toArray();
    }

    public Item[] getItemsArrayForFolder(Folder folder, boolean bl) {
        return ((ItemList)this.getItemsForFolder(folder, bl)).toArray();
    }

    public Item findItem(int n) {
        return (Item)this.m_itemIDs.get(new Integer(n));
    }

    public void refresh() {
        if (this.isRefreshRequired()) {
            this.m_folders.refresh();
            Folder[] folderArray = this.m_folders.getFolders();
            int n = 0;
            while (n < folderArray.length) {
                folderArray[n].refreshItems(this.m_type.getName(), this.getAllCachedPropertyNames(), 0);
                ++n;
            }
            this.clear();
        }
    }

    public boolean isRefreshRequired() {
        int n;
        Folder[] folderArray;
        if (!this.m_server.isMPXEnabled()) {
            return true;
        }
        if (this.m_filter != null) {
            folderArray = this.m_filter.getType();
            if (folderArray.getName() == folderArray.getServer().getTypeNames().FILE && ((n = this.m_filter.getContext()) == 2 || n == 3)) {
                return true;
            }
            if (!this.m_filter.isEqualTo(this.m_previousFilter)) {
                return true;
            }
        }
        if (this.m_folders.isRefreshRequired()) {
            return true;
        }
        folderArray = this.m_folders.getFolders();
        n = 0;
        while (n < folderArray.length) {
            if (folderArray[n].isRefreshItemsRequired(this.m_type.getName(), this.getAllCachedPropertyNames(), 0)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void clear() {
        this.m_nodes = new GroupNode[0];
        this.m_items = new ItemList();
        this.m_CachedPropertyNames = new String[0];
        this.m_itemIDs = new Hashtable();
        this.setDirtyFlag(4, true);
        this.setDirtyFlag(0, true);
        this.setDirtyFlag(1, true);
        this.setDirtyFlag(2, true);
        this.setDirtyFlag(3, true);
    }

    public void discard() {
        Folder[] folderArray = this.m_folders.getFolders();
        int n = 0;
        while (n < folderArray.length) {
            folderArray[n].discardItems(this.m_type.getName());
            ++n;
        }
        this.m_folders.discard();
        this.clear();
    }

    public Items selectByLabel(Label label) {
        ItemList itemList = new ItemList();
        int n = 0;
        while (n < this.m_items.size()) {
            Item item = this.m_items.getAt(n);
            Label[] labelArray = item.getAllLabels();
            int n2 = 0;
            while (n2 < labelArray.length) {
                if (labelArray[n2].getID() == label.getID()) {
                    itemList.addItem(item);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return itemList;
    }

    public Items selectByQuery(QueryInfo queryInfo) {
        ItemList itemList = new ItemList();
        int n = 0;
        while (n < this.m_items.size()) {
            Item item = this.m_items.getAt(n);
            if (queryInfo.evaluate(item)) {
                itemList.addItem(item);
            }
            ++n;
        }
        return itemList;
    }

    public boolean isGrouped() {
        GroupSortInfo[] groupSortInfoArray;
        return this.m_filter != null && (groupSortInfoArray = this.m_filter.getGroupSortInfo()).length > 0 && groupSortInfoArray[0].isGroup();
    }

    public GroupNode[] getItemGroups() {
        return this.m_nodes;
    }

    public int getVisibleLines() {
        if (!this.isGrouped()) {
            return this.m_items.size();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_nodes.length) {
            n += this.m_nodes[n2].getNumVisibleLines();
            ++n2;
        }
        return n;
    }

    public boolean isGroupNodeAtLine(int n) {
        Object object = this.getObjectAtLine(n);
        return object instanceof GroupNode;
    }

    public GroupNode getGroupNodeAtLine(int n) {
        Object object = this.getObjectAtLine(n);
        return object instanceof GroupNode ? (GroupNode)object : null;
    }

    public Item getItemAtLine(int n) {
        Object object = this.getObjectAtLine(n);
        return object instanceof Item ? (Item)object : null;
    }

    public String[] getFullDisplay() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        if (this.isGrouped()) {
            int n = 0;
            while (n < this.m_nodes.length) {
                this.getNodeDisplay(this.m_nodes[n], vector, 0);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.m_items.size()) {
                objectArray = new StringBuffer();
                this.appendProps(this.m_items.getAt(n), (StringBuffer)objectArray);
                vector.addElement(objectArray.toString());
                ++n;
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean getUserVisibleFoldersOnly() {
        return this.m_bUserVisibleFoldersOnly;
    }

    public void setUserVisibleFoldersOnly(boolean bl) {
        this.m_bUserVisibleFoldersOnly = bl;
    }

    public void addItemListener(IItemListener iItemListener) {
        View view = this.getFolderListManager().getView();
        Type type = this.getType();
        String[] stringArray = this.getAllCachedPropertyNames();
        ItemListManager itemListManager = this;
        if (itemListManager == null) {
            throw null;
        }
        MyItemScope myItemScope = itemListManager.new MyItemScope();
        view.addItemListener(iItemListener, type, stringArray, myItemScope);
    }

    public void removeItemListener(IItemListener iItemListener) {
        View view = this.getFolderListManager().getView();
        Type type = this.getType();
        ItemListManager itemListManager = this;
        if (itemListManager == null) {
            throw null;
        }
        MyItemScope myItemScope = itemListManager.new MyItemScope();
        view.removeItemListener(iItemListener, type, myItemScope);
    }

    void setDirtyFlag(int n, boolean bl) {
        this.m_bDirtyFlags[n] = bl;
    }

    private void applyFilter() {
        this.m_bNotInViewFiles = this.m_bIsFileType && this.m_filter != null && this.m_filter.getContext() != 1;
        this.getCandidates();
        this.selectItems();
        this.sortAndGroupItems();
        this.setDirtyFlag(4, false);
        this.setDirtyFlag(3, false);
        this.setDirtyFlag(2, false);
        this.setDirtyFlag(1, false);
        this.setDirtyFlag(0, false);
    }

    private void getCandidates() {
        boolean bl = true;
        if (this.m_bIsFileType && this.m_filter != null && this.m_filter.getContext() == 2) {
            bl = false;
        }
        if (bl) {
            this.getItemList();
            if (this.m_bDirtyFlags[4] || this.m_bDirtyFlags[3]) {
                this.m_items.populateNow(this.getAllCachedPropertyNames());
                if (this.needSpecialStatusHandling()) {
                    Vector vector = this.m_folders.getFoldersInVector();
                    this.m_type.getServer().refreshFolders(vector);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Folder folder = (Folder)enumeration.nextElement();
                        folder.setSyncAvailable(true);
                    }
                }
            }
        }
        if (this.m_bNotInViewFiles) {
            this.addNivFiles();
        }
    }

    private boolean needSpecialStatusHandling() {
        if (this.m_bIsFileType && !this.m_bSyncStoredLocally) {
            Property[] propertyArray = this.getAllCachedProperties();
            int n = 0;
            while (n < propertyArray.length) {
                Property property = propertyArray[n];
                if (property.getName().equals(this.m_FileStatus_propertyName)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void selectItems() {
        ItemList itemList = new ItemList();
        if ((this.m_bDirtyFlags[4] || this.m_bDirtyFlags[2]) && this.m_filter != null) {
            this.m_previousFilter = this.m_filter.copy();
            if (this.m_type.hasQueryForID(this.m_filter.getQueryID())) {
                QueryInfo queryInfo = this.m_type.getQueryForID(this.m_filter.getQueryID());
                Enumeration enumeration = this.m_items.elements();
                while (enumeration.hasMoreElements()) {
                    Item item = (Item)enumeration.nextElement();
                    if (queryInfo.evaluate(item)) {
                        itemList.addItem(item);
                        continue;
                    }
                    this.m_itemIDs.remove(new Integer(this.getItemID(item)));
                }
                this.m_items = itemList;
            }
        }
    }

    private void sortAndGroupItems() {
        if (this.m_filter != null && (this.m_bDirtyFlags[4] || this.m_bDirtyFlags[2] || this.m_bDirtyFlags[0])) {
            ItemListSortCollection itemListSortCollection = new ItemListSortCollection(this.m_items);
            itemListSortCollection.sort(this.m_filter.getGroupSortInfo());
            this.groupItems();
        }
    }

    private void groupItems() {
        if (this.m_items.size() == 0 || this.m_filter == null || this.m_filter.getGroupingDepth() == 0) {
            this.m_nodes = new GroupNode[0];
        } else {
            this.buildGroupNodes();
        }
    }

    private void buildGroupNodes() {
        Vector<GroupNode> vector = new Vector<GroupNode>();
        GroupSortInfo[] groupSortInfoArray = this.m_filter.getGroupSortInfo();
        int n = this.m_filter.getGroupingDepth();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        GroupNode[] groupNodeArray = new GroupNode[n];
        Property[] propertyArray = new Property[n];
        int n2 = 0;
        while (n2 < n) {
            propertyArray[n2] = this.m_type.propertyForPID(groupSortInfoArray[n2].getPropertyID());
            ++n2;
        }
        n2 = 0;
        while (n2 < this.m_items.size()) {
            this.getGroupingValues(this.m_items.getAt(n2), objectArray2, propertyArray, n);
            int n3 = this.findPropertyIndexForGroupBreak(objectArray, objectArray2, groupSortInfoArray, propertyArray, n);
            if (n3 == -1) {
                groupNodeArray[n - 1].increment();
            } else {
                int n4 = n3;
                while (n4 < n) {
                    String string = Res.formatKey(ResIDs.PROPERTY_DISPLAY_NAME_AND_VALUE_PAIR_FMT, new Object[]{propertyArray[n4].getDisplayName(), propertyArray[n4].getDisplayValue(objectArray2[n4])});
                    GroupNode groupNode = new GroupNode(string, n2, 0);
                    if (n4 != 0 && groupNodeArray[n4 - 1] != null) {
                        groupNodeArray[n4 - 1].addChild(groupNode);
                    }
                    if (n4 == n - 1) {
                        groupNode.increment();
                    }
                    if (n4 == 0) {
                        vector.addElement(groupNode);
                    }
                    groupNodeArray[n4] = groupNode;
                    ++n4;
                }
            }
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            ++n2;
        }
        this.m_nodes = new GroupNode[vector.size()];
        vector.copyInto(this.m_nodes);
    }

    private int findPropertyIndexForGroupBreak(Object[] objectArray, Object[] objectArray2, GroupSortInfo[] groupSortInfoArray, Property[] propertyArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (groupSortInfoArray[n2].compareValues(objectArray[n2], objectArray2[n2], propertyArray[n2]) != 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void getGroupingValues(Item item, Object[] objectArray, Property[] propertyArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = item.getByProperty(propertyArray[n2]);
            ++n2;
        }
    }

    private String[] getAllCachedPropertyNames() {
        if (this.m_bDirtyFlags[3]) {
            int n;
            Property[] propertyArray = this.getAllCachedProperties();
            boolean bl = false;
            if (this.needSpecialStatusHandling()) {
                bl = true;
                n = 0;
                while (n < propertyArray.length) {
                    Property property = propertyArray[n];
                    if (property.getName().equals(this.m_FileName_propertyName)) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
            this.m_CachedPropertyNames = new String[bl ? propertyArray.length + 1 : propertyArray.length];
            n = 0;
            while (n < propertyArray.length) {
                this.m_CachedPropertyNames[n] = propertyArray[n].getName();
                ++n;
            }
            if (bl) {
                this.m_CachedPropertyNames[propertyArray.length] = this.m_FileName_propertyName;
            }
        }
        return this.m_CachedPropertyNames;
    }

    private void getItemList() {
        if (this.m_bDirtyFlags[4] || this.m_bDirtyFlags[2]) {
            this.m_items = new ItemList();
            this.m_itemIDs = new Hashtable();
            Folder[] folderArray = this.m_folders.getFolders();
            if (folderArray.length > 0) {
                Object object;
                Vector<Object> vector = new Vector<Object>();
                int n = 0;
                while (n < folderArray.length) {
                    object = folderArray[n];
                    if (!this.m_bUserVisibleFoldersOnly || ((Folder)object).resolveUserVisible()) {
                        vector.addElement(object);
                    }
                    ++n;
                }
                String string = this.m_type.getName();
                object = Query.newBulkQueryContainedBy(string, vector);
                Vector vector2 = this.m_type.getServer().getItems((Query)object);
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    Item item = (Item)enumeration.nextElement();
                    this.m_items.addItem(item);
                    this.m_itemIDs.put(new Integer(this.getItemID(item)), item);
                }
            }
        }
    }

    private Object getObjectAtLine(int n) {
        if (n >= this.getVisibleLines()) {
            return null;
        }
        if (!this.isGrouped()) {
            return this.m_items.getAt(n);
        }
        return this.getObjAtLine(this.m_nodes, n);
    }

    private Object getObjAtLine(GroupNode[] groupNodeArray, int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < groupNodeArray.length) {
            GroupNode groupNode = groupNodeArray[n3];
            if (n2 == 0) {
                return groupNode;
            }
            int n4 = groupNode.getNumVisibleLines();
            if (n2 >= n4) {
                n2 -= n4;
            } else {
                if (groupNode.isLeafNode()) {
                    return this.m_items.getAt(groupNode.getStart() + n2 - 1);
                }
                return this.getObjAtLine(groupNode.getChildren(), n2 - 1);
            }
            ++n3;
        }
        return null;
    }

    private int getNodeDisplay(GroupNode groupNode, Vector vector, int n) {
        StringBuffer stringBuffer = this.prependTabs(n);
        stringBuffer.append(groupNode.getName() + " (" + groupNode.getLength() + " items)");
        vector.addElement(stringBuffer.toString());
        if (groupNode.isExpanded()) {
            int n2;
            ++n;
            if (groupNode.isLeafNode()) {
                int n3;
                n2 = n3 = groupNode.getStart();
                while (n2 < n3 + groupNode.getLength()) {
                    Item item = this.m_items.getAt(n2);
                    StringBuffer stringBuffer2 = this.prependTabs(n);
                    this.appendProps(item, stringBuffer2);
                    vector.addElement(stringBuffer2.toString());
                    ++n2;
                }
            } else {
                GroupNode[] groupNodeArray = groupNode.getChildren();
                n2 = 0;
                while (n2 < groupNodeArray.length) {
                    n = this.getNodeDisplay(groupNodeArray[n2], vector, n);
                    ++n2;
                }
            }
            --n;
        }
        return n;
    }

    private void appendProps(Item item, StringBuffer stringBuffer) {
        String string = " | ";
        if (this.m_filter != null) {
            ColumnInfo[] columnInfoArray = this.m_filter.getColumnInfo();
            int n = 0;
            while (n < columnInfoArray.length) {
                if (n > 0) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append(item.getDisplayValue(this.m_type.propertyForPID(columnInfoArray[n].getPropertyID())));
                ++n;
            }
        } else {
            Property[] propertyArray = this.m_type.getDescriptors();
            int n = 0;
            while (n < propertyArray.length) {
                if (n > 0) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append(item.getDisplayValue(propertyArray[n]));
                ++n;
            }
        }
    }

    private StringBuffer prependTabs(int n) {
        String string = "\t";
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        return stringBuffer;
    }

    private void addNivFiles() {
        if (this.m_bDirtyFlags[4] || this.m_bDirtyFlags[2]) {
            Folder[] folderArray = this.m_folders.getFolders();
            int n = 0;
            while (n < folderArray.length) {
                Folder folder = folderArray[n];
                if (!this.m_bUserVisibleFoldersOnly || folder.resolveUserVisible()) {
                    try {
                        this.addLocalFiles(folder);
                    }
                    catch (IOException iOException) {
                        throw new SDKRuntimeException(Res.getString(ResIDs.IO_EXCEPTION_ENCOUNTERED), iOException);
                    }
                }
                ++n;
            }
        }
    }

    private void addLocalFiles(Folder folder) throws IOException {
        File[] fileArray = folder.getNotInViewFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string = file.getFullName();
            Item item = this.getMappedNotInViewFile(file, string);
            this.m_items.addItem(item);
            this.m_itemIDs.put(new Integer(this.getItemID(item)), item);
            ++n;
        }
    }

    private Item getMappedNotInViewFile(Item item, String string) {
        Integer n = (Integer)m_NotInViewFilePathsToIDs.get(string);
        if (n == null) {
            m_NotInViewFilePathsToIDs.put(string, new Integer(this.m_nNextNotInViewFileID--));
            m_NotInViewFilePathsToItems.put(string, item);
        }
        return (Item)m_NotInViewFilePathsToItems.get(string);
    }

    public ItemListManager(Type type, FolderListManager folderListManager) {
        if (type == null) {
            Assert.nullArgument("Type");
        }
        if (folderListManager == null) {
            Assert.nullArgument("FolderListManager");
        }
        this.m_type = type;
        this.m_server = this.m_type.getServer();
        this.m_bSyncStoredLocally = this.m_server.isSyncStoredLocally();
        this.m_bIsFileType = this.m_type.getName().equals(this.m_server.getTypeNames().FILE);
        if (this.m_bIsFileType) {
            PropertyNames propertyNames = this.m_server.getPropertyNames();
            this.m_FileName_propertyName = propertyNames.FILE_NAME;
            this.m_FileStatus_propertyName = propertyNames.FILE_STATUS;
        }
        this.m_folders = folderListManager;
        this.m_folders.registerIlm(this);
    }

    private class MyItemScope
    implements ItemEventScope {
        private FolderEventScope m_scope = null;
        private ItemListManager m_parent = ItemListManager.this;

        public boolean isMyEvent(Folder folder, Item item) {
            if (folder == null || !this.m_scope.isMyEvent(folder)) {
                return false;
            }
            if (ItemListManager.this.getUserVisibleFoldersOnly() && !folder.resolveUserVisible()) {
                return false;
            }
            if (item == null) {
                return true;
            }
            if (ItemListManager.this.m_filter != null) {
                QueryInfo queryInfo;
                if (ItemListManager.this.m_bIsFileType && ItemListManager.this.m_filter.getContext() == 2) {
                    return false;
                }
                if (ItemListManager.this.m_type.hasQueryForID(ItemListManager.this.m_filter.getQueryID()) && !(queryInfo = ItemListManager.this.m_type.getQueryForID(ItemListManager.this.m_filter.getQueryID())).evaluate(item)) {
                    return false;
                }
            }
            return true;
        }

        public boolean isEqualTo(ItemEventScope itemEventScope) {
            if (itemEventScope != null && itemEventScope instanceof MyItemScope) {
                MyItemScope myItemScope = (MyItemScope)itemEventScope;
                return this.m_parent == myItemScope.m_parent;
            }
            return false;
        }

        MyItemScope() {
            this.m_scope = ItemListManager.this.getFolderListManager().getFolderEventScope();
        }
    }
}

