/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.Folder;
import com.starbase.starteam.FolderEvent;
import com.starbase.starteam.FolderEvent_Marshaler;
import com.starbase.starteam.FolderListener;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemEventScope;
import com.starbase.starteam.ItemIDEvent;
import com.starbase.starteam.ItemIDListener;
import com.starbase.starteam.ItemListEvent;
import com.starbase.starteam.ItemListEvent_Marshaler;
import com.starbase.starteam.ItemListListener;
import com.starbase.starteam.ItemListener;
import com.starbase.starteam.Item_CacheRefCollection;
import com.starbase.starteam.Item_Data;
import com.starbase.starteam.MPXEventMarshalerImpl;
import com.starbase.starteam.MPXItemEvent_Marshaler;
import com.starbase.starteam.MPXItemEvent_Source;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewAdapter;
import com.starbase.starteam.ViewEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ItemIDEvent_Marshaler
extends MPXEventMarshalerImpl
implements ItemListListener,
MPXItemEvent_Marshaler,
FolderListener {
    private static int[] EMPTY_IDS = new int[0];
    private View m_view = null;
    private Type m_type = null;
    private ItemListEvent_Marshaler m_source = null;
    private MPXItemEvent_Source m_items = null;
    private FolderEvent_Marshaler m_folders = null;
    private Vector m_listeners = new Vector();
    private String[] m_propertyNames = null;
    private Hashtable m_FolderIDtoItemList = new Hashtable();
    private Hashtable m_ItemIDtoFolder = new Hashtable();

    public synchronized void addListener(ItemIDListener itemIDListener, ItemEventScope itemEventScope) {
        ItemIDEvent_Marshaler itemIDEvent_Marshaler = this;
        if (itemIDEvent_Marshaler == null) {
            throw null;
        }
        this.m_listeners.addElement(itemIDEvent_Marshaler.new MyListener(itemIDListener, itemEventScope));
        if (this.m_listeners.size() == 1) {
            this.m_source.addListener(this, null);
            this.m_items.addMPXItemEventMarshaler(this);
            this.m_folders.addListener(this, null);
            this.init();
            this.getEventQueue().start();
        }
    }

    public synchronized void removeListener(ItemListener itemListener, ItemEventScope itemEventScope) {
        if (this.m_listeners.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (myListener.m_listener != itemListener || itemEventScope == null != (myListener.m_scope == null) || itemEventScope != null && !itemEventScope.isEqualTo(myListener.m_scope)) continue;
            this.m_listeners.removeElement(myListener);
            break;
        }
        if (this.m_listeners.size() == 0) {
            this.getEventQueue().stop();
            this.m_source.removeListener(this, null);
            this.m_items.removeMPXItemEventMarshaler(this);
            this.m_folders.removeListener(this, null);
        }
    }

    private synchronized void removeAll() {
        this.m_listeners.setSize(0);
        this.removeListener(null, null);
    }

    public synchronized void itemsChanged(ItemListEvent itemListEvent) {
        this.updateFolder(itemListEvent.getFolder(), false, true);
    }

    private void updateFolder(Folder folder, boolean bl, boolean bl2) {
        Vector vector = this.gatherItemLists(folder, bl);
        Item_CacheRefCollection.refresh(vector, this.m_propertyNames);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            this.updateItemList(item_CacheRefCollection, bl2);
        }
    }

    private void updateItemList(Item_CacheRefCollection item_CacheRefCollection, boolean bl) {
        Folder folder = item_CacheRefCollection.getFolder();
        int[] nArray = this.getItemIDs(item_CacheRefCollection);
        this.updateItemList(folder, nArray, bl);
    }

    private int[] getItemIDs(Item_CacheRefCollection item_CacheRefCollection) {
        Vector vector = item_CacheRefCollection.getRefs();
        int n = vector.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = ((Item)vector.elementAt(n2)).getItemID();
            ++n2;
        }
        return nArray;
    }

    private void updateItemList(Folder folder, int[] nArray, boolean bl) {
        Integer n;
        int[] nArray2 = this.getItemIDs(folder);
        Hashtable<Integer, Boolean> hashtable = new Hashtable<Integer, Boolean>(nArray2.length);
        int n2 = 0;
        while (n2 < nArray2.length) {
            hashtable.put(new Integer(nArray2[n2]), Boolean.TRUE);
            ++n2;
        }
        Hashtable<Integer, Boolean> hashtable2 = new Hashtable<Integer, Boolean>(nArray.length);
        int n3 = 0;
        while (n3 < nArray.length) {
            n = new Integer(nArray[n3]);
            hashtable2.put(n, Boolean.TRUE);
            if (!hashtable.containsKey(n)) {
                if (bl) {
                    this.onItemAdded(folder, n);
                }
                this.setFolderForItem(n, folder);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < nArray2.length) {
            n = new Integer(nArray2[n3]);
            if (!hashtable2.containsKey(n)) {
                if (bl) {
                    this.onItemRemoved(folder, n);
                }
                this.setFolderForItem(n, null);
            }
            ++n3;
        }
        this.setItemIDs(folder, nArray);
    }

    private void onItemAdded(Folder folder, int n) {
        ItemIDEvent itemIDEvent = new ItemIDEvent(n);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(folder, itemIDEvent)) continue;
            try {
                try {
                    myListener.m_listener.itemAdded(itemIDEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    private void onItemRemoved(Folder folder, int n) {
        ItemIDEvent itemIDEvent = new ItemIDEvent(n);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(folder, itemIDEvent)) continue;
            try {
                try {
                    myListener.m_listener.itemRemoved(itemIDEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    public void handleMPXItemEvent(int n, Item_Data item_Data) {
        Folder folder = this.getFolderForItemID(n);
        if (folder != null) {
            ItemIDEvent itemIDEvent = new ItemIDEvent(n);
            Enumeration enumeration = this.m_listeners.elements();
            while (enumeration.hasMoreElements()) {
                MyListener myListener = (MyListener)enumeration.nextElement();
                if (!myListener.isListener(folder, itemIDEvent)) continue;
                try {
                    try {
                        myListener.m_listener.itemChanged(itemIDEvent);
                    }
                    catch (Throwable throwable) {
                        this.onUncaughtEventHandlerException(throwable);
                    }
                }
                catch (Exception exception) {
                    this.onUncaughtEventHandlerException(exception);
                }
            }
        }
    }

    public synchronized void folderAdded(FolderEvent folderEvent) {
        Folder folder = folderEvent.getNewFolder();
        if (folder != null) {
            this.updateFolder(folder, false, true);
        }
    }

    public synchronized void folderChanged(FolderEvent folderEvent) {
    }

    public synchronized void folderMoved(FolderEvent folderEvent) {
    }

    public synchronized void folderRemoved(FolderEvent folderEvent) {
        Folder folder = folderEvent.getOldFolder();
        if (folder != null) {
            this.updateItemList(folder, EMPTY_IDS, true);
            this.setItemIDs(folder, null);
        }
    }

    private void init() {
        this.m_FolderIDtoItemList.clear();
        this.m_ItemIDtoFolder.clear();
        this.updateFolder(this.m_folders.getRootFolder(), true, false);
    }

    private Vector gatherItemLists(Folder folder, boolean bl) {
        Vector vector = new Vector();
        this.gatherItemLists(folder, vector, bl);
        return vector;
    }

    private void gatherItemLists(Folder folder, Vector vector, boolean bl) {
        Item_CacheRefCollection item_CacheRefCollection = new Item_CacheRefCollection(folder, this.m_type);
        vector.addElement(item_CacheRefCollection);
        if (bl) {
            Folder[] folderArray = folder.getSubFolders();
            int n = 0;
            while (n < folderArray.length) {
                this.gatherItemLists(folderArray[n], vector, true);
                ++n;
            }
        }
    }

    private int[] getItemIDs(Folder folder) {
        Integer n = new Integer(folder.getItemID());
        int[] nArray = (int[])this.m_FolderIDtoItemList.get(n);
        if (nArray == null) {
            nArray = EMPTY_IDS;
        }
        return nArray;
    }

    private void setItemIDs(Folder folder, int[] nArray) {
        Integer n = new Integer(folder.getItemID());
        if (nArray != null) {
            this.m_FolderIDtoItemList.put(n, nArray);
        } else {
            this.m_FolderIDtoItemList.remove(n);
        }
    }

    private void setFolderForItem(Integer n, Folder folder) {
        if (folder != null) {
            this.m_ItemIDtoFolder.put(n, folder);
        } else {
            this.m_ItemIDtoFolder.remove(n);
        }
    }

    private Folder getFolderForItemID(int n) {
        return this.getFolderForItemID(new Integer(n));
    }

    private Folder getFolderForItemID(Integer n) {
        return (Folder)this.m_ItemIDtoFolder.get(n);
    }

    static /* synthetic */ void access$0(ItemIDEvent_Marshaler itemIDEvent_Marshaler) {
        itemIDEvent_Marshaler.removeAll();
    }

    public ItemIDEvent_Marshaler(View view, Type type) {
        super(view.getServer());
        this.m_view = view;
        this.m_type = type;
        this.m_source = this.m_view.getItemListEventMarshaler(this.m_type);
        this.m_items = this.m_view.getViewConfigCacheManager().getItemTypeCacheManager(this.m_type).getItemCache();
        this.m_propertyNames = new String[1];
        this.m_propertyNames[0] = view.getServer().getPropertyNames().OBJECT_ID;
        this.m_folders = this.m_view.getFolderEventMarshaler();
        ItemIDEvent_Marshaler itemIDEvent_Marshaler = this;
        if (itemIDEvent_Marshaler == null) {
            throw null;
        }
        this.m_view.addViewListener(new ViewAdapter(itemIDEvent_Marshaler){
            private final /* synthetic */ ItemIDEvent_Marshaler this$0;

            public void viewDeleted(ViewEvent viewEvent) {
                ItemIDEvent_Marshaler.access$0(this.this$0);
            }
            {
                this.this$0 = itemIDEvent_Marshaler;
                this.constructor$0(itemIDEvent_Marshaler);
            }

            private final void constructor$0(ItemIDEvent_Marshaler itemIDEvent_Marshaler) {
            }
        });
    }

    private class MyListener {
        public ItemIDListener m_listener = null;
        public ItemEventScope m_scope = null;

        public boolean isListener(Folder folder, ItemIDEvent itemIDEvent) {
            if (this.m_scope == null) {
                return true;
            }
            return this.m_scope.isMyEvent(folder, null);
        }

        MyListener(ItemIDListener itemIDListener, ItemEventScope itemEventScope) {
            this.m_listener = itemIDListener;
            this.m_scope = itemEventScope;
        }
    }
}

