/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.Folder;
import com.starbase.starteam.FolderEvent;
import com.starbase.starteam.FolderEvent_Marshaler;
import com.starbase.starteam.FolderListener;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemEvent;
import com.starbase.starteam.ItemEventScope;
import com.starbase.starteam.ItemListEvent;
import com.starbase.starteam.ItemListEvent_Marshaler;
import com.starbase.starteam.ItemListListener;
import com.starbase.starteam.ItemListener;
import com.starbase.starteam.Item_CacheRefCollection;
import com.starbase.starteam.Item_Data;
import com.starbase.starteam.MPXEventMarshalerImpl;
import com.starbase.starteam.MPXItemEvent_Marshaler;
import com.starbase.starteam.MPXItemEvent_Source;
import com.starbase.starteam.Property;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewAdapter;
import com.starbase.starteam.ViewEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ItemEvent_Marshaler
extends MPXEventMarshalerImpl
implements ItemListListener,
MPXItemEvent_Marshaler,
FolderListener {
    private View m_view = null;
    private Type m_type = null;
    private String[] m_propertyNames = null;
    private ItemListEvent_Marshaler m_source = null;
    private MPXItemEvent_Source m_items = null;
    private FolderEvent_Marshaler m_folders = null;
    private Vector m_listeners = new Vector();
    private Hashtable m_itemLists = new Hashtable();
    private Hashtable m_allItems = new Hashtable();

    public synchronized void addListener(ItemListener itemListener, String[] stringArray, ItemEventScope itemEventScope) {
        ItemEvent_Marshaler itemEvent_Marshaler = this;
        if (itemEvent_Marshaler == null) {
            throw null;
        }
        this.m_listeners.addElement(itemEvent_Marshaler.new MyListener(itemListener, itemEventScope));
        this.cachePropertyNames(stringArray);
        if (this.m_listeners.size() == 1) {
            this.m_source.addListener(this, null);
            this.m_items.addMPXItemEventMarshaler(this);
            this.m_folders.addListener(this, null);
            this.initItemLists();
            this.getEventQueue().start();
        }
    }

    public synchronized void removeListener(ItemListener itemListener, ItemEventScope itemEventScope) {
        if (this.m_listeners.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (myListener.m_listener != itemListener || itemEventScope == null != (myListener.m_scope == null) || itemEventScope != null && !itemEventScope.isEqualTo(myListener.m_scope)) continue;
            this.m_listeners.removeElement(myListener);
            break;
        }
        if (this.m_listeners.size() == 0) {
            this.getEventQueue().stop();
            this.m_source.removeListener(this, null);
            this.m_items.removeMPXItemEventMarshaler(this);
            this.m_folders.removeListener(this, null);
        }
    }

    private synchronized void removeAll() {
        this.m_listeners.setSize(0);
        this.removeListener(null, null);
    }

    public synchronized void itemsChanged(ItemListEvent itemListEvent) {
        Object object;
        Vector vector;
        Object object2;
        this.waitForEvents();
        Vector vector2 = this.gatherItemLists(this.m_folders.getRootFolder());
        int n = vector2.size();
        Vector<Vector> vector3 = new Vector<Vector>(n);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Item_CacheRefCollection)enumeration.nextElement();
            Vector vector4 = ((Item_CacheRefCollection)object2).getRefs();
            vector = new Vector(vector4.size());
            object = vector4.elements();
            while (object.hasMoreElements()) {
                Item item = (Item)object.nextElement();
                Item item2 = item.copy();
                vector.addElement(item2);
            }
            vector3.addElement(vector);
        }
        this.refresh(vector2);
        object2 = new Hashtable();
        int n2 = 0;
        while (n2 < n) {
            vector = (Vector)vector3.elementAt(n2);
            object = ((Item_CacheRefCollection)vector2.elementAt(n2)).getRefs();
            this.findRemovedItems(vector, (Vector)object, (Hashtable)object2);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            vector = (Vector)vector3.elementAt(n2);
            object = ((Item_CacheRefCollection)vector2.elementAt(n2)).getRefs();
            this.findAddedItems(vector, (Vector)object, (Hashtable)object2);
            ++n2;
        }
    }

    private void waitForEvents() {
        Server_CacheManager server_CacheManager = this.m_view.getServer().getServerCacheManager();
        Thread thread = Thread.currentThread();
        int n = server_CacheManager.getMPXMessageCount();
        int n2 = 5;
        while (n2-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n3 = server_CacheManager.getMPXMessageCount();
            if (n3 <= n) break;
            n = n3;
        }
    }

    private void findRemovedItems(Vector vector, Vector vector2, Hashtable hashtable) {
        Object object;
        Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>(vector2.size());
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (Item)enumeration.nextElement();
            hashtable2.put(new Integer(((Item)object).getItemID()), object);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Item item = (Item)object.nextElement();
            if (hashtable2.get(new Integer(item.getItemID())) != null) continue;
            Item item2 = this.findItem(item.getItemID());
            if (item2 == null) {
                this.onItemRemoved(item);
                continue;
            }
            this.onItemMoved(item, item2);
            hashtable.put(new Integer(item2.getItemID()), item2);
        }
    }

    private void findAddedItems(Vector vector, Vector vector2, Hashtable hashtable) {
        Object object;
        Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Item)enumeration.nextElement();
            hashtable2.put(new Integer(((Item)object).getItemID()), object);
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            Item item = (Item)object.nextElement();
            if (hashtable2.get(new Integer(item.getItemID())) != null || hashtable.get(new Integer(item.getItemID())) != null) continue;
            this.onItemAdded(item);
        }
    }

    private void onItemAdded(Item item) {
        Item item2 = this.makeItemForEvent(item);
        ItemEvent itemEvent = new ItemEvent(null, item2);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(itemEvent)) continue;
            try {
                try {
                    myListener.m_listener.itemAdded(itemEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    private void onItemMoved(Item item, Item item2) {
        ItemEvent itemEvent = new ItemEvent(this.makeItemForEvent(item), this.makeItemForEvent(item2));
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(itemEvent)) continue;
            try {
                try {
                    myListener.m_listener.itemMoved(itemEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    private void onItemRemoved(Item item) {
        Item item2 = this.makeItemForEvent(item);
        ItemEvent itemEvent = new ItemEvent(item2, null);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            MyListener myListener = (MyListener)enumeration.nextElement();
            if (!myListener.isListener(itemEvent)) continue;
            try {
                try {
                    myListener.m_listener.itemRemoved(itemEvent);
                }
                catch (Throwable throwable) {
                    this.onUncaughtEventHandlerException(throwable);
                }
            }
            catch (Exception exception) {
                this.onUncaughtEventHandlerException(exception);
            }
        }
    }

    public void handleMPXItemEvent(int n, Item_Data item_Data) {
        Item item = this.findItem(n);
        if (item != null) {
            Item item2 = this.makeItemForEvent(item);
            item.setCachedObject(item_Data);
            Item item3 = this.makeItemForEvent(item);
            ItemEvent itemEvent = new ItemEvent(item2, item3);
            Enumeration enumeration = this.m_listeners.elements();
            while (enumeration.hasMoreElements()) {
                MyListener myListener = (MyListener)enumeration.nextElement();
                if (!myListener.isListener(itemEvent)) continue;
                try {
                    try {
                        myListener.m_listener.itemChanged(itemEvent);
                    }
                    catch (Throwable throwable) {
                        this.onUncaughtEventHandlerException(throwable);
                    }
                }
                catch (Exception exception) {
                    this.onUncaughtEventHandlerException(exception);
                }
            }
        }
    }

    private Item makeItemForEvent(Item item) {
        Item item2 = item.copy();
        item2.updateType(this.m_type);
        return item2;
    }

    public synchronized void folderAdded(FolderEvent folderEvent) {
        Folder folder = folderEvent.getNewFolder();
        if (folder != null) {
            Item_CacheRefCollection item_CacheRefCollection = this.getItemList(folder);
            this.refresh(item_CacheRefCollection);
            Enumeration enumeration = item_CacheRefCollection.getRefs().elements();
            while (enumeration.hasMoreElements()) {
                Item item = (Item)enumeration.nextElement();
                this.onItemAdded(item);
            }
        }
    }

    public synchronized void folderChanged(FolderEvent folderEvent) {
    }

    public synchronized void folderMoved(FolderEvent folderEvent) {
    }

    public synchronized void folderRemoved(FolderEvent folderEvent) {
        Item_CacheRefCollection item_CacheRefCollection;
        Folder folder = folderEvent.getOldFolder();
        if (folder != null && (item_CacheRefCollection = this.findItemList(folder.getItemID())) != null) {
            Enumeration enumeration = item_CacheRefCollection.getRefs().elements();
            while (enumeration.hasMoreElements()) {
                Item item = (Item)enumeration.nextElement();
                this.onItemRemoved(item);
                this.m_allItems.remove(new Integer(item.getItemID()));
            }
            this.m_itemLists.remove(new Integer(folder.getItemID()));
        }
    }

    private void initPropertyNames() {
        this.m_propertyNames = null;
        Property[] propertyArray = this.m_type.getDescriptors();
        if (propertyArray.length > 0) {
            if (propertyArray[0].isPrimaryDescriptor()) {
                this.m_propertyNames = new String[1];
                this.m_propertyNames[0] = propertyArray[0].getName();
            } else {
                this.m_propertyNames = new String[propertyArray.length];
                int n = 0;
                while (n < propertyArray.length) {
                    this.m_propertyNames[n] = propertyArray[n].getName();
                    ++n;
                }
            }
        }
    }

    private void cachePropertyNames(String[] stringArray) {
        if (this.m_propertyNames == null || stringArray == null || stringArray.length == 0) {
            this.m_propertyNames = null;
        } else {
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            int n = 0;
            while (n < this.m_propertyNames.length) {
                hashtable.put(this.m_propertyNames[n].toLowerCase(), Boolean.TRUE);
                ++n;
            }
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                if (!hashtable.containsKey(string.toLowerCase())) {
                    vector.addElement(string);
                }
                ++n2;
            }
            if (vector.size() > 0) {
                String[] stringArray2 = new String[this.m_propertyNames.length + vector.size()];
                int n3 = 0;
                while (n3 < this.m_propertyNames.length) {
                    stringArray2[n3] = this.m_propertyNames[n3];
                    ++n3;
                }
                n3 = 0;
                while (n3 < vector.size()) {
                    stringArray2[this.m_propertyNames.length + n3] = (String)vector.elementAt(n3);
                    ++n3;
                }
                this.m_propertyNames = stringArray2;
            }
        }
    }

    private void initItemLists() {
        this.m_itemLists.clear();
        this.refreshAll();
    }

    private void refreshAll() {
        this.m_allItems.clear();
        this.refresh(this.gatherItemLists(this.m_folders.getRootFolder()));
    }

    private void refresh(Item_CacheRefCollection item_CacheRefCollection) {
        Vector<Item_CacheRefCollection> vector = new Vector<Item_CacheRefCollection>();
        vector.addElement(item_CacheRefCollection);
        this.refresh(vector);
    }

    private void refresh(Vector vector) {
        Item item;
        Enumeration enumeration;
        Item_CacheRefCollection item_CacheRefCollection;
        Enumeration enumeration2;
        if (this.m_allItems.size() > 0) {
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                item_CacheRefCollection = (Item_CacheRefCollection)enumeration2.nextElement();
                enumeration = item_CacheRefCollection.getRefs().elements();
                while (enumeration.hasMoreElements()) {
                    item = (Item)enumeration.nextElement();
                    this.m_allItems.remove(new Integer(item.getItemID()));
                }
            }
        }
        Item_CacheRefCollection.refresh(vector, this.m_propertyNames);
        enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            item_CacheRefCollection = (Item_CacheRefCollection)enumeration2.nextElement();
            enumeration = item_CacheRefCollection.getRefs().elements();
            while (enumeration.hasMoreElements()) {
                item = (Item)enumeration.nextElement();
                this.m_allItems.put(new Integer(item.getItemID()), item);
            }
        }
    }

    private Vector gatherItemLists(Folder folder) {
        Vector vector = new Vector();
        this.gatherItemLists(folder, vector);
        return vector;
    }

    private void gatherItemLists(Folder folder, Vector vector) {
        Item_CacheRefCollection item_CacheRefCollection = this.getItemList(folder);
        if (item_CacheRefCollection.isRefreshRequired(null)) {
            vector.addElement(item_CacheRefCollection);
        }
        Folder[] folderArray = folder.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            this.gatherItemLists(folderArray[n], vector);
            ++n;
        }
    }

    private Item_CacheRefCollection getItemList(Folder folder) {
        Item_CacheRefCollection item_CacheRefCollection = this.findItemList(folder.getItemID());
        if (item_CacheRefCollection == null) {
            item_CacheRefCollection = new Item_CacheRefCollection(folder, this.m_type);
            this.m_itemLists.put(new Integer(folder.getItemID()), item_CacheRefCollection);
        }
        return item_CacheRefCollection;
    }

    private Item_CacheRefCollection findItemList(int n) {
        return (Item_CacheRefCollection)this.m_itemLists.get(new Integer(n));
    }

    public Item findItem(int n) {
        return (Item)this.m_allItems.get(new Integer(n));
    }

    static /* synthetic */ void access$0(ItemEvent_Marshaler itemEvent_Marshaler) {
        itemEvent_Marshaler.removeAll();
    }

    public ItemEvent_Marshaler(View view, Type type) {
        super(view.getServer());
        this.m_view = view;
        this.m_type = type;
        this.initPropertyNames();
        this.m_source = this.m_view.getItemListEventMarshaler(this.m_type);
        this.m_items = this.m_view.getViewConfigCacheManager().getItemTypeCacheManager(this.m_type).getItemCache();
        this.m_folders = this.m_view.getFolderEventMarshaler();
        ItemEvent_Marshaler itemEvent_Marshaler = this;
        if (itemEvent_Marshaler == null) {
            throw null;
        }
        this.m_view.addViewListener(new ViewAdapter(itemEvent_Marshaler){
            private final /* synthetic */ ItemEvent_Marshaler this$0;

            public void viewDeleted(ViewEvent viewEvent) {
                ItemEvent_Marshaler.access$0(this.this$0);
            }
            {
                this.this$0 = itemEvent_Marshaler;
                this.constructor$0(itemEvent_Marshaler);
            }

            private final void constructor$0(ItemEvent_Marshaler itemEvent_Marshaler) {
            }
        });
    }

    private class MyListener {
        public ItemListener m_listener = null;
        public ItemEventScope m_scope = null;

        public boolean isListener(ItemEvent itemEvent) {
            if (this.m_scope == null) {
                return true;
            }
            Item item = itemEvent.getNewItem();
            if (item != null && this.m_scope.isMyEvent(item.getParentFolder(), item)) {
                return true;
            }
            Item item2 = itemEvent.getOldItem();
            return item2 != null && this.m_scope.isMyEvent(item2.getParentFolder(), item2);
        }

        MyListener(ItemListener itemListener, ItemEventScope itemEventScope) {
            this.m_listener = itemListener;
            this.m_scope = itemEventScope;
        }
    }
}

