/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.vts.comm.Command;
import java.io.IOException;

public class ItemBehavior {
    public static final int BRANCH_STATE_BRANCHABLE = 0;
    public static final int BRANCH_STATE_BRANCHED = 1;
    public static final int BRANCH_STATE_ROOT = 2;
    public static final int BRANCH_STATE_NOT_SUPPORTED = 3;
    private boolean m_bFixedConfig = false;
    private ViewConfiguration m_ViewConfiguration = null;
    private boolean m_bBranchOnChange = false;
    private int m_nBranchState = 3;
    private int m_nItemID = -1;
    private boolean m_bUpdateConfig = false;
    private boolean m_bUpdateBranch = false;

    int getItemID() {
        return this.m_nItemID;
    }

    public boolean getFixConfig() {
        return this.m_bFixedConfig;
    }

    public ViewConfiguration getConfig() {
        return this.m_ViewConfiguration;
    }

    void setConfig(ViewConfiguration viewConfiguration) {
        this.m_ViewConfiguration = viewConfiguration;
        this.m_bFixedConfig = this.m_ViewConfiguration != null;
        this.m_bUpdateConfig = true;
    }

    public boolean getBranchOnChange() {
        return this.m_bBranchOnChange;
    }

    void setBranchOnChange(boolean bl) {
        this.m_bBranchOnChange = bl;
        this.m_bUpdateBranch = true;
    }

    public int getBranchState() {
        return this.m_nBranchState;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        String string = System.getProperty("line.separator");
        stringBuffer.append("  FixConfig: ");
        if (this.m_bFixedConfig) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(string);
        stringBuffer.append("  ViewConfiguration: ");
        if (this.m_ViewConfiguration != null) {
            stringBuffer.append(this.m_ViewConfiguration.toString());
        }
        stringBuffer.append(string);
        stringBuffer.append("  BranchOnChange: ");
        if (this.m_bBranchOnChange) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append(string);
        stringBuffer.append("  BranchState: ");
        switch (this.m_nBranchState) {
            case 0: {
                stringBuffer.append("BRANCH_STATE_BRANCHABLE");
                break;
            }
            case 1: {
                stringBuffer.append("BRANCH_STATE_BRANCHED");
                break;
            }
            case 2: {
                stringBuffer.append("BRANCH_STATE_ROOT");
                break;
            }
            case 3: {
                stringBuffer.append("BRANCH_STATE_NOT_SUPPORTED");
                break;
            }
            default: {
                stringBuffer.append("UNKNOWN!!!");
                break;
            }
        }
        return stringBuffer.toString();
    }

    void readGuts(Command command) throws IOException {
        this.m_bFixedConfig = command.readBoolean();
        this.m_ViewConfiguration = ViewConfiguration.createTip();
        this.m_ViewConfiguration.readGuts(command);
        this.m_bBranchOnChange = command.readBoolean();
        this.m_nBranchState = command.readInt();
        command.readBoolean();
        this.m_bUpdateConfig = false;
        this.m_bUpdateBranch = false;
    }

    void writeGuts(Command command) throws IOException {
        command.writeInt(this.m_nItemID);
        command.writeBoolean(this.m_bFixedConfig);
        ViewConfiguration viewConfiguration = this.m_ViewConfiguration == null ? ViewConfiguration.createTip() : this.m_ViewConfiguration;
        viewConfiguration.writeGuts(command);
        command.writeBoolean(this.m_bBranchOnChange);
        command.writeBoolean(false);
        command.writeBoolean(this.m_bUpdateConfig);
        command.writeBoolean(this.m_bUpdateBranch);
        this.m_bUpdateConfig = false;
        this.m_bUpdateBranch = false;
    }

    ItemBehavior(int n) {
        this.m_nItemID = n;
    }
}

