/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertySortCollection;

class IntArrayCollection
extends PropertySortCollection {
    private int[][] m_dest;
    private int[][] m_scratchpad;

    public void swap(int n, int n2) {
        int[] nArray = this.m_dest[n];
        this.m_dest[n] = this.m_dest[n2];
        this.m_dest[n2] = nArray;
    }

    public void copySequence(int n, int n2) {
        System.arraycopy(this.m_scratchpad, n, this.m_dest, n, n2);
    }

    public void setFromScratchpad(int n, int n2) {
        this.m_dest[n2] = this.m_scratchpad[n];
    }

    public void saveToScratchpad(int n, int n2) {
        this.m_scratchpad[n2] = this.m_dest[n];
    }

    public int compareScratchpad(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_scratchpad[n], this.m_scratchpad[n2]);
        }
        return this.comp(this.m_scratchpad[n2], this.m_scratchpad[n]);
    }

    public int compare(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_dest[n], this.m_dest[n2]);
        }
        return this.comp(this.m_dest[n2], this.m_dest[n]);
    }

    private int comp(int[] nArray, int[] nArray2) {
        if (nArray.length > nArray2.length) {
            return 1;
        }
        if (nArray.length < nArray2.length) {
            return -1;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] > nArray2[n]) {
                return 1;
            }
            if (nArray[n] < nArray2[n]) {
                return -1;
            }
            ++n;
        }
        return 0;
    }

    public IntArrayCollection(ItemList itemList, GroupSortInfo groupSortInfo, Property property) {
        super(itemList, groupSortInfo, property);
        this.m_bAscending = groupSortInfo.isAscending();
        int n = this.length();
        this.m_dest = new int[n][];
        this.m_scratchpad = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = (int[])itemList.getAt(n2).getByProperty(property);
            this.m_dest[n2] = nArray;
            this.m_scratchpad[n2] = nArray;
            ++n2;
        }
    }
}

