/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.IConfigOptions;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;

class IniConfigOptions
implements IConfigOptions {
    private Hashtable m_data = new Hashtable();

    public Enumeration keys() {
        return this.m_data.keys();
    }

    public String getOption(String string) {
        return (String)this.m_data.get(string);
    }

    public String getOption(String string, String string2) {
        return (String)this.m_data.get(this.makeKey(string, string2));
    }

    public void setOption(String string, String string2, String string3) {
        String string4;
        if (string2 == null) {
            Assert.nullArgument("String", "name");
        }
        if (string == null) {
            Assert.nullArgument("String", "category");
        }
        if ((string4 = this.makeKey(string, string2)).indexOf(61) != -1) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.OPTION_NAME_WITH_EQUAL_SIGN_FMT, new Object[]{string4}));
        }
        if (string3 == null) {
            this.m_data.remove(string4);
        } else {
            this.m_data.put(string4, string3);
        }
    }

    private void removeOption(String string) {
        this.m_data.remove(string);
    }

    private String makeKey(String string, String string2) {
        return string + "::" + string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(File file) throws IOException {
        if (file == null) return;
        if (!file.exists()) return;
        Hashtable hashtable = (Hashtable)this.m_data.clone();
        BufferedReader bufferedReader = null;
        try {
            try {
                try {
                    this.m_data.clear();
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), "8859_1"));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        this.processLine(string);
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    this.m_data = hashtable;
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    this.m_data = hashtable;
                    throw runtimeException;
                }
                Object var5_8 = null;
                if (bufferedReader == null) return;
            }
            catch (Exception exception) {
                SDKRuntimeException sDKRuntimeException = new SDKRuntimeException(exception.get_Message());
                this.m_data = hashtable;
                throw sDKRuntimeException;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    private void processLine(String string) {
        if ((string = this.trimLeft(string)).length() != 0 && string.charAt(0) != ';' && string.charAt(0) != '[') {
            int n = string.indexOf(61);
            if (n != -1) {
                if (n == string.length() - 1) {
                    if (n != 0) {
                        this.m_data.put(string.substring(0, string.length() - 1), "");
                    }
                } else if (n != 0) {
                    this.m_data.put(string.substring(0, n), string.substring(n + 1));
                }
            } else {
                this.m_data.put(string, "");
            }
        }
    }

    private boolean isWS(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private String trimLeft(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!this.isWS(c) || !bl) {
                bl = false;
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void save(File file) throws IOException {
        if (file != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "8859_1"));
                String string = "\r\n";
                bufferedWriter.write("[StarTeam]" + string);
                Enumeration enumeration = this.m_data.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)this.m_data.get(string2);
                    bufferedWriter.write(string2);
                    bufferedWriter.write(61);
                    bufferedWriter.write(string3);
                    bufferedWriter.write(string);
                }
            }
            finally {
                Object var4_7 = null;
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
    }
}

