/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.vts.comm.Command;
import java.io.IOException;

public class HiveInfo {
    private int m_ID = -1;
    private int m_hiveType = 0;
    private String m_name = "";
    private String m_rootDirectory = "";
    private String m_cacheDirectory = "";
    private String m_archiveDirectory = "";
    private String m_rootCacheAgentArchiveDirectory = "";
    private boolean m_bAllowNewArchives = false;
    private int m_storageLimitThreshold = -1;
    private long m_maxCacheSize = -1L;
    private int m_cacheCleanupInterval = -1;

    public int getID() {
        return this.m_ID;
    }

    public int getType() {
        return this.m_hiveType;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getRootDirectory() {
        return this.m_rootDirectory;
    }

    public void setRootDirectory(String string) {
        this.m_rootDirectory = string;
    }

    public String getCacheDirectory() {
        return this.m_cacheDirectory;
    }

    public void setCacheDirectory(String string) {
        this.m_cacheDirectory = string;
    }

    public String getArchiveDirectory() {
        return this.m_archiveDirectory;
    }

    public void setArchiveDirectory(String string) {
        this.m_archiveDirectory = string;
    }

    public String getRootCacheAgentArchiveDirectory() {
        return this.m_rootCacheAgentArchiveDirectory;
    }

    public void setRootCacheAgentArchiveDirectory(String string) {
        this.m_rootCacheAgentArchiveDirectory = string;
    }

    public long getMaxCacheSize() {
        return this.m_maxCacheSize;
    }

    public void setMaxCacheSize(long l) {
        this.m_maxCacheSize = l;
    }

    public int getCacheCleanupInterval() {
        return this.m_cacheCleanupInterval;
    }

    public void setCacheCleanupInterval(int n) {
        this.m_cacheCleanupInterval = n;
    }

    public int getStorageLimitThreshold() {
        return this.m_storageLimitThreshold;
    }

    public void setStorageLimitThreshold(int n) {
        this.m_storageLimitThreshold = n;
    }

    public boolean getAllowNewArchives() {
        return this.m_bAllowNewArchives;
    }

    public void setAllowNewArchives(boolean bl) {
        this.m_bAllowNewArchives = bl;
    }

    public boolean isEqualTo(HiveInfo hiveInfo) {
        if (this == hiveInfo) {
            return true;
        }
        return this.getID() == hiveInfo.getID() && this.getType() == hiveInfo.getType() && this.getName().equals(hiveInfo.getName()) && this.getRootDirectory().equals(hiveInfo.getRootDirectory()) && this.getCacheDirectory().equals(hiveInfo.getCacheDirectory()) && this.getArchiveDirectory().equals(hiveInfo.getArchiveDirectory()) && this.getRootCacheAgentArchiveDirectory().equals(hiveInfo.getRootCacheAgentArchiveDirectory()) && this.getMaxCacheSize() == hiveInfo.getMaxCacheSize() && this.getCacheCleanupInterval() == hiveInfo.getCacheCleanupInterval() && this.getStorageLimitThreshold() == hiveInfo.getStorageLimitThreshold() && this.getAllowNewArchives() == hiveInfo.getAllowNewArchives();
    }

    public String toString() {
        String[] stringArray = new String[]{"UNKNOWN", "PVCS", "VSS", "NativeII"};
        StringBuffer stringBuffer = new StringBuffer(500);
        String string = System.getProperty("line.separator");
        stringBuffer.append(" ID: " + this.getID() + string);
        int n = this.getType();
        stringBuffer.append(" Type: " + stringArray[n] + string);
        stringBuffer.append(" Name: " + this.getName() + string);
        stringBuffer.append(" Root directory: " + this.getRootDirectory() + string);
        stringBuffer.append(" Cache directory: " + this.getCacheDirectory() + string);
        stringBuffer.append(" Archive directory: " + this.getArchiveDirectory() + string);
        stringBuffer.append(" Root cache agent archive directory: " + this.getRootCacheAgentArchiveDirectory() + string);
        stringBuffer.append(" Max cache size: " + this.getMaxCacheSize() + string);
        stringBuffer.append(" Cache refresh interval: " + this.getCacheCleanupInterval() + string);
        stringBuffer.append(" Storage limit threshold: " + this.getStorageLimitThreshold() + string);
        stringBuffer.append(" Allow new archives: " + this.getAllowNewArchives() + string);
        return stringBuffer.toString();
    }

    static HiveInfo[] readHiveInfoArray(Command command) throws IOException {
        int n = command.readInt();
        HiveInfo[] hiveInfoArray = new HiveInfo[n];
        int n2 = 0;
        while (n2 < n) {
            hiveInfoArray[n2] = HiveInfo.readGuts(command);
            ++n2;
        }
        return hiveInfoArray;
    }

    static HiveInfo readGuts(Command command) throws IOException {
        HiveInfo hiveInfo = new HiveInfo();
        hiveInfo.m_ID = command.readInt();
        hiveInfo.m_hiveType = command.readInt();
        hiveInfo.m_name = command.readString();
        hiveInfo.m_rootDirectory = command.readString();
        hiveInfo.m_cacheDirectory = command.readString();
        hiveInfo.m_archiveDirectory = command.readString();
        hiveInfo.m_rootCacheAgentArchiveDirectory = command.readString();
        hiveInfo.m_maxCacheSize = command.readLong();
        hiveInfo.m_cacheCleanupInterval = command.readInt();
        hiveInfo.m_storageLimitThreshold = command.readInt();
        hiveInfo.m_bAllowNewArchives = command.readBoolean();
        return hiveInfo;
    }

    static void writeHiveInfoArray(Command command, HiveInfo[] hiveInfoArray) throws IOException {
        int n = hiveInfoArray.length;
        command.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            hiveInfoArray[n2].writeGuts(command);
            ++n2;
        }
    }

    void writeGuts(Command command) throws IOException {
        command.writeInt(this.m_ID);
        command.writeInt(this.m_hiveType);
        command.writeString(this.m_name);
        command.writeString(this.m_rootDirectory);
        command.writeString(this.m_cacheDirectory);
        command.writeString(this.m_archiveDirectory);
        command.writeString(this.m_rootCacheAgentArchiveDirectory);
        command.writeLong(this.m_maxCacheSize);
        command.writeInt(this.m_cacheCleanupInterval);
        command.writeInt(this.m_storageLimitThreshold);
        command.writeBoolean(this.m_bAllowNewArchives);
    }

    HiveInfo() {
    }

    public HiveInfo(int n, String string, String string2, String string3, String string4, String string5, boolean bl, int n2, long l, int n3) {
        this(-1, n, string, string2, string3, string4, string5, bl, n2, l, n3);
    }

    HiveInfo(int n, int n2, String string, String string2, String string3, String string4, String string5, boolean bl, int n3, long l, int n4) {
        this.m_ID = n;
        this.m_hiveType = n2;
        this.m_name = string;
        this.m_rootDirectory = string2;
        this.m_cacheDirectory = string3;
        this.m_archiveDirectory = string4;
        this.m_rootCacheAgentArchiveDirectory = string5;
        this.m_bAllowNewArchives = bl;
        this.m_storageLimitThreshold = n3;
        this.m_maxCacheSize = l;
        this.m_cacheCleanupInterval = n4;
    }

    public static interface HiveType {
        public static final int eUNKNOWN = 0;
        public static final int ePVCS = 1;
        public static final int eVSS = 2;
        public static final int eNativeII = 3;
    }
}

