/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Property;
import com.starbase.starteam.vts.pickle.Variant;

public class GroupSortInfo {
    private static final int E_BYTEXTVALUE = 1;
    private static final int E_COMPARENOCASE = 16;
    private static final int E_DATEONLY = 256;
    private static final int E_SORT = 1;
    private static final int E_GROUP = 16;
    private static final int E_ASCENDING = 256;
    private static final int E_DESCENDING = 4096;
    private boolean m_group = false;
    private int m_propID = -1;
    private boolean m_ascending = true;
    private boolean m_dateOnly = false;
    private boolean m_caseSensitive = false;
    private boolean m_byText = false;

    GroupSortInfo copy() {
        GroupSortInfo groupSortInfo = new GroupSortInfo(this.m_group, this.m_propID, this.m_ascending);
        groupSortInfo.setCaseSensitive(this.isCaseSensitive());
        groupSortInfo.setByDateOnly(this.isByDateOnly());
        groupSortInfo.setByTextValue(this.isByTextValue());
        return groupSortInfo;
    }

    public boolean isSort() {
        return !this.m_group;
    }

    public boolean isGroup() {
        return this.m_group;
    }

    public int getPropertyID() {
        return this.m_propID;
    }

    public void setPropertyID(int n) {
        this.m_propID = n;
    }

    public boolean isAscending() {
        return this.m_ascending;
    }

    public void setAscending(boolean bl) {
        this.m_ascending = bl;
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.m_caseSensitive = bl;
    }

    public boolean isByTextValue() {
        return this.m_byText;
    }

    public void setByTextValue(boolean bl) {
        this.m_byText = bl;
    }

    public boolean isByDateOnly() {
        return this.m_dateOnly;
    }

    public void setByDateOnly(boolean bl) {
        this.m_dateOnly = bl;
    }

    int getCompareMask() {
        int n = 0;
        if (this.isByTextValue()) {
            n |= 1;
        }
        if (!this.isCaseSensitive()) {
            n |= 0x10;
        }
        if (this.isByDateOnly()) {
            n |= 0x100;
        }
        return n;
    }

    int getTypeMask() {
        int n = 0;
        n = this.isSort() ? (n |= 1) : (n |= 0x10);
        n = this.isAscending() ? (n |= 0x100) : (n |= 0x1000);
        return n;
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + (this.isSort() ? "sort" : "group"));
        stringBuffer.append(", " + (this.isAscending() ? "ascending" : "descending"));
        stringBuffer.append(", propID=0x" + Integer.toHexString(this.m_propID));
        if (this.isByDateOnly()) {
            stringBuffer.append(", date-only");
        }
        if (this.isByTextValue()) {
            stringBuffer.append(", by-text");
        }
        if (!this.isCaseSensitive()) {
            stringBuffer.append(", no-case");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    int compareValues(Object object, Object object2, Property property) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        int n = property.getTypeCode();
        int n2 = 0;
        if (this.isByTextValue() && (n == 3 || n == 10 || n == 4 || n == 2)) {
            String string = property.getDisplayValue(object);
            String string2 = property.getDisplayValue(object2);
            n2 = Variant.compare(string, string2, this.isByDateOnly(), !this.isCaseSensitive());
        } else {
            n2 = Variant.compare(object, object2, this.isByDateOnly(), !this.isCaseSensitive());
        }
        return this.isAscending() ? n2 : n2 * -1;
    }

    boolean isEqualTo(GroupSortInfo groupSortInfo) {
        if (groupSortInfo != null) {
            return this.isGroup() == groupSortInfo.isGroup() && this.getPropertyID() == groupSortInfo.getPropertyID() && this.isAscending() == groupSortInfo.isAscending() && this.isByDateOnly() == groupSortInfo.isByDateOnly() && this.isCaseSensitive() == groupSortInfo.isCaseSensitive() && this.isByTextValue() == groupSortInfo.isByTextValue();
        }
        return false;
    }

    public GroupSortInfo(boolean bl, int n, boolean bl2) {
        this.m_group = bl;
        this.m_propID = n;
        this.m_ascending = bl2;
    }

    GroupSortInfo(int n, int n2, int n3) {
        this.m_propID = n2;
        this.m_group = (n & 0x10) != 0;
        this.m_ascending = (n & 0x100) != 0;
        this.m_dateOnly = (n3 & 0x100) != 0;
        this.m_caseSensitive = (n3 & 0x10) == 0;
        this.m_byText = (n3 & 1) != 0;
    }
}

