/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import java.util.Hashtable;

public class ForeignPasswordException
extends ServerException {
    private static final int VSS_PROJECT_PASSWORD_REQUIRED = 214;
    private static final String VSS_PROJECT_PASSWORD_REQUIRED_NAME = "CStVSSException";
    private static final int PVCS_PROJECT_PASSWORD_REQUIRED = 215;
    private static final String VSS_ARCHIVE_PASSWORD_REQUIRED_NAME = "CStVssArchiveException";
    private static final int VSS_ARCHIVE_PASSWORD_REQUIRED = 216;
    private static final String PVCS_PROJECT_PASSWORD_REQUIRED_NAME = "CStPVCSException";
    private static final int PVCS_ARCHIVE_PASSWORD_REQUIRED = 217;
    private static final String PVCS_ARCHIVE_PASSWORD_REQUIRED_NAME = "CStPvcsArchiveException";
    private String m_configPath = null;
    private int m_projectType = 0;
    private boolean m_bIsPVCS = false;
    private boolean m_bIsVSS = false;

    static ForeignPasswordException get(Server server, String string, String string2, int n, String string3, boolean bl, double d, int n2, Hashtable hashtable) {
        ForeignPasswordException foreignPasswordException = ForeignPasswordException.forPVCSError(server, string, string2, n, string3, bl, d, n2, hashtable);
        if (foreignPasswordException != null) {
            return foreignPasswordException;
        }
        foreignPasswordException = ForeignPasswordException.forVSSError(server, string, string2, n, string3, bl, d, n2, hashtable);
        if (foreignPasswordException != null) {
            return foreignPasswordException;
        }
        return null;
    }

    private static ForeignPasswordException forPVCSError(Server server, String string, String string2, int n, String string3, boolean bl, double d, int n2, Hashtable hashtable) {
        if (ServerException.isExceptionClass(string, PVCS_PROJECT_PASSWORD_REQUIRED_NAME) && n == 215 || ServerException.isExceptionClass(string, PVCS_ARCHIVE_PASSWORD_REQUIRED_NAME) && n == 217) {
            ForeignPasswordException foreignPasswordException = new ForeignPasswordException(string, string2, n, string3, bl, d, n2, hashtable);
            foreignPasswordException.m_projectType = server.getPropertyEnums().PROJECT_TYPE_PVCS;
            foreignPasswordException.m_bIsPVCS = true;
            return foreignPasswordException;
        }
        return null;
    }

    private static ForeignPasswordException forVSSError(Server server, String string, String string2, int n, String string3, boolean bl, double d, int n2, Hashtable hashtable) {
        if (ServerException.isExceptionClass(string, VSS_PROJECT_PASSWORD_REQUIRED_NAME) && n == 214 || ServerException.isExceptionClass(string, VSS_ARCHIVE_PASSWORD_REQUIRED_NAME) && n == 216) {
            ForeignPasswordException foreignPasswordException = new ForeignPasswordException(string, string2, n, string3, bl, d, n2, hashtable);
            foreignPasswordException.m_projectType = server.getPropertyEnums().PROJECT_TYPE_VISUAL_SOURCESAFE;
            foreignPasswordException.m_bIsVSS = true;
            return foreignPasswordException;
        }
        return null;
    }

    public String getConfigPath() {
        return this.m_configPath;
    }

    public int getProjectType() {
        return this.m_projectType;
    }

    public boolean isPVCS() {
        return this.m_bIsPVCS;
    }

    public boolean isVSS() {
        return this.m_bIsVSS;
    }

    private ForeignPasswordException(String string, String string2, int n, String string3, boolean bl, double d, int n2, Hashtable hashtable) {
        super(string, string2, n, string3, bl, d, n2, hashtable);
        this.m_configPath = (String)hashtable.get("CfgIni");
        Object[] objectArray = new Object[]{this.m_configPath};
        this.setErrorMessage(Res.formatKey(ResIDs.BLANK_FOREIGN_PW_REQUIRED_FMT, objectArray));
    }
}

