/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.FolderEventScope;
import com.starbase.starteam.IFolderListener;
import com.starbase.starteam.ItemListManager;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.View;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FolderListManager {
    private View m_view = null;
    private Hashtable m_excludableFolderList = new Hashtable();
    private boolean m_bListPopulated = false;
    private Vector m_folderOperationList = new Vector();
    private Hashtable m_ilms = new Hashtable();

    public View getView() {
        return this.m_view;
    }

    public void includeFolder(Folder folder) {
        this.includeFolders(folder, 0);
    }

    private void checkView(Folder folder) {
        if (!this.m_view.equals(folder.getView())) {
            throw new IllegalArgumentException(Res.getString(ResIDs.MISMATCH_VIEW_FOLDERS));
        }
    }

    public void includeFolders(Folder folder, int n) {
        this.checkView(folder);
        Vector vector = this.m_folderOperationList;
        synchronized (vector) {
            FolderListManager folderListManager = this;
            if (folderListManager == null) {
                throw null;
            }
            this.m_folderOperationList.addElement(folderListManager.new FolderOperation(folder.getItemID(), n, false));
        }
        this.m_bListPopulated = false;
        this.setIlmsDirty();
    }

    public void excludeFolder(Folder folder) {
        this.excludeFolders(folder, 0);
    }

    public void excludeFolders(Folder folder, int n) {
        this.checkView(folder);
        Vector vector = this.m_folderOperationList;
        synchronized (vector) {
            FolderListManager folderListManager = this;
            if (folderListManager == null) {
                throw null;
            }
            this.m_folderOperationList.addElement(folderListManager.new FolderOperation(folder.getItemID(), n, true));
        }
        this.m_bListPopulated = false;
        this.setIlmsDirty();
    }

    public void clear() {
        Vector vector = this.m_folderOperationList;
        synchronized (vector) {
            this.m_folderOperationList.setSize(0);
        }
        this.clearCachedFolderList();
        this.setIlmsDirty();
    }

    void runOperation(Folder folder, int n, boolean bl) {
        Integer n2 = new Integer(folder.getItemID());
        ExcludableFolder excludableFolder = (ExcludableFolder)this.m_excludableFolderList.get(n2);
        if (excludableFolder == null) {
            FolderListManager folderListManager = this;
            if (folderListManager == null) {
                throw null;
            }
            this.m_excludableFolderList.put(n2, folderListManager.new ExcludableFolder(folder, bl));
        } else {
            excludableFolder.setExcludeFlag(bl);
        }
        if (n == 0) {
            return;
        }
        int n3 = n == -1 ? -1 : n - 1;
        Folder[] folderArray = folder.getSubFolders();
        int n4 = 0;
        while (n4 < folderArray.length) {
            this.runOperation(folderArray[n4], n3, bl);
            ++n4;
        }
    }

    void populateExcludableList() {
        Vector vector = this.m_folderOperationList;
        synchronized (vector) {
            int n = this.m_folderOperationList.size();
            int n2 = 0;
            while (n2 < n) {
                FolderOperation folderOperation = (FolderOperation)this.m_folderOperationList.elementAt(n2);
                Folder folder = this.m_view.findFolder(folderOperation.m_nItemID);
                if (folder != null) {
                    this.runOperation(folder, folderOperation.m_nLevel, folderOperation.m_bExcluded);
                }
                ++n2;
            }
        }
        this.m_bListPopulated = true;
    }

    public Folder[] getFolders() {
        Vector vector = this.getFoldersInVector();
        Object[] objectArray = new Folder[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Vector getFoldersInVector() {
        if (!this.m_bListPopulated) {
            this.populateExcludableList();
        }
        Vector<Folder> vector = new Vector<Folder>();
        Enumeration enumeration = this.m_excludableFolderList.keys();
        while (enumeration.hasMoreElements()) {
            ExcludableFolder excludableFolder = (ExcludableFolder)this.m_excludableFolderList.get(enumeration.nextElement());
            if (excludableFolder.isExcluded()) continue;
            vector.addElement(excludableFolder.getFolder());
        }
        return vector;
    }

    public boolean isFolderIncluded(Folder folder) {
        ExcludableFolder excludableFolder;
        if (!this.m_bListPopulated) {
            this.populateExcludableList();
        }
        return (excludableFolder = (ExcludableFolder)this.m_excludableFolderList.get(new Integer(folder.getItemID()))) != null && !excludableFolder.isExcluded();
    }

    public void refresh() {
        if (this.isRefreshRequired()) {
            this.m_view.refreshFolders();
            this.clearCachedFolderList();
        }
    }

    void clearCachedFolderList() {
        this.m_excludableFolderList = new Hashtable();
        this.m_bListPopulated = false;
    }

    public boolean isRefreshRequired() {
        if (!this.m_view.isRefreshFoldersRequired()) {
            return false;
        }
        if (!this.m_bListPopulated) {
            this.populateExcludableList();
        }
        Enumeration enumeration = this.m_excludableFolderList.keys();
        while (enumeration.hasMoreElements()) {
            ExcludableFolder excludableFolder = (ExcludableFolder)this.m_excludableFolderList.get(enumeration.nextElement());
            if (excludableFolder.isExcluded() || !excludableFolder.getFolder().isRefreshFoldersRequired()) continue;
            return true;
        }
        return false;
    }

    public void discard() {
        Folder[] folderArray = this.getFolders();
        int n = 0;
        while (n < folderArray.length) {
            folderArray[n].discard();
            ++n;
        }
        this.m_view.discardFolders();
    }

    void registerIlm(ItemListManager itemListManager) {
        this.m_ilms.put(itemListManager, itemListManager);
    }

    private void setIlmsDirty() {
        Enumeration enumeration = this.m_ilms.elements();
        while (enumeration.hasMoreElements()) {
            ((ItemListManager)enumeration.nextElement()).setDirtyFlag(4, true);
        }
    }

    public void addFolderListener(IFolderListener iFolderListener) {
        FolderListManager folderListManager = this;
        if (folderListManager == null) {
            throw null;
        }
        MyFolderScope myFolderScope = new MyFolderScope(folderListManager);
        this.getView().addFolderListener(iFolderListener, myFolderScope);
    }

    public void removeFolderListener(IFolderListener iFolderListener) {
        FolderListManager folderListManager = this;
        if (folderListManager == null) {
            throw null;
        }
        MyFolderScope myFolderScope = new MyFolderScope(folderListManager);
        this.getView().removeFolderListener(iFolderListener, myFolderScope);
    }

    FolderEventScope getFolderEventScope() {
        FolderListManager folderListManager = this;
        if (folderListManager == null) {
            throw null;
        }
        return new MyFolderScope(folderListManager);
    }

    public FolderListManager(View view) {
        if (view == null) {
            Assert.nullArgument("View");
        }
        this.m_view = view;
    }

    public FolderListManager(FolderListManager folderListManager) {
        this.m_view = folderListManager.m_view;
        this.m_folderOperationList = (Vector)folderListManager.m_folderOperationList.clone();
    }

    private class ExcludableFolder {
        private Folder m_folder = null;
        private boolean m_bExcluded = false;

        void setExcludeFlag(boolean bl) {
            this.m_bExcluded = bl;
        }

        boolean isExcluded() {
            return this.m_bExcluded;
        }

        Folder getFolder() {
            return this.m_folder;
        }

        ExcludableFolder(Folder folder, boolean bl) {
            this.m_folder = folder;
            this.m_bExcluded = bl;
        }
    }

    private class FolderOperation {
        int m_nItemID = -1;
        int m_nLevel = -1;
        boolean m_bExcluded = false;

        FolderOperation(int n, int n2, boolean bl) {
            this.m_nItemID = n;
            this.m_nLevel = n2;
            this.m_bExcluded = bl;
        }
    }

    private class MyFolderScope
    implements FolderEventScope {
        private FolderListManager m_parent;
        private final /* synthetic */ FolderListManager this$0;

        public boolean isMyEvent(Folder folder) {
            if (folder == null) {
                return false;
            }
            boolean bl = false;
            Vector vector = this.this$0.m_folderOperationList;
            synchronized (vector) {
                Enumeration enumeration = this.this$0.m_folderOperationList.elements();
                while (enumeration.hasMoreElements()) {
                    FolderOperation folderOperation = (FolderOperation)enumeration.nextElement();
                    if (!this.isMyEvent(folder, folderOperation.m_nItemID, folderOperation.m_nLevel)) continue;
                    boolean bl2 = bl = !folderOperation.m_bExcluded;
                }
            }
            return bl;
        }

        private boolean isMyEvent(Folder folder, int n, int n2) {
            if (folder == null) {
                return false;
            }
            if (folder.getItemID() == n) {
                return true;
            }
            if (n2 == 0) {
                return false;
            }
            if (n2 > 0) {
                --n2;
            }
            return this.isMyEvent(folder.getParentFolder(), n, n2);
        }

        public boolean isEqualTo(FolderEventScope folderEventScope) {
            if (folderEventScope != null && folderEventScope instanceof MyFolderScope) {
                return this.m_parent == ((MyFolderScope)folderEventScope).m_parent;
            }
            return false;
        }

        MyFolderScope(FolderListManager folderListManager) {
            this.m_parent = this.this$0 = folderListManager;
        }
    }
}

