/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ClientContext;
import com.starbase.starteam.CmdDeleteSyncInfo;
import com.starbase.starteam.CmdGetSyncInfo;
import com.starbase.starteam.DestIDCache;
import com.starbase.starteam.File;
import com.starbase.starteam.FileSyncInfo;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.Item_CacheRefCollection;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.StatusDataImpl;
import com.starbase.starteam.SyncInfo;
import com.starbase.starteam.SyncInfoCollection;
import com.starbase.starteam.View;
import com.starbase.starteam.vts.pickle.StStatusData;
import com.starbase.util.Assert;
import com.starbase.util.FileUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FileSyncCache {
    private Server m_server = null;
    private Hashtable m_cache = new Hashtable(500);

    public synchronized FileSyncInfo getFileSyncInfo(Folder folder, String string) {
        return this.getStatusData(folder, string);
    }

    public synchronized StatusDataImpl getStatusData(Folder folder, String string) {
        return this.lookup(folder, string);
    }

    public synchronized void setFileSyncInfo(String string, FileSyncInfo fileSyncInfo) {
        Assert.internalError("FileSyncCache.setFileSyncInfo()");
    }

    public synchronized void cacheStatusData(Folder folder, String string, StatusDataImpl statusDataImpl) {
        if (!statusDataImpl.isValid()) {
            return;
        }
        int n = this.getFileDestID(folder, string);
        ClientContext clientContext = folder.getServer().getClientContext();
        String string2 = FileUtils.getName(string, clientContext.getFilePathDelimiter());
        boolean bl = clientContext.getCaseSensitiveFileNames();
        Hashtable<String, StatusDataImpl> hashtable = (Hashtable<String, StatusDataImpl>)this.m_cache.get(new Integer(n));
        if (hashtable == null) {
            hashtable = new Hashtable<String, StatusDataImpl>();
            this.m_cache.put(new Integer(n), hashtable);
        }
        String string3 = string2;
        if (!bl) {
            string3 = string3.toLowerCase();
        }
        hashtable.put(string3, statusDataImpl);
    }

    public synchronized void deleteFileSyncInfo(String string) {
        Assert.internalError("FileSyncCache.deleteFileSyncInfo()");
    }

    public synchronized void deleteFileSyncInfo(Folder folder, String string, View view) {
        int n = this.getFileDestID(folder, string);
        ClientContext clientContext = folder.getServer().getClientContext();
        String string2 = FileUtils.getName(string, clientContext.getFilePathDelimiter());
        boolean bl = clientContext.getCaseSensitiveFileNames();
        this.removeCache(n, string2, bl);
        CmdDeleteSyncInfo cmdDeleteSyncInfo = new CmdDeleteSyncInfo(string2, n, bl);
        cmdDeleteSyncInfo.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), this.m_server.getViewSession(view).getID(), this.m_server.getComponentID(ServerComponentInfo.FILE));
    }

    private void discardFileSyncInfo(Folder folder, File file) {
        String string = new java.io.File(file.getFullName()).getPath();
        int n = this.getFileDestID(folder, string);
        ClientContext clientContext = folder.getServer().getClientContext();
        String string2 = FileUtils.getName(string, clientContext.getFilePathDelimiter());
        boolean bl = clientContext.getCaseSensitiveFileNames();
        this.removeCache(n, string2, bl);
    }

    void discardFolders(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Folder folder = (Folder)enumeration.nextElement();
            Item_CacheRefCollection item_CacheRefCollection = folder.getItemCollection(this.m_server.getTypeNames().FILE);
            Enumeration enumeration2 = item_CacheRefCollection.getRefs().elements();
            while (enumeration2.hasMoreElements()) {
                this.discardFileSyncInfo(folder, (File)enumeration2.nextElement());
            }
        }
    }

    public synchronized void refreshFolders(Vector vector) {
        Vector<Folder> vector2 = new Vector<Folder>();
        Vector<Folder> vector3 = new Vector<Folder>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Folder folder = (Folder)enumeration.nextElement();
            boolean bl = folder.getServer().getClientContext().getCaseSensitiveFileNames();
            if (bl) {
                vector2.addElement(folder);
                continue;
            }
            vector3.addElement(folder);
        }
        this.refreshFolders(vector2, true);
        this.refreshFolders(vector3, false);
    }

    private void refreshFolders(Vector vector, boolean bl) {
        Object object;
        Object object2;
        if (vector.size() == 0) {
            return;
        }
        DestIDCache.populate(vector);
        Vector<SyncInfoImpl> vector2 = new Vector<SyncInfoImpl>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Folder)enumeration.nextElement();
            object = ((Folder)object2).enumerateItems(((Item)object2).getTypeNames().FILE);
            int n = DestIDCache.getID((Folder)object2, ((Folder)object2).getPath());
            while (object.hasMoreElements()) {
                File file = (File)object.nextElement();
                String string = file.getName();
                StatusDataImpl statusDataImpl = this.lookup(n, string, bl);
                FileSyncCache fileSyncCache = this;
                if (fileSyncCache == null) {
                    throw null;
                }
                vector2.addElement(fileSyncCache.new SyncInfoImpl(string, bl, n, statusDataImpl));
            }
        }
        FileSyncCache fileSyncCache = this;
        if (fileSyncCache == null) {
            throw null;
        }
        object2 = new SyncInfoCollection(fileSyncCache, vector2){
            private Vector m_syncInfo;
            private final /* synthetic */ FileSyncCache this$0;
            private final /* synthetic */ Vector val$syncInfoList;

            public int size() {
                return this.m_syncInfo.size();
            }

            public SyncInfo getSyncInfo(int n) {
                return (SyncInfo)this.m_syncInfo.elementAt(n);
            }

            public int getUniqueID(int n) {
                return n;
            }
            {
                this.val$syncInfoList = vector;
                this.this$0 = fileSyncCache;
                this.m_syncInfo = this.val$syncInfoList;
                this.constructor$0(fileSyncCache);
            }

            private final void constructor$0(FileSyncCache fileSyncCache) {
            }
        };
        object = (Folder)vector.elementAt(0);
        CmdGetSyncInfo cmdGetSyncInfo = new CmdGetSyncInfo((SyncInfoCollection)object2, bl, this.m_server.getRepositoryID());
        cmdGetSyncInfo.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), this.m_server.getViewSession(((Item)object).getView()).getID(), this.m_server.getComponentID(ServerComponentInfo.FILE));
    }

    private StatusDataImpl lookup(Folder folder, String string) {
        ClientContext clientContext = folder.getServer().getClientContext();
        return this.lookup(this.getFileDestID(folder, string), FileUtils.getName(string, clientContext.getFilePathDelimiter()), clientContext.getCaseSensitiveFileNames());
    }

    private StatusDataImpl lookup(int n, String string, boolean bl) {
        Hashtable hashtable = (Hashtable)this.m_cache.get(new Integer(n));
        if (hashtable == null) {
            return null;
        }
        String string2 = string;
        if (!bl) {
            string2 = string2.toLowerCase();
        }
        return (StatusDataImpl)hashtable.get(string2);
    }

    private void printCache() {
        System.out.println("!!!!! Status Cache !!!!!!");
        Enumeration enumeration = this.m_cache.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            System.out.println("DESTID = " + n);
            Hashtable hashtable = (Hashtable)this.m_cache.get(n);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                System.out.println("FILE: " + string);
                System.out.println("Data: " + hashtable.get(string));
            }
            System.out.println("=============");
        }
        System.out.println("!!!!! Status Cache !!!!!!");
    }

    private void removeCache(int n, String string, boolean bl) {
        Hashtable hashtable = (Hashtable)this.m_cache.get(new Integer(n));
        if (hashtable == null) {
            return;
        }
        String string2 = string;
        if (!bl) {
            string2 = string2.toLowerCase();
        }
        hashtable.remove(string2);
    }

    private void cache(Folder folder, String string, StatusDataImpl statusDataImpl) {
        if (statusDataImpl.isValid()) {
            ClientContext clientContext = folder.getServer().getClientContext();
            this.cache(this.getFileDestID(folder, string), FileUtils.getName(string, clientContext.getFilePathDelimiter()), clientContext.getCaseSensitiveFileNames(), statusDataImpl);
        }
    }

    private void cache(int n, String string, boolean bl, StatusDataImpl statusDataImpl) {
        if (!statusDataImpl.isValid()) {
            return;
        }
        Hashtable<String, StatusDataImpl> hashtable = (Hashtable<String, StatusDataImpl>)this.m_cache.get(new Integer(n));
        if (hashtable == null) {
            hashtable = new Hashtable<String, StatusDataImpl>(20);
            this.m_cache.put(new Integer(n), hashtable);
        }
        String string2 = string;
        if (!bl) {
            string2 = string2.toLowerCase();
        }
        hashtable.put(string2, statusDataImpl);
    }

    private int getFileDestID(Folder folder, String string) {
        ClientContext clientContext = folder.getServer().getClientContext();
        String string2 = FileUtils.getParent(string, clientContext.getFilePathDelimiter());
        String string3 = FileUtils.getAbsolutePath(string2);
        return DestIDCache.getID(this.m_server, folder, string3);
    }

    public FileSyncCache(Server server) {
        this.m_server = server;
    }

    private class SyncInfoImpl
    implements SyncInfo {
        private String m_name;
        private boolean m_bCaseSensitive;
        private int m_destID;
        private StatusDataImpl m_data;

        public int getRecordID() {
            if (this.m_data == null) {
                return -1;
            }
            return this.m_data.getRecordID();
        }

        public boolean getSyncAndTipDiffer() {
            return false;
        }

        public String getFileName() {
            return this.m_name;
        }

        public int getTipObjectID() {
            return -1;
        }

        public int getTipRevision() {
            return 0;
        }

        public int getTipContentRevision() {
            return 0;
        }

        public double getModifiedTime() {
            return 0.0;
        }

        public int getDestID() {
            return this.m_destID;
        }

        public void setData(StStatusData stStatusData) {
            FileSyncCache.this.cache(this.m_destID, this.m_name, this.m_bCaseSensitive, new StatusDataImpl(stStatusData));
        }

        public SyncInfoImpl(String string, boolean bl, int n, StatusDataImpl statusDataImpl) {
            this.m_name = string;
            this.m_bCaseSensitive = bl;
            this.m_destID = n;
            this.m_data = statusDataImpl;
        }
    }
}

