/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertySortCollection;
import com.starbase.util.OLEDate;

class DoubleCollection
extends PropertySortCollection {
    private double[] m_dest;
    private double[] m_scratchpad;

    public void swap(int n, int n2) {
        double d = this.m_dest[n];
        this.m_dest[n] = this.m_dest[n2];
        this.m_dest[n2] = d;
    }

    public void copySequence(int n, int n2) {
        System.arraycopy(this.m_scratchpad, n, this.m_dest, n, n2);
    }

    public void setFromScratchpad(int n, int n2) {
        this.m_dest[n2] = this.m_scratchpad[n];
    }

    public void saveToScratchpad(int n, int n2) {
        this.m_scratchpad[n2] = this.m_dest[n];
    }

    public int compareScratchpad(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_scratchpad[n], this.m_scratchpad[n2]);
        }
        return this.comp(this.m_scratchpad[n2], this.m_scratchpad[n]);
    }

    public int compare(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_dest[n], this.m_dest[n2]);
        }
        return this.comp(this.m_dest[n2], this.m_dest[n]);
    }

    private int comp(double d, double d2) {
        if (d > d2) {
            return 1;
        }
        if (d < d2) {
            return -1;
        }
        return 0;
    }

    public DoubleCollection(ItemList itemList, GroupSortInfo groupSortInfo, Property property) {
        super(itemList, groupSortInfo, property);
        this.m_bAscending = groupSortInfo.isAscending();
        int n = itemList.size();
        this.m_dest = new double[n];
        this.m_scratchpad = new double[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = itemList.getAt(n2).getByProperty(property);
            double d = 0.0;
            d = object instanceof OLEDate ? ((OLEDate)object).getDoubleValue() : ((Double)object).doubleValue();
            this.m_dest[n2] = d;
            this.m_scratchpad[n2] = d;
            ++n2;
        }
    }
}

