/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.Cacheable;
import com.starbase.starteam.CmdGetCatalog;
import com.starbase.starteam.CmdGetCatalogSet;
import com.starbase.starteam.DescriptorData;
import com.starbase.starteam.MPXObjectEvent;
import com.starbase.starteam.ObjectDescriptors;
import com.starbase.starteam.Server;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.SimpleGlobalCache;
import com.starbase.starteam.vts.pickle.Variant;
import com.starbase.starteam.vts.pickle.VariantMatrix_Marshaler;
import java.util.Enumeration;
import java.util.Hashtable;

class DescriptorCache
extends SimpleGlobalCache
implements VariantMatrix_Marshaler {
    private int m_classID = -1;
    private int[] m_propertyIDs = null;
    private Hashtable m_descriptors = null;

    public DescriptorData setDescriptorData(DescriptorData descriptorData) {
        return (DescriptorData)this.set(descriptorData);
    }

    public synchronized void handleMPXObjectEvent(MPXObjectEvent mPXObjectEvent) {
        String string = mPXObjectEvent.getEventVerb();
        if (string.equals("New")) {
            this.OnObjectAdded(mPXObjectEvent);
        } else if (string.equals("Modify")) {
            this.OnObjectChanged(mPXObjectEvent);
        } else if (!string.equals("ModifyRevision")) {
            if (string.equals("Delete")) {
                this.OnObjectDeleted(mPXObjectEvent);
            } else {
                this.setAllDirty();
            }
        }
    }

    protected Cacheable[] fetchAll(Object object) {
        Server server = (Server)object;
        this.m_descriptors = new Hashtable();
        CmdGetCatalog cmdGetCatalog = new CmdGetCatalog(this.m_classID, -1, this);
        cmdGetCatalog.execute(server.useConnection(), server.getSession().getID(), 0, 65535);
        Cacheable[] cacheableArray = new Cacheable[this.m_descriptors.size()];
        int n = 0;
        Enumeration enumeration = this.m_descriptors.elements();
        while (enumeration.hasMoreElements()) {
            cacheableArray[n++] = (Cacheable)enumeration.nextElement();
        }
        return cacheableArray;
    }

    protected Cacheable[] fetch(Object object, int[] nArray) {
        Server server = (Server)object;
        int n = nArray.length;
        this.m_descriptors = new Hashtable();
        CmdGetCatalogSet cmdGetCatalogSet = new CmdGetCatalogSet(this.m_classID, nArray, this);
        cmdGetCatalogSet.execute(server.useConnection(), server.getSession().getID(), 0, 65535);
        Cacheable[] cacheableArray = new Cacheable[n];
        int n2 = 0;
        while (n2 < n) {
            cacheableArray[n2] = (Cacheable)this.m_descriptors.get(new Integer(nArray[n2]));
            ++n2;
        }
        return cacheableArray;
    }

    protected CacheRef newCacheRef(Object object, Cacheable cacheable) {
        return new ObjectDescriptors((DescriptorData)cacheable);
    }

    public void startItems(int n) {
    }

    public void endItem(Object object) {
    }

    public void endItems() {
    }

    public void setPropertyCount(int n) {
        this.m_propertyIDs = new int[n];
    }

    public void setPropertyIdAt(int n, int n2) {
        this.m_propertyIDs[n] = n2;
    }

    public Object startItem(int n) {
        DescriptorData descriptorData = new DescriptorData(n, new Object[this.m_propertyIDs.length]);
        this.m_descriptors.put(new Integer(n), descriptorData);
        return descriptorData;
    }

    public void setProperty(Object object, int n, Object object2) {
        ((DescriptorData)object).setDescriptor(n, object2);
    }

    public int[] getPropertyIDs(Object object) {
        if (this.m_propertyIDs == null) {
            this.fetch(object, new int[]{0});
        }
        return this.m_propertyIDs;
    }

    private int getPropertyIndex(int n) {
        int n2 = 0;
        while (n2 < this.m_propertyIDs.length) {
            if (this.m_propertyIDs[n2] == n) {
                return n2;
            }
            ++n2;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private void OnObjectAdded(MPXObjectEvent mPXObjectEvent) {
        this.setCacheDirty(true);
    }

    private void OnObjectChanged(MPXObjectEvent mPXObjectEvent) {
        int n;
        DescriptorData descriptorData;
        if (mPXObjectEvent.getClassID() == this.m_classID && (descriptorData = (DescriptorData)this.getCached(n = mPXObjectEvent.getObjectID())) != null) {
            int n2 = this.m_propertyIDs.length;
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                Object object = mPXObjectEvent.getValue(this.m_propertyIDs[n3]);
                objectArray[n3] = object == null ? Variant.createVariant(descriptorData.getDescriptor(n3)).getData() : object;
                ++n3;
            }
            this.set(new DescriptorData(n, objectArray));
        }
    }

    private void OnObjectDeleted(MPXObjectEvent mPXObjectEvent) {
        if (mPXObjectEvent.getClassID() == this.m_classID) {
            this.setObjectDirty(mPXObjectEvent.getObjectID());
        }
    }

    DescriptorCache(Server_CacheManager server_CacheManager, int n, int n2) {
        super(server_CacheManager, n);
        this.m_classID = n2;
    }
}

