/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.ServerList;
import com.starbase.starteam.StarTeamClientOptions;
import com.starbase.starteam.WinProfile;
import com.starbase.util.GUID;
import com.starbase.util.Platform;
import com.starbase.util.StreamUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class ConfigFiles {
    private static File m_baseDir = null;
    private static File m_serverList = null;
    private static File m_starteamINI = null;
    private static File m_connectionManagerINI = null;
    private static File m_nonwinConfig = null;
    private static File m_centralSyncDB = null;
    private static File m_starteamXML = null;
    private static final Object m_sync = new Object();
    private static final String SERVER_LIST_FILENAME = "starteam-servers.xml";
    private static final String CLIENT_CONFIG_FILENAME = "starteam-client-options.xml";
    private static final String OLD_SERVER_LIST_FILENAME = "ServerList.st";
    private static final String OLD_CLIENT_CONFIG_FILENAME = "StarTeam.ini";

    public static File getServerList() throws IOException {
        if (m_serverList == null) {
            Object object = m_sync;
            synchronized (object) {
                if (m_serverList == null) {
                    ConfigFiles.cacheServerList();
                }
            }
        }
        return m_serverList;
    }

    public static File getStarTeamINI() throws IOException {
        if (m_starteamINI == null) {
            Object object = m_sync;
            synchronized (object) {
                if (m_starteamINI == null) {
                    ConfigFiles.cacheStarTeamINI();
                }
            }
        }
        return m_starteamINI;
    }

    public static File getDefaultCentralStatusDirectory() throws IOException {
        if (m_centralSyncDB == null) {
            Object object = m_sync;
            synchronized (object) {
                if (m_centralSyncDB == null) {
                    ConfigFiles.cacheDefaultCentralSyncDir();
                }
            }
        }
        return m_centralSyncDB;
    }

    public static File getConnectionManagerINI() {
        if (Platform.isWin32() && m_connectionManagerINI == null) {
            Object object = m_sync;
            synchronized (object) {
                if (m_connectionManagerINI == null) {
                    File file = new File(WinProfile.getWorkstationIDPath(true));
                    File file2 = new File(WinProfile.getWorkstationIDPath(false));
                    m_connectionManagerINI = file2.exists() ? file2 : (file.exists() ? file : (ConfigFiles.createConnectionManagerINI(file) ? file : (ConfigFiles.createConnectionManagerINI(file2) ? file2 : file)));
                }
            }
        }
        return m_connectionManagerINI;
    }

    private static boolean createConnectionManagerINI(File file) {
        BufferedWriter bufferedWriter = null;
        try {
            String string = Platform.getEOL();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            bufferedWriter.write("[ConnectionManager]" + string);
            GUID gUID = new GUID();
            gUID.create();
            bufferedWriter.write("WorkstationID=" + gUID.canonicalFormat() + string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.exists();
    }

    public static File getNonWindowsConfig() throws IOException {
        if (m_nonwinConfig == null) {
            Object object = m_sync;
            synchronized (object) {
                if (m_nonwinConfig == null) {
                    ConfigFiles.cacheNonWindowsConfig();
                }
            }
        }
        return m_nonwinConfig;
    }

    static File getStarTeamXML() throws IOException {
        if (m_starteamXML == null) {
            Object object = m_sync;
            synchronized (object) {
                if (m_starteamXML == null) {
                    ConfigFiles.cacheStarTeamXML();
                }
            }
        }
        return m_starteamXML;
    }

    private static void cacheServerList() throws IOException {
        File file = null;
        File file2 = null;
        if (Platform.isWin32()) {
            String string = new File(WinProfile.getServerListPath()).getParent();
            file = new File(string, SERVER_LIST_FILENAME);
            file2 = new File(string, OLD_SERVER_LIST_FILENAME);
        } else {
            ConfigFiles.ensureBaseDir();
            file = new File(m_baseDir, SERVER_LIST_FILENAME);
            file2 = new File(m_baseDir, OLD_SERVER_LIST_FILENAME);
        }
        m_serverList = file;
        if (!file.exists() && file2.exists()) {
            ServerList.convert(file2, file);
        }
    }

    private static void cacheStarTeamINI() throws IOException {
        File file = null;
        File file2 = null;
        if (Platform.isWin32()) {
            String string = new File(WinProfile.getStarTeamIniPath()).getParent();
            file = new File(string, CLIENT_CONFIG_FILENAME);
            file2 = new File(string, OLD_CLIENT_CONFIG_FILENAME);
        } else {
            ConfigFiles.ensureBaseDir();
            file = new File(m_baseDir, CLIENT_CONFIG_FILENAME);
            file2 = new File(m_baseDir, OLD_CLIENT_CONFIG_FILENAME);
        }
        m_starteamINI = file;
        if (!file.exists() && file2.exists()) {
            StarTeamClientOptions.convert(file2, file);
        }
    }

    private static void cacheDefaultCentralSyncDir() throws IOException {
        if (Platform.isWin32()) {
            m_centralSyncDB = new File(WinProfile.getLocalStarbaseAppDataDir(), "syncdb");
        } else {
            ConfigFiles.ensureBaseDir();
            m_centralSyncDB = new File(m_baseDir, "syncdb");
        }
    }

    private static void cacheNonWindowsConfig() throws IOException {
        if (Platform.isWin32()) {
            m_nonwinConfig = new File(System.getProperty("user.home"), ".starteam");
        } else {
            File file;
            ConfigFiles.ensureBaseDir();
            m_nonwinConfig = new File(m_baseDir, "platform.ini");
            if (!m_nonwinConfig.exists() && (file = new File(System.getProperty("user.home"), ".starteam")).exists() && !file.isDirectory()) {
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(m_nonwinConfig);
                    StreamUtils.bufferedTransfer(fileInputStream, fileOutputStream, 2048);
                }
                finally {
                    Object var4_3 = null;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
        }
    }

    private static void cacheStarTeamXML() throws IOException {
        if (Platform.isWin32()) {
            m_starteamXML = new File(WinProfile.getStarTeamXMLPath());
        } else {
            ConfigFiles.ensureBaseDir();
            m_starteamXML = new File(m_baseDir, "starteam.xml");
        }
    }

    private static void ensureBaseDir() throws IOException {
        if (m_baseDir == null) {
            String string = System.getProperty("user.home");
            File file = new File(string, ".starteam-client");
            File file2 = new File(string, ".starbase");
            if (file.exists()) {
                m_baseDir = file;
            } else if (file2.exists()) {
                m_baseDir = file2;
            } else {
                if (!file.mkdir()) {
                    throw new IOException(Res.formatKey(ResIDs.UNABLE_TO_CREATE_DIR_FMT, new Object[]{file.getPath()}));
                }
                m_baseDir = file;
            }
            if (!m_baseDir.isDirectory()) {
                String string2 = m_baseDir.getPath();
                m_baseDir = null;
                throw new IOException(Res.formatKey(ResIDs.NOT_A_DIR_FMT, new Object[]{string2}));
            }
        }
    }

    private ConfigFiles() {
    }
}

