/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Property;
import com.starbase.starteam.Task;
import com.starbase.starteam.TypedResource_Marshaler;
import com.starbase.starteam.WorkRecord;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.io.IOException;

class CmdUpdateTask
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(Integer.MIN_VALUE, 524288, 2004, "PROJ_CMD_UPDATE_ITEM");
    private Task m_task;
    private Property[] m_unsavedProperties;
    private int m_newVMID;
    private String m_reason = "";
    private WorkRecord[] m_newRecs;
    private WorkRecord[] m_modifiedRecs;
    private WorkRecord[] m_deletedRecs;
    private boolean m_updatingWorkRecs = false;
    private TypedResource_Marshaler m_marshaler;

    public int getItemID() {
        return this.m_newVMID;
    }

    protected boolean isRetrySupported() {
        return this.isRetrySupportedForEditCommand();
    }

    protected void push(Command command) throws IOException {
        if (this.m_task.hasDirtyWorkRecords()) {
            command.writeInt(102);
            this.m_updatingWorkRecs = true;
        } else {
            command.writeInt(1);
            this.m_updatingWorkRecs = false;
        }
        command.writeInt(this.m_task.getItemID());
        if (this.m_task.isDisembodied()) {
            command.writeInt(-1);
        } else {
            command.writeInt(this.m_task.getParentFolder().getItemID());
        }
        this.m_marshaler.writeItemProperties(this.m_task, this.m_unsavedProperties, command);
        command.writeString(this.m_reason);
        OLEDate oLEDate = this.m_task.getSnapshotTime();
        command.writeTime(oLEDate.getDoubleValue());
        if (this.m_task.hasDirtyWorkRecords()) {
            command.writeInt(102);
            this.m_newRecs = this.m_task.getNewWorkRecords();
            this.m_modifiedRecs = this.m_task.getModifiedWorkRecords();
            this.m_deletedRecs = this.m_task.getDeletedWorkRecords();
            command.writeInt(this.m_newRecs.length + this.m_modifiedRecs.length + this.m_deletedRecs.length);
            int n = 0;
            while (n < this.m_newRecs.length) {
                this.m_newRecs[n].writeGuts(command);
                ++n;
            }
            n = 0;
            while (n < this.m_modifiedRecs.length) {
                this.m_modifiedRecs[n].writeGuts(command);
                ++n;
            }
            n = 0;
            while (n < this.m_deletedRecs.length) {
                this.m_deletedRecs[n].writeGuts(command);
                ++n;
            }
            command.writeInt(this.m_newRecs.length + this.m_modifiedRecs.length + this.m_deletedRecs.length);
            n = 0;
            while (n < this.m_newRecs.length) {
                command.writeInt(0);
                ++n;
            }
            n = 0;
            while (n < this.m_modifiedRecs.length) {
                command.writeInt(1);
                ++n;
            }
            n = 0;
            while (n < this.m_deletedRecs.length) {
                command.writeInt(2);
                ++n;
            }
        } else {
            command.writeInt(1);
        }
    }

    protected void pop(Command command) throws IOException {
        this.m_newVMID = command.readInt();
        if (this.m_task.isNew()) {
            this.m_task.setItemID(this.m_newVMID);
        }
        double d = command.readTime();
        this.m_task.setSnapshotTime(new OLEDate(d));
        if (SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel())) {
            this.m_marshaler.readItem(this.m_task, command);
        }
        if (this.m_updatingWorkRecs) {
            int n = command.readInt();
            if (n != this.m_newRecs.length + this.m_modifiedRecs.length + this.m_deletedRecs.length) {
                Assert.internalError("CmdUpdateTask.pop(), count=" + n + ", m_newRecs.length=" + this.m_newRecs.length + ", m_modifiedRecs.length=" + this.m_modifiedRecs.length + ", m_deletedRecs.length=" + this.m_deletedRecs.length + ".");
            }
            int n2 = 0;
            while (n2 < this.m_newRecs.length) {
                this.m_newRecs[n2].pokeID(command.readInt());
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m_modifiedRecs.length) {
                command.readInt();
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m_deletedRecs.length) {
                command.readInt();
                ++n2;
            }
        }
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdUpdateTask(Task task, Property[] propertyArray, String string, TypedResource_Marshaler typedResource_Marshaler) {
        this.m_task = task;
        this.m_unsavedProperties = propertyArray;
        this.m_reason = string;
        this.m_marshaler = typedResource_Marshaler;
    }
}

