/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.UserAccount_Data;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.pickle.LoginInfo;
import com.starbase.util.GUID;
import java.io.IOException;

class CmdServerLogin
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(0x10000000, 0, 14, "SRVR_CMD_SERVER_LOGIN");
    private int m_nLoginID;
    private GUID m_WorkstationID;
    private String m_UserName = null;
    private String m_hostName = null;
    private byte[] m_mangledPassword = null;
    private GUID m_ServerGuid;
    private GUID m_ClientID;
    private int m_nUserID;
    private LoginInfo m_loginInfo = null;
    private int[] m_productCodes = null;

    public GUID getServerGuid() {
        return this.m_ServerGuid;
    }

    public GUID getClientID() {
        return this.m_ClientID;
    }

    public int getUserID() {
        return this.m_nUserID;
    }

    public LoginInfo getLoginInfo() {
        return this.m_loginInfo;
    }

    public int[] getProductCodes() {
        return this.m_productCodes;
    }

    protected boolean isRetrySupported() {
        return true;
    }

    protected void push(Command command) throws IOException {
        command.writeInt(this.m_nLoginID);
        command.writeGUID(this.m_WorkstationID);
        command.writeString(this.m_hostName);
        command.writeString(this.m_UserName.toLowerCase());
        if (command.getRevisionLevel() >= 67) {
            command.writePassword(this.m_mangledPassword);
        } else {
            command.writePassword(UserAccount_Data.mangledPasswordAsString(this.m_mangledPassword));
        }
        if (command.getRevisionLevel() < 51) {
            command.writeString("NO CLIENT ACTIVATION KEY ASSIGNED");
        }
    }

    protected void pop(Command command) throws IOException {
        this.m_ServerGuid = command.readGUID();
        this.m_ClientID = command.readGUID();
        this.m_nUserID = command.readInt();
        this.m_loginInfo = new LoginInfo();
        this.m_loginInfo.read(command);
        if (command.getRevisionLevel() >= 46) {
            byte[] byArray = command.readRaw();
            this.m_productCodes = new int[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                this.m_productCodes[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdServerLogin(int n, GUID gUID, String string, String string2, byte[] byArray) {
        this.m_nLoginID = n;
        this.m_WorkstationID = gUID;
        this.m_hostName = string;
        this.m_UserName = string2;
        this.m_mangledPassword = byArray;
    }
}

