/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.FileStream;
import com.starbase.starteam.Item;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.starteam.vts.pickle.FileRevisionID;
import com.starbase.starteam.vts.pickle.StStatusData;
import com.starbase.util.MD5;
import java.io.IOException;

class CmdResyncFile
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(Integer.MIN_VALUE, 0, 10121, "FILE_CMD_RESYNC_FILE");
    private Item m_fileItem = null;
    private String m_fileName = null;
    private FileStream.Sender m_sender = null;
    private MD5 m_localMD5 = null;
    private int m_compareSize = 0;
    private boolean m_caseSensitive = false;
    private int m_destID = -1;
    private double m_syncTime = 0.0;
    private int m_syncSize = 0;
    private MD5 m_syncMD5 = new MD5();
    private StStatusData m_statusData = null;
    private FileRevisionID m_revisionID = null;

    protected boolean isRetrySupported() {
        if (this.m_sender != null) {
            return this.m_sender.isRetrySupported();
        }
        return true;
    }

    protected void prepareForRetry() {
        if (this.m_sender != null) {
            this.m_sender.prepareForRetry();
        }
    }

    public StStatusData getStatusData() {
        return this.m_statusData;
    }

    public FileRevisionID getFileRevisionID() {
        return this.m_revisionID;
    }

    protected void push(Command command) throws IOException {
        boolean bl = SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel());
        command.writeInt(this.m_fileItem.getItemID());
        if (bl) {
            command.writeMD5(this.m_localMD5);
            command.writeInt(this.m_compareSize);
        } else {
            command.writeInt(this.m_destID);
            command.writeString(this.m_fileName);
            command.writeBoolean(this.m_caseSensitive);
            command.writeBoolean(true);
            if (this.m_sender == null) {
                command.writeInt(0);
                command.writeMD5(this.m_localMD5);
            } else {
                command.writeInt(1);
                this.m_compareSize = command.writeStream(this.m_sender.getStream());
            }
            command.writeInt(this.m_compareSize);
            command.writeTime(this.m_syncTime);
            command.writeInt(this.m_syncSize);
            command.writeMD5(this.m_syncMD5);
        }
    }

    protected void pop(Command command) throws IOException {
        if (SystemRevisionNumbers.isClientManagedStatus(command.getRevisionLevel())) {
            this.m_revisionID = FileRevisionID.read(command);
        } else {
            this.m_statusData = StStatusData.read(this.m_fileItem.getServer().getRepositoryID(), command);
        }
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdResyncFile(Item item, String string, FileStream.Sender sender, int n, boolean bl, double d, int n2, MD5 mD5) {
        this.m_fileItem = item;
        this.m_fileName = string;
        this.m_syncTime = d;
        this.m_syncSize = n2;
        this.m_syncMD5 = mD5;
        this.m_destID = n;
        this.m_caseSensitive = bl;
        this.m_sender = sender;
    }

    public CmdResyncFile(Item item, String string, MD5 mD5, int n, int n2, boolean bl, double d, int n3, MD5 mD52) {
        this.m_fileItem = item;
        this.m_fileName = string;
        this.m_syncTime = d;
        this.m_syncSize = n3;
        this.m_syncMD5 = mD52;
        this.m_destID = n2;
        this.m_caseSensitive = bl;
        this.m_localMD5 = mD5;
        this.m_compareSize = n;
    }
}

