/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdMacroGlobalServiceCommand;
import com.starbase.starteam.Item;
import com.starbase.starteam.MergePoint;
import com.starbase.starteam.RevisionID;
import com.starbase.starteam.Server;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandRoute;
import java.io.IOException;
import java.util.Vector;

class CmdMergeHistory
extends CmdMacroGlobalServiceCommand {
    private static final CommandRoute m_route = new CommandRoute(0x1000000, 786432, 4, "SRVC_CMD_MERGE_HISTORY");
    private RevisionID m_revisionID;
    private int m_classID;
    private MergePoint[] m_mergePoints = null;

    static MergePoint[] getMergeHistory(Item item) {
        RevisionID revisionID = new RevisionID(item.getObjectID(), item.getRevisionNumber());
        CmdMergeHistory cmdMergeHistory = new CmdMergeHistory(item.getServer(), 65535, item.getType().getClassID(), revisionID);
        cmdMergeHistory.execute();
        return cmdMergeHistory.getMergePoints();
    }

    protected boolean isRetrySupported() {
        return true;
    }

    public MergePoint[] getMergePoints() {
        return this.m_mergePoints;
    }

    protected void push(Command command) throws IOException {
        command.writeInt(this.m_classID);
        this.m_revisionID.writeGuts(command);
    }

    protected void pop(Command command) throws IOException {
        Vector<MergePoint> vector = new Vector<MergePoint>();
        int n = command.readInt();
        int n2 = 0;
        while (n2 < n) {
            RevisionID revisionID = RevisionID.read(command);
            RevisionID revisionID2 = RevisionID.read(command);
            MergePoint mergePoint = new MergePoint(revisionID, revisionID2);
            vector.addElement(mergePoint);
            ++n2;
        }
        this.m_mergePoints = new MergePoint[vector.size()];
        vector.copyInto(this.m_mergePoints);
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdMergeHistory(Server server, int n, int n2, RevisionID revisionID) {
        super(server, n);
        this.m_classID = n2;
        this.m_revisionID = revisionID;
    }
}

