/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.TypedResource_Marshaler;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CmdGetVersionData
extends CommandMacro {
    private static final CommandRoute m_route = new CommandRoute(Integer.MIN_VALUE, 524288, 5001, "PROJ_CMD_GET_ITEMS_VERSIONS");
    private Vector m_items;
    private Hashtable m_PIDsToProperties;
    private Hashtable m_IDsToItems = new Hashtable();
    private TypedResource_Marshaler m_marshaler;

    protected boolean isRetrySupported() {
        return true;
    }

    protected void push(Command command) throws IOException {
        int n = this.m_items.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        command.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Item item = (Item)this.m_items.elementAt(n2);
            PropertyNames propertyNames = item.getPropertyNames();
            command.writeInt(item.getItemID());
            nArray[n2] = (Integer)item.get(propertyNames.OBJECT_ID);
            nArray2[n2] = (Integer)item.get(propertyNames.REVISION_NUMBER);
            CmdGetVersionData cmdGetVersionData = this;
            if (cmdGetVersionData == null) {
                throw null;
            }
            this.m_IDsToItems.put(cmdGetVersionData.new MultiKey(item.getItemID(), nArray[n2], nArray2[n2]), item);
            ++n2;
        }
        command.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            command.writeInt(nArray[n2]);
            command.writeInt(nArray2[n2]);
            ++n2;
        }
        command.writeInt(this.m_PIDsToProperties.size());
        Enumeration enumeration = this.m_PIDsToProperties.keys();
        while (enumeration.hasMoreElements()) {
            command.writeInt((Integer)enumeration.nextElement());
        }
    }

    protected void pop(Command command) throws IOException {
        int n = command.readInt();
        Property[] propertyArray = new Property[n];
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = new Integer(command.readInt());
            propertyArray[n2] = (Property)this.m_PIDsToProperties.get(n3);
            ++n2;
        }
        n2 = command.readInt();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = command.readInt();
            int n6 = command.readInt();
            int n7 = command.readInt();
            CmdGetVersionData cmdGetVersionData = this;
            if (cmdGetVersionData == null) {
                throw null;
            }
            Item item = (Item)this.m_IDsToItems.get(cmdGetVersionData.new MultiKey(n5, n6, n7));
            if (item == null) {
                Assert.internalError("CmdGetVersionData.pop(), item = null");
            }
            this.m_marshaler.readItemProperties(item, command, propertyArray);
            ++n4;
        }
    }

    protected CommandRoute getCommandRoute() {
        return m_route;
    }

    public CmdGetVersionData(Vector vector, Hashtable hashtable, TypedResource_Marshaler typedResource_Marshaler) {
        this.m_items = vector;
        this.m_PIDsToProperties = hashtable;
        this.m_marshaler = typedResource_Marshaler;
    }

    private class MultiKey {
        private int m_vmid = -1;
        private int m_objid = -1;
        private int m_rev = -1;

        public int hashCode() {
            int n = 0;
            n = n * 37 + this.m_vmid;
            n = n * 37 + this.m_objid;
            n = n * 37 + this.m_rev;
            return n;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof MultiKey) {
                MultiKey multiKey = (MultiKey)object;
                return this.m_vmid == multiKey.m_vmid && this.m_objid == multiKey.m_objid && this.m_rev == multiKey.m_rev;
            }
            return false;
        }

        public MultiKey(int n, int n2, int n3) {
            this.m_vmid = n;
            this.m_objid = n2;
            this.m_rev = n3;
        }
    }
}

