/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CmdMacroServerCommand;
import com.starbase.starteam.Server;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.util.StreamUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

class CmdGetLog
extends CmdMacroServerCommand {
    public static final int LOG_MODE_ALL = 0;
    public static final int LOG_MODE_ERRORS = 1;
    public static final int LOG_ALL = 65535;
    public static final int LOG_MESSAGES = 4097;
    public static final int LOG_WARNINGS = 4098;
    public static final int LOG_EXCEPTIONS = 4100;
    public static final int LOG_ASSERTIONS = 4104;
    private int m_nLogType = 0;
    private int m_nLogMode = 0;
    private int m_localeInfo = 0;
    private FileOutputStream m_out = null;
    private Locale m_serverLocale = null;
    private boolean m_bServerLocalized = false;
    private final CommandRoute m_route = new CommandRoute(this.m_commandRouteFlag, 0, 2046, "SRVR_CMD_GET_LOG");

    public Locale getServerLocale() {
        return this.m_serverLocale;
    }

    protected boolean isRetrySupported() {
        return this.isRetrySupportedForEditCommand();
    }

    private int getNewLogMode(int n) {
        if (this.m_bServerLocalized) {
            if (n == 0) {
                return 15;
            }
            if (n == 1) {
                return 12;
            }
            if (n < 4097) {
                return n;
            }
            int n2 = 0;
            if (n == 65535) {
                n2 |= 0xF;
            } else {
                int n3 = 0xF & n;
                if ((n3 & 0x1001) != 0) {
                    n2 |= 1;
                }
                if ((n3 & 0x1002) != 0) {
                    n2 |= 2;
                }
                if ((n3 & 0x1004) != 0) {
                    n2 |= 4;
                }
                if ((n3 & 0x1008) != 0) {
                    n2 |= 8;
                }
            }
            return n2;
        }
        if (n == 1) {
            return 1;
        }
        return 0;
    }

    protected void push(Command command) throws IOException {
        command.writeInt(this.m_nLogType);
        if (this.m_bServerLocalized) {
            command.writeInt(this.m_localeInfo);
        }
        command.writeInt(this.m_nLogMode);
    }

    protected void pop(Command command) throws IOException {
        if (this.m_bServerLocalized) {
            this.m_serverLocale = command.readLocale();
            InputStream inputStream = command.getChunkStream();
            StreamUtils.bufferedTransfer(inputStream, this.m_out, 2048);
            this.m_out.flush();
        } else {
            command.readStream(this.m_out);
            this.m_out.flush();
        }
    }

    protected CommandRoute getCommandRoute() {
        return this.m_route;
    }

    public CmdGetLog(Server server, int n, int n2, int n3, FileOutputStream fileOutputStream) {
        super(server, 1);
        this.m_bServerLocalized = server.getSupportedFeatures().isServerLocalized();
        this.m_nLogType = n;
        this.m_nLogMode = this.getNewLogMode(n3);
        this.m_localeInfo = n2;
        this.m_out = fileOutputStream;
    }
}

