/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.BuildNumber;
import com.starbase.util.Assert;

public class ClientApplication {
    private static String m_name = "<Unknown Application>";

    public static String getName() {
        return m_name;
    }

    public static void setName(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        m_name = string;
    }

    public static String getDescription() {
        return ClientApplication.getName() + "; " + ClientApplication.getSDKDescription() + "; " + ClientApplication.getJavaDescription() + "; " + ClientApplication.getOSName();
    }

    private static String getSDKDescription() {
        return "SDK " + BuildNumber.getBuildString();
    }

    private static String getJavaDescription() {
        String string;
        block5: {
            string = "";
            try {
                try {
                    if (ClientApplication.isSunVM()) {
                        string = ClientApplication.isHotspotClientVM() ? "JVM " + ClientApplication.getJavaVersion() : ClientApplication.getJavaName() + ", " + ClientApplication.getJavaVersion();
                        break block5;
                    }
                    string = ClientApplication.getJavaName() + ", " + ClientApplication.getJavaVendor() + ", " + ClientApplication.getJavaVersion();
                }
                catch (RuntimeException runtimeException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static String getJavaName() {
        String string = System.getProperty("java.vm.name");
        if (string == null || string.length() == 0) {
            string = "Java";
        }
        return string;
    }

    private static boolean isHotspotClientVM() {
        String string = ClientApplication.getJavaName().toLowerCase();
        int n = string.indexOf("hotspot");
        int n2 = string.indexOf("client");
        return n >= 0 && n2 > n;
    }

    private static String getJavaVendor() {
        String string = System.getProperty("java.vm.vendor");
        if (string == null || string.length() == 0) {
            string = System.getProperty("java.vendor");
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static boolean isSunVM() {
        String string = ClientApplication.getJavaVendor().toLowerCase();
        return string.startsWith("sun microsystems");
    }

    private static String getJavaVersion() {
        String string = System.getProperty("java.vm.version");
        if (string == null || string.length() == 0) {
            string = System.getProperty("java.version");
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static String getOSName() {
        String string = "";
        try {
            try {
                string = System.getProperty("os.name");
                if (string == null) {
                    string = "";
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private ClientApplication() {
    }
}

