/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CheckOutInputStream;
import com.starbase.starteam.File;
import com.starbase.starteam.IdentityReader;
import com.starbase.starteam.KeywordReader;
import com.starbase.starteam.Keywords;
import com.starbase.starteam.Server;
import com.starbase.starteam.vts.pickle.CheckoutRequest;
import com.starbase.starteam.vts.pickle.FileRevisionID;
import com.starbase.starteam.vts.pickle.StStatusData;
import com.starbase.util.EOLReader;
import com.starbase.util.LineProcessor;
import com.starbase.util.LineReader;
import com.starbase.util.MD5;
import com.starbase.util.TextInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CheckOutStream
extends InputStream {
    private File m_File = null;
    private String m_EOL = null;
    private boolean m_doKeywords = false;
    private int m_LockStatus = 3;
    private InputStream m_source = null;
    private CheckOutInputStream m_COstream = null;
    private Keywords m_keywords = null;
    private boolean m_transformsApplied = false;

    boolean getTransformsApplied() {
        return this.m_transformsApplied;
    }

    public double getFileTime() {
        return this.m_COstream.getFileTime();
    }

    public boolean getFileExecutable() {
        return this.m_COstream.getFileExecutable();
    }

    Keywords getKeywords() {
        return this.m_keywords;
    }

    MD5 getSyncMD5() {
        return this.m_COstream.getSyncMD5();
    }

    int getExclusiveLockerID() {
        return this.m_COstream.getExclusiveLockerID();
    }

    int getMyLockState() {
        return this.m_COstream.getMyLockState();
    }

    public StStatusData getStatusData() {
        return this.m_COstream.getStatusData();
    }

    public FileRevisionID getFileRevisionID() {
        return this.m_COstream.getFileRevisionID();
    }

    private void init() throws IOException {
        Server server = this.m_File.getServer();
        int n = this.m_File.getObjectID();
        int n2 = this.m_File.getInt(server.getPropertyNames().REVISION_NUMBER);
        CheckoutRequest checkoutRequest = new CheckoutRequest(this.m_File.getItemID(), this.m_LockStatus);
        checkoutRequest.setGetKeywords(this.m_doKeywords);
        checkoutRequest.checkoutByVersion(n, n2);
        checkoutRequest.setFileInfo(this.m_File.getName(), -1, true);
        this.m_COstream = new CheckOutInputStream(server.useConnection(), server.getSession().getID(), server.getViewSession(this.m_File.getView()).getID(), this.m_File.getRoutingComponentID(), checkoutRequest, this.m_File);
        LineProcessor lineProcessor = null;
        if (this.m_doKeywords) {
            Keywords keywords = new Keywords();
            keywords.setFrom(this.m_File, this.m_COstream.getCommand().getKeywordValues(), this.m_COstream.getCommand().getHistory(), this.m_COstream.getCommand().getUserMap(), this.m_COstream.getCommand().getViewMap());
            this.m_keywords = keywords;
            lineProcessor = new KeywordReader(new LineReader(new IdentityReader(this.m_COstream)), keywords.getKeywords(), true);
        }
        if (this.m_EOL != null && this.m_EOL.length() != 0) {
            lineProcessor = lineProcessor == null ? new EOLReader(new LineReader(new IdentityReader(this.m_COstream)), this.m_EOL) : new EOLReader(new LineReader(lineProcessor), this.m_EOL);
        }
        if (lineProcessor == null) {
            this.m_source = new BufferedInputStream(this.m_COstream);
        } else {
            this.m_transformsApplied = true;
            this.m_source = new BufferedInputStream(new TextInputStream(lineProcessor));
        }
    }

    public int read() throws IOException {
        return this.m_source.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.m_source.read(byArray, n, n2);
    }

    public void close() throws IOException {
        this.m_source.close();
    }

    public CheckOutStream(File file) {
        this.m_File = file;
    }

    public CheckOutStream(File file, int n, String string, boolean bl) throws IOException {
        this.m_File = file;
        this.m_EOL = string;
        this.m_doKeywords = bl;
        this.m_LockStatus = n;
        this.init();
    }
}

