/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheManager;
import com.starbase.starteam.CacheRef;
import com.starbase.starteam.Cacheable;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

abstract class Cache {
    protected CacheManager m_parent = null;
    protected Hashtable m_contents = null;
    private long m_lastModified = 0L;

    protected Cacheable get(Object object, int n) {
        int[] nArray = new int[]{n};
        Cacheable[] cacheableArray = this.get(object, nArray);
        if (cacheableArray != null && cacheableArray.length == 1) {
            return cacheableArray[0];
        }
        return null;
    }

    protected synchronized Cacheable[] get(Object object, int[] nArray) {
        int n;
        Object[] objectArray;
        int n2;
        Cacheable[] cacheableArray = this.getCached(nArray);
        int n3 = n2 = nArray.length;
        int[] nArray2 = nArray;
        if (this.isMPXAvailable()) {
            n3 = 0;
            objectArray = new int[n2];
            n = 0;
            while (n < n2) {
                Cacheable cacheable = cacheableArray[n];
                if (cacheable == null || this.isFetchRequired(cacheable, object)) {
                    objectArray[n3++] = nArray[n];
                }
                ++n;
            }
            if (n3 > 0 && n3 < n2) {
                nArray2 = new int[n3];
                n = 0;
                while (n < n3) {
                    nArray2[n] = objectArray[n];
                    ++n;
                }
            }
        }
        if (n3 == 0) {
            return cacheableArray;
        }
        objectArray = this.fetch(object, nArray2);
        if (objectArray.length != n3) {
            Assert.internalError("Cache.get(), fetch() returned " + objectArray.length + " objects; should have returned " + n3 + ".");
        }
        n = 0;
        int n4 = 0;
        while (n < n3) {
            if (nArray[n4] == nArray2[n]) {
                cacheableArray[n4] = this.set((Cacheable)objectArray[n++]);
            }
            ++n4;
        }
        return cacheableArray;
    }

    protected synchronized Cacheable getCached(int n) {
        return (Cacheable)this.m_contents.get(new Integer(n));
    }

    protected synchronized Cacheable[] getCached(int[] nArray) {
        int n = nArray.length;
        Cacheable[] cacheableArray = new Cacheable[n];
        int n2 = 0;
        while (n2 < n) {
            cacheableArray[n2] = this.getCached(nArray[n2]);
            ++n2;
        }
        return cacheableArray;
    }

    protected boolean isFetchRequired(Cacheable cacheable, Object object) {
        return cacheable.isDirty();
    }

    protected synchronized Cacheable set(Cacheable cacheable) {
        Cacheable cacheable2 = null;
        if (cacheable != null) {
            Integer n = new Integer(cacheable.getID());
            cacheable2 = (Cacheable)this.m_contents.get(n);
            if (cacheable2 == null || !cacheable.isEqualTo(cacheable2)) {
                if (cacheable2 != null) {
                    cacheable2.setDirty(true);
                }
                this.m_contents.put(n, cacheable);
                this.setModified();
                cacheable.setDirty(false);
                cacheable2 = cacheable;
            } else if (cacheable2 != null) {
                cacheable2.setDirty(false);
            }
        }
        return cacheable2;
    }

    protected synchronized void setObjectDirty(int n) {
        Cacheable cacheable = this.getCached(n);
        if (cacheable != null) {
            cacheable.setDirty(true);
            this.setModified();
        }
    }

    protected synchronized void setAllDirty() {
        Enumeration enumeration = this.m_contents.elements();
        while (enumeration.hasMoreElements()) {
            Cacheable cacheable = (Cacheable)enumeration.nextElement();
            cacheable.setDirty(true);
        }
        this.setModified();
    }

    protected synchronized void discard(int n) {
        this.m_contents.remove(new Integer(n));
    }

    protected synchronized void discardAll() {
        this.m_contents.clear();
    }

    protected synchronized void refresh(Object object, Vector vector) {
        if (this.isRefreshRequired(vector)) {
            this.internalRefresh(object, vector);
        }
    }

    protected void internalRefresh(Object object, Vector vector) {
        Cacheable[] cacheableArray;
        int n = vector.size();
        int[] nArray = new int[n];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            cacheableArray = (Cacheable[])enumeration.nextElement();
            Cacheable cacheable = cacheableArray.getCachedObject();
            nArray[n2++] = cacheable.getID();
        }
        cacheableArray = this.get(object, nArray);
        this.updateInPlace(object, vector, cacheableArray);
    }

    protected void updateInPlace(Object object, Vector vector, Cacheable[] cacheableArray) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CacheRef cacheRef = (CacheRef)enumeration.nextElement();
            cacheRef.setCachedObject(cacheableArray[n++]);
        }
    }

    protected boolean isMPXAvailable() {
        return this.getParent().useMPX(this);
    }

    protected synchronized boolean isRefreshRequired(Vector vector) {
        if (vector.size() == 0) {
            return false;
        }
        boolean bl = true;
        if (this.isMPXAvailable()) {
            bl = false;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CacheRef cacheRef = (CacheRef)enumeration.nextElement();
                Cacheable cacheable = cacheRef.getCachedObject();
                if (!cacheable.isDirty()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected abstract Cacheable[] fetch(Object var1, int[] var2);

    protected synchronized int[] getCachedIDs() {
        int n = this.m_contents.size();
        int[] nArray = new int[n];
        Enumeration enumeration = this.m_contents.keys();
        int n2 = n;
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            nArray[--n2] = n3;
        }
        return nArray;
    }

    protected CacheManager getParent() {
        return this.m_parent;
    }

    protected long getLastModified() {
        return this.m_lastModified;
    }

    protected long setModified() {
        this.m_lastModified = this.getParent().getTimestamp();
        return this.m_lastModified;
    }

    protected Cache(CacheManager cacheManager, int n) {
        this.m_parent = cacheManager;
        this.m_contents = new Hashtable(n);
    }

    protected Cache(CacheManager cacheManager) {
        this.m_parent = cacheManager;
        this.m_contents = new Hashtable();
    }
}

