/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertySortCollection;

class ByteArrayCollection
extends PropertySortCollection {
    private byte[][] m_dest;
    private byte[][] m_scratchpad;
    private boolean m_bAscending = true;

    public void swap(int n, int n2) {
        byte[] byArray = this.m_dest[n];
        this.m_dest[n] = this.m_dest[n2];
        this.m_dest[n2] = byArray;
    }

    public void copySequence(int n, int n2) {
        System.arraycopy(this.m_scratchpad, n, this.m_dest, n, n2);
    }

    public void setFromScratchpad(int n, int n2) {
        this.m_dest[n2] = this.m_scratchpad[n];
    }

    public void saveToScratchpad(int n, int n2) {
        this.m_scratchpad[n2] = this.m_dest[n];
    }

    public int compareScratchpad(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_scratchpad[n], this.m_scratchpad[n2]);
        }
        return this.comp(this.m_scratchpad[n2], this.m_scratchpad[n]);
    }

    public int compare(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_dest[n], this.m_dest[n2]);
        }
        return this.comp(this.m_dest[n2], this.m_dest[n]);
    }

    private int comp(byte[] byArray, byte[] byArray2) {
        if (byArray.length > byArray2.length) {
            return 1;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] > byArray2[n]) {
                return 1;
            }
            if (byArray[n] < byArray2[n]) {
                return -1;
            }
            ++n;
        }
        return 0;
    }

    public ByteArrayCollection(ItemList itemList, GroupSortInfo groupSortInfo, Property property) {
        super(itemList, groupSortInfo, property);
        this.m_bAscending = groupSortInfo.isAscending();
        int n = this.length();
        this.m_dest = new byte[n][];
        this.m_scratchpad = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = (byte[])itemList.getAt(n2).getByProperty(property);
            this.m_dest[n2] = byArray;
            this.m_scratchpad[n2] = byArray;
            ++n2;
        }
    }
}

