/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.Sequence;
import com.starbase.diff.SharedCharSequence;
import com.starbase.diff.StringCharSequence;
import com.starbase.util.LineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;

public class ParsedCharSequence
implements Sequence {
    private Vector m_Lines = new Vector(5000, 5000);
    private CharSequence m_source = null;
    private boolean m_autoeol = true;
    private char m_delimiter = '\u0000';

    private String getEOLCharacters(int n) {
        switch (n) {
            case 0: {
                return "\r";
            }
            case 2: {
                return "\r\n";
            }
            case 1: {
                return "\n";
            }
        }
        return "";
    }

    private void initFromReader(LineReader lineReader) throws IOException {
        try {
            this.m_autoeol = true;
            this.m_delimiter = '\u0000';
            String string = lineReader.readLine();
            while (string != null) {
                string = string.concat(this.getEOLCharacters(lineReader.getLastEOL()));
                this.addLine(new StringCharSequence(string));
                string = lineReader.readLine();
            }
        }
        finally {
            Object var3_3 = null;
            lineReader.close();
        }
    }

    private void initFromReader(BufferedReader bufferedReader) throws IOException {
        try {
            this.m_autoeol = true;
            this.m_delimiter = '\u0000';
            String string = bufferedReader.readLine();
            while (string != null) {
                this.addLine(new StringCharSequence(string));
                string = bufferedReader.readLine();
            }
        }
        finally {
            Object var3_3 = null;
            bufferedReader.close();
        }
    }

    public void addLine(CharSequence charSequence) {
        this.m_Lines.addElement(charSequence);
    }

    public CharSequence getLine(int n) {
        return (CharSequence)this.m_Lines.elementAt(n);
    }

    public int size() {
        return this.m_Lines.size();
    }

    public boolean add(Object object) {
        this.addLine((CharSequence)object);
        return true;
    }

    public Object get(int n) {
        return this.getLine(n);
    }

    /*
     * Unable to fully structure code
     */
    private final void parseLines() {
        var1_1 = 0;
        var2_2 = 0;
        var3_3 = this.m_source.length();
        var4_4 = 0;
        ** GOTO lbl12
        {
            ++var1_1;
            do {
                if (var1_1 < var3_3 && this.m_delimiter != this.m_source.charAt(var1_1)) continue block0;
                var4_4 = var1_1 >= var3_3 ? var3_3 - var2_2 : var1_1 - var2_2 + 1;
                this.addLine(new SharedCharSequence(this.m_source, var2_2, var4_4));
                var2_2 = ++var1_1;
lbl12:
                // 2 sources

            } while (var1_1 < var3_3);
        }
    }

    public ParsedCharSequence(CharSequence charSequence) throws IOException {
        this.m_source = charSequence;
        this.m_autoeol = true;
        this.m_delimiter = '\u0000';
        this.parseLines();
    }

    public ParsedCharSequence(CharSequence charSequence, char c) throws IOException {
        this.m_source = charSequence;
        this.m_autoeol = false;
        this.m_delimiter = c;
        this.parseLines();
    }

    public ParsedCharSequence(BufferedReader bufferedReader) throws IOException {
        this.initFromReader(bufferedReader);
    }

    public ParsedCharSequence(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            this.initFromReader((BufferedReader)reader);
        } else {
            this.initFromReader(new BufferedReader(reader));
        }
    }

    public ParsedCharSequence(LineReader lineReader) throws IOException {
        this.initFromReader(lineReader);
    }

    public ParsedCharSequence(File file) throws IOException {
        this.initFromReader(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
    }

    public ParsedCharSequence(File file, String string) throws IOException {
        this.initFromReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string)));
    }

    public ParsedCharSequence(File file, boolean bl) throws IOException {
        if (bl) {
            this.initFromReader(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
        } else {
            this.initFromReader(new LineReader(new BufferedReader(new InputStreamReader(new FileInputStream(file)))));
        }
    }

    public ParsedCharSequence(File file, String string, boolean bl) throws IOException {
        if (bl) {
            this.initFromReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string)));
        } else {
            this.initFromReader(new LineReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string))));
        }
    }
}

