/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.BasicCompare;
import com.starbase.diff.DiffCompare;
import com.starbase.diff.DiffException;
import com.starbase.diff.EditList;
import com.starbase.diff.HTMLDiffWriter;
import com.starbase.diff.HTMLTableDiffWriter;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.diff.StarTeamDiff;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;

public class HTMLStereoDiffWriter
extends HTMLTableDiffWriter {
    private static final String HTML_ROW_HEADER = "<TR><TD nowrap class=\"CNVD\">&nbsp;{1}&nbsp;{2}&nbsp;</TD><TD nowrap>&nbsp;&nbsp;&nbsp;</TD><TD nowrap class=\"CHD\" colSpan=\"4\"><SPAN class=\"HD\">{3}</SPAN></TD><TD nowrap>&nbsp;&nbsp;&nbsp;</TD><TD nowrap class=\"CCHD\">&nbsp;</TD><TD nowrap>&nbsp;&nbsp;&nbsp;</TD><TD nowrap class=\"CH2\" colSpan=\"4\"><SPAN class=\"HD\"> {4} </SPAN></TD></TR>\r\n";
    private static final String HTML_ROW_BORDER = "<TR><TD nowrap class=\"CNV\">&nbsp;</TD><TD nowrap>&nbsp;&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;&nbsp;&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;&nbsp;&nbsp;</TD><TD nowrap>&nbsp;&nbsp;</TD><TD nowrap class=\"CCHD\">&nbsp;</TD><TD nowrap>&nbsp;&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;&nbsp;&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;</TD><TD nowrap class=\"CBR\">&nbsp;&nbsp;&nbsp;</TD></TR>\r\n";
    private static final String HTML_ROW_LINE_SAME = "<TR><TD class=\"CNV\">{0}</TD><TD></TD><TD class=\"CBR\"></TD><TD {10}>{4}</TD><TD nowrap>&nbsp;{5}&nbsp;</TD><TD class=\"CBR\"></TD><TD></TD><TD class=\"CTU\">{1}</TD><TD></TD><TD class=\"CBR\"></TD><TD class=\"CL2\">{8}</TD><TD nowrap>&nbsp;{9}&nbsp;</TD><TD class=\"CBR\"></TD></TR>\r\n";
    private static final String HTML_ROW_LINE_ADDED = "<TR><TD class=\"CNV\">{0}</TD><TD></TD><TD class=\"CBR\"></TD><TD {10}>{4}</TD><TD nowrap {2}>&nbsp;{5}&nbsp;</TD><TD class=\"CBR\"></TD><TD></TD><TD class=\"CTA\">{1}</TD><TD></TD><TD class=\"CBR\"></TD><TD class=\"CL2\">{8}</TD><TD nowrap {6}>&nbsp;<SPAN {7}>{9}</SPAN>&nbsp;</TD><TD class=\"CBR\"></TD></TR>\r\n";
    private static final String HTML_ROW_LINE_DELETED = "<TR><TD class=\"CNV\">{0}</TD><TD></TD><TD class=\"CBR\"></TD><TD {10}>{4}</TD><TD nowrap {2}>&nbsp;<SPAN {3}>{5}</SPAN>&nbsp;</TD><TD class=\"CBR\"></TD><TD></TD><TD class=\"CTD\">{1}</TD><TD></TD><TD class=\"CBR\"></TD><TD {12}>{8}</TD><TD nowrap {6}>&nbsp;{9}&nbsp;</TD><TD class=\"CBR\"></TD></TR>\r\n";
    private static final String HTML_ROW_LINE_REPLACED = "<TR><TD class=\"CNV\">{0}</TD><TD></TD><TD class=\"CBR\"></TD><TD {10}>{4}</TD><TD nowrap {2}>&nbsp;<SPAN {3}>{5}</SPAN>&nbsp;</TD><TD class=\"CBR\"></TD><TD></TD><TD class=\"CTR\">{1}</TD><TD></TD><TD class=\"CBR\"></TD><TD class=\"CL2\">{8}</TD><TD nowrap {6}>&nbsp;<SPAN {7}>{9}</SPAN>&nbsp;</TD><TD class=\"CBR\"></TD></TR>\r\n";
    private static final String HTML_ROW_LINE_ELLIPSIS = "<TR><TD></TD><TD></TD><TD colspan=4><HR></TD><TD></TD><TD></TD><TD></TD><TD colspan=4><HR></TD></TR>\r\n";

    public static void diff(File file, File file2, File file3) throws FileNotFoundException, IOException, DiffException {
        int n = 25;
        HTMLStereoDiffWriter.diff(file, file2, n, file3);
    }

    public static void diff(File file, File file2, int n, File file3) throws FileNotFoundException, IOException, DiffException {
        BasicCompare basicCompare = new BasicCompare(n, null);
        HTMLStereoDiffWriter.diff(file, file2, basicCompare, file3);
    }

    public static void diff(File file, File file2, DiffCompare diffCompare, File file3) throws FileNotFoundException, IOException, DiffException {
        ParsedCharSequence parsedCharSequence = new ParsedCharSequence(file);
        ParsedCharSequence parsedCharSequence2 = new ParsedCharSequence(file2);
        StarTeamDiff starTeamDiff = new StarTeamDiff();
        EditList editList = starTeamDiff.diff(parsedCharSequence, parsedCharSequence2, diffCompare);
        HTMLStereoDiffWriter hTMLStereoDiffWriter = new HTMLStereoDiffWriter(parsedCharSequence, parsedCharSequence2, file3);
        hTMLStereoDiffWriter.write(editList, parsedCharSequence.size(), parsedCharSequence2.size());
    }

    protected String getRowHeaderHTML() {
        return HTML_ROW_HEADER;
    }

    protected String getRowFooterHTML() {
        return HTML_ROW_HEADER;
    }

    protected String getRowBorderHTML() {
        return HTML_ROW_BORDER;
    }

    protected String getHTMLRowLineSame() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_SAME);
    }

    protected String getHTMLRowLineAdded() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_ADDED);
    }

    protected String getHTMLRowLineDeleted() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_DELETED);
    }

    protected String getHTMLRowLineReplaced() {
        return this.getHTMLRowLine_LineNumbers(HTML_ROW_LINE_REPLACED);
    }

    protected String getLeftReplaceText(HTMLDiffWriter.IntralineDiff intralineDiff) throws IOException {
        return intralineDiff.getSourceMarkupText();
    }

    protected String getRightReplaceText(HTMLDiffWriter.IntralineDiff intralineDiff) throws IOException {
        return intralineDiff.getTargetMarkupText();
    }

    protected String getHTMLRowEllipsis() {
        return HTML_ROW_LINE_ELLIPSIS;
    }

    public HTMLStereoDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, File file) throws IOException {
        super(parsedCharSequence, parsedCharSequence2, file);
    }

    public HTMLStereoDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, BufferedWriter bufferedWriter) {
        this(parsedCharSequence, parsedCharSequence2, (Writer)bufferedWriter);
    }

    public HTMLStereoDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, Writer writer) {
        super(parsedCharSequence, parsedCharSequence2, writer);
    }
}

