/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.BasicCompare;
import com.starbase.diff.CharSequence;
import com.starbase.diff.DiffCompare;
import com.starbase.diff.DiffException;
import com.starbase.diff.EditList;
import com.starbase.diff.EditListWriter;
import com.starbase.diff.IntralineSequence;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.diff.Res;
import com.starbase.diff.ResIDs;
import com.starbase.diff.Sequence;
import com.starbase.diff.StarTeamDiff;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class HTMLDiffWriter
extends EditListWriter {
    protected static final String EMPTY = "";
    protected static final String HTML_EOL = "\r\n";
    protected static final String HTML_AMP = "&amp;";
    protected static final String HTML_LT = "&lt;";
    protected static final String HTML_GT = "&gt;";
    protected static final String HTML_NBSP = "&nbsp;";
    protected static String HTML_SP = "&nbsp;";
    protected static final String HTML_CR = "[CR]";
    protected static final String HTML_LF = "[LF]";
    public static final int DEFAULT_SPACES_PER_TAB = 4;
    private static final String SPACE = " ";
    private static final String VERT_BAR = "|";
    private static final String NAV_TOP = "[[";
    private static final String NAV_BOT = "]]";
    private static final String NAV_FIRST = "[&gt;";
    private static final String NAV_LAST = "&lt;]";
    private static final String NAV_NEXT = "&gt;&gt;";
    private static final String NAV_PREV = "&lt;&lt;";
    private static final String NAV_NONE = "  ";
    private static final String ADDED_SYMBOL = "+";
    private static final String DELETED_SYMBOL = "-";
    private static final String REPLACED_SYMBOL = "*";
    private static final String UNCHANGED_SYMBOL = " ";
    protected static final String CLASSNAME_DIFFTABLE = "difftabl";
    protected static final String CLASSNAME_ADDED = "add";
    protected static final String CLASSNAME_DELETED = "del";
    protected static final String CLASSNAME_REPLACED = "rep";
    protected static final String CLASSNAME_ADDEDSYMBOL = "sadd";
    protected static final String CLASSNAME_DELETEDSYMBOL = "sdel";
    protected static final String CLASSNAME_REPLACEDSYMBOL = "srep";
    protected static final String CLASSNAME_INLINE_ADD = "ila";
    protected static final String CLASSNAME_INLINE_DEL = "ild";
    protected static final String CLASSNAME_FILENAME = "filename";
    protected static final String CLASSNAME_EOL = "eol";
    private static final int MAX_NUMBER_COLS = 5;
    private String m_strTitle = null;
    private String m_strBaseURL = null;
    private String m_strSourceFileHTML = null;
    private String m_strTargetFileHTML = null;
    private String m_strSourceFileURL = null;
    private String m_strTargetFileURL = null;
    private String m_strAppHeaderHTML = null;
    private String m_strAppFooterHTML = null;
    private boolean m_bEmbedStyles = true;
    private String m_strStyleSheet = "diff.css";
    private boolean m_bShowInlineDiffs = true;
    private int m_tabs = 4;
    private String m_strGotoTopHTML = "[[";
    private String m_strGotoBottomHTML = "]]";
    private String m_strGotoFirstDiffHTML = "[&gt;";
    private String m_strGotoLastDiffHTML = "&lt;]";
    private String m_strGotoPrevDiffHTML = "&lt;&lt;";
    private String m_strGotoNextDiffHTML = "&gt;&gt;";
    private String m_strGotoBlankHTML = "  ";
    private boolean m_bNavigateOnEveryLine = false;
    private boolean m_bShowLineNumbers = true;
    private boolean m_bShowUnchangedLines = true;
    private int m_nContextLines = -1;
    protected int m_sourceLength = 0;
    protected int m_targetLength = 0;
    private boolean m_bShowEOLs = true;
    private String m_strCRHTML = "[CR]";
    private String m_strLFHTML = "[LF]";
    private String m_strAddedSymbolHTML = "+";
    private String m_strDeletedSymbolHTML = "-";
    private String m_strReplacedSymbolHTML = "*";
    private String m_strUnchangedSymbolHTML = " ";
    private String m_strInlineInsertMarkHTML = "";
    private String m_strInlineDeleteMarkHTML = "";
    private Writer m_out = null;
    protected ParsedCharSequence m_source = null;
    protected ParsedCharSequence m_target = null;
    private boolean m_trouble = false;
    protected int m_anchornum = 0;
    private String m_encoding = "UTF-8";
    private boolean m_bAutoCloseOutput = false;

    public void setPageTitle(String string) {
        this.m_strTitle = string;
    }

    public String getPageTitle() {
        return this.m_strTitle;
    }

    public void setPageBaseURL(String string) {
        this.m_strBaseURL = string;
    }

    public String getPageBaseURL() {
        return this.m_strBaseURL;
    }

    public void setSourceFileHTML(String string) {
        this.m_strSourceFileHTML = string;
    }

    public String getSourceFileHTML() {
        return this.m_strSourceFileHTML;
    }

    public void setTargetFileHTML(String string) {
        this.m_strTargetFileHTML = string;
    }

    public String getTargetFileHTML() {
        return this.m_strTargetFileHTML;
    }

    public void setSourceFileURL(String string) {
        this.m_strSourceFileURL = string;
    }

    public String getSourceFileURL() {
        return this.m_strSourceFileURL;
    }

    public void setTargetFileURL(String string) {
        this.m_strTargetFileURL = string;
    }

    public String getTargetFileURL() {
        return this.m_strTargetFileURL;
    }

    public void setApplicationHeaderHTML(String string) {
        this.m_strAppHeaderHTML = string;
    }

    public String getApplicationHeaderHTML() {
        return this.m_strAppHeaderHTML;
    }

    public void setApplicationFooterHTML(String string) {
        this.m_strAppFooterHTML = string;
    }

    public String getApplicationFooterHTML() {
        return this.m_strAppFooterHTML;
    }

    public void setEmbedDefaultStyles(boolean bl) {
        this.m_bEmbedStyles = bl;
    }

    public boolean getEmbedDefaultStyles() {
        return this.m_bEmbedStyles;
    }

    public void setStyleSheetURL(String string) {
        this.m_strStyleSheet = string;
    }

    public String getStyleSheetURL() {
        return this.m_strStyleSheet;
    }

    public void setShowInlineDiffs(boolean bl) {
        this.m_bShowInlineDiffs = bl;
    }

    public boolean getShowInlineDiffs() {
        return this.m_bShowInlineDiffs;
    }

    public void setSpacesPerTab(int n) {
        this.m_tabs = n;
    }

    public int getSpacesPerTab() {
        return this.m_tabs;
    }

    public void setGotoTopHTML(String string) {
        this.m_strGotoTopHTML = string;
    }

    public String getGotoTopHTML() {
        return this.m_strGotoTopHTML != null ? this.m_strGotoTopHTML : this.getGotoBlankHTML();
    }

    public void setGotoBottomHTML(String string) {
        this.m_strGotoBottomHTML = string;
    }

    public String getGotoBottomHTML() {
        return this.m_strGotoBottomHTML != null ? this.m_strGotoBottomHTML : this.getGotoBlankHTML();
    }

    public void setGotoFirstDiffHTML(String string) {
        this.m_strGotoFirstDiffHTML = string;
    }

    public String getGotoFirstDiffHTML() {
        return this.m_strGotoFirstDiffHTML != null ? this.m_strGotoFirstDiffHTML : this.getGotoBlankHTML();
    }

    public void setGotoLastDiffHTML(String string) {
        this.m_strGotoLastDiffHTML = string;
    }

    public String getGotoLastDiffHTML() {
        return this.m_strGotoLastDiffHTML != null ? this.m_strGotoLastDiffHTML : this.getGotoBlankHTML();
    }

    public void setGotoPrevDiffHTML(String string) {
        this.m_strGotoPrevDiffHTML = string;
    }

    public String getGotoPrevDiffHTML() {
        return this.m_strGotoPrevDiffHTML != null ? this.m_strGotoPrevDiffHTML : this.getGotoBlankHTML();
    }

    public void setGotoNextDiffHTML(String string) {
        this.m_strGotoNextDiffHTML = string;
    }

    public String getGotoNextDiffHTML() {
        return this.m_strGotoNextDiffHTML != null ? this.m_strGotoNextDiffHTML : this.getGotoBlankHTML();
    }

    public void setGotoBlankHTML(String string) {
        this.m_strGotoBlankHTML = string;
    }

    public String getGotoBlankHTML() {
        return this.m_strGotoBlankHTML != null ? this.m_strGotoBlankHTML : NAV_NONE;
    }

    public void setNavigateOnEveryChangedLine(boolean bl) {
        this.m_bNavigateOnEveryLine = bl;
    }

    public boolean getNavigateOnEveryChangedLine() {
        return this.m_bNavigateOnEveryLine;
    }

    public void setShowLineNumbers(boolean bl) {
        this.m_bShowLineNumbers = bl;
    }

    public boolean getShowLineNumbers() {
        return this.m_bShowLineNumbers;
    }

    public void setShowUnchangedLines(boolean bl) {
        this.m_bShowUnchangedLines = bl;
    }

    public boolean getShowUnchangedLines() {
        return this.m_bShowUnchangedLines;
    }

    public void setNumContextLines(int n) {
        this.m_nContextLines = n;
    }

    public int getNumContextLines() {
        return this.m_nContextLines;
    }

    public void setShowEOLs(boolean bl) {
        this.m_bShowEOLs = bl;
    }

    public boolean getShowEOLs() {
        return this.m_bShowEOLs;
    }

    public void setCRHTML(String string) {
        this.m_strCRHTML = string;
    }

    public String getCRHTML() {
        return this.m_strCRHTML;
    }

    public void setLFHTML(String string) {
        this.m_strLFHTML = string;
    }

    public String getLFHTML() {
        return this.m_strLFHTML;
    }

    public void setAddedSymbolHTML(String string) {
        this.m_strAddedSymbolHTML = string;
    }

    public String getAddedSymbolHTML() {
        return this.m_strAddedSymbolHTML != null ? this.m_strAddedSymbolHTML : HTML_SP;
    }

    public void setDeletedSymbolHTML(String string) {
        this.m_strDeletedSymbolHTML = string;
    }

    public String getDeletedSymbolHTML() {
        return this.m_strDeletedSymbolHTML != null ? this.m_strDeletedSymbolHTML : HTML_SP;
    }

    public void setReplacedSymbolHTML(String string) {
        this.m_strReplacedSymbolHTML = string;
    }

    public String getReplacedSymbolHTML() {
        return this.m_strReplacedSymbolHTML != null ? this.m_strReplacedSymbolHTML : HTML_SP;
    }

    public void setUnchangedSymbolHTML(String string) {
        this.m_strUnchangedSymbolHTML = string;
    }

    public String getUnchangedSymbolHTML() {
        return this.m_strUnchangedSymbolHTML != null ? this.m_strUnchangedSymbolHTML : HTML_SP;
    }

    public void setInlineInsertMarkHTML(String string) {
        this.m_strInlineInsertMarkHTML = string;
    }

    public String getInlineInsertMarkHTML() {
        return this.m_strInlineInsertMarkHTML != null ? this.m_strInlineInsertMarkHTML : EMPTY;
    }

    public void setInlineDeleteMarkHTML(String string) {
        this.m_strInlineDeleteMarkHTML = string;
    }

    public String getInlineDeleteMarkHTML() {
        return this.m_strInlineDeleteMarkHTML != null ? this.m_strInlineDeleteMarkHTML : EMPTY;
    }

    public static void simpleDiff(File file, File file2, File file3) throws FileNotFoundException, IOException, DiffException {
        HTMLDiffWriter.diff(file, file2, file3);
    }

    static void diff(File file, File file2, File file3) throws FileNotFoundException, IOException, DiffException {
        int n = 25;
        HTMLDiffWriter.diff(file, file2, n, file3);
    }

    static void diff(File file, File file2, int n, File file3) throws FileNotFoundException, IOException, DiffException {
        BasicCompare basicCompare = new BasicCompare(n, null);
        HTMLDiffWriter.diff(file, file2, basicCompare, file3);
    }

    static void diff(File file, File file2, DiffCompare diffCompare, File file3) throws FileNotFoundException, IOException, DiffException {
        ParsedCharSequence parsedCharSequence = new ParsedCharSequence(file);
        ParsedCharSequence parsedCharSequence2 = new ParsedCharSequence(file2);
        StarTeamDiff starTeamDiff = new StarTeamDiff();
        EditList editList = starTeamDiff.diff(parsedCharSequence, parsedCharSequence2, diffCompare);
        HTMLDiffWriter hTMLDiffWriter = new HTMLDiffWriter(parsedCharSequence, parsedCharSequence2, file3);
        hTMLDiffWriter.write(editList, parsedCharSequence.size(), parsedCharSequence2.size());
    }

    private void commonInit(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, Writer writer) {
        this.m_source = parsedCharSequence;
        this.m_target = parsedCharSequence2;
        this.m_sourceLength = parsedCharSequence.size();
        this.m_targetLength = parsedCharSequence2.size();
        this.m_out = writer;
        this.m_bAutoCloseOutput = false;
        HTML_SP = " ";
    }

    protected void finalize() throws Throwable {
        if (this.m_bAutoCloseOutput) {
            if (this.m_out != null) {
                this.m_out.close();
            }
            this.m_bAutoCloseOutput = false;
        }
    }

    public void start() throws IOException {
        this.m_anchornum = 0;
        this.writeHeader();
    }

    public void finish() throws IOException {
        this.writeFooter();
        this.m_out.flush();
        if (this.m_bAutoCloseOutput) {
            this.m_out.close();
            this.m_bAutoCloseOutput = false;
        }
    }

    public void unchangedLines(int n, int n2, int n3) throws IOException {
        block8: {
            int n4;
            int n5;
            boolean bl;
            boolean bl2;
            boolean bl3;
            block7: {
                if (n3 == 0) {
                    return;
                }
                if (!this.getShowUnchangedLines()) {
                    return;
                }
                bl3 = n == 1 && n2 == 1;
                bl2 = n + n3 - 1 == this.m_sourceLength && n2 + n3 - 1 == this.m_targetLength;
                bl = bl3 || bl2;
                n5 = this.getNumContextLines();
                if (n5 >= 0 && (!bl || n5 < n3) && (bl || 2 * n5 < n3)) break block7;
                int n6 = 0;
                while (n6 < n3) {
                    this.doUnchangedLine(n + n6, n2 + n6);
                    ++n6;
                }
                break block8;
            }
            if (!bl3) {
                n4 = 0;
                while (n4 < n5) {
                    this.doUnchangedLine(n + n4, n2 + n4);
                    ++n4;
                }
            }
            if (!bl) {
                this.addHRULE();
            }
            if (bl2) break block8;
            n4 = n3 - n5;
            while (n4 < n3) {
                this.doUnchangedLine(n + n4, n2 + n4);
                ++n4;
            }
        }
    }

    private void doUnchangedLine(int n, int n2) throws IOException {
        this.writeNav(false);
        this.write(this.getFormattedUnchangedSymbol());
        this.writeLineNumbers(n, n2);
        this.write(HTML_SP);
        this.write(VERT_BAR);
        this.outputLine(this.m_source.getLine(n - 1), null);
    }

    public void insertLines(int n, int n2, int n3) throws IOException {
        this.startAnchor();
        boolean bl = true;
        int n4 = 0;
        while (n4 < n3) {
            this.writeNav(bl);
            this.write(this.getFormattedAddedSymbol());
            this.writeLineNumbers(0, n2 + n4);
            this.write(HTML_SP);
            this.write(VERT_BAR);
            this.outputLine(this.m_target.getLine(n2 + n4 - 1), CLASSNAME_ADDED);
            bl = this.getNavigateOnEveryChangedLine();
            ++n4;
        }
        this.endAnchor();
    }

    public void deleteLines(int n, int n2, int n3) throws IOException {
        this.startAnchor();
        boolean bl = true;
        int n4 = 0;
        while (n4 < n3) {
            this.writeNav(bl);
            this.write(this.getFormattedDeletedSymbol());
            this.writeLineNumbers(n + n4, 0);
            this.write(HTML_SP);
            this.write(VERT_BAR);
            this.outputLine(this.m_source.getLine(n + n4 - 1), CLASSNAME_DELETED);
            bl = this.getNavigateOnEveryChangedLine();
            ++n4;
        }
        this.endAnchor();
    }

    public void replaceLines(int n, int n2, int n3, int n4) throws IOException {
        if (!this.getShowInlineDiffs() || n2 != n4) {
            this.insertLines(n, n3, n4);
            this.deleteLines(n, n3, n2);
        } else {
            this.startAnchor();
            boolean bl = true;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = n + n5;
                int n7 = n3 + n5;
                CharSequence charSequence = this.m_source.getLine(n6 - 1);
                CharSequence charSequence2 = this.m_target.getLine(n7 - 1);
                try {
                    HTMLDiffWriter hTMLDiffWriter = this;
                    if (hTMLDiffWriter == null) {
                        throw null;
                    }
                    IntralineDiff intralineDiff = hTMLDiffWriter.new IntralineDiff(charSequence, charSequence2);
                    String string = intralineDiff.getCombinedMarkupText();
                    this.writeNav(bl);
                    this.write(this.getFormattedReplacedSymbol());
                    this.writeLineNumbers(n6, n7);
                    this.write(HTML_SP);
                    this.write(VERT_BAR);
                    this.startSpan(CLASSNAME_REPLACED);
                    this.writeln(string);
                    this.endSpan();
                    bl = this.getNavigateOnEveryChangedLine();
                }
                catch (DiffException diffException) {
                    // empty catch block
                }
                ++n5;
            }
            this.endAnchor();
        }
    }

    private void outputLine(CharSequence charSequence, String string) throws IOException {
        if (string != null) {
            this.startSpan(string);
        }
        this.outputSourceText(charSequence);
        if (string != null) {
            this.endSpan();
        }
        this.write(HTML_EOL);
    }

    private void outputSourceText(CharSequence charSequence) throws IOException {
        this.write(this.makeSourceLine(charSequence));
    }

    private void outputSourceText(int n, CharSequence charSequence, int n2) throws IOException {
        this.write(this.makeSourceText(n, charSequence, n2));
    }

    protected String makeSourceLine(CharSequence charSequence) {
        return this.makeSourceText(0, charSequence, this.lengthNoEOL(charSequence));
    }

    protected String makeSourceText(int n, CharSequence charSequence, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            char c = charSequence.charAt(n3);
            if (this.m_tabs > 0 && c == '\t') {
                n4 = this.m_tabs - (n3 + n) % this.m_tabs;
                int n5 = 0;
                while (n5 < n4) {
                    stringBuffer.append(HTML_SP);
                    ++n5;
                }
                bl = false;
            } else if (c == ' ') {
                if (bl && n3 + 1 < n2) {
                    n4 = charSequence.charAt(n3 + 1);
                    if (n4 != 32 && n4 != 9) {
                        stringBuffer.append(' ');
                    } else {
                        stringBuffer.append(HTML_SP);
                    }
                } else {
                    stringBuffer.append(HTML_SP);
                }
                bl = false;
            } else {
                stringBuffer.append(this.makeHTMLChar(c));
                bl = true;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected int lengthNoEOL(CharSequence charSequence) {
        int n = charSequence.length() - 1;
        while (n >= 0) {
            char c = charSequence.charAt(n);
            if (c != '\r' && c != '\n') break;
            --n;
        }
        return n + 1;
    }

    private void writeLineNumbers(int n, int n2) throws IOException {
        if (!this.getShowLineNumbers()) {
            return;
        }
        this.outputLineNumber(n);
        this.write(HTML_SP);
        this.outputLineNumber(n2);
    }

    private void outputLineNumber(int n) throws IOException {
        if (n > 0) {
            this.write(this.makeLineNumber(n));
        } else {
            this.write(this.makeNoLineNumber());
        }
    }

    protected String makeLineNumber(int n) {
        String string = n > 0 ? String.valueOf(n) : REPLACED_SYMBOL;
        int n2 = 5 - string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(HTML_SP);
            ++n3;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected String makeNoLineNumber() {
        String string = EMPTY;
        int n = 0;
        while (n < 5) {
            string = string + HTML_SP;
            ++n;
        }
        return string;
    }

    private void writeNav(boolean bl) throws IOException {
        this.write(this.makeNav(bl));
    }

    protected String makeNav(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HTML_SP);
        if (bl) {
            int n = this.m_anchornum;
            stringBuffer.append("<A NAME=\"" + this.getAnchorName(n) + "\">");
            stringBuffer.append(this.makeLink(this.getGotoPrevDiffHTML(), n - 1, Res.getString(ResIDs.PREV_DIFF)));
        } else {
            stringBuffer.append(this.getGotoBlankHTML());
        }
        stringBuffer.append(HTML_SP);
        if (bl) {
            stringBuffer.append(this.makeLink(this.getGotoNextDiffHTML(), this.m_anchornum + 1, Res.getString(ResIDs.NEXT_DIFF)));
        } else {
            stringBuffer.append(this.getGotoBlankHTML());
        }
        stringBuffer.append(HTML_SP);
        return stringBuffer.toString();
    }

    protected String getFormattedEOL(String string) {
        return this.getFormattedSymbol(string, CLASSNAME_EOL);
    }

    protected String getFormattedUnchangedSymbol() {
        return this.getFormattedSymbol(this.getUnchangedSymbolHTML(), null);
    }

    protected String getFormattedAddedSymbol() {
        return this.getFormattedSymbol(this.getAddedSymbolHTML(), CLASSNAME_ADDEDSYMBOL);
    }

    protected String getFormattedDeletedSymbol() {
        return this.getFormattedSymbol(this.getDeletedSymbolHTML(), CLASSNAME_DELETEDSYMBOL);
    }

    protected String getFormattedReplacedSymbol() {
        return this.getFormattedSymbol(this.getReplacedSymbolHTML(), CLASSNAME_REPLACEDSYMBOL);
    }

    protected String getFormattedSymbol(String string, String string2) {
        if (string2 != null) {
            return "<SPAN class=\"" + string2 + "\">" + string + "</SPAN>";
        }
        return string;
    }

    protected String makeLink(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<A href=\"#");
        stringBuffer.append(this.getAnchorName(n));
        stringBuffer.append("\"");
        if (string2 != null) {
            stringBuffer.append(" title=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(string);
        stringBuffer.append("</A>");
        return stringBuffer.toString();
    }

    protected String makeUrl(String string, String string2, String string3) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<A href=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
            if (string3 != null) {
                stringBuffer.append(" title=\"");
                stringBuffer.append(string3);
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            stringBuffer.append(string2);
            stringBuffer.append("</A>");
            return stringBuffer.toString();
        }
        return string2;
    }

    protected void writeHeader() throws IOException {
        this.writeln("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.0//EN\"><HTML>");
        this.writeln("<HEAD>");
        this.writeln("<META http-equiv=\"content-type\" content=\"text/html; charset=" + this.m_encoding + "\">");
        String string = this.getPageBaseURL();
        if (string != null) {
            this.writeln("<BASE HREF=\"" + string + "\">");
        }
        this.writeHeaderStyles();
        this.writeHeaderTitle();
        this.writeln("</HEAD>");
        this.writeln("<BODY>");
        this.startAnchor(this.getTopAnchorName());
        this.endAnchor();
        this.startAnchor(0);
        this.endAnchor();
        String string2 = this.getApplicationHeaderHTML();
        if (string2 != null) {
            this.write(string2);
        }
        this.writeClassHeader();
    }

    protected void writeHeaderStyles() throws IOException {
        if (this.getEmbedDefaultStyles()) {
            this.writeEmbeddedStyleSheet();
        } else {
            this.writeln("<LINK REL=StyleSheet HREF=\"" + this.getStyleSheetURL() + "\" TYPE=\"text/css\">");
        }
    }

    protected void writeEmbeddedStyleSheet() throws IOException {
        this.writeln("<STYLE TYPE=\"text/css\"><!--");
        this.writeln(".difftabl { BACKGROUND-COLOR: white; FONT-FAMILY: Verdana, Helvetica; FONT-SIZE: 10pt; FONT-WEIGHT: normal; COLOR: black; TEXT-ALIGN: left; VERTICAL-ALIGN: top }");
        this.writeln(".add { COLOR: green }");
        this.writeln(".del { COLOR: red; TEXT-DECORATION: line-through }");
        this.writeln(".rep { COLOR: blue; }");
        this.writeln(".sadd { COLOR: green; FONT-FAMILY: 'Courier New', Courier, Fixed }");
        this.writeln(".sdel { COLOR: red; FONT-FAMILY: 'Courier New', Courier, Fixed }");
        this.writeln(".srep { COLOR: blue; FONT-FAMILY: 'Courier New', Courier, Fixed }");
        this.writeln(".ila { BACKGROUND-COLOR: green; COLOR: white; FONT-WEIGHT: bold }");
        this.writeln(".ild { BACKGROUND-COLOR: red; COLOR: white; FONT-WEIGHT: bold; TEXT-DECORATION: line-through }");
        this.writeln(".eol { FONT-FAMILY: 'Courier New', Courier, Fixed; FONT-SIZE: 6pt }");
        this.writeClassStyles();
        this.writeln("--></STYLE>");
    }

    protected void writeClassStyles() throws IOException {
        this.writeln(".filename { FONT-SIZE: larger; FONT-WEIGHT: bold }");
    }

    protected void writeHeaderTitle() throws IOException {
        String string = this.getPageTitle();
        if (string != null) {
            this.writeln("<TITLE>" + string + "</TITLE>");
        }
    }

    protected void writeClassHeader() throws IOException {
        this.startSpan(CLASSNAME_DIFFTABLE);
        boolean bl = this.writeFileReference(Res.getString(ResIDs.SOURCE_FILE), this.getSourceFileHTML(), this.getSourceFileURL());
        boolean bl2 = this.writeFileReference(Res.getString(ResIDs.TARGET_FILE), this.getTargetFileHTML(), this.getTargetFileURL());
        if (bl || bl2) {
            this.writeln("<HR>");
        }
        String string = Res.getString(ResIDs.FIRST_DIFF);
        String string2 = "<A HREF=\"#" + this.getFirstAnchorName() + "\" title=\"" + string + "\">";
        this.write(string2 + this.getGotoFirstDiffHTML() + "</A>");
        this.writeln(HTML_SP);
        this.writeln(string2 + string + "</A><BR>");
        String string3 = Res.getString(ResIDs.END_OF_FILE);
        String string4 = "<A HREF=\"#" + this.getBottomAnchorName() + "\" title=\"" + string3 + "\">";
        this.write(string4 + this.getGotoBottomHTML() + "</A>");
        this.writeln(HTML_SP);
        this.writeln(string4 + string3 + "</A>");
        this.writeln("<HR><PRE>");
    }

    private boolean writeFileReference(String string, String string2, String string3) throws IOException {
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            this.startSpan(CLASSNAME_FILENAME);
            this.write(string + ": ");
            boolean bl2 = false;
            if (string3 != null && string3.length() > 0) {
                this.write("<A href=\"" + string3 + "\">");
                bl2 = true;
            }
            this.write(string2);
            if (bl2) {
                this.write("</A>");
            }
            this.endSpan();
            this.writeln("<BR>");
            bl = true;
        }
        return bl;
    }

    protected void writeFooter() throws IOException {
        this.writeClassFooter();
        String string = this.getApplicationFooterHTML();
        if (string != null) {
            this.write(string);
        }
        this.startAnchor(this.m_anchornum + 1);
        this.endAnchor();
        this.startAnchor(this.getBottomAnchorName());
        this.endAnchor();
        this.writeln("</BODY></HTML>");
    }

    protected void writeClassFooter() throws IOException {
        this.writeln("</PRE><HR>");
        String string = Res.getString(ResIDs.LAST_DIFF);
        String string2 = "<A HREF=\"#" + this.getLastAnchorName() + "\" title=\"" + string + "\">";
        this.write(string2 + this.getGotoLastDiffHTML() + "</A>");
        this.writeln(HTML_SP);
        this.writeln(string2 + string + "</A><BR>");
        String string3 = Res.getString(ResIDs.TOP_OF_FILE);
        String string4 = "<A HREF=\"#" + this.getTopAnchorName() + "\" title=\"" + string3 + "\">";
        this.write(string4 + this.getGotoTopHTML() + "</A>");
        this.writeln(HTML_SP);
        this.writeln(string4 + string3 + "</A>");
        this.endSpan();
    }

    protected void startAnchor() throws IOException {
        this.startAnchor(++this.m_anchornum);
    }

    protected void startAnchor(int n) throws IOException {
        this.startAnchor(this.getAnchorName(n));
    }

    protected void startAnchor(String string) throws IOException {
        this.write("<A NAME=\"" + string + "\">");
    }

    private void endAnchor() throws IOException {
        this.write("</A>");
    }

    private void addHRULE() throws IOException {
        this.write("<HR>");
    }

    protected String makeHTMLChar(char c) {
        if (c == '&') {
            return HTML_AMP;
        }
        if (c == '<') {
            return HTML_LT;
        }
        if (c == '>') {
            return HTML_GT;
        }
        if (c == '\r') {
            return this.getShowEOLs() ? this.getFormattedEOL(this.getCRHTML()) : EMPTY;
        }
        if (c == '\n') {
            return this.getShowEOLs() ? this.getFormattedEOL(this.getLFHTML()) : EMPTY;
        }
        return String.valueOf(c);
    }

    protected void write(String string) throws IOException {
        this.m_out.write(string);
    }

    protected void writeln(String string) throws IOException {
        this.m_out.write(string);
        this.m_out.write(HTML_EOL);
    }

    protected void startSpan(String string) throws IOException {
        this.write(this.makeStartSpan(string));
    }

    protected String makeStartSpan(String string) {
        return "<SPAN CLASS=\"" + string + "\">";
    }

    protected void endSpan() throws IOException {
        this.write(this.makeEndSpan());
    }

    protected String makeEndSpan() {
        return "</SPAN>";
    }

    protected String getAnchorName(int n) {
        return this.getAnchorName(Integer.toString(n));
    }

    protected String getAnchorName(String string) {
        return "_DIFF_" + string;
    }

    protected String getTopAnchorName() {
        return this.getAnchorName("top");
    }

    protected String getBottomAnchorName() {
        return this.getAnchorName("bottom");
    }

    protected String getFirstAnchorName() {
        return this.getAnchorName(1);
    }

    protected String getLastAnchorName() {
        return this.getAnchorName(this.m_anchornum);
    }

    public HTMLDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, File file) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
        }
        this.m_encoding = outputStreamWriter.getEncoding();
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        this.commonInit(parsedCharSequence, parsedCharSequence2, bufferedWriter);
        this.m_bAutoCloseOutput = true;
    }

    public HTMLDiffWriter(BufferedWriter bufferedWriter, int n, ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2) {
        this(parsedCharSequence, parsedCharSequence2, bufferedWriter);
        this.setSpacesPerTab(n);
    }

    public HTMLDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, BufferedWriter bufferedWriter) {
        this(parsedCharSequence, parsedCharSequence2, (Writer)bufferedWriter);
    }

    public HTMLDiffWriter(ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2, Writer writer) {
        this.commonInit(parsedCharSequence, parsedCharSequence2, writer);
    }

    class IntralineDiff
    extends EditListWriter {
        private static final int COMBINED = 0;
        private static final int SOURCE = 1;
        private static final int TARGET = 2;
        Sequence m_sourceChars = null;
        Sequence m_targetChars = null;
        EditList m_edits = null;
        StringBuffer m_output = null;
        int m_outputColumn = 0;
        private int m_mode = 0;

        String getCombinedMarkupText() throws IOException {
            return this.diff(0);
        }

        String getSourceMarkupText() throws IOException {
            return this.diff(1);
        }

        String getTargetMarkupText() throws IOException {
            return this.diff(2);
        }

        private String diff(int n) throws IOException {
            this.m_output = new StringBuffer();
            this.m_outputColumn = 0;
            this.m_mode = n;
            this.write(this.m_edits, this.m_sourceChars.size(), this.m_targetChars.size());
            String string = this.m_output.toString();
            this.m_output = null;
            this.m_outputColumn = 0;
            this.m_mode = 0;
            return string;
        }

        public void start() throws IOException {
        }

        private int copyToBuffer(int n, Sequence sequence, int n2, int n3, StringBuffer stringBuffer, String string) {
            if (string != null) {
                stringBuffer.append("<SPAN CLASS=\"" + string + "\">");
            }
            int n4 = 0;
            while (n4 < n3) {
                String string2 = (String)sequence.get(n2 + n4 - 1);
                int n5 = 0;
                while (n5 < string2.length()) {
                    char c = string2.charAt(n5);
                    if (HTMLDiffWriter.this.m_tabs > 0 && c == '\t') {
                        int n6 = HTMLDiffWriter.this.m_tabs - n % HTMLDiffWriter.this.m_tabs;
                        int n7 = 0;
                        while (n7 < n6) {
                            stringBuffer.append(HTML_SP);
                            ++n;
                            ++n7;
                        }
                    } else if (c == ' ') {
                        stringBuffer.append(HTML_SP);
                        ++n;
                    } else {
                        stringBuffer.append(HTMLDiffWriter.this.makeHTMLChar(c));
                        ++n;
                    }
                    ++n5;
                }
                ++n4;
            }
            if (string != null) {
                stringBuffer.append("</SPAN>");
            }
            return n;
        }

        private String sequenceToString(Sequence sequence, int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                String string = (String)sequence.get(n + n3 - 1);
                int n4 = 0;
                while (n4 < string.length()) {
                    char c = string.charAt(n4);
                    stringBuffer.append(c);
                    ++n4;
                }
                ++n3;
            }
            return stringBuffer.toString();
        }

        private int copyToBuffer(int n, String string, StringBuffer stringBuffer, String string2) {
            if (string2 != null) {
                stringBuffer.append("<SPAN CLASS=\"" + string2 + "\">");
            }
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (HTMLDiffWriter.this.m_tabs > 0 && c == '\t') {
                    int n3 = HTMLDiffWriter.this.m_tabs - n % HTMLDiffWriter.this.m_tabs;
                    int n4 = 0;
                    while (n4 < n3) {
                        stringBuffer.append(HTML_SP);
                        ++n;
                        ++n4;
                    }
                } else if (c == ' ') {
                    stringBuffer.append(HTML_SP);
                    ++n;
                } else {
                    stringBuffer.append(HTMLDiffWriter.this.makeHTMLChar(c));
                    ++n;
                }
                ++n2;
            }
            if (string2 != null) {
                stringBuffer.append("</SPAN>");
            }
            return n;
        }

        public void unchangedLines(int n, int n2, int n3) throws IOException {
            this.m_outputColumn = this.copyToBuffer(this.m_outputColumn, this.m_sourceChars, n, n3, this.m_output, null);
        }

        public void insertLines(int n, int n2, int n3) throws IOException {
            if (this.m_mode == 1) {
                this.m_output.append(HTMLDiffWriter.this.getInlineInsertMarkHTML());
            } else {
                this.m_outputColumn = this.copyToBuffer(this.m_outputColumn, this.m_targetChars, n2, n3, this.m_output, HTMLDiffWriter.CLASSNAME_INLINE_ADD);
            }
        }

        public void deleteLines(int n, int n2, int n3) throws IOException {
            if (this.m_mode == 2) {
                this.m_output.append(HTMLDiffWriter.this.getInlineDeleteMarkHTML());
            } else {
                this.m_outputColumn = this.copyToBuffer(this.m_outputColumn, this.m_sourceChars, n, n3, this.m_output, HTMLDiffWriter.CLASSNAME_INLINE_DEL);
            }
        }

        public void replaceLines(int n, int n2, int n3, int n4) throws IOException {
            String string = this.sequenceToString(this.m_sourceChars, n, n2);
            String string2 = this.sequenceToString(this.m_targetChars, n3, n4);
            int n5 = string.length();
            int n6 = string2.length();
            int n7 = 0;
            while (n7 < n5 && n7 < n6 && string.charAt(n7) == string2.charAt(n7)) {
                ++n7;
            }
            String string3 = HTMLDiffWriter.EMPTY;
            if (n7 > 0) {
                string3 = string.substring(0, n7);
                string = string.substring(n7, n5);
                string2 = string2.substring(n7, n6);
                n5 -= string3.length();
                n6 -= string3.length();
            }
            int n8 = 0;
            while (n5 - n8 - 1 >= 0 && n6 - n8 - 1 >= 0 && string.charAt(n5 - n8 - 1) == string2.charAt(n6 - n8 - 1)) {
                ++n8;
            }
            String string4 = HTMLDiffWriter.EMPTY;
            if (n8 > 0) {
                string4 = string.substring(n5 - n8, n5);
                string = string.substring(0, n5 - n8);
                string2 = string2.substring(0, n6 - n8);
                n5 -= string4.length();
                n6 -= string4.length();
            }
            this.m_outputColumn = this.copyToBuffer(this.m_outputColumn, string3, this.m_output, null);
            if (this.m_mode != 2) {
                this.copyToBuffer(this.m_outputColumn, string, this.m_output, HTMLDiffWriter.CLASSNAME_INLINE_DEL);
            }
            if (this.m_mode != 1) {
                this.m_outputColumn = this.copyToBuffer(this.m_outputColumn, string2, this.m_output, HTMLDiffWriter.CLASSNAME_INLINE_ADD);
            }
            this.m_outputColumn = this.copyToBuffer(this.m_outputColumn, string4, this.m_output, null);
        }

        public void finish() throws IOException {
        }

        IntralineDiff(CharSequence charSequence, CharSequence charSequence2) throws DiffException {
            this.m_sourceChars = new IntralineSequence(charSequence);
            this.m_targetChars = new IntralineSequence(charSequence2);
            this.m_edits = new StarTeamDiff().diff(this.m_sourceChars, this.m_targetChars, IntralineSequence.getDiffCompare());
        }
    }
}

