/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.EditListWriter;
import com.starbase.diff.ParsedCharSequence;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class ConsoleWriter
extends EditListWriter {
    private static final char TAB = '\t';
    private static final char SPACE = ' ';
    private static final char DIVIDER_SYMBOL = '-';
    private static final char ADD_SYMBOL = '+';
    private static final char DEL_SYMBOL = '-';
    private static final char VSEP_SYMBOL = '|';
    private static final String EOL = System.getProperty("line.separator");
    private int m_tabs = 0;
    private Writer m_out = null;
    private ParsedCharSequence m_source = null;
    private ParsedCharSequence m_target = null;
    private int m_contextLines = -1;
    private int m_sourceLength = 0;
    private int m_targetLength = 0;
    private boolean m_showLineNumbers = true;

    public void start() throws IOException {
        this.printDivider();
    }

    public void finish() throws IOException {
        this.printDivider();
        this.m_out.flush();
    }

    public void unchangedLines(int n, int n2, int n3) throws IOException {
        block7: {
            int n4;
            boolean bl;
            boolean bl2;
            boolean bl3;
            block6: {
                if (n3 == 0) {
                    return;
                }
                bl3 = n == 1 && n2 == 1;
                bl2 = n + n3 - 1 == this.m_sourceLength && n2 + n3 - 1 == this.m_targetLength;
                boolean bl4 = bl = bl3 || bl2;
                if (this.m_contextLines >= 0 && (!bl || this.m_contextLines < n3) && (bl || 2 * this.m_contextLines < n3)) break block6;
                int n5 = 0;
                while (n5 < n3) {
                    this.doUnchangedLine(n + n5, n2 + n5);
                    ++n5;
                }
                break block7;
            }
            if (!bl3) {
                n4 = 0;
                while (n4 < this.m_contextLines) {
                    this.doUnchangedLine(n + n4, n2 + n4);
                    ++n4;
                }
            }
            if (!bl) {
                this.printDivider();
            }
            if (bl2) break block7;
            n4 = n3 - this.m_contextLines;
            while (n4 < n3) {
                this.doUnchangedLine(n + n4, n2 + n4);
                ++n4;
            }
        }
    }

    private void doUnchangedLine(int n, int n2) throws IOException {
        this.m_out.write(32);
        this.outputLineNumbers(n, n2);
        this.outputLine(this.m_source.getLine(n - 1));
    }

    public void insertLines(int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.m_out.write(43);
            this.outputLineNumbers(0, n2 + n4);
            this.outputLine(this.m_target.getLine(n2 + n4 - 1));
            ++n4;
        }
    }

    public void deleteLines(int n, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.m_out.write(45);
            this.outputLineNumbers(n + n4, 0);
            this.outputLine(this.m_source.getLine(n + n4 - 1));
            ++n4;
        }
    }

    public void replaceLines(int n, int n2, int n3, int n4) throws IOException {
        this.insertLines(n, n3, n4);
        this.deleteLines(n, n3, n2);
    }

    private void outputLineNumbers(int n, int n2) throws IOException {
        if (this.m_showLineNumbers) {
            if (n > 0) {
                this.outputLineNumber(n, false);
            } else {
                this.outputNoLineNumber();
            }
            this.m_out.write(32);
            if (n2 > 0) {
                this.outputLineNumber(n2, false);
            } else {
                this.outputNoLineNumber();
            }
            this.m_out.write(32);
            this.m_out.write(32);
            this.m_out.write(124);
        }
    }

    private void outputLine(CharSequence charSequence) throws IOException {
        int n = this.lengthNoEOL(charSequence);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = charSequence.charAt(n3);
            if (this.m_tabs > 0 && c == '\t') {
                n2 += this.outputTab(n2);
            } else {
                this.m_out.write(c);
                ++n2;
            }
            ++n3;
        }
        this.m_out.write(EOL);
    }

    private int outputTab(int n) throws IOException {
        int n2 = this.m_tabs - n % this.m_tabs;
        int n3 = 0;
        while (n3 < n2) {
            this.m_out.write(32);
            ++n3;
        }
        return n2;
    }

    private int lengthNoEOL(CharSequence charSequence) {
        int n = charSequence.length();
        if (n > 0) {
            char c = charSequence.charAt(n - 1);
            if (c == '\n') {
                if (--n > 1 && (c = charSequence.charAt(n - 2)) == '\r') {
                    --n;
                }
            } else if (c == '\r') {
                --n;
            }
            return n;
        }
        return 0;
    }

    private void outputNoLineNumber() throws IOException {
        int n = 7;
        int n2 = 0;
        while (n2 < n) {
            this.m_out.write(32);
            ++n2;
        }
    }

    private void outputLineNumber(int n, boolean bl) throws IOException {
        String string = Integer.toString(n);
        int n2 = 7 - string.length();
        int n3 = 0;
        while (n3 < n2) {
            this.m_out.write(32);
            ++n3;
        }
        this.m_out.write(string);
    }

    private void printDivider() throws IOException {
        int n = 79;
        int n2 = 0;
        while (n2 < n) {
            this.m_out.write(45);
            ++n2;
        }
        this.m_out.write(EOL);
    }

    public ConsoleWriter(BufferedWriter bufferedWriter, boolean bl, int n, int n2, ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2) {
        this((Writer)bufferedWriter, bl, n, n2, parsedCharSequence, parsedCharSequence2);
    }

    public ConsoleWriter(Writer writer, boolean bl, int n, int n2, ParsedCharSequence parsedCharSequence, ParsedCharSequence parsedCharSequence2) {
        this.m_tabs = n;
        this.m_out = writer;
        this.m_source = parsedCharSequence;
        this.m_target = parsedCharSequence2;
        this.m_contextLines = n2;
        this.m_sourceLength = parsedCharSequence.size();
        this.m_targetLength = parsedCharSequence2.size();
        this.m_showLineNumbers = bl;
    }
}

