/*
 * Decompiled with CFR 0.152.
 */
package com.borland.starteam.util;

import System.Exception;
import com.starbase.starteam.StarTeamClientOptions;
import com.starbase.util.Assert;
import com.starbase.util.QuickSort;
import com.starbase.util.SortCompare;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Encoding {
    public static final String STARTEAM_PROPERTY = "starteam.file.encoding";
    public static final int ID_UNKNOWN = -1;
    public static final int CODEPAGE_UNKNOWN = -1;
    public static final Encoding US_ASCII;
    public static final Encoding ISO_8859_1;
    public static final Encoding UTF_8;
    public static final Encoding UTF_16BE;
    public static final Encoding UTF_16LE;
    public static final Encoding UTF_16;
    private static final String PLATFORM_PROPERTY = "file.encoding";
    private static final String[] NO_ALIASES;
    private static final InputStream EMPTY_INPUT;
    private static final OutputStream EMPTY_OUTPUT;
    private static Encoding[] m_all;
    private static Encoding[] m_supported;
    private static Encoding[] m_readable;
    private static Encoding[] m_writable;
    private static Vector m_allEncodings;
    private static Hashtable m_byName;
    private static Hashtable m_byID;
    private static Hashtable m_byCP;
    private String m_name = null;
    private String m_registeredName = null;
    private int m_registeredID = -1;
    private String m_mime = null;
    private String[] m_allNames = NO_ALIASES;
    private boolean m_bPlatformSupportInitialized = false;
    private String m_nameForReading = null;
    private String m_nameForWriting = null;
    private int m_codepage = -1;

    public static Encoding getDefaultStarTeamEncoding() {
        Encoding encoding = null;
        String string = System.getProperty(STARTEAM_PROPERTY);
        if (string != null) {
            encoding = Encoding.forName(string);
        }
        if (encoding == null) {
            encoding = Encoding.getDefaultPlatformEncoding();
        }
        if (encoding == null) {
            Assert.internalError("getDefaultStarTeamEncoding()");
        }
        return encoding;
    }

    public static void setDefaultStarTeamEncoding(Encoding encoding) {
        if (encoding != null) {
            ((Hashtable)System.getProperties()).put(STARTEAM_PROPERTY, encoding.getName());
        } else {
            ((Hashtable)System.getProperties()).remove(STARTEAM_PROPERTY);
        }
    }

    public static Encoding getDefaultPlatformEncoding() {
        Encoding encoding = null;
        String string = System.getProperty(PLATFORM_PROPERTY);
        if (string != null) {
            encoding = Encoding.forName(string);
        }
        if (encoding == null) {
            encoding = US_ASCII;
        }
        if (encoding == null) {
            Assert.internalError("getDefaultPlatformEncoding()");
        }
        return encoding;
    }

    public static Encoding forName(String string) {
        Encoding encoding;
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if ((encoding = (Encoding)m_byName.get(string)) != null) {
            return encoding;
        }
        return (Encoding)m_byName.get(Encoding.getCanonicalForm(string));
    }

    public static Encoding forID(int n) {
        if (n != -1) {
            return (Encoding)m_byID.get(new Integer(n));
        }
        return null;
    }

    public static Encoding forCodePage(int n) {
        if (n != -1) {
            return (Encoding)m_byCP.get(new Integer(n));
        }
        return null;
    }

    public static Encoding[] getAllKnownEncodings() {
        if (m_all == null) {
            int n = m_allEncodings.size();
            Object[] objectArray = new Encoding[n];
            Enumeration enumeration = m_allEncodings.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Encoding encoding = (Encoding)enumeration.nextElement();
                objectArray[n2++] = encoding;
            }
            QuickSort.sortArray(objectArray, new SortCompare(){

                public int compare(Object object, Object object2) {
                    String string = ((Encoding)object).getName().toLowerCase();
                    String string2 = ((Encoding)object2).getName().toLowerCase();
                    return string.compareTo(string2);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            m_all = objectArray;
        }
        return m_all;
    }

    public static Encoding[] getSupportedEncodings() {
        if (m_supported == null) {
            Object object;
            int n = 0;
            Enumeration enumeration = m_allEncodings.elements();
            while (enumeration.hasMoreElements()) {
                object = (Encoding)enumeration.nextElement();
                if (!((Encoding)object).isSupported()) continue;
                ++n;
            }
            object = new Encoding[n];
            int n2 = 0;
            enumeration = m_allEncodings.elements();
            while (enumeration.hasMoreElements()) {
                Encoding encoding = (Encoding)enumeration.nextElement();
                if (!encoding.isSupported()) continue;
                object[n2++] = encoding;
            }
            QuickSort.sortArray((Object[])object, new SortCompare(){

                public int compare(Object object, Object object2) {
                    String string = ((Encoding)object).getPlatformName().toLowerCase();
                    String string2 = ((Encoding)object2).getPlatformName().toLowerCase();
                    return string.compareTo(string2);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            m_supported = object;
        }
        return m_supported;
    }

    public static Encoding[] getReadableEncodings() {
        if (m_readable == null) {
            Object object;
            int n = 0;
            Enumeration enumeration = m_allEncodings.elements();
            while (enumeration.hasMoreElements()) {
                object = (Encoding)enumeration.nextElement();
                if (!((Encoding)object).isReadingSupported()) continue;
                ++n;
            }
            object = new Encoding[n];
            int n2 = 0;
            enumeration = m_allEncodings.elements();
            while (enumeration.hasMoreElements()) {
                Encoding encoding = (Encoding)enumeration.nextElement();
                if (!encoding.isReadingSupported()) continue;
                object[n2++] = encoding;
            }
            QuickSort.sortArray((Object[])object, new SortCompare(){

                public int compare(Object object, Object object2) {
                    String string = ((Encoding)object).getPlatformNameForReading().toLowerCase();
                    String string2 = ((Encoding)object2).getPlatformNameForReading().toLowerCase();
                    return string.compareTo(string2);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            m_readable = object;
        }
        return m_readable;
    }

    public static Encoding[] getWritableEncodings() {
        if (m_writable == null) {
            Object object;
            int n = 0;
            Enumeration enumeration = m_allEncodings.elements();
            while (enumeration.hasMoreElements()) {
                object = (Encoding)enumeration.nextElement();
                if (!((Encoding)object).isWritingSupported()) continue;
                ++n;
            }
            object = new Encoding[n];
            int n2 = 0;
            enumeration = m_allEncodings.elements();
            while (enumeration.hasMoreElements()) {
                Encoding encoding = (Encoding)enumeration.nextElement();
                if (!encoding.isWritingSupported()) continue;
                object[n2++] = encoding;
            }
            QuickSort.sortArray((Object[])object, new SortCompare(){

                public int compare(Object object, Object object2) {
                    String string = ((Encoding)object).getPlatformNameForWriting().toLowerCase();
                    String string2 = ((Encoding)object2).getPlatformNameForWriting().toLowerCase();
                    return string.compareTo(string2);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            m_writable = object;
        }
        return m_writable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getMimeName() {
        return this.m_mime;
    }

    public String getRegisteredName() {
        return this.m_registeredName;
    }

    public String[] getAllNames() {
        return this.m_allNames;
    }

    public boolean isNamed(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        String[] stringArray = this.getAllNames();
        string = Encoding.getCanonicalForm(string);
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(Encoding.getCanonicalForm(stringArray[n]))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int getRegisteredID() {
        return this.m_registeredID;
    }

    public int getCodePage() {
        return this.m_codepage;
    }

    public boolean isSupported() {
        return this.isReadingSupported() && this.isWritingSupported();
    }

    public String getPlatformName() {
        if (this.isSupported()) {
            return this.getPlatformNameForReading();
        }
        return null;
    }

    public boolean isReadingSupported() {
        return this.getPlatformNameForReading() != null;
    }

    public String getPlatformNameForReading() {
        this.initPlatformSupport();
        return this.m_nameForReading;
    }

    public boolean isWritingSupported() {
        return this.getPlatformNameForWriting() != null;
    }

    public String getPlatformNameForWriting() {
        this.initPlatformSupport();
        return this.m_nameForWriting;
    }

    private void initCodePage() {
        int n = -1;
        String[] stringArray = this.getAllNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            int n3 = Encoding.toCodePage(string);
            if (n3 != -1) {
                if (n == -1) {
                    n = n3;
                } else if (n != n3) {
                    Assert.internalError("initCodePage(), name=" + stringArray[0]);
                }
            }
            ++n2;
        }
        this.m_codepage = n;
    }

    private static int toCodePage(String string) {
        String string2 = "cp";
        int n = "cp".length();
        int n2 = -1;
        if (string != null && string.length() >= n && "cp".equals(string.substring(0, n).toLowerCase())) {
            String string3 = string.substring(n);
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private void initPlatformSupport() {
        if (!this.m_bPlatformSupportInitialized) {
            String[] stringArray = this.getAllNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                boolean bl = Encoding.isReadingSupported(string);
                boolean bl2 = Encoding.isWritingSupported(string);
                if (bl && bl2) {
                    this.m_nameForReading = string;
                    this.m_nameForWriting = string;
                    break;
                }
                if (bl) {
                    this.m_nameForReading = string;
                } else if (bl2) {
                    this.m_nameForWriting = string;
                }
                ++n;
            }
            this.m_bPlatformSupportInitialized = true;
        }
    }

    private static boolean isReadingSupported(String string) {
        boolean bl = false;
        try {
            try {
                new InputStreamReader(EMPTY_INPUT, string);
                bl = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static boolean isWritingSupported(String string) {
        boolean bl = false;
        try {
            try {
                new OutputStreamWriter(EMPTY_OUTPUT, string);
                bl = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static Encoding add(String string, int n, String string2, String[] stringArray) {
        Encoding encoding = new Encoding(string, n, string2, stringArray);
        Encoding.register(encoding);
        return encoding;
    }

    private static Encoding add(int n, String string, String string2) {
        if (n != -1) {
            Encoding encoding = Encoding.forID(n);
            if (encoding != null) {
                Encoding.add(encoding, string, string2);
            } else {
                Assert.internalError("Encoding.add(" + n + "/*NOI18N*/, newname, oldname)");
            }
            return encoding;
        }
        return Encoding.add(string, string2);
    }

    private static Encoding add(String string, String string2) {
        Encoding encoding = null;
        int n = Encoding.toCodePage(string);
        if (n == -1) {
            n = Encoding.toCodePage(string2);
        }
        if (n != -1 && (encoding = Encoding.forCodePage(n)) != null) {
            Encoding.add(encoding, string, string2);
            return encoding;
        }
        if (string != null && (encoding = Encoding.forName(string)) != null) {
            encoding.addName(string2);
            return encoding;
        }
        if (string2 != null && (encoding = Encoding.forName(string2)) != null) {
            encoding.addName(string);
            return encoding;
        }
        if (string != null && string2 != null && string.equals(string2)) {
            string2 = null;
        }
        if (string != null && string2 != null) {
            encoding = new Encoding(string, string2);
        } else if (string != null) {
            encoding = new Encoding(string);
        } else if (string2 != null) {
            encoding = new Encoding(string2);
        } else {
            Assert.internalError("add(null, null)");
        }
        Encoding.register(encoding);
        return encoding;
    }

    private static void add(Encoding encoding, String string, String string2) {
        encoding.addName(string);
        encoding.addName(string2);
    }

    private static Encoding add(String string) {
        return Encoding.add(null, string);
    }

    private void addName(String string) {
        if (string != null && !this.isNamed(string)) {
            String[] stringArray = this.m_allNames;
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 1];
            int n2 = 0;
            while (n2 < n) {
                stringArray2[n2] = stringArray[n2];
                ++n2;
            }
            stringArray2[n] = string;
            this.m_allNames = stringArray2;
            Encoding.registerName(string, this);
            n2 = this.getCodePage();
            this.initCodePage();
            if (n2 == -1 && (n2 = this.getCodePage()) != -1) {
                Encoding.registerCP(n2, this);
            }
        }
    }

    private static void register(Encoding encoding) {
        m_allEncodings.addElement(encoding);
        String[] stringArray = encoding.getAllNames();
        int n = 0;
        while (n < stringArray.length) {
            Encoding.registerName(stringArray[n], encoding);
            ++n;
        }
        Encoding.registerID(encoding.getRegisteredID(), encoding);
        Encoding.registerCP(encoding.getCodePage(), encoding);
    }

    private static void registerName(String string, Encoding encoding) {
        Encoding encoding2 = Encoding.forName(string);
        if (encoding2 != null && encoding2 != encoding) {
            Assert.internalError("Encoding.registerName(), name=\"" + string + "\"");
        }
        m_byName.put(string, encoding);
        m_byName.put(Encoding.getCanonicalForm(string), encoding);
    }

    private static String getCanonicalForm(String string) {
        string = string.toLowerCase().trim();
        char[] cArray = new char[]{'_', ':', '.', ' '};
        int n = 0;
        while (n < cArray.length) {
            string = string.replace(cArray[n], '-');
            ++n;
        }
        return string;
    }

    private static void registerID(int n, Encoding encoding) {
        if (n != -1) {
            Integer n2 = new Integer(n);
            if (m_byID.get(n2) != null) {
                Assert.internalError("Encoding.registerID(), id=" + n + "");
            }
            m_byID.put(n2, encoding);
        }
    }

    private static void registerCP(int n, Encoding encoding) {
        if (n != -1) {
            Integer n2 = new Integer(n);
            if (m_byCP.get(n2) != null) {
                Assert.internalError("Encoding.registerCP(), cp=" + n + "");
            }
            m_byCP.put(n2, encoding);
        }
    }

    private static void initStarTeamEncoding() {
        try {
            try {
                String string = System.getProperty(STARTEAM_PROPERTY);
                if (string == null) {
                    StarTeamClientOptions starTeamClientOptions = StarTeamClientOptions.getDefault();
                    starTeamClientOptions.reloadIfNeeded();
                    string = starTeamClientOptions.getFileDefaultEncoding();
                    if (string != null) {
                        ((Hashtable)System.getProperties()).put(STARTEAM_PROPERTY, string);
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void ensure(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            Encoding.add(string2);
        }
    }

    private Encoding(String string, int n, String string2, String[] stringArray) {
        int n2;
        int n3;
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if (n < 3 && n != -1) {
            Assert.internalError("Encoding(), id=" + n);
        }
        if (stringArray == null) {
            Assert.nullArgument("String[]", "aliases");
        }
        if (string2 != null && !string2.equals(string)) {
            n3 = 0;
            n2 = 0;
            while (n2 < stringArray.length) {
                if (string2.equals(stringArray[n2])) {
                    n3 = 1;
                    break;
                }
                ++n2;
            }
            if (n3 == 0) {
                Assert.internalError("Encoding(), mimeName=\"" + string2 + "\"");
            }
        }
        this.m_name = string;
        this.m_registeredName = string;
        this.m_registeredID = n;
        this.m_mime = string2;
        this.m_allNames = new String[1 + stringArray.length];
        n3 = 0;
        if (this.m_mime != null) {
            this.m_allNames[n3++] = this.m_mime;
            this.m_name = this.m_mime;
        }
        if (this.m_mime == null || !this.m_registeredName.equals(this.m_mime)) {
            this.m_allNames[n3++] = this.m_registeredName;
        }
        n2 = 0;
        while (n2 < stringArray.length) {
            if (this.m_mime == null || !stringArray[n2].equals(this.m_mime)) {
                this.m_allNames[n3++] = stringArray[n2];
            }
            ++n2;
        }
        this.initCodePage();
    }

    private Encoding(String string, String string2) {
        if (string == null) {
            Assert.nullArgument("String", "newname");
        }
        if (string2 == null) {
            Assert.nullArgument("String", "oldname");
        }
        if (string.equals(string2)) {
            Assert.internalError("Encoding(), newname=" + string + ", oldname=" + string2);
        }
        this.m_name = string;
        this.m_allNames = new String[2];
        this.m_allNames[0] = string;
        this.m_allNames[1] = string2;
        this.initCodePage();
    }

    private Encoding(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        this.m_name = string;
        this.m_allNames = new String[1];
        this.m_allNames[0] = string;
        this.initCodePage();
    }

    static {
        NO_ALIASES = new String[0];
        EMPTY_INPUT = new ByteArrayInputStream(new byte[0]);
        EMPTY_OUTPUT = new ByteArrayOutputStream();
        m_all = null;
        m_supported = null;
        m_readable = null;
        m_writable = null;
        m_allEncodings = new Vector();
        m_byName = new Hashtable();
        m_byID = new Hashtable();
        m_byCP = new Hashtable();
        US_ASCII = Encoding.add("ANSI_X3.4-1968", 3, "US-ASCII", new String[]{"iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "US-ASCII", "us", "IBM367", "cp367", "csASCII"});
        Encoding.add("ISO-10646-UTF-1", 27, null, new String[]{"csISO10646UTF1"});
        Encoding.add("ISO_646.basic:1983", 28, null, new String[]{"ref", "csISO646basic1983"});
        Encoding.add("INVARIANT", 29, null, new String[]{"csINVARIANT"});
        Encoding.add("ISO_646.irv:1983", 30, null, new String[]{"iso-ir-2", "irv", "csISO2IntlRefVersion"});
        Encoding.add("BS_4730", 20, null, new String[]{"iso-ir-4", "ISO646-GB", "gb", "uk", "csISO4UnitedKingdom"});
        Encoding.add("NATS-SEFI", 31, null, new String[]{"iso-ir-8-1", "csNATSSEFI"});
        Encoding.add("NATS-SEFI-ADD", 32, null, new String[]{"iso-ir-8-2", "csNATSSEFIADD"});
        Encoding.add("NATS-DANO", 33, null, new String[]{"iso-ir-9-1", "csNATSDANO"});
        Encoding.add("NATS-DANO-ADD", 34, null, new String[]{"iso-ir-9-2", "csNATSDANOADD"});
        Encoding.add("SEN_850200_B", 35, null, new String[]{"iso-ir-10", "FI", "ISO646-FI", "ISO646-SE", "se", "csISO10Swedish"});
        Encoding.add("SEN_850200_C", 21, null, new String[]{"iso-ir-11", "ISO646-SE2", "se2", "csISO11SwedishForNames"});
        Encoding.add("KS_C_5601-1987", 36, null, new String[]{"iso-ir-149", "KS_C_5601-1989", "KSC_5601", "korean", "csKSC56011987"});
        Encoding.add("ISO-2022-KR", 37, "ISO-2022-KR", new String[]{"csISO2022KR"});
        Encoding.add("EUC-KR", 38, "EUC-KR", new String[]{"csEUCKR"});
        Encoding.add("ISO-2022-JP", 39, "ISO-2022-JP", new String[]{"csISO2022JP"});
        Encoding.add("ISO-2022-JP-2", 40, "ISO-2022-JP-2", new String[]{"csISO2022JP2"});
        Encoding.add("ISO-2022-CN", 104, null, NO_ALIASES);
        Encoding.add("ISO-2022-CN-EXT", 105, null, NO_ALIASES);
        Encoding.add("JIS_C6220-1969-jp", 41, null, new String[]{"JIS_C6220-1969", "iso-ir-13", "katakana", "x0201-7", "csISO13JISC6220jp"});
        Encoding.add("JIS_C6220-1969-ro", 42, null, new String[]{"iso-ir-14", "jp", "ISO646-JP", "csISO14JISC6220ro"});
        Encoding.add("IT", 22, null, new String[]{"iso-ir-15", "ISO646-IT", "csISO15Italian"});
        Encoding.add("PT", 43, null, new String[]{"iso-ir-16", "ISO646-PT", "csISO16Portuguese"});
        Encoding.add("ES", 23, null, new String[]{"iso-ir-17", "ISO646-ES", "csISO17Spanish"});
        Encoding.add("greek7-old", 44, null, new String[]{"iso-ir-18", "csISO18Greek7Old"});
        Encoding.add("latin-greek", 45, null, new String[]{"iso-ir-19", "csISO19LatinGreek"});
        Encoding.add("DIN_66003", 24, null, new String[]{"iso-ir-21", "de", "ISO646-DE", "csISO21German"});
        Encoding.add("NF_Z_62-010_(1973)", 46, null, new String[]{"iso-ir-25", "ISO646-FR1", "csISO25French"});
        Encoding.add("Latin-greek-1", 47, null, new String[]{"iso-ir-27", "csISO27LatinGreek1"});
        Encoding.add("ISO_5427", 48, null, new String[]{"iso-ir-37", "csISO5427Cyrillic"});
        Encoding.add("JIS_C6226-1978", 49, null, new String[]{"iso-ir-42", "csISO42JISC62261978"});
        Encoding.add("BS_viewdata", 50, null, new String[]{"iso-ir-47", "csISO47BSViewdata"});
        Encoding.add("INIS", 51, null, new String[]{"iso-ir-49", "csISO49INIS"});
        Encoding.add("INIS-8", 52, null, new String[]{"iso-ir-50", "csISO50INIS8"});
        Encoding.add("INIS-cyrillic", 53, null, new String[]{"iso-ir-51", "csISO51INISCyrillic"});
        Encoding.add("ISO_5427:1981", 54, null, new String[]{"iso-ir-54", "ISO5427Cyrillic1981"});
        Encoding.add("ISO_5428:1980", 55, null, new String[]{"iso-ir-55", "csISO5428Greek"});
        Encoding.add("GB_1988-80", 56, null, new String[]{"iso-ir-57", "cn", "ISO646-CN", "csISO57GB1988"});
        Encoding.add("GB_2312-80", 57, null, new String[]{"iso-ir-58", "chinese", "csISO58GB231280"});
        Encoding.add("NS_4551-1", 25, null, new String[]{"iso-ir-60", "ISO646-NO", "no", "csISO60DanishNorwegian", "csISO60Norwegian1"});
        Encoding.add("NS_4551-2", 58, null, new String[]{"ISO646-NO2", "iso-ir-61", "no2", "csISO61Norwegian2"});
        Encoding.add("NF_Z_62-010", 26, null, new String[]{"iso-ir-69", "ISO646-FR", "fr", "csISO69French"});
        Encoding.add("videotex-suppl", 59, null, new String[]{"iso-ir-70", "csISO70VideotexSupp1"});
        Encoding.add("PT2", 60, null, new String[]{"iso-ir-84", "ISO646-PT2", "csISO84Portuguese2"});
        Encoding.add("ES2", 61, null, new String[]{"iso-ir-85", "ISO646-ES2", "csISO85Spanish2"});
        Encoding.add("MSZ_7795.3", 62, null, new String[]{"iso-ir-86", "ISO646-HU", "hu", "csISO86Hungarian"});
        Encoding.add("JIS_C6226-1983", 63, null, new String[]{"iso-ir-87", "x0208", "JIS_X0208-1983", "csISO87JISX0208"});
        Encoding.add("greek7", 64, null, new String[]{"iso-ir-88", "csISO88Greek7"});
        Encoding.add("ASMO_449", 65, null, new String[]{"ISO_9036", "arabic7", "iso-ir-89", "csISO89ASMO449"});
        Encoding.add("iso-ir-90", 66, null, new String[]{"csISO90"});
        Encoding.add("JIS_C6229-1984-a", 67, null, new String[]{"iso-ir-91", "jp-ocr-a", "csISO91JISC62291984a"});
        Encoding.add("JIS_C6229-1984-b", 68, null, new String[]{"iso-ir-92", "ISO646-JP-OCR-B", "jp-ocr-b", "csISO92JISC62991984b"});
        Encoding.add("JIS_C6229-1984-b-add", 69, null, new String[]{"iso-ir-93", "jp-ocr-b-add", "csISO93JIS62291984badd"});
        Encoding.add("JIS_C6229-1984-hand", 70, null, new String[]{"iso-ir-94", "jp-ocr-hand", "csISO94JIS62291984hand"});
        Encoding.add("JIS_C6229-1984-hand-add", 71, null, new String[]{"iso-ir-95", "jp-ocr-hand-add", "csISO95JIS62291984handadd"});
        Encoding.add("JIS_C6229-1984-kana", 72, null, new String[]{"iso-ir-96", "csISO96JISC62291984kana"});
        Encoding.add("ISO_2033-1983", 73, null, new String[]{"iso-ir-98", "e13b", "csISO2033"});
        Encoding.add("ANSI_X3.110-1983", 74, null, new String[]{"iso-ir-99", "CSA_T500-1983", "NAPLPS", "csISO99NAPLPS"});
        ISO_8859_1 = Encoding.add("ISO_8859-1:1987", 4, "ISO-8859-1", new String[]{"iso-ir-100", "ISO_8859-1", "ISO-8859-1", "latin1", "l1", "IBM819", "CP819", "csISOLatin1"});
        Encoding.add("ISO_8859-2:1987", 5, "ISO-8859-2", new String[]{"iso-ir-101", "ISO_8859-2", "ISO-8859-2", "latin2", "l2", "csISOLatin2"});
        Encoding.add("T.61-7bit", 75, null, new String[]{"iso-ir-102", "csISO102T617bit"});
        Encoding.add("T.61-8bit", 76, null, new String[]{"T.61", "iso-ir-103", "csISO103T618bit"});
        Encoding.add("ISO_8859-3:1988", 6, "ISO-8859-3", new String[]{"iso-ir-109", "ISO_8859-3", "ISO-8859-3", "latin3", "l3", "csISOLatin3"});
        Encoding.add("ISO_8859-4:1988", 7, "ISO-8859-4", new String[]{"iso-ir-110", "ISO_8859-4", "ISO-8859-4", "latin4", "l4", "csISOLatin4"});
        Encoding.add("ECMA-cyrillic", 77, null, new String[]{"iso-ir-111", "KOI8-E", "csISO111ECMACyrillic"});
        Encoding.add("CSA_Z243.4-1985-1", 78, null, new String[]{"iso-ir-121", "ISO646-CA", "csa7-1", "ca", "csISO121Canadian1"});
        Encoding.add("CSA_Z243.4-1985-2", 79, null, new String[]{"iso-ir-122", "ISO646-CA2", "csa7-2", "csISO122Canadian2"});
        Encoding.add("CSA_Z243.4-1985-gr", 80, null, new String[]{"iso-ir-123", "csISO123CSAZ24341985gr"});
        Encoding.add("ISO_8859-6:1987", 9, "ISO-8859-6", new String[]{"iso-ir-127", "ISO_8859-6", "ISO-8859-6", "ECMA-114", "ASMO-708", "arabic", "csISOLatinArabic"});
        Encoding.add("ISO_8859-6-E", 81, "ISO-8859-6-E", new String[]{"csISO88596E", "ISO-8859-6-E"});
        Encoding.add("ISO_8859-6-I", 82, "ISO-8859-6-I", new String[]{"csISO88596I", "ISO-8859-6-I"});
        Encoding.add("ISO_8859-7:1987", 10, "ISO-8859-7", new String[]{"iso-ir-126", "ISO_8859-7", "ISO-8859-7", "ELOT_928", "ECMA-118", "greek", "greek8", "csISOLatinGreek"});
        Encoding.add("T.101-G2", 83, null, new String[]{"iso-ir-128", "csISO128T101G2"});
        Encoding.add("ISO_8859-8:1988", 11, "ISO-8859-8", new String[]{"iso-ir-138", "ISO_8859-8", "ISO-8859-8", "hebrew", "csISOLatinHebrew"});
        Encoding.add("ISO_8859-8-E", 84, "ISO-8859-8-E", new String[]{"csISO88598E", "ISO-8859-8-E"});
        Encoding.add("ISO_8859-8-I", 85, "ISO-8859-8-I", new String[]{"csISO88598I", "ISO-8859-8-I"});
        Encoding.add("CSN_369103", 86, null, new String[]{"iso-ir-139", "csISO139CSN369103"});
        Encoding.add("JUS_I.B1.002", 87, null, new String[]{"iso-ir-141", "ISO646-YU", "js", "yu", "csISO141JUSIB1002"});
        Encoding.add("ISO_6937-2-add", 14, null, new String[]{"iso-ir-142", "csISOTextComm"});
        Encoding.add("IEC_P27-1", 88, null, new String[]{"iso-ir-143", "csISO143IECP271"});
        Encoding.add("ISO_8859-5:1988", 8, "ISO-8859-5", new String[]{"iso-ir-144", "ISO_8859-5", "ISO-8859-5", "cyrillic", "csISOLatinCyrillic"});
        Encoding.add("JUS_I.B1.003-serb", 89, null, new String[]{"iso-ir-146", "serbian", "csISO146Serbian"});
        Encoding.add("JUS_I.B1.003-mac", 90, null, new String[]{"macedonian", "iso-ir-147", "csISO147Macedonian"});
        Encoding.add("ISO_8859-9:1989", 12, "ISO-8859-9", new String[]{"iso-ir-148", "ISO_8859-9", "ISO-8859-9", "latin5", "l5", "csISOLatin5"});
        Encoding.add("greek-ccitt", 91, null, new String[]{"iso-ir-150", "csISO150", "csISO150GreekCCITT"});
        Encoding.add("NC_NC00-10:81", 92, null, new String[]{"cuba", "iso-ir-151", "ISO646-CU", "csISO151Cuba"});
        Encoding.add("ISO_6937-2-25", 93, null, new String[]{"iso-ir-152", "csISO6937Add"});
        Encoding.add("GOST_19768-74", 94, null, new String[]{"ST_SEV_358-88", "iso-ir-153", "csISO153GOST1976874"});
        Encoding.add("ISO_8859-supp", 95, null, new String[]{"iso-ir-154", "latin1-2-5", "csISO8859Supp"});
        Encoding.add("ISO_10367-box", 96, null, new String[]{"iso-ir-155", "csISO10367Box"});
        Encoding.add("ISO-8859-10", 13, "ISO-8859-10", new String[]{"iso-ir-157", "l6", "ISO_8859-10:1992", "csISOLatin6", "latin6"});
        Encoding.add("latin-lap", 97, null, new String[]{"lap", "iso-ir-158", "csISO158Lap"});
        Encoding.add("JIS_X0212-1990", 98, null, new String[]{"x0212", "iso-ir-159", "csISO159JISX02121990"});
        Encoding.add("DS_2089", 99, null, new String[]{"DS2089", "ISO646-DK", "dk", "csISO646Danish"});
        Encoding.add("us-dk", 100, null, new String[]{"csUSDK"});
        Encoding.add("dk-us", 101, null, new String[]{"csDKUS"});
        Encoding.add("JIS_X0201", 15, null, new String[]{"X0201", "csHalfWidthKatakana"});
        Encoding.add("KSC5636", 102, null, new String[]{"ISO646-KR", "csKSC5636"});
        Encoding.add("ISO-10646-UCS-2", 1000, null, new String[]{"csUnicode"});
        Encoding.add("ISO-10646-UCS-4", 1001, null, new String[]{"csUCS4"});
        Encoding.add("DEC-MCS", 2008, null, new String[]{"dec", "csDECMCS"});
        Encoding.add("hp-roman8", 2004, null, new String[]{"roman8", "r8", "csHPRoman8"});
        Encoding.add("macintosh", 2027, null, new String[]{"mac", "csMacintosh"});
        Encoding.add("IBM037", 2028, null, new String[]{"cp037", "ebcdic-cp-us", "ebcdic-cp-ca", "ebcdic-cp-wt", "ebcdic-cp-nl", "csIBM037"});
        Encoding.add("IBM038", 2029, null, new String[]{"EBCDIC-INT", "cp038", "csIBM038"});
        Encoding.add("IBM273", 2030, null, new String[]{"CP273", "csIBM273"});
        Encoding.add("IBM274", 2031, null, new String[]{"EBCDIC-BE", "CP274", "csIBM274"});
        Encoding.add("IBM275", 2032, null, new String[]{"EBCDIC-BR", "cp275", "csIBM275"});
        Encoding.add("IBM277", 2033, null, new String[]{"EBCDIC-CP-DK", "EBCDIC-CP-NO", "csIBM277"});
        Encoding.add("IBM278", 2034, null, new String[]{"CP278", "ebcdic-cp-fi", "ebcdic-cp-se", "csIBM278"});
        Encoding.add("IBM280", 2035, null, new String[]{"CP280", "ebcdic-cp-it", "csIBM280"});
        Encoding.add("IBM281", 2036, null, new String[]{"EBCDIC-JP-E", "cp281", "csIBM281"});
        Encoding.add("IBM284", 2037, null, new String[]{"CP284", "ebcdic-cp-es", "csIBM284"});
        Encoding.add("IBM285", 2038, null, new String[]{"CP285", "ebcdic-cp-gb", "csIBM285"});
        Encoding.add("IBM290", 2039, null, new String[]{"cp290", "EBCDIC-JP-kana", "csIBM290"});
        Encoding.add("IBM297", 2040, null, new String[]{"cp297", "ebcdic-cp-fr", "csIBM297"});
        Encoding.add("IBM420", 2041, null, new String[]{"cp420", "ebcdic-cp-ar1", "csIBM420"});
        Encoding.add("IBM423", 2042, null, new String[]{"cp423", "ebcdic-cp-gr", "csIBM423"});
        Encoding.add("IBM424", 2043, null, new String[]{"cp424", "ebcdic-cp-he", "csIBM424"});
        Encoding.add("IBM437", 2011, null, new String[]{"cp437", "437", "csPC8CodePage437"});
        Encoding.add("IBM500", 2044, null, new String[]{"CP500", "ebcdic-cp-be", "ebcdic-cp-ch", "csIBM500"});
        Encoding.add("IBM775", 2087, null, new String[]{"cp775", "csPC775Baltic"});
        Encoding.add("IBM850", 2009, null, new String[]{"cp850", "850", "csPC850Multilingual"});
        Encoding.add("IBM851", 2045, null, new String[]{"cp851", "851", "csIBM851"});
        Encoding.add("IBM852", 2010, null, new String[]{"cp852", "852", "csPCp852"});
        Encoding.add("IBM855", 2046, null, new String[]{"cp855", "855", "csIBM855"});
        Encoding.add("IBM857", 2047, null, new String[]{"cp857", "857", "csIBM857"});
        Encoding.add("IBM860", 2048, null, new String[]{"cp860", "860", "csIBM860"});
        Encoding.add("IBM861", 2049, null, new String[]{"cp861", "861", "cp-is", "csIBM861"});
        Encoding.add("IBM862", 2013, null, new String[]{"cp862", "862", "csPC862LatinHebrew"});
        Encoding.add("IBM863", 2050, null, new String[]{"cp863", "863", "csIBM863"});
        Encoding.add("IBM864", 2051, null, new String[]{"cp864", "csIBM864"});
        Encoding.add("IBM865", 2052, null, new String[]{"cp865", "865", "csIBM865"});
        Encoding.add("IBM866", 2086, null, new String[]{"cp866", "866", "csIBM866"});
        Encoding.add("IBM868", 2053, null, new String[]{"CP868", "cp-ar", "csIBM868"});
        Encoding.add("IBM869", 2054, null, new String[]{"cp869", "869", "cp-gr", "csIBM869"});
        Encoding.add("IBM870", 2055, null, new String[]{"CP870", "ebcdic-cp-roece", "ebcdic-cp-yu", "csIBM870"});
        Encoding.add("IBM871", 2056, null, new String[]{"CP871", "ebcdic-cp-is", "csIBM871"});
        Encoding.add("IBM880", 2057, null, new String[]{"cp880", "EBCDIC-Cyrillic", "csIBM880"});
        Encoding.add("IBM891", 2058, null, new String[]{"cp891", "csIBM891"});
        Encoding.add("IBM903", 2059, null, new String[]{"cp903", "csIBM903"});
        Encoding.add("IBM904", 2060, null, new String[]{"cp904", "904", "csIBBM904"});
        Encoding.add("IBM905", 2061, null, new String[]{"CP905", "ebcdic-cp-tr", "csIBM905"});
        Encoding.add("IBM918", 2062, null, new String[]{"CP918", "ebcdic-cp-ar2", "csIBM918"});
        Encoding.add("IBM1026", 2063, null, new String[]{"CP1026", "csIBM1026"});
        Encoding.add("EBCDIC-AT-DE", 2064, null, new String[]{"csIBMEBCDICATDE"});
        Encoding.add("EBCDIC-AT-DE-A", 2065, null, new String[]{"csEBCDICATDEA"});
        Encoding.add("EBCDIC-CA-FR", 2066, null, new String[]{"csEBCDICCAFR"});
        Encoding.add("EBCDIC-DK-NO", 2067, null, new String[]{"csEBCDICDKNO"});
        Encoding.add("EBCDIC-DK-NO-A", 2068, null, new String[]{"csEBCDICDKNOA"});
        Encoding.add("EBCDIC-FI-SE", 2069, null, new String[]{"csEBCDICFISE"});
        Encoding.add("EBCDIC-FI-SE-A", 2070, null, new String[]{"csEBCDICFISEA"});
        Encoding.add("EBCDIC-FR", 2071, null, new String[]{"csEBCDICFR"});
        Encoding.add("EBCDIC-IT", 2072, null, new String[]{"csEBCDICIT"});
        Encoding.add("EBCDIC-PT", 2073, null, new String[]{"csEBCDICPT"});
        Encoding.add("EBCDIC-ES", 2074, null, new String[]{"csEBCDICES"});
        Encoding.add("EBCDIC-ES-A", 2075, null, new String[]{"csEBCDICESA"});
        Encoding.add("EBCDIC-ES-S", 2076, null, new String[]{"csEBCDICESS"});
        Encoding.add("EBCDIC-UK", 2077, null, new String[]{"csEBCDICUK"});
        Encoding.add("EBCDIC-US", 2078, null, new String[]{"csEBCDICUS"});
        Encoding.add("UNKNOWN-8BIT", 2079, null, new String[]{"csUnknown8BiT"});
        Encoding.add("MNEMONIC", 2080, null, new String[]{"csMnemonic"});
        Encoding.add("MNEM", 2081, null, new String[]{"csMnem"});
        Encoding.add("VISCII", 2082, null, new String[]{"csVISCII"});
        Encoding.add("VIQR", 2083, null, new String[]{"csVIQR"});
        Encoding.add("KOI8-R", 2084, "KOI8-R", new String[]{"csKOI8R"});
        Encoding.add("KOI8-U", 2088, null, NO_ALIASES);
        Encoding.add("IBM00858", 2089, null, new String[]{"CCSID00858", "CP00858", "PC-Multilingual-850+euro"});
        Encoding.add("IBM00924", 2090, null, new String[]{"CCSID00924", "CP00924", "ebcdic-Latin9--euro"});
        Encoding.add("IBM01140", 2091, null, new String[]{"CCSID01140", "CP01140", "ebcdic-us-37+euro"});
        Encoding.add("IBM01141", 2092, null, new String[]{"CCSID01141", "CP01141", "ebcdic-de-273+euro"});
        Encoding.add("IBM01142", 2093, null, new String[]{"CCSID01142", "CP01142", "ebcdic-dk-277+euro", "ebcdic-no-277+euro"});
        Encoding.add("IBM01143", 2094, null, new String[]{"CCSID01143", "CP01143", "ebcdic-fi-278+euro", "ebcdic-se-278+euro"});
        Encoding.add("IBM01144", 2095, null, new String[]{"CCSID01144", "CP01144", "ebcdic-it-280+euro"});
        Encoding.add("IBM01145", 2096, null, new String[]{"CCSID01145", "CP01145", "ebcdic-es-284+euro"});
        Encoding.add("IBM01146", 2097, null, new String[]{"CCSID01146", "CP01146", "ebcdic-gb-285+euro"});
        Encoding.add("IBM01147", 2098, null, new String[]{"CCSID01147", "CP01147", "ebcdic-fr-297+euro"});
        Encoding.add("IBM01148", 2099, null, new String[]{"CCSID01148", "CP01148", "ebcdic-international-500+euro"});
        Encoding.add("IBM01149", 2100, null, new String[]{"CCSID01149", "CP01149", "ebcdic-is-871+euro"});
        Encoding.add("Big5-HKSCS", 2101, null, NO_ALIASES);
        Encoding.add("IBM1047", 2102, null, new String[]{"IBM-1047"});
        Encoding.add("PTCP154", 2103, null, new String[]{"csPTCP154", "PT154", "CP154", "Cyrillic-Asian"});
        Encoding.add("Amiga-1251", 2104, null, new String[]{"Ami1251", "Amiga1251", "Ami-1251"});
        Encoding.add("KOI7-switched", 2105, null, NO_ALIASES);
        Encoding.add("UNICODE-1-1", 1010, null, new String[]{"csUnicode11"});
        Encoding.add("SCSU", 1011, null, NO_ALIASES);
        Encoding.add("UTF-7", 1012, null, NO_ALIASES);
        UTF_16BE = Encoding.add("UTF-16BE", 1013, null, NO_ALIASES);
        UTF_16LE = Encoding.add("UTF-16LE", 1014, null, NO_ALIASES);
        UTF_16 = Encoding.add("UTF-16", 1015, null, NO_ALIASES);
        Encoding.add("CESU-8", 1016, null, new String[]{"csCESU-8"});
        Encoding.add("UTF-32", 1017, null, NO_ALIASES);
        Encoding.add("UTF-32BE", 1018, null, NO_ALIASES);
        Encoding.add("UTF-32LE", 1019, null, NO_ALIASES);
        Encoding.add("BOCU-1", 1020, null, new String[]{"csBOCU-1"});
        Encoding.add("UNICODE-1-1-UTF-7", 103, null, new String[]{"csUnicode11UTF7"});
        UTF_8 = Encoding.add("UTF-8", 106, null, NO_ALIASES);
        Encoding.add("ISO-8859-13", 109, null, NO_ALIASES);
        Encoding.add("ISO-8859-14", 110, null, new String[]{"iso-ir-199", "ISO_8859-14:1998", "ISO_8859-14", "latin8", "iso-celtic", "l8"});
        Encoding.add("ISO-8859-15", 111, null, new String[]{"ISO_8859-15", "Latin-9"});
        Encoding.add("ISO-8859-16", 112, null, new String[]{"iso-ir-226", "ISO_8859-16:2001", "ISO_8859-16", "latin10", "l10"});
        Encoding.add("GBK", 113, null, new String[]{"CP936", "MS936", "windows-936"});
        Encoding.add("GB18030", 114, null, NO_ALIASES);
        Encoding.add("OSD_EBCDIC_DF04_15", 115, null, NO_ALIASES);
        Encoding.add("OSD_EBCDIC_DF03_IRV", 116, null, NO_ALIASES);
        Encoding.add("OSD_EBCDIC_DF04_1", 117, null, NO_ALIASES);
        Encoding.add("JIS_Encoding", 16, null, new String[]{"csJISEncoding"});
        Encoding.add("Shift_JIS", 17, "Shift_JIS", new String[]{"MS_Kanji", "csShiftJIS"});
        Encoding.add("Extended_UNIX_Code_Packed_Format_for_Japanese", 18, "EUC-JP", new String[]{"csEUCPkdFmtJapanese", "EUC-JP"});
        Encoding.add("Extended_UNIX_Code_Fixed_Width_for_Japanese", 19, null, new String[]{"csEUCFixWidJapanese"});
        Encoding.add("ISO-10646-UCS-Basic", 1002, null, new String[]{"csUnicodeASCII"});
        Encoding.add("ISO-10646-Unicode-Latin1", 1003, null, new String[]{"csUnicodeLatin1", "ISO-10646"});
        Encoding.add("ISO-10646-J-1", -1, null, NO_ALIASES);
        Encoding.add("ISO-Unicode-IBM-1261", 1005, null, new String[]{"csUnicodeIBM1261"});
        Encoding.add("ISO-Unicode-IBM-1268", 1006, null, new String[]{"csUnicodeIBM1268"});
        Encoding.add("ISO-Unicode-IBM-1276", 1007, null, new String[]{"csUnicodeIBM1276"});
        Encoding.add("ISO-Unicode-IBM-1264", 1008, null, new String[]{"csUnicodeIBM1264"});
        Encoding.add("ISO-Unicode-IBM-1265", 1009, null, new String[]{"csUnicodeIBM1265"});
        Encoding.add("ISO-8859-1-Windows-3.0-Latin-1", 2000, null, new String[]{"csWindows30Latin1"});
        Encoding.add("ISO-8859-1-Windows-3.1-Latin-1", 2001, null, new String[]{"csWindows31Latin1"});
        Encoding.add("ISO-8859-2-Windows-Latin-2", 2002, null, new String[]{"csWindows31Latin2"});
        Encoding.add("ISO-8859-9-Windows-Latin-5", 2003, null, new String[]{"csWindows31Latin5"});
        Encoding.add("Adobe-Standard-Encoding", 2005, null, new String[]{"csAdobeStandardEncoding"});
        Encoding.add("Ventura-US", 2006, null, new String[]{"csVenturaUS"});
        Encoding.add("Ventura-International", 2007, null, new String[]{"csVenturaInternational"});
        Encoding.add("PC8-Danish-Norwegian", 2012, null, new String[]{"csPC8DanishNorwegian"});
        Encoding.add("PC8-Turkish", 2014, null, new String[]{"csPC8Turkish"});
        Encoding.add("IBM-Symbols", 2015, null, new String[]{"csIBMSymbols"});
        Encoding.add("IBM-Thai", 2016, null, new String[]{"csIBMThai"});
        Encoding.add("HP-Legal", 2017, null, new String[]{"csHPLegal"});
        Encoding.add("HP-Pi-font", 2018, null, new String[]{"csHPPiFont"});
        Encoding.add("HP-Math8", 2019, null, new String[]{"csHPMath8"});
        Encoding.add("Adobe-Symbol-Encoding", 2020, null, new String[]{"csHPPSMath"});
        Encoding.add("HP-DeskTop", 2021, null, new String[]{"csHPDesktop"});
        Encoding.add("Ventura-Math", 2022, null, new String[]{"csVenturaMath"});
        Encoding.add("Microsoft-Publishing", 2023, null, new String[]{"csMicrosoftPublishing"});
        Encoding.add("Windows-31J", 2024, null, new String[]{"csWindows31J"});
        Encoding.add("GB2312", 2025, "GB2312", new String[]{"csGB2312"});
        Encoding.add("Big5", 2026, "Big5", new String[]{"csBig5"});
        Encoding.add("windows-1250", 2250, null, NO_ALIASES);
        Encoding.add("windows-1251", 2251, null, NO_ALIASES);
        Encoding.add("windows-1252", 2252, null, NO_ALIASES);
        Encoding.add("windows-1253", 2253, null, NO_ALIASES);
        Encoding.add("windows-1254", 2254, null, NO_ALIASES);
        Encoding.add("windows-1255", 2255, null, NO_ALIASES);
        Encoding.add("windows-1256", 2256, null, NO_ALIASES);
        Encoding.add("windows-1257", 2257, null, NO_ALIASES);
        Encoding.add("windows-1258", 2258, null, NO_ALIASES);
        Encoding.add("TIS-620", 2259, null, NO_ALIASES);
        Encoding.add("BIG5", "MS950");
        Encoding.add("BIG5-HKSCS", "MS950_HKSCS");
        Encoding.add("BIG5-HKSCS", "HKSCS");
        Encoding.add("GB2312", "EUC-CN");
        Encoding.add("GBK");
        Encoding.add("GB18030");
        Encoding.add("EUC-TW", "CNS11643");
        Encoding.add("EUC-TW", "CNS11643:1992");
        Encoding.add("HZ-GB-2312", "HZ");
        Encoding.add("ISO-2022-CN");
        Encoding.add("windows-31j", "windows-932");
        Encoding.add(3, "US-ASCII", "ASCII");
        Encoding.add(106, "UTF-8", "UTF8");
        Encoding.add(-1, "UTF-16", "Unicode");
        Encoding.add(4, "ISO-8859-1", "ISO8859_1");
        Encoding.add(5, "ISO-8859-2", "ISO8859_2");
        Encoding.add(6, "ISO-8859-3", "ISO8859_3");
        Encoding.add(7, "ISO-8859-4", "ISO8859_4");
        Encoding.add(8, "ISO-8859-5", "ISO8859_5");
        Encoding.add(9, "ISO-8859-6", "ISO8859_6");
        Encoding.add(10, "ISO-8859-7", "ISO8859_7");
        Encoding.add(11, "ISO-8859-8", "ISO8859_8");
        Encoding.add(12, "ISO-8859-9", "ISO8859_9");
        Encoding.add(-1, "ISO-8859-13", "ISO8859_13");
        Encoding.add(-1, "ISO-8859-15", "ISO8859_15_FDIS");
        Encoding.add(2026, "Big5", "Big5");
        Encoding.add(2028, "IBM037", "Cp037");
        Encoding.add(2030, "IBM273", "Cp273");
        Encoding.add(2033, "IBM277", "Cp277");
        Encoding.add(2034, "IBM278", "Cp278");
        Encoding.add(2035, "IBM280", "Cp280");
        Encoding.add(2037, "IBM284", "Cp284");
        Encoding.add(2038, "IBM285", "Cp285");
        Encoding.add(2040, "IBM297", "Cp297");
        Encoding.add(2041, "IBM420", "Cp420");
        Encoding.add(2043, "IBM424", "Cp424");
        Encoding.add(2011, "IBM437", "Cp437");
        Encoding.add(2044, "IBM500", "Cp500");
        Encoding.add(-1, "IBM737", "Cp737");
        Encoding.add(2087, "IBM775", "Cp775");
        Encoding.add(-1, "IBM838", "Cp838");
        Encoding.add(2009, "IBM850", "Cp850");
        Encoding.add(2010, "IBM852", "Cp852");
        Encoding.add(2046, "IBM855", "Cp855");
        Encoding.add(-1, "IBM856", "Cp856");
        Encoding.add(2047, "IBM857", "Cp857");
        Encoding.add(-1, "IBM858", "Cp858");
        Encoding.add(2048, "IBM860", "Cp860");
        Encoding.add(2049, "IBM861", "Cp861");
        Encoding.add(2013, "IBM862", "Cp862");
        Encoding.add(2050, "IBM863", "Cp863");
        Encoding.add(2051, "IBM864", "Cp864");
        Encoding.add(2052, "IBM865", "Cp865");
        Encoding.add(2086, "IBM866", "Cp866");
        Encoding.add(2053, "IBM868", "Cp868");
        Encoding.add(2054, "IBM869", "Cp869");
        Encoding.add(2055, "IBM870", "Cp870");
        Encoding.add(2056, "IBM871", "Cp871");
        Encoding.add(-1, "IBM874", "Cp874");
        Encoding.add(-1, "IBM875", "Cp875");
        Encoding.add(2062, "IBM918", "Cp918");
        Encoding.add(-1, "IBM921", "Cp921");
        Encoding.add(-1, "IBM922", "Cp922");
        Encoding.add(-1, "IBM930", "Cp930");
        Encoding.add(-1, "IBM933", "Cp933");
        Encoding.add(-1, "IBM935", "Cp935");
        Encoding.add(-1, "IBM937", "Cp937");
        Encoding.add(-1, "IBM939", "Cp939");
        Encoding.add(-1, "IBM942", "Cp942");
        Encoding.add(-1, "IBM942C", "Cp942C");
        Encoding.add(-1, "IBM943", "Cp943");
        Encoding.add(-1, "IBM943C", "Cp943C");
        Encoding.add(-1, "IBM948", "Cp948");
        Encoding.add(-1, "IBM949", "Cp949");
        Encoding.add(-1, "IBM949C", "Cp949C");
        Encoding.add(-1, "IBM950", "Cp950");
        Encoding.add(-1, "IBM964", "Cp964");
        Encoding.add(-1, "IBM970", "Cp970");
        Encoding.add(-1, "IBM1006", "Cp1006");
        Encoding.add(-1, "IBM1025", "Cp1025");
        Encoding.add(2063, "IBM1026", "Cp1026");
        Encoding.add(-1, "IBM1046", "Cp1046");
        Encoding.add(-1, "IBM1097", "Cp1097");
        Encoding.add(-1, "IBM1098", "Cp1098");
        Encoding.add(-1, "IBM1112", "Cp1112");
        Encoding.add(-1, "IBM1122", "Cp1122");
        Encoding.add(-1, "IBM1123", "Cp1123");
        Encoding.add(-1, "IBM1124", "Cp1124");
        Encoding.add(-1, "IBM1140", "Cp1140");
        Encoding.add(-1, "IBM1141", "Cp1141");
        Encoding.add(-1, "IBM1142", "Cp1142");
        Encoding.add(-1, "IBM1143", "Cp1143");
        Encoding.add(-1, "IBM1144", "Cp1144");
        Encoding.add(-1, "IBM1145", "Cp1145");
        Encoding.add(-1, "IBM1146", "Cp1146");
        Encoding.add(-1, "IBM1147", "Cp1147");
        Encoding.add(-1, "IBM1148", "Cp1148");
        Encoding.add(-1, "IBM1149", "Cp1149");
        Encoding.add(2250, "windows-1250", "Cp1250");
        Encoding.add(2251, "windows-1251", "Cp1251");
        Encoding.add(2252, "windows-1252", "Cp1252");
        Encoding.add(2253, "windows-1253", "Cp1253");
        Encoding.add(2254, "windows-1254", "Cp1254");
        Encoding.add(2255, "windows-1255", "Cp1255");
        Encoding.add(2256, "windows-1256", "Cp1256");
        Encoding.add(2257, "windows-1257", "Cp1257");
        Encoding.add(2258, "windows-1258", "Cp1258");
        Encoding.add(-1, "IBM1381", "Cp1381");
        Encoding.add(-1, "IBM1383", "Cp1383");
        Encoding.add(-1, "IBM33722", "Cp33722");
        Encoding.add(2025, "GB2312", "EUC_CN");
        Encoding.add(18, "EUC-JP", "EUC_JP");
        Encoding.add(38, "EUC-KR", "EUC_KR");
        Encoding.add(-1, "CNS11643", "EUC_TW");
        Encoding.add(-1, "GBK", "GBK");
        Encoding.add(104, "ISO-2022-CN", "ISO2022CN");
        Encoding.add(-1, "ISO-2022-CN-CNS", "ISO2022CN_CNS");
        Encoding.add(-1, "ISO-2022-CN-GB", "ISO2022CN_GB");
        Encoding.add(39, "ISO-2022-JP", "ISO2022JP");
        Encoding.add(37, "ISO-2022-KR", "ISO2022KR");
        Encoding.add(15, "JIS_X0201", "JIS0201");
        Encoding.add(63, "JIS_X0208-1983", "JIS0208");
        Encoding.add(98, "JIS_X0212-1990", "JIS0212");
        Encoding.add(-1, "JISAutoDetect", "JISAutoDetect");
        Encoding.add(-1, "Johab", "Johab");
        Encoding.add(2084, "KOI8-R", "KOI8_R");
        Encoding.add(-1, "windows-874", "MS874");
        Encoding.add(-1, "windows-932", "MS932");
        Encoding.add(-1, "windows-936", "MS936");
        Encoding.add(-1, "windows-949", "MS949");
        Encoding.add(-1, "windows-950", "MS950");
        Encoding.add(-1, "MacArabic", "MacArabic");
        Encoding.add(-1, "MacCentralEurope", "MacCentralEurope");
        Encoding.add(-1, "MacCroatian", "MacCroatian");
        Encoding.add(-1, "MacCyrillic", "MacCyrillic");
        Encoding.add(-1, "MacDingbat", "MacDingbat");
        Encoding.add(-1, "MacGreek", "MacGreek");
        Encoding.add(-1, "MacHebrew", "MacHebrew");
        Encoding.add(-1, "MacIceland", "MacIceland");
        Encoding.add(-1, "MacRoman", "MacRoman");
        Encoding.add(-1, "MacRomania", "MacRomania");
        Encoding.add(-1, "MacSymbol", "MacSymbol");
        Encoding.add(-1, "MacThai", "MacThai");
        Encoding.add(-1, "MacTurkish", "MacTurkish");
        Encoding.add(-1, "MacUkraine", "MacUkraine");
        Encoding.add(17, "Shift_JIS", "SJIS");
        Encoding.add(2259, "TIS-620", "TIS620");
        Encoding.add("US-ASCII", "ASCII");
        Encoding.add("windows-1250", "Cp1250");
        Encoding.add("windows-1251", "Cp1251");
        Encoding.add("windows-1252", "Cp1252");
        Encoding.add("windows-1253", "Cp1253");
        Encoding.add("windows-1254", "Cp1254");
        Encoding.add("windows-1257", "Cp1257");
        Encoding.add("ISO-8859-1", "ISO8859_1");
        Encoding.add("ISO-8859-2", "ISO8859_2");
        Encoding.add("ISO-8859-4", "ISO8859_4");
        Encoding.add("ISO-8859-5", "ISO8859_5");
        Encoding.add("ISO-8859-7", "ISO8859_7");
        Encoding.add("ISO-8859-9", "ISO8859_9");
        Encoding.add("ISO-8859-13", "ISO8859_13");
        Encoding.add("ISO-8859-15", "ISO8859_15");
        Encoding.add("KOI8-R", "KOI8_R");
        Encoding.add("UTF-8", "UTF8");
        Encoding.add("UTF-16", "UTF-16");
        Encoding.add("UTF-16BE", "UnicodeBigUnmarked");
        Encoding.add("UTF-16LE", "UnicodeLittleUnmarked");
        Encoding.add(null, "UnicodeBig");
        Encoding.add(null, "UnicodeLittle");
        Encoding.add("windows-1255", "Cp1255");
        Encoding.add("windows-1256", "Cp1256");
        Encoding.add("windows-1258", "Cp1258");
        Encoding.add("ISO-8859-3", "ISO8859_3");
        Encoding.add("ISO-8859-6", "ISO8859_6");
        Encoding.add("ISO-8859-8", "ISO8859_8");
        Encoding.add("windows-31j", "MS932");
        Encoding.add("EUC-JP", "EUC_JP");
        Encoding.add("x-EUC-JP-LINUX", "EUC_JP_LINUX");
        Encoding.add("Shift_JIS", "SJIS");
        Encoding.add("ISO-2022-JP", "ISO2022JP");
        Encoding.add("x-mswin-936", "MS936");
        Encoding.add("GB18030", "GB18030");
        Encoding.add("x-EUC-CN", "EUC_CN");
        Encoding.add("GBK", "GBK");
        Encoding.add("ISCII91", "ISCII91");
        Encoding.add("x-windows-949", "MS949");
        Encoding.add("EUC-KR", "EUC_KR");
        Encoding.add("ISO-2022-KR", "ISO2022KR");
        Encoding.add("x-windows-950", "MS950");
        Encoding.add("x-MS950-HKSCS", "MS950_HKSCS");
        Encoding.add("x-EUC-TW", "EUC_TW");
        Encoding.add("Big5", "Big5");
        Encoding.add("Big5-HKSCS", "Big5_HKSCS");
        Encoding.add("TIS-620", "TIS620");
        Encoding.add("Big5_Solaris");
        Encoding.add("Cp037");
        Encoding.add("Cp273");
        Encoding.add("Cp277");
        Encoding.add("Cp278");
        Encoding.add("Cp280");
        Encoding.add("Cp284");
        Encoding.add("Cp285");
        Encoding.add("Cp297");
        Encoding.add("Cp420");
        Encoding.add("Cp424");
        Encoding.add("Cp437");
        Encoding.add("Cp500");
        Encoding.add("Cp737");
        Encoding.add("Cp775");
        Encoding.add("Cp838");
        Encoding.add("Cp850");
        Encoding.add("Cp852");
        Encoding.add("Cp855");
        Encoding.add("Cp856");
        Encoding.add("Cp857");
        Encoding.add("Cp858");
        Encoding.add("Cp860");
        Encoding.add("Cp861");
        Encoding.add("Cp862");
        Encoding.add("Cp863");
        Encoding.add("Cp864");
        Encoding.add("Cp865");
        Encoding.add("Cp866");
        Encoding.add("Cp868");
        Encoding.add("Cp869");
        Encoding.add("Cp870");
        Encoding.add("Cp871");
        Encoding.add("Cp874");
        Encoding.add("Cp875");
        Encoding.add("Cp918");
        Encoding.add("Cp921");
        Encoding.add("Cp922");
        Encoding.add("Cp930");
        Encoding.add("Cp933");
        Encoding.add("Cp935");
        Encoding.add("Cp937");
        Encoding.add("Cp939");
        Encoding.add("Cp942");
        Encoding.add("Cp942C");
        Encoding.add("Cp943");
        Encoding.add("Cp943C");
        Encoding.add("Cp948");
        Encoding.add("Cp949");
        Encoding.add("Cp949C");
        Encoding.add("Cp950");
        Encoding.add("Cp964");
        Encoding.add("Cp970");
        Encoding.add("Cp1006");
        Encoding.add("Cp1025");
        Encoding.add("Cp1026");
        Encoding.add("Cp1046");
        Encoding.add("Cp1047");
        Encoding.add("Cp1097");
        Encoding.add("Cp1098");
        Encoding.add("Cp1112");
        Encoding.add("Cp1122");
        Encoding.add("Cp1123");
        Encoding.add("Cp1124");
        Encoding.add("Cp1140");
        Encoding.add("Cp1141");
        Encoding.add("Cp1142");
        Encoding.add("Cp1143");
        Encoding.add("Cp1144");
        Encoding.add("Cp1145");
        Encoding.add("Cp1146");
        Encoding.add("Cp1147");
        Encoding.add("Cp1148");
        Encoding.add("Cp1149");
        Encoding.add("Cp1381");
        Encoding.add("Cp1383");
        Encoding.add("Cp33722");
        Encoding.add("ISO2022_CN_CNS");
        Encoding.add("ISO2022_CN_GB");
        Encoding.add("JISAutoDetect");
        Encoding.add("MS874");
        Encoding.add("MacArabic");
        Encoding.add("MacCentralEurope");
        Encoding.add("MacCroatian");
        Encoding.add("MacCyrillic");
        Encoding.add("MacDingbat");
        Encoding.add("MacGreek");
        Encoding.add("MacHebrew");
        Encoding.add("MacIceland");
        Encoding.add("MacRoman");
        Encoding.add("MacRomania");
        Encoding.add("MacSymbol");
        Encoding.add("MacThai");
        Encoding.add("MacTurkish");
        Encoding.add("MacUkraine");
        Encoding.initStarTeamEncoding();
        Encoding.ensure(PLATFORM_PROPERTY);
        Encoding.ensure(STARTEAM_PROPERTY);
    }
}

