/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.type.MutableType;
import org.hibernate.util.CalendarComparator;

public class CalendarDateType
extends MutableType {
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        Date date = rs.getDate(name);
        if (date != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return cal;
        }
        return null;
    }

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        Calendar cal = (Calendar)value;
        st.setDate(index, new Date(cal.getTime().getTime()), cal);
    }

    public int sqlType() {
        return 91;
    }

    public String toString(Object value) throws HibernateException {
        return Hibernate.DATE.toString(((Calendar)value).getTime());
    }

    public Object fromStringValue(String xml) throws HibernateException {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime((Date)Hibernate.DATE.fromStringValue(xml));
        return result;
    }

    public Object deepCopyNotNull(Object value) {
        return ((Calendar)value).clone();
    }

    public Class getReturnedClass() {
        return Calendar.class;
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        return CalendarComparator.INSTANCE.compare(x, y);
    }

    public boolean isEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Calendar calendar1 = (Calendar)x;
        Calendar calendar2 = (Calendar)y;
        return calendar1.get(5) == calendar2.get(5) && calendar1.get(2) == calendar2.get(2) && calendar1.get(1) == calendar2.get(1);
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        Calendar calendar = (Calendar)x;
        int hashCode = 1;
        hashCode = 31 * hashCode + calendar.get(5);
        hashCode = 31 * hashCode + calendar.get(2);
        hashCode = 31 * hashCode + calendar.get(1);
        return hashCode;
    }

    public String getName() {
        return "calendar_date";
    }
}

