/****** Object:  Table [dbo].[ChatMessages]    Script Date: 10/15/2007 17:24:45 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [ChatMessages](
	[cm_id] [int] IDENTITY(1,1) NOT NULL,
	[cm_time] [datetime] NOT NULL,
	[cr_id] [int] NULL,
	[cu_id_sender] [int] NULL,
	[cm_senderdisplayname] [nvarchar](100) NOT NULL,
	[cu_id_target] [int] NULL,
	[cm_text] [nvarchar](2000) NOT NULL,
	[cm_texthtml] [nvarchar](2000) NOT NULL,
 CONSTRAINT [PK_ChatMessages] PRIMARY KEY CLUSTERED 
(
	[cm_id] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ChatAdmins]    Script Date: 10/15/2007 17:24:35 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [ChatAdmins](
	[ca_username] [varchar](20) NOT NULL,
	[ca_password] [varchar](250) NOT NULL,
	[ca_lastlogin] [datetime] NOT NULL CONSTRAINT [DF_ChatAdmins_a_lastlogin]  DEFAULT (getdate()),
	[ca_lastsessionid] [varchar](32) NOT NULL CONSTRAINT [DF_ChatAdmins_a_lastsessionid]  DEFAULT (''),
 CONSTRAINT [PK__Admins] PRIMARY KEY CLUSTERED 
(
	[ca_username] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ChatBans]    Script Date: 10/15/2007 17:24:38 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [ChatBans](
	[cb_id] [int] IDENTITY(1,1) NOT NULL,
	[cr_id] [int] NULL,
	[cu_id] [int] NULL,
	[cb_ip] [varchar](15) NULL,
	[cb_date] [datetime] NOT NULL CONSTRAINT [DF_ChatBans_cb_date]  DEFAULT (getdate()),
	[cb_dateexpires] [datetime] NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ChatRooms]    Script Date: 10/15/2007 17:24:50 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [ChatRooms](
	[cr_id] [int] IDENTITY(1,1) NOT NULL,
	[cr_name] [nvarchar](100) NOT NULL,
	[cr_topic] [nvarchar](250) NOT NULL CONSTRAINT [DF_ChatRooms_cr_topic]  DEFAULT (''),
	[cr_password] [nvarchar](50) NULL,
	[cr_maxusers] [int] NULL,
	[cr_visible] [bit] NOT NULL CONSTRAINT [DF_ChatRooms_cr_visible]  DEFAULT ((1)),
 CONSTRAINT [PK_ChatRooms] PRIMARY KEY CLUSTERED 
(
	[cr_id] ASC
) ON [PRIMARY],
 CONSTRAINT [IX_ChatRooms] UNIQUE NONCLUSTERED 
(
	[cr_name] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  StoredProcedure [dbo].[SearchChatUsers]    Script Date: 10/15/2007 17:24:32 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [SearchChatUsers]
	@Username varchar(100) = null,
	@DisplayName nvarchar(200) = null,
	@Gender	int = null,
	@BeginTimeFrom	datetime = null,
	@BeginTimeTo	datetime = null,
	@LastActiveFrom datetime = null,
	@LastActiveTo	datetime = null,
	@Ip varchar(15) = null,
	@SortColumn		varchar(50)
AS
BEGIN
    SELECT
		cu_id as Id
	FROM ChatUsers
	WHERE
		(@Username IS NULL OR @Username = cu_username)
		AND (@DisplayName IS NULL OR @DisplayName = cu_displayname)
		AND (@Gender IS NULL OR @Gender = cu_gender)
		AND ((@BeginTimeFrom IS NULL AND @BeginTimeTo IS NULL)
			 OR
			((@BeginTimeFrom IS NULL AND @BeginTimeTo IS NOT NULL AND cu_begintime > '1/1/2000') OR cu_begintime > @BeginTimeFrom) AND
			((@BeginTimeTo IS NULL AND @BeginTimeFrom IS NOT NULL AND cu_begintime < '1/1/2100') OR cu_begintime < @BeginTimeTo))
		AND ((@LastActiveFrom IS NULL AND @LastActiveTo IS NULL) 
			 OR
			((@LastActiveFrom IS NULL AND @LastActiveTo IS NOT NULL AND cu_lastactive > '1/1/2000') OR cu_lastactive > @LastActiveFrom) AND
			((@LastActiveTo IS NULL AND @LastActiveFrom IS NOT NULL AND cu_lastactive < '1/1/2100') OR cu_lastactive < @LastActiveTo))
		AND (@Ip IS NULL OR @Ip = cu_ip)
	ORDER BY
		CASE @SortColumn
			WHEN 'Username' THEN cu_username
			WHEN 'IP' THEN cu_ip
		END,
		CASE @SortColumn
			WHEN 'Gender' THEN cu_gender
		END,
		CASE @SortColumn
			WHEN 'BeginTime' THEN cu_begintime
			WHEN 'LastActive' THEN cu_lastactive
		END
END
GO
/****** Object:  StoredProcedure [dbo].[DeleteChatUser]    Script Date: 10/15/2007 17:24:21 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [DeleteChatUser]
(
	@UserId	int
)
 AS

DELETE FROM ChatUsers WHERE cu_id = @UserId
GO
/****** Object:  Table [dbo].[ChatUsers]    Script Date: 10/15/2007 17:25:01 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [ChatUsers](
	[cu_id] [int] IDENTITY(1,1) NOT NULL,
	[cu_username] [varchar](100) NOT NULL,
	[cu_password] [char](40) NULL,
	[cu_displayname] [nvarchar](200) NULL,
	[cu_gender] [int] NULL,
	[cu_begintime] [datetime] NOT NULL CONSTRAINT [DF_ChatUsers_cu_begintime]  DEFAULT (getdate()),
	[cu_lastactive] [datetime] NOT NULL CONSTRAINT [DF_ChatUsers_cu_activetime]  DEFAULT (getdate()),
	[cu_ip] [varchar](15) NULL,
	[cu_lastactiveguid] [char](36) NULL,
	[cu_thumbimage] [varchar](500) NULL,
 CONSTRAINT [PK_ChatUsers] PRIMARY KEY CLUSTERED 
(
	[cu_id] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ChatRoomAdmins]    Script Date: 10/15/2007 17:24:46 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [ChatRoomAdmins](
	[cu_id] [int] NOT NULL,
	[cr_id] [int] NOT NULL
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ChatSettings]    Script Date: 10/15/2007 17:24:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [ChatSettings](
	[cs_key] [varchar](80) NOT NULL,
	[cs_value] [ntext] NOT NULL,
 CONSTRAINT [PK_ChatSettings] PRIMARY KEY CLUSTERED 
(
	[cs_key] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[ChatTranslations]    Script Date: 10/15/2007 17:24:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [ChatTranslations](
	[ct_key] [nvarchar](400) NOT NULL,
	[l_id] [int] NOT NULL CONSTRAINT [DF_ChatTranslations_l_id]  DEFAULT ((1)),
	[ct_value] [nvarchar](400) NOT NULL,
	[ct_clientside] [bit] NOT NULL,
 CONSTRAINT [PK_ChatTranslations] PRIMARY KEY CLUSTERED 
(
	[ct_key] ASC,
	[l_id] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ChatIgnoredUsers]    Script Date: 10/15/2007 17:24:40 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [ChatIgnoredUsers](
	[cu_id] [int] NOT NULL,
	[ciu_ignoreduserid] [int] NOT NULL,
	[ciu_ignoredate] [datetime] NOT NULL,
 CONSTRAINT [PK_ChatIgnoredUsers] PRIMARY KEY CLUSTERED 
(
	[cu_id] ASC,
	[ciu_ignoreduserid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  StoredProcedure [dbo].[FetchChatBans]    Script Date: 10/15/2007 17:24:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatBans]
	@Id int = null,
	@ChatRoomId int = null,
	@UserId int = null,
	@UserIp varchar(15) = null,
	@ExpiresAfter datetime = getdate
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    SELECT
		cb_id as Id,
		cr_id as ChatRoomId,
		cu_id as UserId,
		cb_ip as UserIp,
		cb_date as BanDate,
		cb_dateexpires as BanExpires
	FROM
		ChatBans
	WHERE
		(@Id is null OR @Id = cu_id)
		AND (@ChatRoomId is null or @ChatRoomId = cr_id)
		AND (@UserId is null or @UserId = cu_id)
		AND (@UserIp is null or @UserIp = cb_ip)
		AND (@ExpiresAfter is null or cb_dateexpires is null or @ExpiresAfter < cb_dateexpires)
END
GO
/****** Object:  StoredProcedure [dbo].[SaveChatBan]    Script Date: 10/15/2007 17:24:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [SaveChatBan]
	@Id int = null,
	@ChatRoomId int = null,
	@UserId int = null,
	@UserIp varchar(15) = null,
	@BanDate datetime = getdate,
	@BanExpires datetime = null
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    IF (@Id IS NULL)
	BEGIN

		INSERT INTO ChatBans
			(cr_id, cu_id, cb_ip, cb_date, cb_dateexpires)
		VALUES
			(@ChatRoomId, @UserId, @UserIp, @BanDate, @BanExpires)

		SELECT @@Identity

	END
	ELSE
	BEGIN

		UPDATE ChatBans
		SET cr_id = @ChatRoomId, cu_id = @UserId, cb_ip = @UserIp, cb_date = @BanDate,
			cb_dateexpires = @BanExpires
		WHERE cb_id = @Id
	
	END
END
GO
/****** Object:  StoredProcedure [dbo].[SaveChatMessage]    Script Date: 10/15/2007 17:24:28 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [SaveChatMessage] 
	@Id int = null,
	@Time datetime = getdate,
	@ChatRoomId	int = null,
	@SenderUserId int = null,
	@SenderDisplayName nvarchar(100),
	@TargetUserId int = null,
	@Text nvarchar(2000),
	@TextHtml nvarchar(2000)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    IF (@Id IS NULL)
	BEGIN

		INSERT INTO ChatMessages
			(cm_time, cr_id, cu_id_sender, cm_senderdisplayname, cu_id_target, cm_text, cm_texthtml)
		VALUES
			(@Time, @ChatRoomId, @SenderUserId, @SenderDisplayName, @TargetUserId, @Text, @TextHtml)

		SELECT @@Identity

	END
	ELSE
	BEGIN

		UPDATE ChatMessages
		SET cm_time = @Time, cr_id = @ChatRoomId, cu_id_sender = @SenderUserId, 
			cm_senderdisplayname = @SenderDisplayName, cu_id_target = @TargetUserId, cm_text = @Text,
			cm_texthtml = @TextHtml
		WHERE cr_id = @Id
	
	END
END
GO
/****** Object:  StoredProcedure [dbo].[UpdateChatAdminLastLogin]    Script Date: 10/15/2007 17:24:32 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [UpdateChatAdminLastLogin]
(
	@Username	VARCHAR(20),
	@SessionID	VARCHAR(32)
)
AS
	UPDATE ChatAdmins
	SET
		ca_lastlogin = GETDATE(),
		ca_lastsessionid = @SessionID
	WHERE
		ca_username = @Username
GO
/****** Object:  StoredProcedure [dbo].[CreateChatAdmin]    Script Date: 10/15/2007 17:24:19 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [CreateChatAdmin]
(
	@Username	VARCHAR(20),
	@Password	VARCHAR(250)
)
AS
	INSERT INTO ChatAdmins
		(ca_username, ca_password)
	VALUES
		(@Username, @Password)
GO
/****** Object:  StoredProcedure [dbo].[LoadChatAdmin]    Script Date: 10/15/2007 17:24:26 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [LoadChatAdmin]
(
	@Username varchar(20)
)
AS
	SELECT 
		ca_username as Username,
		ca_password as Password,
		ca_lastlogin as LastLogin,
		ca_lastsessionid as LastSessionID
	FROM
		ChatAdmins
	WHERE
		@Username = ca_username
GO
/****** Object:  StoredProcedure [dbo].[UpdateChatAdmin]    Script Date: 10/15/2007 17:24:32 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [UpdateChatAdmin]
(
	@Username	VARCHAR(20),
	@Password	VARCHAR(250)
)
 AS
	UPDATE ChatAdmins
	SET
		ca_password = @Password,
		ca_lastlogin = getdate()
	WHERE
		ca_username = @Username
GO
/****** Object:  StoredProcedure [dbo].[FetchChatAdmins]    Script Date: 10/15/2007 17:24:21 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [FetchChatAdmins]
(
	@Username	VARCHAR(20) = null
)
AS
	SELECT
		ca_password as Password,
		ca_username as Username,
		ca_lastlogin as LastLogin
	FROM 
		ChatAdmins
	WHERE
		@Username = null OR @Username = ca_username
GO
/****** Object:  StoredProcedure [dbo].[DeleteChatAdmin]    Script Date: 10/15/2007 17:24:20 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [DeleteChatAdmin]
(
	@Username	VARCHAR(20)
)
 AS

DELETE FROM ChatAdmins WHERE ca_username = @Username
GO
/****** Object:  StoredProcedure [dbo].[FetchChatSetting]    Script Date: 10/15/2007 17:24:23 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatSetting]
(
	@Key	varchar(80)
)
 AS
	SELECT cs_value FROM ChatSettings WHERE @Key = cs_key
GO
/****** Object:  StoredProcedure [dbo].[UpdateChatSetting]    Script Date: 10/15/2007 17:24:33 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [UpdateChatSetting]
(
	@Key	varchar(80),
	@Value ntext
)
 AS
	IF (EXISTS(SELECT * FROM ChatSettings WHERE @Key = cs_key))
	UPDATE ChatSettings
	SET
		cs_value = @Value
	WHERE
		@Key = cs_key
	ELSE
	INSERT INTO ChatSettings
		(cs_key, cs_value)
	VALUES
		(@Key, @Value)
GO
/****** Object:  StoredProcedure [dbo].[FetchChatRooms]    Script Date: 10/15/2007 17:24:23 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatRooms] 
(
	@ID	INT,
	@Name	NVARCHAR(100)
)
AS
BEGIN
	SET NOCOUNT ON;

    SELECT 
		cr_id		as Id,
		cr_name		as Name,
		cr_topic	as Topic,
		cr_password as Password,
		cr_maxusers as MaxUsers,
		cr_visible	as Visible
	FROM ChatRooms
	WHERE
		(@ID IS NULL OR @ID = cr_id) AND
		(@Name IS NULL OR @Name = cr_name)
END
GO
/****** Object:  StoredProcedure [dbo].[SaveChatRoom]    Script Date: 10/15/2007 17:24:29 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [SaveChatRoom]
	@Id int = null,
	@Name nvarchar(100),
	@Topic nvarchar(250),
	@Password nvarchar(50),
	@MaxUsers int,
	@Visible bit
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    IF (@Id IS NULL)
	BEGIN

		INSERT INTO ChatRooms
			(cr_name, cr_topic, cr_password, cr_maxusers, cr_visible)
		VALUES
			(@Name, @Topic, @Password, @MaxUsers, @Visible)

		SELECT @@Identity

	END
	ELSE
	BEGIN
		UPDATE ChatRooms
		SET cr_name = @Name,
			cr_topic = @Topic,
			cr_password = @Password,
			cr_maxusers = @MaxUsers,
			cr_visible = @Visible
		WHERE cr_id = @Id
	
	END
END
GO
/****** Object:  StoredProcedure [dbo].[DeleteChatRoom]    Script Date: 10/15/2007 17:24:20 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [DeleteChatRoom]
(
	@ID	INT,
	@Name NVARCHAR(100)
)
 AS

DELETE FROM ChatRooms 
WHERE 
	(@ID IS NULL OR cr_id = @ID) AND
	(@Name IS NULL OR cr_name = @Name)
GO
/****** Object:  StoredProcedure [dbo].[FetchChatUsers]    Script Date: 10/15/2007 17:24:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatUsers]
	@Id int = null,
	@Username varchar(100) = null,
	@DisplayName nvarchar(200) = null,
	@Ip varchar(15) = null
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    SELECT
		cu_id as Id,
		cu_username as Username,
		cu_displayname as DisplayName,
		cu_password	as Password,
		cu_gender as Gender,
		cu_begintime as BeginTime,
		cu_lastactive as LastActive,
		cu_ip as Ip,
		cu_lastactiveguid as [Guid],
		cu_thumbimage as ThumbImage
	FROM
		ChatUsers
	WHERE
		(@Id is null OR @Id = cu_id)
		AND (@Username is null OR @Username = cu_username)
		AND (@DisplayName is null OR @DisplayName = cu_displayname)
		AND (@Ip is null OR @Ip = cu_ip)
END
GO
/****** Object:  StoredProcedure [dbo].[SaveChatUser]    Script Date: 10/15/2007 17:24:30 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [SaveChatUser]
	@Id int = null,
	@Username varchar(100),
	@DisplayName nvarchar(200),
	@Password	char(40),
	@Gender		int,
	@BeginTime datetime = getdate,
	@LastActive datetime = getdate,
	@Ip varchar(15),
	@LastActiveGuid	char(36),
	@ThumbImage varchar(500)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    IF (@Id IS NULL)
	BEGIN

		INSERT INTO ChatUsers
			(cu_username, cu_displayname, cu_password, cu_gender, cu_begintime, cu_lastactive, cu_ip, cu_lastactiveguid, cu_thumbimage)
		VALUES
			(@Username, @DisplayName, @Password, @Gender, @BeginTime, @LastActive, @Ip, @LastActiveGuid, @ThumbImage)

		SELECT @@Identity

	END
	ELSE
	BEGIN

		UPDATE ChatUsers
		SET cu_username = @Username, cu_displayname = @DisplayName,
			cu_password = @Password, cu_gender = @Gender, cu_begintime = @BeginTime,
			cu_lastactive = @LastActive, cu_ip = @Ip, cu_lastactiveguid = @LastActiveGuid,
			cu_thumbimage = @ThumbImage
		WHERE cu_id = @Id
	
	END
END
GO
/****** Object:  StoredProcedure [dbo].[IsRoomAdmin]    Script Date: 10/15/2007 17:24:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [IsRoomAdmin]
	@UserId int,
	@ChatRoomId int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	IF EXISTS(SELECT cu_id FROM ChatRoomAdmins WHERE cu_id = @UserId AND cr_id = @ChatRoomId)
		SELECT CAST(1 AS BIT)
	ELSE
		SELECT CAST(0 AS BIT)
END
GO
/****** Object:  StoredProcedure [dbo].[CreateChatRoomAdmin]    Script Date: 10/15/2007 17:24:19 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [CreateChatRoomAdmin]
(
	@UserId	int,
	@ChatRoomId int
)
AS
BEGIN
	IF NOT EXISTS(SELECT cu_id FROM ChatRoomAdmins WHERE cu_id = @UserId AND cr_id = @ChatRoomId)
		INSERT INTO ChatRoomAdmins
			(cu_id, cr_id)
		VALUES
			(@UserId, @ChatRoomId)
END
GO
/****** Object:  StoredProcedure [dbo].[DeleteChatRoomAdmin]    Script Date: 10/15/2007 17:24:20 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [DeleteChatRoomAdmin] 
(
	@UserId	int,
	@ChatRoomId int
)
AS

DELETE FROM ChatRoomAdmins WHERE cu_id = @UserId AND cr_id = @ChatRoomId
GO
/****** Object:  StoredProcedure [dbo].[FetchChatRoomAdmins]    Script Date: 10/15/2007 17:24:23 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatRoomAdmins] 
(
	@ChatRoomId int
)
AS

SELECT cu_id as UserId FROM ChatRoomAdmins WHERE cr_id = @ChatRoomId
GO
/****** Object:  StoredProcedure [dbo].[FetchChatIgnores]    Script Date: 10/15/2007 17:24:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatIgnores] 
(
	@UserId	int,
	@IgnoredUserId	int
)
AS
BEGIN
	SET NOCOUNT ON;

	SELECT 
		cu_id as UserId,
		ciu_ignoreduserid as IgnoredUserId,
		ciu_ignoredate	as IgnoreDate
	FROM
		ChatIgnoredUsers
	WHERE
		(@UserId IS NULL OR cu_id = @UserId) AND
		(@IgnoredUserId IS NULL OR ciu_ignoreduserid = @IgnoredUserId)
END
GO
/****** Object:  StoredProcedure [dbo].[SaveChatIgnore]    Script Date: 10/15/2007 17:24:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [SaveChatIgnore] 
(
	@UserId	int,
	@IgnoredUserId	int,
	@IgnoreDate datetime
)
AS
BEGIN
	IF NOT EXISTS (SELECT 1 FROM ChatIgnoredUsers WHERE cu_id = @UserId AND ciu_ignoreduserid = @IgnoredUserId)
		INSERT INTO ChatIgnoredUsers
			(cu_id, ciu_ignoreduserid, ciu_ignoredate)
		VALUES
			(@UserId, @IgnoredUserId, @IgnoreDate)
	ELSE
		UPDATE ChatIgnoredUsers
		SET
			ciu_ignoredate = @IgnoreDate
		WHERE
			cu_id = @UserId AND ciu_ignoreduserid = @IgnoredUserId
END
GO
/****** Object:  StoredProcedure [dbo].[FetchChatTranslation]    Script Date: 10/15/2007 17:24:24 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatTranslation] 
(
	@LanguageId	INT = 1,
	@Key		NVARCHAR(400)
)
AS

SELECT
	ct_value as Value
FROM
	ChatTranslations
WHERE
	l_id = @LanguageId AND
	ct_key = @Key
GO
/****** Object:  StoredProcedure [dbo].[SaveChatTranslation]    Script Date: 10/15/2007 17:24:29 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [SaveChatTranslation] 
(
	@LanguageId	INT = 1,
	@Key		NVARCHAR(400),
	@Value		NVARCHAR(400),
	@ClientSide	BIT
)
AS

IF NOT EXISTS (SELECT ct_key FROM ChatTranslations WHERE l_id = @LanguageId AND ct_key = @Key)
BEGIN
	INSERT INTO ChatTranslations
		(l_id, ct_key, ct_value, ct_clientside)
	VALUES
		(@LanguageId, @Key, @Value, @ClientSide)
END
ELSE
BEGIN
	UPDATE ChatTranslations
	SET ct_value = @Value
	WHERE l_id = @LanguageId AND ct_key = @Key
END
GO
/****** Object:  StoredProcedure [dbo].[FetchClientChatTranslations]    Script Date: 10/15/2007 17:24:25 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchClientChatTranslations] 
(
	@LanguageId	INT = 1
)
AS

SELECT
	ct_key as [Key],
	ct_value as [Value]
FROM
	ChatTranslations
WHERE
	l_id = @LanguageId AND ct_clientside = 1
GO
/****** Object:  StoredProcedure [dbo].[FetchChatTranslationKeys]    Script Date: 10/15/2007 17:24:24 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [FetchChatTranslationKeys] 
(
	@LanguageId	INT = 1
)
AS

SELECT 
	DISTINCT ct_key as [Key]
FROM
	ChatTranslations
GO
/****** Object:  ForeignKey [FK_ChatIgnoredUsers_ChatIgnoredUsers]    Script Date: 10/15/2007 17:24:41 ******/
ALTER TABLE [ChatIgnoredUsers]  WITH CHECK ADD  CONSTRAINT [FK_ChatIgnoredUsers_ChatIgnoredUsers] FOREIGN KEY([cu_id])
REFERENCES [ChatUsers] ([cu_id])
GO
ALTER TABLE [ChatIgnoredUsers] CHECK CONSTRAINT [FK_ChatIgnoredUsers_ChatIgnoredUsers]
GO
/****** Object:  ForeignKey [FK_ChatIgnoredUsers_ChatUsers]    Script Date: 10/15/2007 17:24:41 ******/
ALTER TABLE [ChatIgnoredUsers]  WITH CHECK ADD  CONSTRAINT [FK_ChatIgnoredUsers_ChatUsers] FOREIGN KEY([ciu_ignoreduserid])
REFERENCES [ChatUsers] ([cu_id])
GO
ALTER TABLE [ChatIgnoredUsers] CHECK CONSTRAINT [FK_ChatIgnoredUsers_ChatUsers]
GO


-- INSERT DEFAULT ADMIN ACCOUNT (admin/admin) into ChatAdmins table 
INSERT INTO ChatAdmins 
(ca_username,ca_password) 
VALUES 
('admin','D033E22AE348AEB5660FC2140AEC35850C4DA997')
GO 

INSERT INTO [ChatRooms] (
	[cr_name],
	[cr_visible]
) VALUES ( N'Main Chat', 1 ) 
GO