/**
 * ZipSnap 2.1
 * Copyright 2007 Zach Scrivena
 * 2007-08-26
 * zachscrivena@gmail.com
 * http://zipsnap.sourceforge.net/
 *
 * ZipSnap is a simple command-line incremental backup tool for directories.
 *
 * TERMS AND CONDITIONS:
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package zipsnap;

import java.util.Locale;
import java.util.Scanner;


/**
 * Simple class for basic user input/output.
 */
public class UserIO
{
	/**
	 * Prompt user for a single-character input.
	 *
	 * @param prompt
	 *     Prompt string
	 * @param ops
	 *     Options string containing permitted character responses
	 * @return
	 *     Char chosen by the user
	 */
	public static char userCharPrompt(
			final String prompt,
			final String ops)
	{
		/* case-insensitive comparison; convert everything to uppercase */
		final String options = ops.toUpperCase(Locale.ENGLISH);

		try
		{
			final Scanner kb = new Scanner(System.in);

			while (true)
			{
				System.out.print(prompt);

				final String choice = kb.nextLine().trim().toUpperCase(Locale.ENGLISH);

				if (choice.length() != 1) continue;

				/* convert to char */
				final char c = choice.charAt(0);

				if (options.indexOf(c) >= 0) return c;
			}
		}
		catch (Exception e)
		{
			System.err.print("(FATAL) Cannot read from keyboard.\n" +
					ErrorWarningHandler.getExceptionMessage(e));
			System.err.flush();
		}

		/* only on exception */
		return '\0';
	}


	/**
	 * Print immediately to standard output.
	 *
	 * @param o
	 *     Object to be printed
	 */
	public static void p(
			final Object o)
	{
		System.out.print(o + "");
		System.out.flush();
	}
}
