/*
 * Decompiled with CFR 0.152.
 */
package zipsnap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import zipsnap.ErrorWarningHandler;
import zipsnap.FileIO;
import zipsnap.ZipSnap;

public class FileUnit
implements Comparable<FileUnit> {
    public String name;
    public final String nativeName;
    public final File file;
    public final boolean isDirectory;
    public long size = 0L;
    public long time = 0L;
    private long crc = -1L;
    public final List<Integer> snapshots = new ArrayList<Integer>();

    FileUnit(String nativeName, File file, boolean isDirectory) {
        this.nativeName = nativeName;
        this.file = file;
        this.isDirectory = isDirectory;
    }

    @Override
    public int compareTo(FileUnit o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (o instanceof FileUnit) {
            return this.name.equals(((FileUnit)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean matchesFilter() {
        if (ZipSnap.filterPattern == null) {
            return true;
        }
        String s = ZipSnap.filterFullPathname ? this.nativeName : FileIO.trimTrailingSeparator(this.file.getName()) + (this.isDirectory ? Character.valueOf(File.separatorChar) : "");
        return ZipSnap.filterPattern.matcher(s).matches();
    }

    public long getCrc() {
        if (this.crc < 0L) {
            FileIO.ComputeFileCRC32Result result = FileIO.computeFileCRC32(this.file);
            if (result.success) {
                this.crc = result.checksum;
            } else {
                ErrorWarningHandler.reportWarning("Unable to compute CRC-32 checksum of file \"" + this.file.getPath() + "\".\nThe CRC-32 checksum of this file will be assumed to be 0.");
                this.crc = 0L;
            }
        }
        return this.crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }
}

