/*
 * Decompiled with CFR 0.152.
 */
package zipsnap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import zipsnap.ErrorWarningHandler;
import zipsnap.FileIO;
import zipsnap.FileUnit;
import zipsnap.SnapshotUnit;
import zipsnap.ZipSnap;

public class Catalog {
    final List<SnapshotUnit> snapshots = new ArrayList<SnapshotUnit>();
    final List<FileUnit> files = new ArrayList<FileUnit>();
    private static final Pattern patternZipSnapVersion = Pattern.compile(Pattern.quote("v:") + "([0-9]+\\.[0-9]+)");
    private static final Pattern patternNumberOfSnapshots = Pattern.compile(Pattern.quote("ns:") + "([0-9]+)");
    private static final Pattern patternNumberOfFiles = Pattern.compile(Pattern.quote("nf:") + "([0-9]+)");
    private static final Pattern patternSnapshot1 = Pattern.compile(Pattern.quote("s:") + "([0-9]+)" + Pattern.quote(":") + "([0-9\\-]+)");
    private static final Pattern patternSnapshot = Pattern.compile(Pattern.quote("s:") + "([0-9]+)" + Pattern.quote(";") + "([0-9\\-]+)");
    private static final Pattern patternFile1 = Pattern.compile(Pattern.quote("f:") + "([0-9]+)" + Pattern.quote(":[") + "(.*)" + Pattern.quote("],") + "([0-9]+)" + Pattern.quote(",") + "([0-9]+)" + Pattern.quote(",") + "([0-9]+)" + Pattern.quote(",") + "([0-9\\,]+)");
    private static final Pattern patternFile = Pattern.compile(Pattern.quote("f:") + "(.*)" + Pattern.quote(";") + "([0-9]+)" + Pattern.quote(";") + "([0-9]+)" + Pattern.quote(";") + "([0-9a-fA-F]+)" + Pattern.quote(";") + "([0-9\\,]+)");

    Catalog() {
    }

    Catalog(File catalogFile) {
        String catalogFileName = catalogFile.getName();
        if (!catalogFile.exists()) {
            ErrorWarningHandler.reportErrorAndExit("Catalog \"" + catalogFileName + "\" does not exist.");
        }
        BufferedReader br = null;
        ZipFile zf = null;
        JarFile jf = null;
        try {
            if (catalogFileName.endsWith(".txt")) {
                br = new BufferedReader(new FileReader(catalogFile));
            } else if (catalogFileName.endsWith(".txt.zip")) {
                zf = new ZipFile(catalogFile);
                br = new BufferedReader(new InputStreamReader(zf.getInputStream(zf.getEntry(catalogFileName.substring(0, catalogFileName.lastIndexOf("."))))));
            } else if (catalogFileName.endsWith(".txt.jar")) {
                jf = new JarFile(catalogFile);
                br = new BufferedReader(new InputStreamReader(jf.getInputStream(jf.getEntry(catalogFileName.substring(0, catalogFileName.lastIndexOf("."))))));
            } else {
                ErrorWarningHandler.reportErrorAndExit("(INTERNAL) Catalog \"" + catalogFileName + "\" has an invalid file extension.");
            }
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to open catalog \"" + catalogFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        int numSnapshots = 0;
        int numFiles = 0;
        double versionNum = 0.0;
        int lineNum = 1;
        while (true) {
            block50: {
                String lineString = null;
                try {
                    if (!br.ready()) break;
                    lineString = br.readLine().trim();
                }
                catch (Exception e) {
                    ErrorWarningHandler.reportErrorAndExit("Unable to read line " + lineNum + " of catalog \"" + catalogFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
                }
                if (!lineString.isEmpty() && !lineString.startsWith("#")) {
                    String s = lineString;
                    try {
                        Matcher m;
                        if (s.startsWith("v:")) {
                            m = patternZipSnapVersion.matcher(s);
                            if (!m.matches()) {
                                throw new Exception("Malformed ZIPSNAP_VERSION line.");
                            }
                            versionNum = Double.parseDouble(m.group(1));
                            if (versionNum > 2.1) {
                                ErrorWarningHandler.reportWarning("Catalog \"" + catalogFileName + "\" was created by a newer version of ZipSnap, and may not be read correctly.");
                            }
                            break block50;
                        }
                        if (s.startsWith("ns:")) {
                            m = patternNumberOfSnapshots.matcher(s);
                            if (!m.matches()) {
                                throw new Exception("Malformed NUMBER_OF_SNAPSHOTS line.");
                            }
                            numSnapshots = Integer.parseInt(m.group(1));
                            break block50;
                        }
                        if (s.startsWith("nf:")) {
                            m = patternNumberOfFiles.matcher(s);
                            if (!m.matches()) {
                                throw new Exception("Malformed NUMBER_OF_FILES line.");
                            }
                            numFiles = Integer.parseInt(m.group(1));
                            break block50;
                        }
                        if (s.startsWith("s:")) {
                            if (versionNum < 2.0) {
                                m = patternSnapshot1.matcher(s);
                                if (!m.matches()) {
                                    throw new Exception("Malformed SNAPSHOT line.");
                                }
                                int number = Integer.parseInt(m.group(1));
                                if (number != this.snapshots.size() + 1) {
                                    ErrorWarningHandler.reportWarning("Malformed snapshot entry found on line " + lineNum + " of catalog \"" + catalogFileName + "\":\n\"" + lineString + "\"\n" + "Expected snapshot number " + (this.snapshots.size() + 1) + ", but found snapshot number " + number + ".\n" + "Snapshot entries must be listed in ascending order of snapshot number.\n" + "This snapshot entry will be ignored.");
                                } else {
                                    this.snapshots.add(new SnapshotUnit(m.group(2)));
                                }
                            } else {
                                m = patternSnapshot.matcher(s);
                                if (!m.matches()) {
                                    throw new Exception("Malformed SNAPSHOT line.");
                                }
                                int number = Integer.parseInt(m.group(1));
                                if (number != this.snapshots.size() + 1) {
                                    ErrorWarningHandler.reportWarning("Malformed snapshot entry found on line " + lineNum + " of catalog \"" + catalogFileName + "\":\n\"" + lineString + "\"\n" + "Expected snapshot number " + (this.snapshots.size() + 1) + ", but found snapshot number " + number + ".\n" + "Snapshot entries must be listed in ascending order of snapshot number.\n" + "This snapshot entry will be ignored.");
                                } else {
                                    this.snapshots.add(new SnapshotUnit(m.group(2)));
                                }
                            }
                            break block50;
                        }
                        if (s.startsWith("f:")) {
                            if (versionNum < 2.0) {
                                m = patternFile1.matcher(s);
                                if (!m.matches()) {
                                    throw new Exception("Malformed FILE line.");
                                }
                                int number = Integer.parseInt(m.group(1));
                                if (number != this.files.size() + 1) {
                                    ErrorWarningHandler.reportWarning("Malformed file entry found on line " + lineNum + " of catalog \"" + catalogFileName + "\":\n\"" + lineString + "\"\n" + "Expected file number " + (this.files.size() + 1) + ", but found file number " + number + ".\n" + "File entries must be listed in ascending order of file number.\n" + "This file entry will be ignored.");
                                } else {
                                    String[] tokens;
                                    String name = m.group(2);
                                    String nativeName = FileIO.neutralToNative(name);
                                    File file = new File(ZipSnap.currentDir, nativeName);
                                    boolean isDirectory = name.endsWith("/");
                                    FileUnit u = new FileUnit(nativeName, file, isDirectory);
                                    u.name = name;
                                    u.size = Long.parseLong(m.group(3));
                                    u.time = Long.parseLong(m.group(4)) * 1000L;
                                    u.setCrc(Long.parseLong(m.group(5)));
                                    ArrayList<Integer> snapshots = new ArrayList<Integer>();
                                    for (String t : tokens = m.group(6).split("\\,")) {
                                        snapshots.add(Integer.parseInt(t) - 1);
                                    }
                                    u.snapshots.addAll(snapshots);
                                    this.files.add(u);
                                }
                            } else {
                                String[] tokens;
                                m = patternFile.matcher(s);
                                if (!m.matches()) {
                                    throw new Exception("Malformed FILE line.");
                                }
                                String name = Catalog.catalogToNeutral(m.group(1));
                                if (name == null) {
                                    throw new Exception("Malformed file/directory name \"" + m.group(1) + "\".");
                                }
                                String nativeName = FileIO.neutralToNative(name);
                                File file = new File(ZipSnap.currentDir, nativeName);
                                boolean isDirectory = name.endsWith("/");
                                FileUnit u = new FileUnit(nativeName, file, isDirectory);
                                u.name = name;
                                u.size = Long.parseLong(m.group(2));
                                u.time = Long.parseLong(m.group(3));
                                u.setCrc(Long.parseLong(m.group(4), 16));
                                ArrayList<Integer> snapshots = new ArrayList<Integer>();
                                for (String t : tokens = m.group(5).split("\\,")) {
                                    snapshots.add(Integer.parseInt(t) - 1);
                                }
                                u.snapshots.addAll(snapshots);
                                this.files.add(u);
                            }
                            break block50;
                        }
                        throw new Exception("Unexpected line encountered.");
                    }
                    catch (Exception e) {
                        ErrorWarningHandler.reportWarning("Unable to parse line " + lineNum + " of catalog \"" + catalogFileName + "\":\n\"" + lineString + "\"\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nThis line will be ignored.");
                    }
                }
            }
            ++lineNum;
        }
        try {
            if (catalogFileName.endsWith(".txt")) {
                br.close();
            } else if (catalogFileName.endsWith(".txt.zip")) {
                br.close();
                zf.close();
            } else if (catalogFileName.endsWith(".txt.jar")) {
                br.close();
                jf.close();
            }
        }
        catch (Exception e) {
            ErrorWarningHandler.reportWarning("Unable to close catalog \"" + catalogFileName + "\"\n(file may not be read successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        if (numSnapshots != this.snapshots.size()) {
            ErrorWarningHandler.reportWarning("Inconsistent number of snapshots found in catalog \"" + catalogFileName + "\":\n" + "Expected " + numSnapshots + " snapshots, but parsed " + this.snapshots.size() + ".");
        }
        if (numFiles != this.files.size()) {
            ErrorWarningHandler.reportWarning("Inconsistent number of files found in catalog \"" + catalogFileName + "\":\n" + "Expected " + numFiles + " files, but parsed " + this.files.size() + ".");
        }
        this.sort();
    }

    void writeToFile(File catalogFile) {
        String catalogFileName = catalogFile.getName();
        if (ZipSnap.simulateOnly) {
            System.out.print("\n\nSimulating creation of new catalog \"" + catalogFileName + "\"...");
            return;
        }
        System.out.print("\n\nCreating new catalog \"" + catalogFileName + "\"...");
        File parentDir = catalogFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!parentDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create catalog \"" + catalogFileName + "\":\nThe parent directory \"" + parentDir.getPath() + "\" does not exist, and cannot be created.");
        }
        if (catalogFile.exists()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create catalog \"" + catalogFileName + "\":\nA " + (catalogFile.isDirectory() ? "directory" : "file") + " of the same name already exists.");
        }
        PrintWriter pw = null;
        try {
            if (catalogFileName.endsWith(".txt")) {
                pw = new PrintWriter(new BufferedWriter(new FileWriter(catalogFile)));
            } else if (catalogFileName.endsWith(".txt.zip")) {
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(catalogFile));
                zos.setLevel(9);
                zos.putNextEntry(new ZipEntry(catalogFileName.substring(0, catalogFileName.lastIndexOf("."))));
                pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(zos)));
            } else if (catalogFileName.endsWith(".txt.jar")) {
                JarOutputStream jos = new JarOutputStream(new FileOutputStream(catalogFile));
                jos.setLevel(9);
                jos.putNextEntry(new ZipEntry(catalogFileName.substring(0, catalogFileName.lastIndexOf("."))));
                pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(jos)));
            } else {
                ErrorWarningHandler.reportErrorAndExit("(INTERNAL) Catalog \"" + catalogFileName + "\" has an invalid file extension.");
            }
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create new catalog \"" + catalogFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        pw.println("# ZipSnap 2.1   Copyright 2007 Zach Scrivena   2007-08-26");
        pw.println("# COMMENT: Lines beginning with a '#' character are ignored by ZipSnap");
        pw.println();
        pw.println("# ZipSnap version");
        pw.println("v:2.1");
        pw.println();
        pw.println("# SNAPSHOT:number;time");
        for (int i = 0; i < this.snapshots.size(); ++i) {
            pw.println("s:" + (i + 1) + ";" + this.snapshots.get((int)i).time);
        }
        pw.println("# Number of snapshots");
        pw.println("ns:" + this.snapshots.size());
        pw.println();
        pw.println("# FILE:name;size;time;checksum;snapshots");
        for (FileUnit u : this.files) {
            pw.print("f:" + Catalog.neutralToCatalog(u.name) + ";" + u.size + ";" + u.time + ";" + Long.toHexString(u.getCrc()).toUpperCase(Locale.ENGLISH) + ";");
            for (int i = 0; i < u.snapshots.size() - 1; ++i) {
                pw.print(u.snapshots.get(i) + 1 + ",");
            }
            pw.println(u.snapshots.get(u.snapshots.size() - 1) + 1);
        }
        pw.println("# Number of files/directories");
        pw.println("nf:" + this.files.size());
        pw.println();
        pw.println("# End-of-Catalog");
        pw.flush();
        pw.close();
        if (pw.checkError()) {
            ErrorWarningHandler.reportWarning("An error was encountered while creating catalog \"" + catalogFileName + "\" (file may not be written successfully).");
        }
        FileIO.FileIOResult result = FileIO.setFileTime(catalogFile, ZipSnap.currentTime.getTime());
        if (!result.success) {
            ErrorWarningHandler.reportWarning("Unable to set last-modified time of catalog \"" + catalogFileName + "\".");
        }
    }

    void sort() {
        Collections.sort(this.files);
    }

    private static String neutralToCatalog(String path) {
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\n') {
                t.append("\\n");
                continue;
            }
            if (c == '\r') {
                t.append("\\r");
                continue;
            }
            if (c == '\\') {
                t.append("\\\\");
                continue;
            }
            t.append(c);
        }
        return t.toString();
    }

    private static String catalogToNeutral(String path) {
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (i + 1 < path.length()) {
                    char d;
                    if ((d = path.charAt(++i)) == 'n') {
                        t.append('\n');
                        continue;
                    }
                    if (d == 'r') {
                        t.append('\r');
                        continue;
                    }
                    if (d == '\\') {
                        t.append('\\');
                        continue;
                    }
                    return null;
                }
                return null;
            }
            t.append(c);
        }
        return t.toString();
    }
}

