` Scriptol PHP
` A wrapper to GD, the image library
` Requires only: include "image.sol"  with Scriptol PHP
` requires also: include "w_gd.hpp"   with Scriptol C++

include "phpgd.h"


extern

 int imagetypes()

 class Font
 /class

 Font gdFontTiny
 Font gdFontSmall
 Font gdFontMediumBold
 Font gdFontLarge
 Font gdFontGiant

 class GDImage
    array pixels
    int sx
    int sy
    int colorsTotal
    array red
    array green
    array blue
 /class



 GDImage imagecreatefromjpeg(file)
 GDImage imagecreatefrompng(file)
 GDImage imagecreatefromwbmp(file)
 GDImage imagecreate(int, int)
 int imagecolorallocate(GDImage, int, int, int)
 void imagefill(GDImage, int, int, int)
 void imageline(GDImage, int, int, int, int, int)
 void imagestring(GDImage, Font, int, int, byte *, int)
 void imagejpeg(GDImage, file, int)

/extern


class Image

 constant int GIF = 1
 constant int PNG = 4
 constant int JPG = 2
 constant int BMP = 8
 constant int TTF = 16

 Font gdFontTiny = null
 Font gdFontSmall = null
 Font gdFontMediumBold = null
 Font gdFontLarge = null
 Font gdFontGiant = null

 GDImage theimage = null
 int font = 1                 ` the number of the font
 dyn texture = 0
 boolean created = false
 int width = 0
 int height = 0

 GDImage create(int w, int h)
  theimage = imagecreate(w, h)
  width = w
  height = h
  created = true
 return theimage

 int notCreated()
   print "Runtime error: image not created"
 return 0

 int copy(int x, int y, int w, int h, Image dst, int dx, int dy)
   if not created ? return notCreated()
   imagecopy(dst.theimage, theimage, dx, dy, x, y, w, h)
 return 1

 void setFontSize(int f) : font = f; return

 void setTexture(dyn t): texture = t; return

 void update()
   width  = imagesx(theimage)
   height = imagesy(theimage)
 return

 int createColor(int r, int g, int b)
   if not created ? return notCreated();
 return imagecolorallocate(theimage, r, g, b)


 `================== figures

 int ellipse(int cx, int cy, int w, int h, int color)
   if not created ? return notCreated()
   imagearc(theimage, cx, cy, w, h, 0, 359, color)
 return 1

 int getPixel(int x, int y)
   if not created ? return notCreated()
 return imagecolorat(theimage, x, y)

 int setPixel(int x, int y, int color)
   if not created ? return notCreated()
   imagesetpixel(theimage, x, y, color)
 return 1

 int line(int x, int y, int x2, int y2, int color)
   if not created ? return notCreated()
   imageline(theimage, x, y, x2, y2, color)
 return 1

 int fill(int color, int x = 0, int y = 0)
   if not created ? return notCreated()
   imagefill(theimage, x, y, color)
 return 1

 int rectangle(int xl, int yt, int xr, int yb, int color)
   if not created ? return notCreated()
   imagerectangle(theimage, xl, yt, xr, yb, color)
 return 1


 `================= Loading an image

 boolean loadJpg(text filename)
   file f
   f.open(filename, "rb")
   theimage = imagecreatefromjpeg(f)
   f.close()
   created = theimage <> 0
   update()
 return created
/*
 boolean loadPng(text filename)
   file f
   f.open(filename, "rb")
   theimage = imagecreatefrompng(f)
   f.close()
   created = theimage <> 0
   update()
 return created
*/
 boolean loadBmp(text filename)
   file f
   f.open(filename, "rb")
   theimage = imagecreatefromwbmp(f)
   f.close()
   created = theimage <> 0
   update()
 return created


 `================= Making a file
/*
 int savePng(text filename)
   if not created ? return notCreated()
   file f
   f.open(filename, "wb")
   imagepng(theimage, f)
   f.close()
 return 1
*/
 int saveJpeg(text filename, int quality=80)
   if not created ? return notCreated()
   file f
   f.open(filename, "wb")
   imagejpeg(theimage, f, quality)
   f.close()
 return 1

 int saveJpg(text filename, int quality=80)
   if not created ? return notCreated()
   file f
   f.open(filename, "wb")
   imagejpeg(theimage, f, quality)
   f.close()
 return 1

 int saveBmp(text filename, int fg = 0)
   if not created ? return notCreated()
   file f
   f.open(filename, "wb")
   imagewbmp(theimage, fg, f)
   f.close()
 return 1

 `================= Text


 void write(int x, int y, text t, int color)
   if not created : notCreated();  return; /if
   imagestring(theimage, font, x, y, t, color)
 return


 `================= Misc

 ` check for supported formats
 boolean support(int type)
  if type
  = JPG:
  = PNG:
  = BMP:
  = TTF:
  else return false
  /if
 return true

 void dispSupport(text format, int f)
   echo format, " "
   if support(f) ? print "supported"; else print "not supported"
 return

 void checkSupport()
  dispSupport("GIF", GIF)
  dispSupport("JPG - requires libjpeg.lib", JPG)
  dispSupport("PNG - requires libpng.lib", PNG)
  dispSupport("BMP - requires libwbmp.lib", BMP)
  dispSupport("TTF - requires libttf.lib", TTF)
 return

/class
