// R2VInterface.h: interface for the CR2VInterface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_R2VINTERFACE_H__8B68A3EB_EFE3_4F38_BF2F_C2635D8AA984__INCLUDED_)
#define AFX_R2VINTERFACE_H__8B68A3EB_EFE3_4F38_BF2F_C2635D8AA984__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//Converting is completed
//if successfully, the WPARAM is 0
//Otherwise the WPARAM is none 0
#define WM_USER_TRACE_FINISHED (WM_APP+100)

//The follow messages are messages about progress
//begin a progress, and the LPARAM is the LPCTSTR type, shows the progress name
#define WM_USER_TRACE_PROGRESS_BEGIN (WM_APP+101)

//The position of current progress, the max value is 100
#define WM_USER_TRACE_PROGRESS (WM_APP+102)

//End the progress
#define WM_USER_TRACE_PROGRESS_END (WM_APP+103)

// convertone raster file to vector file
//***********************************************************************
// Parameters:
// OwnerHanlde - indicate the window which will receive the above message sent by DLL
// source - raster image file name, can be bmp, jpeg, tiff, pcx, tga
// Dest - vector file name
// DestType - the format of vector file: 0-Dxf, 1-text, 2-HP/GL, 3-Svg, 4-EPS
// TraceType - Trace method: 0 - Trace Outline, 1 - Trace Center line
// Threshold - the threshold converting into 1-bit image, not greater than 255
//             If this value is negative, DLL will calculate the threshold auto
// Straighten - Straighten indicates when curve is pulled into beeline,
//              the dot in the curve is the maximum distance from the beeline
// RecCircle - if 0, don't recognise circle or arc, if none 0, recognise the circle and arc
// Fill      - if 0, dont fill, if none 0, fill patten.
//             This parameter only have meanings when trace outline
//             and must set filling parameters before converting
//***********************************************************************
// Return value
// if successfully, it return none zero, otherwise it return zero
typedef	long TraceRasterFileFun(HWND OwnerWindow,
                               LPCTSTR Source, 
                               LPCTSTR Dest, 
                               long DestType,
                               long TraceType,
                               long Threshold,
                               double  Straighten,
                               long   bRecCircle,
                               long   Fill
                               );
//set filling pattern type
//0 - fill hor lines, 1 - fill ver lines, 2 - fill cross line (hor and ver lines)
typedef void SetFillTypeFun(long type);

//Set filling space, must be greater than 0.0
typedef void SetFillSpaceFun(double space);

// if Connect is 0, DLl don't connect the adjacent line
// if Connect isn't 0, DLl will connect the adjacent line
// Connection distance is that when connect two beeline segments,
// the distance is the maxim value from one beeline segment dot to another beeline segment dot.
typedef void SetConnectDistanceFun(long Connect, long Distance);

// If delete is 0, don't delete any lines
// if delete isn't 0, DLL will delete the lines which length is smaller than the parameter Length
typedef void SetDeleteLengthFun(long Delete, long Length);

// if Calc is 0, DLL don't calculate the width of lines
// if Calc isn't 0, DLl will calculate the width of lines.
typedef void SetCalcWidthFun(long Calc);

// Clear all the values of width series
typedef void DeleteAllWidthSeriesFun(void);

// Add one value of width series
// Call this function continually to add all the values of width series
// Before add the first value, you must call function "DeleteAllWidthSeries"
// to clear the values of width series
typedef void AddWidthSeriesValueFun(double Width);

// Set the mode of processing more width
// If Mode is 0, all the width that is greater than the max width in the width series will be shrink  to the max width., eg:
//               if the width series is 0, 1mm, 2mm, 3mm, the width of a line is 5.8mm, it will be shrink into 3mm.

// If Mode is 1, the width that is greater than the max width will not be changed,, eg:
//               if the width series is 0, 1mm, 2mm, 3mm, the width of a line is 5.8mm, it will not be changed, and it still is 5.8mm.

// If mode is 2, the width that is greater than the max width will be rounded into the width by the equal space method, eg:
//               if the width series is 0, 1mm, 2mm, 3mm, the width of a line is 5.8mm, it will be rounded into 6mm.
typedef void SetMoreWidthModeFun(long Mode);

//Set width units: 0-inch, 1-cm, 2-mm, 3-pixel
typedef void SetWidthUnitFun(long unit);

// set the values of width series into default values, and the default values is:
// 0.0mm, 0.5mm, 1.0mm, 2.0mm, the mode of processing more widht is 1, the width units is mm
typedef void SetDefaultWidthSeriesFun(void);

// If Adjust is 0, DLL don't adjust the angle of vectors
// If Adjust isn't 0, DLL  will adjust the angle of vectors
typedef void SetAdjustAngleFun(long Adjust);

// clear all the values of angle series
// Note: if you clear all the values of angle series
//       you must add the new values of angle series, or call the functions
//       SetDefaultAngleSeries or SetOrthoAngleSeries to add predefined values,
//       otherwise, DLL can't adjust the angle, because there is no adjusting basis
typedef	void DeleteAllAngleSeriesFun(void);

// add one value of angle series, the units is radians
// Call this function continually to add all the values of angle series
// Before add the first value, you must call function "DeleteAllAngleSeries"
// if successfully, it return none zero, otherwise it return 0
// Note: MinAngle isn't greater than MainAngle, and
//       MaxAngle isn't smaller than MainAngle.
typedef	long AddAngleSeriesValueFun(double MinAngle, double MaxAngle, double MainAngle);

//  set the values of angle series into default values, and the default values is:
//  Main angle     Max angle     Min angle
//  0.0            1.0           0.0
//  30.0           31.0          29.0
//  45.0           46.0          44.0
//  60.0           61.0          59.0
//  90.0           91.0          89.0
//  120.0          121.0         119.0
//  135.0          136.0         134.0
//  150.0          151.0         149.0
//  180.0          180.0         179.0
typedef	void SetDefaultAngleSeriesFun(void);

//  set the values of angle series into ortho values, and the ortho values is:
//  Main angle     Max angle     Min angle
//  0.0            1.0           0.0
//  90.0           91.0          89.0
//  180.0          180.0         179.0
typedef	void SetOrthoAngleSeriesFun(void);

//----------------------------------------------------------------------------
//	R2VDLL Interface class
class CR2VInterface  
{
	HINSTANCE					m_hModule;

	TraceRasterFileFun			*m_pTraceRasterFileFun;
	SetConnectDistanceFun		*m_pSetConnectDistanceFun;
	SetDeleteLengthFun			*m_pSetDeleteLengthFun;
	SetCalcWidthFun				*m_pSetCalcWidthFun;
	DeleteAllWidthSeriesFun		*m_pDeleteAllWidthSeriesFun;
	AddWidthSeriesValueFun		*m_pAddWidthSeriesValueFun;
	SetMoreWidthModeFun			*m_pSetMoreWidthModeFun;
  SetWidthUnitFun         *m_pSetWidthUnitFun;
	SetDefaultWidthSeriesFun	*m_pSetDefaultWidthSeriesFun;
	SetAdjustAngleFun			*m_pSetAdjustAngleFun;
	DeleteAllAngleSeriesFun		*m_pDeleteAllAngleSeriesFun;
	AddAngleSeriesValueFun		*m_pAddAngleSeriesValueFun;
	SetDefaultAngleSeriesFun	*m_pSetDefaultAngleSeriesFun;
	SetOrthoAngleSeriesFun		*m_pSetOrthoAngleSeriesFun;
  SetFillTypeFun            *m_pSetFillTypeFun;
  SetFillSpaceFun           *m_pSetFillSpaceFun;

	void	Init(void);
public:
	CR2VInterface();
	virtual ~CR2VInterface();

	bool	IsReady(void)	{ return m_hModule != NULL; }
	//----------------------------------------------------Trace Interface
	long TraceRasterFile(HWND OwnerWindow,
                      LPCTSTR Source, 
                      LPCTSTR Dest, 
                      long DestType,
                      long TraceType,
                      long Threshold,
                      double  Straighten, 
                      long   bRecCircle,
                      long   Fill
                      )
	{
		if(m_pTraceRasterFileFun)
			return	m_pTraceRasterFileFun(OwnerWindow,Source,Dest,DestType,TraceType,Threshold,Straighten,bRecCircle,Fill);
		else
			return	FALSE;
	}
  
  void SetFillType(long type)
  {
    if(m_pSetFillTypeFun)m_pSetFillTypeFun(type);
  }
  void SetFillSpace(double space)
  {
    if(m_pSetFillSpaceFun)m_pSetFillSpaceFun(space);
  }
	void SetConnectDistance(long Connect, long Distance)
	{
		if(m_pSetConnectDistanceFun)m_pSetConnectDistanceFun(Connect,Distance);
	}
	void SetDeleteLength(long Delete, long Length)
	{
		if(m_pSetDeleteLengthFun)m_pSetDeleteLengthFun(Delete,Length);
	}
	void SetCalcWidth(long Calc)
	{
		if(m_pSetCalcWidthFun)m_pSetCalcWidthFun(Calc);
	}
	void DeleteAllWidthSeries(void)
	{
		if(m_pDeleteAllWidthSeriesFun)m_pDeleteAllWidthSeriesFun();
	}
	void AddWidthSeriesValue(double Width)
	{
		if(m_pAddWidthSeriesValueFun)m_pAddWidthSeriesValueFun(Width);
	}
	void SetMoreWidthMode(long Mode)
	{
		if(m_pSetMoreWidthModeFun)m_pSetMoreWidthModeFun(Mode);
	}
  //Set width units: 0-inch, 1-cm, 2-mm, 3-pixel
  void SetWidthUnit(long unit)
  {
    if(m_pSetWidthUnitFun)m_pSetWidthUnitFun(unit);
  }  
	void SetDefaultWidthSeries(void)
	{
		if(m_pSetDefaultWidthSeriesFun)m_pSetDefaultWidthSeriesFun();
	}
	void SetAdjustAngle(long Adjust)
	{
		if(m_pSetAdjustAngleFun)m_pSetAdjustAngleFun(Adjust);
	}
	void DeleteAllAngleSeries(void)
	{
		if(m_pDeleteAllAngleSeriesFun)m_pDeleteAllAngleSeriesFun();
	}
	long AddAngleSeriesValue(double MinAngle, double MaxAngle, double MainAngle)
	{
		if(m_pAddAngleSeriesValueFun)
			return	m_pAddAngleSeriesValueFun(MinAngle,MaxAngle,MainAngle);
		else
			return	FALSE;
	}
	void SetDefaultAngleSeries(void)
	{
		if(m_pSetDefaultAngleSeriesFun)m_pSetDefaultAngleSeriesFun();
	}
	void SetOrthoAngleSeries(void)
	{
		if(m_pSetOrthoAngleSeriesFun)m_pSetOrthoAngleSeriesFun();
	}

};

extern CR2VInterface	g_R2V;

#endif // !defined(AFX_R2VINTERFACE_H__8B68A3EB_EFE3_4F38_BF2F_C2635D8AA984__INCLUDED_)
