/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q_RegExpValidator(summary, detail, regExpPattern, trimNeeded, type) {
  this.summary = summary;
  this.detail = detail;
  this.regExpPattern = regExpPattern;
  this.trimNeeded = trimNeeded;
  this.type = type;
  try {
    this.regExp = new RegExp(regExpPattern);
  } catch(e) {
    alert("Error in q_RegExpValidator. Currently defined pattern '" + this.regExpPattern + "' is invalid.");
  }

}

q_RegExpValidator.prototype.validate = function(input) {
  var value = q_getValue(input);

  if (this.trimNeeded) {
    value = q__trim(value);
  }

  if (q_notEmpty(value)) {
    if (!q_matchRegExp(value, this.regExp)) {
      q_addMessage(input, this.summary, this.detail);
      return false;
    }
  }
  return true;
}