/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

var Q__AJAX_REQUEST_MARKER = "teamdev_ajax";
var Q__UPDATE_PORTIONS_SUFFIX = "tc_ajax_portions";
var Q__SUBMIT_PARAMS_SUFFIX = "_ajax_submit_params";
var Q__PARAM_COMPONENT_ID = "q__componentId";
var Q__SUBMITTED_COMPONENT_IDS = "submittedComponentIds";
var Q__SERVER_ACTION = "serverAction";
var Q__SERVER_ACTION_SOURCE_COMPONENT_ID = "serverActionSourceComponentId";
var Q__TAG_AJAX_UPDATABLE = "updatable";
var Q__TAG_AJAX_SCRIPT = "script";
var Q__TAG_AJAX_CSS = "css";
var Q__TAG_AJAX_STYLE = "style";

var Q__UPDATE_TYPE_SIMPLE = "simple";
var Q__UPDATE_TYPE_PORTION = "portion";
var Q__UPDATE_TYPE_STATE = "state";

var Q__UPDATE_TYPE_INITIALIZATION = "initialization";

var Q__TEXT_RESPONSE_PREFIX = "_quipukit_ajax_response_prefix_";
var Q__TEXT_RESPONSE_SUFFIX = "_quipukit_ajax_response_suffix_";


function q__submitComponentWithAdditionalParam(componentId, paramName, paramValue) {
  var component = document.getElementById(componentId);
  var field = q__addHiddenField(component, paramName, paramValue);
  q__reloadComponent(componentId);
  field.parentNode.removeChild(field);
}

function q__reloadComponent(componentId, completionCallback, submittedComponentIds, serverAction, serverActionSourceComponentId) {
  q__sendAjaxRequestIfNoFormSubmission(componentId, null, null, completionCallback, submittedComponentIds, serverAction, serverActionSourceComponentId);
}

function q__requestComponentPortions(componentId, portionNames, portionProcessor) {
  q__sendAjaxRequestIfNoFormSubmission(componentId, portionNames, portionProcessor, null);
}

/*
  Sends ajax request only if no form submission is initated in the same event handler
  (e.g. a submit button invoking an ajax request in the onclick handler)
*/
function q__sendAjaxRequestIfNoFormSubmission() {
  var ajaxArgs = arguments;
  setTimeout(function(){
    if (q__isFormSubmissionStated())
      return;
    q__sendAjaxRequest.apply(null, ajaxArgs);
  }, 1);
}

/**
 * componentId - component to which an ajax request is being made
 * portionNames - null value means that the whole component should be reloaded, otherwise it should be array of component portion names
 * portionProcessor - must be non-null if portionNames is non-null
 * completonCallback - (optional) the function that should be invoked when ajax request is fully processed
 * submittedComponentIds - (optional) array of clientIds for components whose processDecodes->...->processUpdates phases should be invoked in addition to the component being reloaded
 * serverAction - (optional) server action in the form of EL, which should be executed during this ajax request
 * serverActionSourceComponentId - (optional) client id of a component from which this action is initiated (e.g. actual for a button in a table which needs current row's data in the action)
 */
function q__sendAjaxRequest(
        componentId,
        portionNames,
        portionProcessor,
        completionCallback,
        submittedComponentIds,
        serverAction,
        serverActionSourceComponentId) {
  var component = q__getElement(componentId);

  //we need to fire validation for enclosing form (if there are no client validation support - just skip client validation (there will be server side validation only)
  //if form is not valid - no AJAX request at all
  if (document.tc_clientValidationSupport)
    q_validateEnclosingForm(component);

  var form = q__findParentNode(component, "FORM");
  q__assert(component, "q__sendAjaxRequest: Enclosing form not found for element with id: " + component.id);

  var ajaxObject = new q__AjaxObject(componentId);

  var paramsBuf = new q__StringBuffer();
  q__prepareFormParams(form, paramsBuf);
  paramsBuf.append("&");
  q__prepareUpdates(paramsBuf, componentId, portionNames);
  paramsBuf.append("&");
  paramsBuf.append(Q__PARAM_COMPONENT_ID).append("=").append(componentId);
  if (submittedComponentIds != null) {
    paramsBuf.append("&");
    var componentIds = "";
    for (var idx = 0, count = submittedComponentIds.length; idx < count; idx++) {
      if (componentIds != "")
        componentIds += ";";
      componentIds += submittedComponentIds[idx];
    }
    paramsBuf.append(Q__SUBMITTED_COMPONENT_IDS).append("=").append(componentIds);
  }
  if (serverAction != null) {
    paramsBuf.append("&");
    paramsBuf.append(Q__SERVER_ACTION).append("=").append(serverAction);
    if (serverActionSourceComponentId) {
      paramsBuf.append("&");
      paramsBuf.append(Q__SERVER_ACTION_SOURCE_COMPONENT_ID).append("=").append(serverActionSourceComponentId);
    }
  }
  paramsBuf.append("&");
  paramsBuf.append(Q__AJAX_REQUEST_MARKER).append("=").append("true");


  if (portionProcessor) {
    ajaxObject._customProcessor = portionProcessor;
  }

  ajaxObject._request.onreadystatechange = q__getEventHandlerFunction("_processResponse", null, ajaxObject);
  ajaxObject._completionCallback = completionCallback;
  ajaxObject._requestedComponentId = componentId;

  var url = form.action;
  ajaxObject._request.open("POST", url, true);
  ajaxObject._request.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
  ajaxObject._request.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT"); // required for IE not to cache response (vital for Portlets)
  ajaxObject._request.send(paramsBuf.toString());

  q__requestStarted(ajaxObject);
}

var q__ajaxRequestsInProgress = 0;

function q__requestStarted(ajaxObject) {
  q__ajaxRequestsInProgress++;
  if (q__ajaxRequestsInProgress == 1)
    q__showAjaxProgressMessage();
}

function q__requestFinished(ajaxObject) {
  q__ajaxRequestsInProgress--;
  if (q__ajaxRequestsInProgress == 0)
    q__hideAjaxProgressMessage();
}

function q__setAjaxMessageHTML(messageHTML) {
  var div = document.createElement("div");
  var simulateFixedPos = q__isExplorer();
  div.style.position = simulateFixedPos ? "absolute" : "fixed";
  div.style.zIndex = 1000;
  div.style.right = 0;
  div.style.top = 0;
  div.style.visibility = "hidden";
  div.innerHTML = messageHTML;
  document._ajaxInProgressMessage = div;
  q__addLoadEvent(function() {
    var parent = document.forms[0];
    if (parent)
      parent = parent.parent;
    if (!parent)
      parent = document.body;

    parent.appendChild(document._ajaxInProgressMessage);
    setTimeout("if (document._ajaxInProgressMessage.style.visibility=='hidden'){document._ajaxInProgressMessage.style.display='none'; document._ajaxInProgressMessage.style.visibility='';}", 1000);
  })
}

function q__showAjaxProgressMessage() {
  var message = document._ajaxInProgressMessage;
  q__assert(message, "q__showAjaxProgressMessage: no message was registered");
  var simulateFixedPos = q__isExplorer();
  if (simulateFixedPos)
    q__updateAjaxInProgressMessagePos();

  if (message.style.visibility == "hidden")
    message.style.visibility = "";
  else
    message.style.display = "";
  document.body.oldCursor = document.body.style.cursor;
  document.body.style.cursor = "progress";
                              
  if (simulateFixedPos) {
    window.attachEvent("onscroll", q__updateAjaxInProgressMessagePos);
    window.attachEvent("onresize", q__updateAjaxInProgressMessagePos);
  }
}

function q__hideAjaxProgressMessage() {
  var simulateFixedPos = q__isExplorer();
  if (simulateFixedPos) {
    window.detachEvent("onscroll", q__updateAjaxInProgressMessagePos);
    window.detachEvent("onresize", q__updateAjaxInProgressMessagePos);
  }
  document.body.style.cursor = document.body.oldCursor;
  var message = document._ajaxInProgressMessage;
  q__assert(message, "q__hideAjaxProgressMessage: no message was registered");
  message.style.display = "none";
}

function q__updateAjaxInProgressMessagePos() {
  var message = document._ajaxInProgressMessage;
  message.style.top = q__getPageScrollPos().y;
}

// q__AjaxObject class
function q__AjaxObject(componentId) {
  this._targetId = componentId;
  if (window.XMLHttpRequest) {
    this._request = new XMLHttpRequest();
  } else {
    this._request = new ActiveXObject("Microsoft.XMLHTTP"); // todo: catch exception here and report some meaningful error
  }

  this._processResponse = function() {
    var request = this._request;
    if (request.readyState != 4)
      return;

    var requestStatus = request.status;
    if (requestStatus != 200) {
      q__requestFinished(this);
      if (requestStatus == 500) {
        alert("Error while performing Ajax request: 500 (internal server error). See server logs for details.");
      } else if (requestStatus == 302) { // by the spec, 302 responses should be handled transparently by XMLHttpRequest
        alert("Error while performing Ajax request: 302 (this usually means a bug in the browser). If you're using Opera 9.0.x, please upgrade to Opera 9.1 or higher.");
      } else {
        alert("Error while performing Ajax request: \n" + requestStatus);
      }
      return;
    }

    //test if there were no validation error during processing request on the server-side
    if (q__validationErrorDuringProcessing(request)) {
      q__requestFinished(this);
      q__submitById(this._targetId);
      return;
    }
    try {
      //set flag - ajax update in progress
      document.tc_page_is_already_initialized = true;
      if (request.responseXML) {
        var responseXML = request.responseXML;
        this._jsIncludes = responseXML.getElementsByTagName(Q__TAG_AJAX_SCRIPT);
        this._updatables = responseXML.getElementsByTagName(Q__TAG_AJAX_UPDATABLE);
        this._styles = responseXML.getElementsByTagName(Q__TAG_AJAX_STYLE);
        this._cssFiles = responseXML.getElementsByTagName(Q__TAG_AJAX_CSS);
      }
      if (!this._updatables || this._updatables.length == 0) {
        var responseText = request.responseText;
        var startIndex = responseText.indexOf(Q__TEXT_RESPONSE_PREFIX);
        if (startIndex == -1) {
  //        document.write("<xmp>" + responseText + "</xmp>");
          q__requestFinished(this);
          alert("Error while performing Ajax request: illegal response - couldn't find data start marker. Response length: " + responseText.length);
          return;
        }
        startIndex += Q__TEXT_RESPONSE_PREFIX.length;
        var endIndex = responseText.lastIndexOf(Q__TEXT_RESPONSE_SUFFIX);
        if (endIndex == -1) {
          q__requestFinished(this);
          alert("Error while performing Ajax request: illegal response - couldn't find data end marker. Response length: " + responseText.length);
          return;
        }
        var clippedResponseText = responseText.substring(startIndex, endIndex);
        var responseObj;
        eval("responseObj = " + clippedResponseText);
        this._jsIncludes = responseObj[Q__TAG_AJAX_SCRIPT];
        this._updatables = responseObj[Q__TAG_AJAX_UPDATABLE];
        this._styles = responseObj[Q__TAG_AJAX_STYLE];
        this._cssFiles = responseObj[Q__TAG_AJAX_CSS];
      }

      q__processStylesIncludes(this._styles);
      q__processCSSFilesIncludes(this._cssFiles);
      //substitute document.write method to prevent error if foreign js library contains code that executes on library
      //loading and invokes document.write method to render some HTML. Otherwise document.write() method rewrites all
      //currently rendered in page content with content passed to it on AJAX response
      q__substituteDocumentWrite();
      try {
        q__processJSIncludes(this._jsIncludes);
      } catch (e) {
        q__restoreDocumentWrite();
        throw e;
      }
    } catch (e) {
      q__requestFinished(this);
      throw e;
    }

    this._processUpdatesWhenReady();
    document.tc_page_is_already_initialized = null;
  }
  this._processUpdatesWhenReady = function() {
    try {
      var jsIncludes = this._jsIncludes;
      if (!q__areRequiredLibrariesLoaded(jsIncludes)) {
        setTimeout(q__getEventHandlerFunction("_processUpdatesWhenReady", null, this), 50);
        return
      }
      //restore document.write() method to original. used in pair with q__substituteDocumentWrite() method.
      q__restoreDocumentWrite();

      this._processUpdates();
    } catch (e) {
      q__requestFinished(this);
      throw e;
    }
    q__requestFinished(this);

    this._jsIncludes = undefined;
    this._updatables = undefined;
    this._styles = undefined;
    this._cssFiles = undefined;
    this._request = false;
  }

  this._processUpdates = function() {
    var updatables = this._updatables;
    if (!updatables || updatables.length == 0)
      return;
    var rtLibrary = undefined;

    // Cache state update part
    var updateStateId;
    var updateStateHTML;
    for (var i = 0; i < updatables.length; i++) {
      var upd = updatables[i];
      var updType = upd.tagName ? upd.getAttribute("type") : upd.type;

      if (updType == Q__UPDATE_TYPE_STATE) {
        var updId = upd.tagName ? upd.getAttribute("id") : upd.id;
        var updHTML = upd.tagName ? upd.getAttribute("value") : upd.value;
        if (q__isSafari()) {  //unescape ampersands for Safari
          updHTML = updHTML.replace(/&#38;/g, '&');
          updHTML = updHTML.replace(/&amp;/g, '&');
        }
        updateStateId = updId;
        updateStateHTML = updHTML;
        break;
      }
    }

    var simpleUpdate = false;
    for (var i = 0; i < updatables.length; i ++) {
      var upd = updatables[i];
      var updType = upd.tagName ? upd.getAttribute("type") : upd.type;
      var updId = upd.tagName ? upd.getAttribute("id") : upd.id;
      var updHTML = upd.tagName ? upd.getAttribute("value") : upd.value;
      var updScripts = upd.tagName ? upd.getAttribute("scripts") : upd.scripts;

      //runtime generated library with initialization scripts for all components presented on page
      if (updType == Q__UPDATE_TYPE_INITIALIZATION) {
        rtLibrary = updHTML;
      }
      if (q__isSafari()) {  //unescape ampersands for Safari
        updHTML = updHTML.replace(/&#38;/g, '&');
        updHTML = updHTML.replace(/&amp;/g, '&');
      }

      if (updType == Q__UPDATE_TYPE_SIMPLE) {
        this._processSimpleUpdate(updId, updHTML, updScripts, updateStateHTML);
        simpleUpdate = true;
      }
      else if (updType == Q__UPDATE_TYPE_PORTION) {
        this._processPortionUpdate(updId, updHTML, updScripts);
      }
    }

    if (!simpleUpdate && updateStateHTML) {
      q__processStateUpdate(updateStateId, updateStateHTML)
    }

    if (rtLibrary) {
      q__processJSInclude(rtLibrary);
    }

    if (this._completionCallback)
      this._completionCallback(this._requestedComponentId);
  }

  this._processSimpleUpdate = function(updId, updHTML, updScripts, updateStateHTML) {

    var replacedElement = document.getElementById(updId);

    if (replacedElement.onComponentUnload) {
      var delayedUpdate = replacedElement.onComponentUnload();
      if (delayedUpdate) {
        replacedElement.onComponentUnload = null;
        var delayedCompletionCallback = this._completionCallback;
        var delayedCompletionCallbackComponentId = this._requestedComponentId;
        var delayedSimpleUpdate = this._processSimpleUpdate;
        setTimeout(function () {
            delayedSimpleUpdate(updId, updHTML, updScripts, updateStateHTML);
            if (delayedCompletionCallback)
              delayedCompletionCallback(delayedCompletionCallbackComponentId);
        }, 1);
        this._completionCallback = null;
        return;
      }
    }

    var prnt = replacedElement.parentNode;
    var tempDiv = document.createElement("div");
    tempDiv.innerHTML = updHTML;

    var newElements = [];
    for (var childIndex = 0, childCount = tempDiv.childNodes.length; childIndex < childCount; childIndex++) {
      var newElement = tempDiv.childNodes[childIndex];
      q__ajax_pushElementsWithId(newElements, newElement);
    }
    for (var childIndex = 0, childCount = newElements.length; childIndex < childCount; childIndex++) {
      var newElement = newElements[childIndex];
      q__assert(newElement.id, "tc_processSimpleUpdate: newElement without id encountered");
      var elementId = newElement.id;
      var oldElement = document.getElementById(elementId);
      q__assert(oldElement, "Couldn't find component to replace: " + elementId);
      var parent = oldElement.parentNode;
      parent.replaceChild(newElement, oldElement);

      if (q__isOpera()) { // needed for Opera8.5 only (JSFC-1170)
        var oldClassName = parent.className;
        parent.className = parent.className + " _non_existing_class_name_tc__123_";
        parent.className = oldClassName;
      }

    }
    //todo: insert runtime js library invokation with all initial scripts (instead of scripts passing to ajax response) here.
    //todo: replace q__executeScripts() method with runtime js library invokation
    q__executeScripts(updScripts);

    q__processStateUpdate(updId, updateStateHTML);
  }

  this._processPortionUpdate = function(portionName, portionHTML, portionScripts) {
    var componentId = this._targetId;
    var component = document.getElementById(componentId);
    q__assert(component, "Couldn't find component by id: " + componentId);
    this._customProcessor(component, portionName, portionHTML, portionScripts);
  }

}


function q__processStateUpdate(updId, updHTML) {
  if (!updHTML) return;
  
  var updatedElement = document.getElementById(updId);

  var prnt = updatedElement.parentNode;
  var tempDiv = document.createElement("div");
  tempDiv.innerHTML = updHTML;

  var stateField = tempDiv.childNodes[0];
  q__assert(stateField, "No state field found in updateable");
  q__assert(tempDiv.childNodes.length == 1, "There should be only one element in the state field array");
  var stateFieldId = stateField.id;
  var stateOnPage = document.getElementById(stateFieldId);
  if (stateOnPage)
  {
    stateOnPage.parentNode.replaceChild(stateField, stateOnPage);
  }
  else
  {
    // Try to add hidden field into updated element
    var tagName = updatedElement.tagName.toUpperCase();
    if(tagName == "TABLE")
    {
      var firstTD = q__getFirstChildWithName(updatedElement, "TD");
      firstTD.appendChild(stateField);
    }
    else if (updatedElement.childNodes) // check that element already has children to filter one tag elements
    {
      updatedElement.appendChild(stateField);
    }
    else
    {
      prnt.appendChild(stateField);
    }
  }
}

function q__getFirstChildWithName(node, tagName) {
  tagName = tagName.toUpperCase();
  var children = node.childNodes;
  for (var i = 0; i < children.length; i++)
  {
    var childrenTagName = children[i].tagName;
    if (childrenTagName && tagName == childrenTagName.toUpperCase()) {
      return children[i];
    }
    var deepResult = q__getFirstChildWithName(children[i], tagName);
    if (deepResult)
    {
      return deepResult;
    }
  }

  return null;
}

var q__lastAjaxId = 0;

function q__ajax_pushElementsWithId(destElements, element) {
  if (!element)
    return;
  if (element.id) {
    destElements.push(element);
    return;
  }

  for (var childIndex = 0, childCount = element.childNodes.length; childIndex < childCount; childIndex++) {
    var subElement = element.childNodes[childIndex];
    q__ajax_pushElementsWithId(destElements, subElement);
  }

}

function q__findStateField(node) {
  var children = node.childNodes;
  for (var i = 0, count = children.length; i < count; i++) {
    var child = children[i];
    if (q__isStateField(child))
      return child;
  }
  return null;
}

function q__isStateField(element) {
  if (!element || !element.id)
    return false;
  return q__stringEndsWith(element.id, "::_state")
}

function q__processJSIncludes(jsIncludes) {
  if (jsIncludes) {
    for (var i = 0; i < jsIncludes.length; i ++) {
      var jsIncludeElement = jsIncludes[i];
      var include = jsIncludeElement.tagName ? jsIncludeElement.getAttribute("value") : jsIncludeElement.value;
      q__processJSInclude(include);
    }
  }
}

function q__processJSInclude(jsInclude) {
  var found = q__isLibraryLoaded(jsInclude);
  if (!found) {
    var newScript = document.createElement("script");
    newScript.type = "text/javascript";
    newScript.src = jsInclude;
    var head = document.getElementsByTagName("head")[0];
    head.appendChild(newScript);
  }
}
function q__processCSSFilesIncludes(cssFiles) {
  if (cssFiles) {
    var head = document.getElementsByTagName("head")[0];
    for (var i = 0; i < cssFiles.length; i ++) {
      var cssFileElement = cssFiles[i];
      var cssFile = cssFileElement.tagName ? cssFileElement.getAttribute("value") : cssFileElement.value;
      var newCSSFile = document.createElement("link");
      newCSSFile.type = "text/css";
      newCSSFile.href = cssFile;
      newCSSFile.rel = "stylesheet";
      head.appendChild(newCSSFile);
    }
  }
}

function q__processStylesIncludes(styles) {
  if (styles) {
    for (var i = 0; i < styles.length; i ++) {
      var styleElement = styles[i];
      var rule = styleElement.tagName ? styleElement.getAttribute("value") : styleElement.value;
      q__addRule(rule);
    }
  }
}

function q__executeScripts(source) { //should not be invoked cause all init scripts are moved to runtime generated js library (as for now) 
  if (!source || source.length == 0) return;
  var idx1 = source.indexOf("<script");
  var result;
  if (idx1 > -1) {
    result = source.substring(idx1);
    idx1 = result.indexOf(">");
    idx1 += 1;

    var idx2 = result.indexOf("</script>");
    var script = result.substring(idx1, idx2);
    script = script.replace(/<!--/g, "");
    script = script.replace(/\/\/-->/g, "");
    try {
      window.eval(script);
    } catch (e) {
      alert("Couldn't execute script on Ajax request: \n" + script);
      throw e;
    }
    idx2 += "</script>".length;
    result = result.substring(idx2);
    q__executeScripts(result);
  }
}

function q__prepareSubmitParameters(componentId) {
  var component = eval(componentId + Q__SUBMIT_PARAMS_SUFFIX);
  var result = "";
  for (var i = 0; i < component.length; i ++) {
    var c = document.getElementById(component[i]);
    if (c.id || c.name) {
      result += (c.id ? c.id : c.name) + "=";
      result += c.value;
      if (i < component.length - 1) {
        result += "&";
      }
    }
  }
  return result;
}

function q__prepareUpdates(buf, componentId, portionName) {
  var component = document.getElementById(componentId);
  if (!portionName || portionName.length <= 0) return;

  buf.append(Q__UPDATE_PORTIONS_SUFFIX).append("=");
  for (var i = 0, count = portionName.length; i < count; i ++) {
    buf.append(portionName[i]);
    if (i < count - 1) {
      buf.append(",");
    }
  }
}

function q__prepareFormParams(form, buf) {
  var elements = form.elements;
  for (var i = 0, count = elements.length; i < count; i ++) {
    var element = elements[i];
    var elementName = element.name;
    if (!elementName)
      continue;
    var elementType = element.type;
    if (elementType)
      elementType = elementType.toLowerCase();
    if (!elementType || elementType == "image" || elementType == "button" || elementType == "submit")
      continue;

    if (elementType == "checkbox" || elementType == "radio") {
      if (!element.checked)
        continue;
    }

    var paramName = encodeURIComponent(elementName);
    var paramValue = encodeURIComponent(element.value);
    buf.append(paramName).append("=").append(paramValue);
    if (i < count - 1) {
      buf.append("&");
    }
  }
}

function q__areRequiredLibrariesLoaded(libs) {
  if (!libs) return true;
  for (var i = 0; i < libs.length; i ++) {
    var libElement = libs[i];
    var lib = libElement.tagName ? libElement.getAttribute("value") : libElement.value;
    var loaded = q__isLibraryLoaded(lib);
    if (!loaded) return false;
  }
  return true;
}

function q__isLibraryLoaded(lib) {
  var result = eval("window['tc_loadedLibrary:" + lib + "']");
  return result;
}

function q__validationErrorDuringProcessing(request) {
  if (!request)
    return true;
  if (request.responseText && request.responseText.indexOf("validation error") > -1)
    return true;
  return false;
}

function q__substituteDocumentWrite() {
  document._oldWrite = document.write;
  document._tempAjaxStr = "";
  document.write = function(str) {
    document._tempAjaxStr += str;
  };
}

function q__restoreDocumentWrite(placeHolderId) {
  if (document._tempAjaxStr.length > 0) {
    var div = document.createElement("div");
    div.innerHTML = document._tempAjaxStr;
    var childNodes = div.childNodes;
    if (!placeHolderId) {
      for (var i = 0; i < childNodes.length; i ++) {
        document.body.appendChild(childNodes[i]);
      }
    } else {
      var placeholderEl = document.getElementById(placeHolderId);
      if (placeholderEl) {
        var parentEl = placeholderEl.parentNode;
        for (var i = 0; i < childNodes.length; i ++) {
          parentEl.insertBefore(childNodes[i], placeholderEl);
        }
        parentEl.removeChild(placeholderEl);
      }
    }
  }
  document.write = document._oldWrite;
  document._tempAjaxStr = undefined;
}

function q__updateViewIdForRI(viewId) {
  var viewField = document.getElementById('com.sun.faces.VIEW'); // JSF RI 1.1_02
  if (!viewField)
    viewField = document.getElementById('javax.faces.ViewState'); // JSF RI 1.2
  if (!viewField)
    return;

  viewField.value = viewId;
}