/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

// ================================== PUBLIC API METHODS

function q_getTabbedPaneSelectedIndex(tabbedPaneId) {
  if (!tabbedPaneId)
    throw "q_getTabbedPaneSelectedIndex: tabbedPane's clientId must be passed as a parameter";
  var tabbedPane = document.getElementById(tabbedPaneId);
  if (!tabbedPane)
    throw "q_getTabbedPaneSelectedIndex: Invalid clientId passed - no such component was found: " + tabbedPaneId;
  return tabbedPane.getSelectedIndex();
}

function q_setTabbedPaneSelectedIndex(tabbedPaneId, index) {
  if (!tabbedPaneId)
    throw "q_setTabbedPaneSelectedIndex: tabbedPane's clientId must be passed as a parameter";
  var tabbedPane = document.getElementById(tabbedPaneId);
  if (!tabbedPane)
    throw "q_setTabbedPaneSelectedIndex: Invalid clientId passed - no such component was found: " + tabbedPaneId;
  if (!tabbedPane._tabSet._tabs)
    throw "q_setTabbedPaneSelectedIndex: TabbedPane has no tabs: " + tabbedPaneId;
  if (index < 0)
    throw "q_setTabbedPaneSelectedIndex: Invalid index passed - index can not be < 0";
  if (index >= tabbedPane._tabSet._tabs.length)
    throw "q_setTabbedPaneSelectedIndex: Invalid index passed - value '" + index + "' is out of bound. Tab amount is " + tabbedPane._tabSet._tabs.length;

  tabbedPane.setSelectedIndex(index);
}

// ================================== END OF PUBLIC API METHODS

function q__initTabbedPane(clientId, rolloverClass,
                           containerClass, rolloverContainerClass, borderClass, loadingMode) {
  var tabbedPane = q__getControl(clientId);
  tabbedPane._loadingMode = loadingMode;
  tabbedPane._rolloverClass = rolloverClass;
  tabbedPane._containerClass = containerClass;
  tabbedPane._rolloverContainerClass = rolloverContainerClass;

  var tabSet = q__getControl(clientId + "--tabSet");
  tabbedPane._tabSet = tabSet;
  tabSet._tabbedPane = tabbedPane;

  tabbedPane._getPageContainer = function(pageIndex) {
    var result = q__getControl(this.id + "::pane" + pageIndex);
    return result;
  }

  var currentPageContainer = tabbedPane._getPageContainer(tabSet._index);
  if (!currentPageContainer)
    return;
  currentPageContainer.parentNode.fontSize = "0px";
  tabbedPane._currentPageContainer = currentPageContainer;
  var pagesContainer = currentPageContainer.parentNode;
  tabbedPane._pagesContainer = pagesContainer;
  pagesContainer.className = borderClass;

  // setup methods
  tabbedPane.onmouseover = function (evt) {
    q__appendClassNames(this, [this._rolloverClass])
    q__appendClassNames(q__getContianerStyleElement(this._currentPageContainer), [this._rolloverContainerClass])
    q__repaintAreaForOpera(this, true);

    if (this._tabSet._tabs) {
      this._tabSet._getTabByAbsoluteIndex(tabbedPane._tabSet._index).onmouseover();
    }
  }
  tabbedPane.onmouseout = function (evt) {
    q__excludeClassNames(this, [this._rolloverClass])
    q__excludeClassNames(q__getContianerStyleElement(this._currentPageContainer), [this._rolloverContainerClass])
    if (this._tabSet._tabs) {
      this._tabSet._getTabByAbsoluteIndex(tabbedPane._tabSet._index).onmouseout();
    }
    q__repaintAreaForOpera(this, true);
  }

  tabbedPane._changeCurrentPageContainer = function (newPageContainer) {
    var prevPageContainer = this._currentPageContainer;
    q__hideTabbedPaneContainer(prevPageContainer);

    q__getContianerStyleElement(newPageContainer).className = tabbedPane._containerClass;
    q__showTabbedPaneContainer(newPageContainer);
    tabbedPane._currentPageContainer = newPageContainer;
    q__repaintAreaForOpera(tabbedPane);
  }

  tabSet.onchange = function (absoluteIndex) {
    var tabbedPane = this._tabbedPane;
    if (tabbedPane.onselectionchange)
      tabbedPane.onselectionchange(absoluteIndex);
    var loadingMode = tabbedPane._loadingMode;
    if (loadingMode == "server") {
      q__submitEnclosingForm(tabbedPane);
    } else if (loadingMode == "ajax") {
      var newPageContainer = tabbedPane._getPageContainer(absoluteIndex);
      if (!newPageContainer)
        q__requestComponentPortions(tabbedPane.id, ["page:" + absoluteIndex], q__tabbedPanePageLoaded);
      else
        tabbedPane._changeCurrentPageContainer(newPageContainer);
    } else if (loadingMode == "client") {
      var newPageContainer = tabbedPane._getPageContainer(absoluteIndex);
      tabbedPane._changeCurrentPageContainer(newPageContainer);
    } else
      q__assert(false, "tabSet.onchange - invalid loading mode: " + loadingMode);
  }

  function q__tabbedPanePageLoaded(tabbedPane, portionName, portionHTML, portionScripts) {
    var tempDiv = document.createElement("div");
    tempDiv.innerHTML = portionHTML;
    var newPageContainer = tempDiv.childNodes[0];
    tabbedPane._pagesContainer.appendChild(newPageContainer);
    q__executeScripts(portionScripts);

    q__assert(portionName.substring(0, "page:".length) == "page:", "q__tabbedPanePageLoaded: illegal portion prefix:" + portionName);
    var pageNoStr = portionName.substring("page:".length);
    var pageNo = eval(pageNoStr);
    tabbedPane._changeCurrentPageContainer(newPageContainer);
    tabbedPane.setSelectedIndex(pageNo);
  }

  tabbedPane.getSelectedIndex = function () {
    return tabbedPane._tabSet.getSelectedIndex();
  }

  tabbedPane.setSelectedIndex = function (index) {
    tabbedPane._tabSet.setSelectedIndex(index);
  }

  // relayout pane container
  q__showTabbedPaneContainer(currentPageContainer);

  //  tabbedPane.onLoadHandler = q__showTabbedPaneContainer;
  //  var bodyOnLoadHandler = q__getEventHandlerFunction('onLoadHandler', "'" + tabbedPane.id + "'", tabbedPane);
  //  q__addEventHandler(window, "load", bodyOnLoadHandler);
}

function q__hideTabbedPaneContainer(paneContainer) {
  paneContainer.style.display = "none";
}

//function tc_showTabbedPaneContainer1 (paneId) {
//  var tabbedPane = q__getControl(paneId);
//  q__showTabbedPaneContainer(tabbedPane.paneContainer);
//}

function q__showTabbedPaneContainer(paneContainer) {
  paneContainer.style.display = "";
  paneContainer.parentNode.style.height = "100%";
  paneContainer.parentNode.style.width = "100%";
  paneContainer.style.width = "100%";
  paneContainer.style.height = "100%";
  q__repaintAreaForOpera(paneContainer, true); // JSFC-2244
}

function q__getContianerStyleElement(container) {
  if (!container._styleElement)
    container._styleElement = container.getElementsByTagName("td")[0];
  return container._styleElement;
}