/*
 * Copyright (c) 1998-2007 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */


// ================================== PUBLIC API METHODS

function q_showPopupLayer(popupId) {
  if (!popupId)
    throw "q_showPopupLayer: popupLayer's clientId must be passed as a parameter";
  var popup = document.getElementById(popupId);
  if (!popup)
    throw "q_showPopupLayer: Invalid clientId passed - no such component was found: " + popupId;
  popup.show();
}

function q_showPopupLayerAtXY(popupId, x, y) {
  if (!popupId)
    throw "q_showPopupLayerAtXY: popupLayer's clientId must be passed as a parameter";
  var popup = document.getElementById(popupId);
  if (!popup)
    throw "q_showPopupLayerAtXY: Invalid clientId passed - no such component was found: " + popupId;
  popup.showAtXY(x, y);
}

function q_setPopupLayerLeft(popupId, x) {
  if (!popupId)
    throw "q_setPopupLayerLeft: popupLayer's clientId must be passed as a parameter";
  var popup = document.getElementById(popupId);
  if (!popup)
    throw "q_setPopupLayerLeft: Invalid clientId passed - no such component was found: " + popupId;
  popup.setLeft(x);
}

function q_setPopupLayerTop(popupId, y) {
  if (!popupId)
    throw "q_setPopupLayerTop: popupLayer's clientId must be passed as a parameter";
  var popup = document.getElementById(popupId);
  if (!popup)
    throw "q_setPopupLayerTop: Invalid clientId passed - no such component was found: " + popupId;
  popup.setTop(y);
}

function q_hidePopupLayer(popupId) {
  if (!popupId)
    throw "q_hidePopupLayer: popupLayer's clientId must be passed as a parameter";
  var popup = document.getElementById(popupId);
  if (!popup)
    throw "q_hidePopupLayer: Invalid clientId passed - no such component was found: " + popupId;
  popup.hide();
}

function q_showPopupLayerCentered(popupId) {
  if (!popupId)
    throw "q_setPopupLayerTop: popupLayer's clientId must be passed as a parameter";
  var popup = document.getElementById(popupId);
  if (!popup)
    throw "q_hidePopupLayer: Invalid clientId passed - no such component was found: " + popupId;
  popup.showCentered();
}

// ================================== END OF PUBLIC API METHODS

var POPUP_FIRST_EXTERNAL_ANCHOR_SUFFIX = "::firstExternalAnchor";
var POPUP_LAST_EXTERNAL_ANCHOR_SUFFIX = "::lastExternalAnchor";
var POPUP_PRE_FIRST_INTERNAL_ANCHOR_SUFFIX = "::preFirstInternalFocusableAnchor";
var POPUP_FIRST_INTERNAL_ANCHOR_SUFFIX = "::firstInternalFocusableAnchor";
var POPUP_LAST_INTERNAL_ANCHOR_SUFFIX = "::lastInternalFocusableAnchor";

function q__initPopupLayer(id, left, top, width, height, rolloverStyle, hidingTimeout, draggable) {
  var popup = q__getControl(id);

  if (q__isExplorer()) {
    popup._popupComponent = true;
  }

  popup._visibleField = q__getControl(popup.id + "::visible");
  popup._leftField = q__getControl(popup.id + "::left");
  popup._topField = q__getControl(popup.id + "::top");

  var blockingLayers = new Array(document.getElementsByName(popup.id + "::blockingLayer").length);
  for (var i = 0; i < blockingLayers.length; i++) {
    blockingLayers[i] = document.getElementsByName(popup.id + "::blockingLayer")[i];
  }

  if (blockingLayers.length == 2)
  {
    var oldBlockingLayer = blockingLayers[0];
    oldBlockingLayer.parentNode.removeChild(oldBlockingLayer);

    popup.blockingLayer = blockingLayers[1];
    var popupParentNode = null;
    if (q__isExplorer()) {
      popupParentNode = document.getElementsByTagName("body")[0];
    } else {
      popupParentNode = q__getControl(popup.id).parentNode;
    }
    popupParentNode.insertBefore(popup.blockingLayer, popupParentNode.firstChild);
  }
  else {
    popup.blockingLayer = q__getControl(popup.id + "::blockingLayer");
    if (popup.blockingLayer) {
      var popupParentNode = q__getControl(popup.id).parentNode;
      popupParentNode.insertBefore(popup.blockingLayer, popupParentNode.firstChild);
    }
  }

  //  popup.anchorField = q__getControl(popup.id + "_anchor");

  popup.draggable = draggable;

  popup._rolloverStyleNames = rolloverStyle;

  popup._onmousedown = popup.onmousedown;
  popup._onmouseup = popup.onmouseup;
  popup._onmousemove = popup.onmousemove;
  popup._onmouseover = popup.onmouseover;
  popup._onmouseout = popup.onmouseout;

  // --------------- Popup functions start
  popup.setLeft = function (left) {
    if (left == null || left == undefined || isNaN(left))
      throw "popupLayer.setLeft: the integer number should be passed as a parameter, but the following value was passed: " + left;
    var outerDiv = popup._outerIEDiv;
    if (outerDiv)
      outerDiv.style.left = left + "px";
    else
      popup.style.left = left + "px";

    popup._leftField.value = left;
    popup.left = left;
  }

  popup.setTop = function (top) {
    if (top == null || top == undefined || isNaN(top))
      throw "poupLayer.setTop: the integer number should be passed as a parameter, but the following value was passed: " + top;
    var outerDiv = popup._outerIEDiv;
    if (outerDiv)
      outerDiv.style.top = top + "px";
    else
      popup.style.top = top + "px";

    popup._topField.value = top;
    popup.top = top;
  }

  popup.showCentered = function() {
    this.show();
    q__centerPopup(this);
  }

  popup.show = function () {
    if (popup.isVisible()) return;
    popup.style.display = "";
    if (q__isExplorer()) {
      popup._outerIEDiv = q__createIEDragControl(popup);
    }
    if (popup.blockingLayer) {
      var body = document.getElementsByTagName("body")[0];
      var firstExternalAnchor = q__createHiddenFocusElement();
      firstExternalAnchor.id = popup.id + POPUP_FIRST_EXTERNAL_ANCHOR_SUFFIX;
      firstExternalAnchor.onfocus = function() {
        var el = document.getElementById(popup.id + POPUP_FIRST_INTERNAL_ANCHOR_SUFFIX);
        el.focus();
      };

      var firstDocEl = body.firstChild;
      body.insertBefore(firstExternalAnchor, firstDocEl);

      var lastExternalAnchor = q__createHiddenFocusElement();
      lastExternalAnchor.id = popup.id + POPUP_LAST_EXTERNAL_ANCHOR_SUFFIX;
      lastExternalAnchor.onfocus = function() {
        var el = document.getElementById(popup.id + POPUP_FIRST_INTERNAL_ANCHOR_SUFFIX);
        el.focus();
      };
      body.appendChild(lastExternalAnchor);

      var firstInternalAnchor = q__createHiddenFocusElement();
      firstInternalAnchor.id = popup.id + POPUP_FIRST_INTERNAL_ANCHOR_SUFFIX;
      var firstPopupEl = popup.firstChild;
      popup.insertBefore(firstInternalAnchor, firstPopupEl);
      var preFirstInternalAnchor = q__createHiddenFocusElement();
      preFirstInternalAnchor.id = popup.id + POPUP_PRE_FIRST_INTERNAL_ANCHOR_SUFFIX;
      preFirstInternalAnchor.onfocus = function() {
        var el = document.getElementById(popup.id + POPUP_FIRST_INTERNAL_ANCHOR_SUFFIX);
        el.focus();
      };
      popup.insertBefore(preFirstInternalAnchor, firstInternalAnchor);
      firstInternalAnchor.focus();

      var lastInternalAnchor = q__createHiddenFocusElement();
      lastInternalAnchor.id = popup.id + POPUP_LAST_INTERNAL_ANCHOR_SUFFIX;
      lastInternalAnchor.onfocus = function () {
        var el = document.getElementById(popup.id + POPUP_FIRST_INTERNAL_ANCHOR_SUFFIX);
        el.focus();
      };
      popup.appendChild(lastInternalAnchor);
    }

    if (popup.anchorElement != undefined) {
      q__popup_moveToAnchor(popup);
    }
    //    q__hideControlsUnderPopup(this);

    if (popup.blockingLayer) { //modal popup
      //todo: rework blocking layer creation to make <body> its parent (to prevent other controls in table cell, when this cell is big, moving up or down)
      //todo: jsfc-1497
      popup.blockingLayer.style.display = "";

      document._q_activeModalLayer = popup.blockingLayer;
      q__popupLayer_resizeModalLayer();
      if (q__simulateFixedPosForBlockingLayer()) {
        var prnt = popup.offsetParent;
        if (prnt) {
          prnt = prnt.offsetParent;
        }
        var parentLeft = prnt != null ? q__getElementLeft(prnt, true) : 0;
        var parentTop = prnt != null ? q__getElementTop(prnt, true) : 0;
        popup.blockingLayer.style.left = (document.body.scrollLeft - parentLeft) + "px";
        popup.blockingLayer.style.top = (document.body.scrollTop - parentTop) + "px";
        q__addEventHandler(window, "scroll", q__popupLayer_alignModalLayerForIE);
        q__addEventHandler(window, "resize", q__popupLayer_resizeModalLayer);
        q__popupLayer_alignModalLayerForIE();
      } else {
        popup.blockingLayer.style.left = q__getLeftBodyMargin() + "px";
        popup.blockingLayer.style.top = q__getTopBodyMargin() + "px";
        popup.blockingLayer.style.position = "fixed";
        window.addEventListener("resize", q__popupLayer_resizeModalLayer, true);
      }

    }
    popup._visibleField.value = "true";
    if (popup.onshow) {
      popup.onshow();
    }
    if (popup.hideTimer) {
      clearTimeout(popup.hideTimer);
    }

    /*
        if (q__isExplorer()) {
          popup.setLeft(popup.startX);
          popup.setTop(popup.startY);
        }
    */

    if (popup._hidingTimeout && popup._hidingTimeout > 0) {
      popup.hideTimer = setTimeout(function() {
        popup.hide()
      }, popup._hidingTimeout);
    }
    q__repaintAreaForOpera(popup, true);
  }

  popup.hide = function () {
    if (!popup.isVisible()) return;
    if (q__isExplorer()) {
      q__removeIEDragControl(popup);
    }
    if (popup.blockingLayer) {
      var body = document.getElementsByTagName("body")[0];
      var firstExtAnc = document.getElementById(popup.id + POPUP_FIRST_EXTERNAL_ANCHOR_SUFFIX);
      if (firstExtAnc) {
        body.removeChild(firstExtAnc);
      }
      var lastExtAnc = document.getElementById(popup.id + POPUP_LAST_EXTERNAL_ANCHOR_SUFFIX);
      if (lastExtAnc) {
        body.removeChild(lastExtAnc);
      }
      var el = document.getElementById(popup.id + POPUP_FIRST_INTERNAL_ANCHOR_SUFFIX);
      if (el) {
        popup.removeChild(el);
      }
      el = document.getElementById(popup.id + POPUP_LAST_INTERNAL_ANCHOR_SUFFIX);
      if (el) {
        popup.removeChild(el);
      }
      el = document.getElementById(popup.id + POPUP_PRE_FIRST_INTERNAL_ANCHOR_SUFFIX);
      if (el) {
        popup.removeChild(el);
      }
    }

    //    q__unhideControlsUnderPopup(this);
    popup.style.display = "none";
    if (popup.onhide) {
      popup.onhide();
    }
    if (popup.hideTimer) {
      clearTimeout(popup.hideTimer);
    }
    popup._visibleField.value = "false";

    if (popup.blockingLayer) {
      popup.blockingLayer.style.display = "none";
      if (q__simulateFixedPosForBlockingLayer()) {
        q__removeEventHandler(window, "scroll", q__popupLayer_alignModalLayerForIE);
        q__removeEventHandler(window, "resize", q__popupLayer_resizeModalLayer);
      } else {
        document.removeEventListener("resize", q__popupLayer_resizeModalLayer, true);
      }
      if (q__isOpera()) {
        document.body.style.visibility = "hidden";
        document.body.style.visibility = "visible";
      }
    }
    q__repaintAreaForOpera(document.body, true);
  }

  popup.isVisible = function () {
    return popup.style.display != 'none';
  }

  if (rolloverStyle != null) {
    popup.onmouseover = function (e) {
      if (popup._onmouseover) {
        popup._onmouseover(e);
      }
      q__appendClassNames(popup, [popup._rolloverStyleNames]);
      q__repaintAreaForOpera(popup, true);
    }

    popup.onmouseout = function (e) {
      if (popup._onmouseout) {
        popup._onmouseout(e);
      }
      q__excludeClassNames(popup, [popup._rolloverStyleNames]);
      q__repaintAreaForOpera(popup, true);
    }
  } else {
    popup.onmouseover = function (e) {
      if (popup._onmouseover) {
        popup._onmouseover(e);
      }
    }

    popup.onmouseout = function (e) {
      if (popup._onmouseout) {
        popup._onmouseout(e);
      }
    }
  }

  popup.showAtXY = function (x, y) {
    popup.setLeft(x);
    popup.setTop(y);
    popup.show();
  }

  popup.getAnchorElement = function () {
    return popup.anchorElement;
  }
  popup.attachToElement = function (elt, anchorX, anchorY) {
    popup.anchorElement = elt;
    popup.anchorX = anchorX;
    popup.anchorY = anchorY;

    q__popup_moveToAnchor(popup);

    //    if (elt.id) {
    //      popup.anchorField.value = elt.id;
    //    }
  }

  popup.onmousedown = function (e) {
    if (popup._onmousedown) {
      popup._onmousedown(e);
    }
    if (popup.draggable) {
      q__popupLayer_drag_start(e, popup);
    }
  }
  popup.onmouseup = function (e) {
    if (popup._onmouseup) {
      popup._onmouseup(e);
    }
  }
  popup.onmousemove = function (e) {
    if (popup._onmousemove) {
      if (!popup._dragStartFlag) {
        popup._onmousemove(e);
      }
    }
  }

  // --------------- Popup functions end


  popup.left = left;
  if (left != null)
    try {
      popup.setLeft(left);
    } catch (e) {
      q__logError("Invalid value of the 'left' attribute of PopupLayer: \"" + left + "\" ; it must be an integer value ; original error: " + e.message);
      throw e;
    }

  popup.top = top;
  if (top != null)
    try {
      popup.setTop(top);
    } catch (e) {
      q__logError("Invalid value of the 'top' attribute of PopupLayer: \"" + top + "\" ; it must be an integer value ; original error: " + e.message);
      throw e;
    }

  if (width != null)
    try {
      popup.style.width = width;
    } catch (e) {
      q__logError("Invalid value of the 'width' attribute of PopupLayer: \"" + width + "\" ; it must be a valid CSS declaration like \"100px\" ; original error: " + e.message);
      throw e;
    }

  if (height != null)
    try {
      popup.style.height = height;
    } catch (e) {
      q__logError("Invalid value of the 'height' attribute of PopupLayer: \"" + height + "\" ; it must be a valid CSS declaration like \"100px\" ; original error: " + e.message);
      throw e;
    }

  popup._hidingTimeout = hidingTimeout;

  q__addLoadEvent(function () {
    if (popup._visibleField.value == 'true')
      popup.show();
  });

  //  if(popup.anchorField.value && popup.anchorField.value != ''){
  //    var elt = q__getControl(popup.anchorField.value);
  //    if(elt){
  //      popup.attachToElement(elt, 'center', 'middle');
  //    }
  //  }
}

function q__simulateFixedPosForBlockingLayer() {
  return q__isExplorer() /*ie doesn't support fixed pos*/ ||
         q__isMozilla() /*mozilla's blocking layer hides cursor of text-field in fixed-pos popup-layer (JSFC-1930) */;
}

// -- Standalone popup functions

function q__popup_moveToAnchor(popup) {
  var elt = popup.anchorElement;
  var anchorX = popup.anchorX;
  var anchorY = popup.anchorY;

  if (anchorX == undefined || anchorX == 'null') {
    anchorX = 'left';
  }
  if (anchorY == undefined || anchorY == 'null') {
    anchorY = 'top';
  }

  var eltLeft = q__getElementLeft(elt);
  if (anchorX == 'right') {
    popup.setLeft(eltLeft + elt.offsetWidth);
  } else if (anchorX == 'center') {
    popup.setLeft(eltLeft + elt.offsetWidth / 2);
  } else { // left
    popup.setLeft = eltLeft;
  }

  var eltTop = q__getElementTop(elt);
  if (anchorY == 'bottom') {
    popup.setTop(eltTop + elt.offsetHeight);
  } else if (anchorY == 'middle') {
    popup.setTop(eltTop + elt.offsetHeight / 2);
  } else { // top
    popup.setTop(eltTop);
  }
}

function q__getTargetComponentHasOwnMouseBehavior(evt) {
  var element = evt.target ? evt.target : evt.srcElement;
  var tagName = element ? element.tagName : null;
  if (tagName)
    tagName = tagName.toUpperCase();
  var elementHasItsOwnMouseBehavior =
          tagName == "INPUT" ||
          tagName == "TEXTAREA" ||
          tagName == "SELECT" ||
          tagName == "OPTION" ||
          tagName == "BUTTON" ||
          tagName == "A";
  return elementHasItsOwnMouseBehavior;
}

function q__popupLayer_drag_start(e, popup) {
  var evt = q__getEvent(e);
  if (q__getTargetComponentHasOwnMouseBehavior(evt))
    return; // don't drag native components to avoid unwanted effects (see JSFC-2347 and all related requests)
  var scrollLeft = 0;
  var scrollTop = 0;

  if (q__isExplorer()) {
    popup._dragStartFlag = true;
    document.attachEvent("onmousemove", q__popupLayer_dragging);
    document.attachEvent("onmouseup", q__popupLayer_drag_stop);
  } else {
    document.addEventListener("mousemove", q__popupLayer_dragging, true);
    document.addEventListener("mouseup", q__popupLayer_drag_stop, true);
  }

  if (window.pageXOffset) {
    scrollLeft = window.pageXOffset;
    scrollTop = window.pageYOffset;
  } else if (document.documentElement && document.documentElement.scrollLeft) {
    scrollLeft = document.documentElement.scrollLeft;
    scrollTop = document.documentElement.scrollTop;
  } else if (document.body && document.body.scrollLeft) {
    scrollLeft = document.body.scrollLeft;
    scrollTop = document.body.scrollTop;
  }
  if (q__isExplorer()) {
    var outerDiv = popup._outerIEDiv;
    outerDiv.dragX = evt.clientX + scrollLeft;
    outerDiv.dragY = evt.clientY + scrollTop;

    outerDiv.startX = outerDiv.offsetLeft;
    outerDiv.startY = outerDiv.offsetTop;
  } else {
    popup.dragX = evt.clientX + scrollLeft;
    popup.dragY = evt.clientY + scrollTop;

    popup.startX = popup.offsetLeft;
    popup.startY = popup.offsetTop;
  }

  if (q__isExplorer()) {
    document._q_draggedElement = popup._outerIEDiv;
  } else {
    document._q_draggedElement = popup;
  }

  q__breakEvent(evt);
}


function q__popupLayer_dragging(e) {
  var evt = q__getEvent(e);
  var realPopup;

  var popup = document._q_draggedElement;
  if (q__isExplorer()) {
    realPopup = document.getElementById(popup._originalPopupElementId);
  }
  var scrollLeft = 0;
  var scrollTop = 0;

  if (q__isExplorer()) {
    realPopup._dragStartFlag = true;
    if (!realPopup.dragStartCalled && realPopup.ondragstart) {
      realPopup.dragStartCalled = true;
      realPopup.ondragstart(evt);
    }
  } else {
    popup._dragStartFlag = true;
    if (!popup.dragStartCalled && popup.ondragstart) {
      popup.dragStartCalled = true;
      popup.ondragstart(evt);
    }
  }
  if (window.pageXOffset) {
    scrollLeft = window.pageXOffset;
    scrollTop = window.pageYOffset;
  } else if (document.documentElement && document.documentElement.scrollLeft) {
    scrollLeft = document.documentElement.scrollLeft;
    scrollTop = document.documentElement.scrollTop;
  } else if (document.body && document.body.scrollLeft) {
    scrollLeft = document.body.scrollLeft;
    scrollTop = document.body.scrollTop;
  }
  if (q__isExplorer()) {
    var left = popup.offsetLeft + (evt.clientX + scrollLeft - popup.dragX);
    realPopup.setLeft(left);
    popup.dragX = evt.clientX + scrollLeft;
    var top = popup.offsetTop + (evt.clientY + scrollTop - popup.dragY);
    realPopup.setTop(top);
    popup.dragY = evt.clientY + scrollTop;
  } else {
    popup.setLeft(popup.offsetLeft + (evt.clientX + scrollLeft - popup.dragX));
    popup.dragX = evt.clientX + scrollLeft;
    popup.setTop(popup.offsetTop + (evt.clientY + scrollTop - popup.dragY));
    popup.dragY = evt.clientY + scrollTop;
  }
  q__breakEvent(evt);
}

function q__popupLayer_drag_stop(e) {
  var evt = q__getEvent(e);
  var realPopup;

  var popup = document._q_draggedElement;
  if (q__isExplorer()) {
    realPopup = document.getElementById(popup._originalPopupElementId);
  }
  if (q__isExplorer()) {
    if (realPopup.ondragend) {
      if (realPopup.startX != realPopup.offsetLeft || realPopup.startY != realPopup.offsetTop) {
        realPopup.ondragend(evt);
      }
    }
  } else {
    if (popup.ondragend) {
      if (popup.startX != popup.offsetLeft || popup.startY != popup.offsetTop) {
        popup.ondragend(evt);
      }
    }
  }

  if (q__isExplorer()) {
    document.detachEvent("onmousemove", q__popupLayer_dragging);
    document.detachEvent("onmouseup", q__popupLayer_drag_stop);
  } else {
    document.removeEventListener("mousemove", q__popupLayer_dragging, true);
    document.removeEventListener("mouseup", q__popupLayer_drag_stop, true);
  }
  if (q__isExplorer()) {

    if (!realPopup._onmouseup) {
      q__breakEvent(evt);
    }
    realPopup._dragStartFlag = false;
  } else {

    if (!popup._onmouseup) {
      q__breakEvent(evt);
    }
    popup._dragStartFlag = false;
  }
}

function q__popupLayer_alignModalLayerForIE() {
  var modalLayer = document._q_activeModalLayer;
  var scrollPos = q__getPageScrollPos();
  var prnt = modalLayer.offsetParent;
  var parentLeft = prnt != null ? q__getElementLeft(prnt, true) : 0;
  var parentTop = prnt != null ? q__getElementTop(prnt, true) : 0;
  // below comments are caused by JSFC-2030
  modalLayer.style.left = (/*q__getLeftBodyMargin() + */ scrollPos.x - parentLeft) + "px";
  modalLayer.style.top = (/*q__getTopBodyMargin() + */ scrollPos.y - parentTop) + "px";
}

function q__popupLayer_resizeModalLayer() {
  var modalLayer = document._q_activeModalLayer;

  var visibleAreaSize = q__getVisibleAreaSize();

  modalLayer.style.width = visibleAreaSize[0] + "px";
  modalLayer.style.height = visibleAreaSize[1] + "px";
}

function q__getVisibleAreaSize() {
  var width = 0, height = 0;
  if (typeof( window.innerWidth ) == 'number') {
    //Non-IE
    width = window.innerWidth;
    height = window.innerHeight;
  } else if (document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight )) {
    //IE 6+ in 'standards compliant mode'
    width = document.documentElement.clientWidth;
    height = document.documentElement.clientHeight;
  } else if (document.body && ( document.body.clientWidth || document.body.clientHeight )) {
    //IE 4 compatible
    width = document.body.clientWidth;
    height = document.body.clientHeight;
  }
  return [width, height];
}

function q__getCoordsForCenteredPopup(popup) {
  var visibleAreaSize = q__getVisibleAreaSize();

  var scrollX = 0;
  if (document.body && document.body.scrollLeft) {
    scrollX = document.body.scrollLeft;
  } else if (window.pageXOffset) {
    scrollX = window.pageXOffset;
  }
  var scrollY = 0;
  if (document.body && document.body.scrollTop) {
    scrollY = document.body.scrollTop;
  } else if (window.pageYOffset) {
    scrollY = window.pageYOffset;
  }

  var x = visibleAreaSize[0] / 2 - (q__isExplorer() ? popup._outerIEDiv.offsetWidth : popup.offsetWidth) / 2
          - q__getElementLeft(q__getParentToCalculateScrollOffset(popup), true) + scrollX;
  var y = visibleAreaSize[1] / 2 - (q__isExplorer() ? popup._outerIEDiv.offsetHeight : popup.offsetHeight) / 2
          - q__getElementTop(q__getParentToCalculateScrollOffset(popup), true) + scrollY;
  return [x, y];
}

function q__centerPopup(popup) {
  var coords = q__getCoordsForCenteredPopup(popup);
  popup.setLeft(coords[0]);
  popup.setTop(coords[1]);
}

function q__getParentToCalculateScrollOffset(popup) {
  var parentToCalculate = (q__isExplorer() ? popup._outerIEDiv.offsetParent : popup.offsetParent);
  if (!parentToCalculate) {
    parentToCalculate = document.body;
  }
  return parentToCalculate;
}
