/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */
function q_FloatingIconMessageRenderer(clientId, forClientId, imageUrl, offsetTop, offsetLeft, css, hideImg, showSummary, showDetail, defaultPresentation) {
  this.clientId = clientId;
  this.forId = forClientId;
  this.imageUrl = imageUrl;
  this.offsetTop = offsetTop;
  this.offsetLeft = offsetLeft;
  this.errorCss = css;
  this.showImg = !hideImg;
  this.showSummary = showSummary;
  this.showDetail = showDetail;
  this.defaultPresentation = defaultPresentation;
}

q_FloatingIconMessageRenderer.prototype.renderMessage = function(message) {
  if (this.defaultPresentation && q__isComponentHasPresentation(this.forId)) {
    return;
  }
  var forElement = q__getElement(this.forId);

  if (message) {
    var messageText = "";
    if (this.showSummary) messageText = message.summary;
    if (this.showDetail) messageText = message.detail;
    if (this.showDetail && this.showSummary)messageText = message.summary + "; " + message.detail;
    if (!this.showDetail && !this.showSummary) messageText = message.summary;

    if (this.showImg /*|| (!this.showImg && !this.errorCss)*/)
    {
      var messageElement = q__getElement(this.clientId);
      if (!messageElement) {
        messageElement = document.createElement("img");
        messageElement.id = this.clientId;
        messageElement.src = this.imageUrl;
        messageElement.style.position = 'absolute';
        messageElement.style.zIndex = 700;
        document.body.appendChild(messageElement);
      }
      this.position();
      messageElement.alt = messageText;
      messageElement.title = messageText;

    }
    if (!forElement.q_titleChanged) {
      forElement.q_title = forElement.title;
      forElement.q_titleChanged = true;
    }
    //    forElement.title = message.detail;
    forElement.title = messageText;

    if (this.errorCss && !forElement.q_cssChanged)
    {
      forElement.q_className = forElement.className;
      forElement.className = forElement.className + " " + this.errorCss;
      forElement.q_cssChanged = true;
      q__repaintAreaForOpera(forElement, true);
    }

  } else {
    var messageElement = q__getElement(this.clientId);
    if (messageElement) {
      var parentNode = messageElement.parentNode;
      parentNode.removeChild(messageElement);
    }
    if (forElement.q_titleChanged) {
      forElement.title = forElement.q_title;
      forElement.q_title = undefined;
      forElement.q_titleChanged = undefined;
    }
    if (forElement.q_cssChanged) {
      forElement.className = forElement.q_className;
      forElement.q_className = undefined;
      forElement.q_cssChanged = undefined;
      q__repaintAreaForOpera(forElement, true);
    }
  }
}

q_FloatingIconMessageRenderer.prototype.update = function() {
  var forElement = q__getElement(this.forId);
  var message;
  if (forElement) {
    message = q_getMessages(forElement)[0];
    this.renderMessage(message);
  }
}

q_FloatingIconMessageRenderer.prototype.position = function() {

  var messageElement = q__getElement(this.clientId);
  if (messageElement) {
    var forElement = q__getElement(this.forId);

    if (!q__isVisibleRecursive(forElement)) {
      messageElement.style.display = "none";
      return;
    }
    else {
      messageElement.style.display = "";
    }

    //    var left = q__getElementLeft(forElement)
    var left = q_getElLeft(forElement)

    if (this.offsetLeft) {
      left += this.offsetLeft;
    }
    messageElement.style.left = left + "px";


    //    var top = q__getElementTop(forElement);
    var top = q_getElTop(forElement);

    if (this.offsetTop) {
      top += this.offsetTop;
    }
    messageElement.style.top = top + "px";
  }
}
