/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */
function q__initDropDown(dropDownId,
                         containerClass,
                         rolloverContainerClass,
                         fieldClass,
                         rolloverFieldClass,
                         buttonClass,
                         rolloverButtonClass,
                         pressedButtonClass,
                         popupClass,
                         rolloverPopupClass) {

  var dropDown = q__getControl(dropDownId);

  dropDown._fieldId = dropDownId + "::field";
  dropDown._buttonId = dropDownId + "::button";
  dropDown._popupId = dropDownId + "--popup";

  var field = q__getControl(dropDown._fieldId);
  field._dropDownId = dropDownId;
  var button = q__getControl(dropDown._buttonId);
  button._dropDownId = dropDownId;
  var popup = q__getControl(dropDown._popupId);
  popup._dropDownId = dropDownId;

  dropDown._containerClass = q__dropdown_getClassName(containerClass);
  dropDown.className = dropDown._containerClass;
  dropDown._rolloverContainerClass = dropDown._containerClass + q__dropdown_getClassName(rolloverContainerClass);

  dropDown._fieldClass = q__dropdown_getClassName(fieldClass);
  field.className = dropDown._fieldClass;
  dropDown._rolloverFieldClass = dropDown._fieldClass + q__dropdown_getClassName(rolloverFieldClass);

  dropDown._buttonClass = q__dropdown_getClassName(buttonClass);
  button.className = dropDown._buttonClass;
  dropDown._rolloverButtonClass = dropDown._buttonClass + q__dropdown_getClassName(rolloverButtonClass);
  dropDown._pressedButtonClass = dropDown._rolloverButtonClass + q__dropdown_getClassName(pressedButtonClass);

  button._dropDownId = dropDownId;
  button.onclick = function() {
    q__getControl(this._dropDownId)._showHidePopup();
    return false;
  }

  button.onmousedown = function () {
    button.className = dropDown._pressedButtonClass;
  }
  button.onmouseup = function () {
    button.className = dropDown._rolloverButtonClass;
  }

  dropDown._popupClass = q__dropdown_getClassName(popupClass);
  popup.className = dropDown._popupClass;
  dropDown._rolloverPopupClass = dropDown._popupClass + " " + q__dropdown_getClassName(rolloverPopupClass);

  //add onMouseOver style changing
  dropDown.dropDown_mouseover = q__dropDownMouseOver;
  var dropDown_mouseover = q__getEventHandlerFunction('dropDown_mouseover', "'" + dropDownId + "'", dropDown);
  q__addEventHandler(dropDown, "mouseover", dropDown_mouseover);

  //add onMouseOut style changing
  dropDown.dropDown_mouseout = q__dropDownMouseOut;
  var dropDown_mouseout = q__getEventHandlerFunction('dropDown_mouseout', "'" + dropDownId + "'", dropDown);
  q__addEventHandler(dropDown, "mouseout", dropDown_mouseout);

  //set mouse out - over for popup
  q__addEventHandler(popup, "mouseover", dropDown_mouseover);
  q__addEventHandler(popup, "mouseout", dropDown_mouseout);

  //add function to change popup position if window is resized and layout is changed
  dropDown.windowResizeListener = function () {
    var dropDownPopup = q__getControl(dropDown._popupId);
    // drop-down can be removed from the page using Ajax, so we need to check its presense
    if (dropDownPopup && dropDownPopup.isVisible()) {
      q__dropDown_alignPopup(dropDown.id);
    }
  }
  q__addEventHandler(window, "resize", dropDown.windowResizeListener);

  dropDown.dropDown_mouseover = q__dropDownMouseOver;
  var dropDown_mouseover = q__getEventHandlerFunction('dropDown_mouseover', "'" + dropDownId + "'", dropDown);
  q__addEventHandler(dropDown, "mouseover", dropDown_mouseover);

  dropDown.initValue = function (value) {
    field.value = value;
  }

  var hiddenValue = q__getControl(dropDown.id + '::hiddenInitValue');
  setTimeout('q__getControl("' + dropDown.id + '").initValue("' + hiddenValue.value + '");', 0);
}

function q__dropdown_getClassName(param) {
  return param == 'null' ? '' : ' ' + param;
}

function q__dropDownMouseOver(controlId) {
  var dropDown = q__getControl(controlId);
  var field = q__getControl(dropDown._fieldId);
  var button = q__getControl(dropDown._buttonId);
  var popup = q__getControl(dropDown._popupId);

  if (dropDown && dropDown._containerClass != dropDown._rolloverContainerClass)
    dropDown.className = dropDown._rolloverContainerClass;
  if (field && dropDown._fieldClass != dropDown._rolloverFieldClass)
    field.className = dropDown._rolloverFieldClass;
  if (button && dropDown._buttonClass != dropDown._rolloverButtonClass)
    button.className = dropDown._rolloverButtonClass;
  if (popup && dropDown._popupClass != dropDown._rolloverPopupClass)
    popup.className = dropDown._rolloverPopupClass;
  dropDown._mouseOut = false;
  q__repaintAreaForOpera(dropDown, true);
  q__repaintAreaForOpera(popup, true);
}

function q__dropDownMouseOut(controlId) {
  var dropDown = q__getControl(controlId);
  var field = q__getControl(dropDown._fieldId);
  var button = q__getControl(dropDown._buttonId);
  var popup = q__getControl(dropDown._popupId);

  if (dropDown && dropDown._containerClass != dropDown._rolloverContainerClass)
    dropDown.className = dropDown._containerClass;
  if (field && dropDown._fieldClass != dropDown._rolloverFieldClass)
    field.className = dropDown._fieldClass;
  if (button && dropDown._buttonClass != dropDown._rolloverButtonClass)
    button.className = dropDown._buttonClass;
  if (popup && dropDown._popupClass != dropDown._rolloverPopupClass)
    popup.className = dropDown._popupClass;
  dropDown._mouseOut = true;
  q__repaintAreaForOpera(dropDown, true);
  q__repaintAreaForOpera(popup, true);
}

function q__dropDown_initPopup(controlId, calendar) {
  var dropDown = q__getControl(controlId);
  var popup = q__getControl(dropDown._popupId);

  if (calendar) {
    popup.setWidth(calendar.offsetWidth);
  } else {
    if (dropDown._popupInitialized == 0) {
      if (dropDown.offsetWidth > popup.offsetWidth) {
        popup.setWidth(dropDown.offsetWidth);
      }
    }

    if (popup.offsetWidth < dropDown.offsetWidth) {
      popup.style.width = dropDown.offsetWidth + "px";
    }
  }

  q__dropDown_alignPopup(controlId, calendar);
}

function q__dropDown_alignPopup(controlId, calendar) {
  var dropDown = q__getControl(controlId);
  var popup = q__getControl(dropDown._popupId);

  var left;
  var top;
  if (dropDown._listAlignment == 'right' || calendar) { // to the right border
    left = q__getElementLeft(dropDown, false, true) - ((calendar ? calendar.clientWidth : popup.clientWidth) - dropDown.clientWidth);
  } else { // bind drop list to the left border
    left = q__getElementLeft(dropDown, false, true);
  }

  top = q__getElementTop(dropDown, false, true) + dropDown.offsetHeight;

  if ((q__isOpera() || q__isSafari()) && dropDown.offsetParent.tagName.toLowerCase() != 'body') {
    var leftMargin = q__getLeftBodyMargin();
    left -= leftMargin;
    var topMargin = q__getTopBodyMargin();
    top -= topMargin;
  }

  var widthModifier = 0;
  var topModifier = 0;
  var leftModifier = 0;
  if (!q__isExplorer()) {
    var containerClasses = dropDown._containerClass;
    var cssRulesNames = q__getArrayFromString(containerClasses, " ");
    for (var i = 0; i < cssRulesNames.length; i ++) {
      var cssRule = q__findRule('.' + cssRulesNames[i]);
      if (cssRule) {
        if (cssRule.style.marginLeft && cssRule.style.marginLeft.length > 0) {
          var marginLeft = parseInt(cssRule.style.marginLeft);
          widthModifier += marginLeft;
          leftModifier += marginLeft;
        }
        if (cssRule.style.marginRight && cssRule.style.marginRight.length > 0) {
          var marginRight = parseInt(cssRule.style.marginRight);
          widthModifier += marginRight;
        }
        if (cssRule.style.marginTop && cssRule.style.marginTop.length > 0) {
          var marginTop = parseInt(cssRule.style.marginTop);
          topModifier = marginTop;
        }
      }
    }
    var w = popup.offsetWidth;
    w -= widthModifier;
    popup.style.width = w + "px";
  }
  popup.setTop(top - topModifier);
  popup.setLeft(left + leftModifier);
}
