/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */
function q__initDateChooser(dateChooserId,
                            dateFormat,
                            calendarDate,
                            localeStr,
                            valueChangeHandler) {
  var dc = q__getControl(dateChooserId);

  dc._calendar = document.getElementById(dateChooserId + "--popup--calendar");
  //  dc._valueHolderId = dateChooserId + "_valueHolder";

  dc._dateFormat = dateFormat;
  dc._localeStr = localeStr;

  dc._valueChangeHandler = valueChangeHandler;

  var cal = dc._calendar;
  //  var valueHolder = q__getControl(dc._valueHolderId);

  var field = q__getControl(dc._fieldId);
  field.onchange = function(e) {
    if (!e)
      e = event;
    e.cancelBubble = true; // works in IE only
    dc.validateInputAndUpdateCalendar();
  };

  if (valueChangeHandler) {
    dc._prevOnchange = dc.onchange;
    eval('dc._invokeChangeHandler = function(event) {' + valueChangeHandler + '}');
    dc.onchange = function(e) {
      if (e && e.target && e.target == field) // works everywhere except IE
        return;
      if (this._prevOnchange)
        this._prevOnchange();
      dc._invokeChangeHandler(e);
    }
  }

  //  dc.initValue = function (value) {
  //    // DataChooser uses its own way to set value. See tc_dc_updateDateChooser(...)
  //  }

  //  if (date) {
  //    valueHolder.value = date;
  //    var d = new Date();
  //    d.setTime(date);
  //    tc_dc_updateDateChooser(dc.id, d);
  //  } else {
  //    valueHolder.value = "";
  //    tc_dc_updateDateChooser(dc.id);
  //  }

  // Sometimes date chooser may be placed into container with "display: none;".
  // We have to catch the moment when container becomes to displayable one and set the date chooser width
  setTimeout(function() {
    q__dateChooser_checkCalendarWidth(dc.id);
  }, 100);
  //  q__DateChooser_checkCalendarWidth (dc.id);

  dc._showHidePopup = function () {
    q__dc_changeCalendarVisibility(dc.id);
  }

  dc._dateChangeListener = function(date) {
    if (dc._isSetDateFromInput) return;
    var popup = q__getControl(dc._popupId);
    if (self.q_validateById != undefined) {
      if (dc.q_messages) {
        dc.q_messages = undefined;
        q_updateClientMessages();
        q_updateClientMessagesPosition();
      }
    }
    popup.hide();
    q__dc_updateDCField(dc.id, date != null ? new Date(date) : null);
  }
  cal._addDateChangeListener(dc._dateChangeListener);

  dc.validateInputAndUpdateCalendar = function() {
    //  var field = q__getControl(dc._fieldId);
    //    var valueHolder = q__getControl(dc._valueHolderId);
    /*
        var formatter = new DateChooserAjaxDateFormatter();
        formatter.validateAndParse(field.value);
    */
    var date;
    if (self.q_validateById != undefined) {
      var converters = q_getValidators(dc);
      for (var i = 0; i < converters.length; i ++) {
        var v = converters[i];
        if (v instanceof q_DateTimeConverterValidator) {
          if (dc.q_messages) {
            dc.q_messages = undefined;
          }
          //          dc._isManualValidation = true;
          var result = v.validate(dc);
          //          dc._isManualValidation = false;
          //          if (result[0] == 'true' || result[0] == true) {
          if (result && result instanceof Date) {
            date = result;
          }
          dc.valid = result ? true : false;
          //            }
          //            q_updateClientMessages();
          //            q_updateClientMessagesPosition();
          //          } else {
          q_updateClientMessages();
          q_updateClientMessagesPosition();
          //          }
          break;
        }
      }
    }
    /*
        var dtf = q__getDateTimeFormatObject(dc._localeStr);
        if (!dtf) return;
        var date = dtf.parse(field.value, dc._dateFormat, valueHolder.value);
    */
    dc._isSetDateFromInput = true;
    q_setSelectedDate(dc._calendar.id, date);
    dc._isSetDateFromInput = false;
    if (!dc._updatingField && dc.onchange) {
      q__sendEvent(dc, "change");
    }
  }

  // Hide popup default border for date chooser
  var popup = q__getControl(dc._popupId);
  popup.style.borderWidth = "0px";

  dc.q_clientValueFunctionExist = true;
  dc.q_clientValueFunction = function () {
    return q__getControl(dc._fieldId).value;
    /*
        var valueHolder = q__getControl(dc._valueHolderId);
        return valueHolder.value;
    */
  }

  popup._addVisibilityChangeListener(function () {
    var lastHoveredCell = dc._calendar._lastHoveredCell;
    if (lastHoveredCell)
      lastHoveredCell.onmouseout();
  });

  // Related to JSFC-2042. Adjust date for calendar inner component.
  if (calendarDate) {
    var clientTimeZoneOffset = new Date().getTimezoneOffset();
    var dateToAdjust = calendarDate + 60 * 1000 * clientTimeZoneOffset;
    var valueHolder = q__getControl(cal._valueHolderId);
    valueHolder.value = dateToAdjust;
    q__updateCalendar(cal, new Date(dateToAdjust));
  }

}

function q__showCalendar(controlId) {
  var dc = q__getControl(controlId);
  var popup = q__getControl(dc._popupId);
  popup.show();
}

function q__hideCalendar(controlId) {
  var dc = q__getControl(controlId);
  var popup = q__getControl(dc._popupId);
  popup.hide();
}

function q__dc_changeCalendarVisibility(controlId) {
  var dc = q__getControl(controlId);
  var popup = q__getControl(dc._popupId);
  var calendar = dc._calendar;
  q__dropDown_initPopup(controlId, calendar);
  if (popup.isVisible()) {
    popup.hide();
  } else {
    popup.show();
  }
  if (q__isOpera()) {
    var body = document.getElementsByTagName("body")[0];
    body.style.visibility = "hidden";
    body.style.visibility = "visible";
  }
}

function q__dc_updateDCField(controlId, date) {
  var dc = q__getControl(controlId);
  //  var valueHolder = q__getControl(dc._valueHolderId);
  var field = q__getControl(dc._fieldId);
  //  var oldValue = valueHolder.value;
  if (date) {
    var dtf = q__getDateTimeFormatObject(dc._localeStr);
    if (!dtf) return;
    var sDate = dtf.format(date, dc._dateFormat);
    dc._updatingField = true;
    if (field.value != sDate) {
      try {
        field.value = sDate;
      } finally {
        dc._updatingField = false;
      }
      if (dc.onchange)
        q__sendEvent(dc, "change");
    }
    //    valueHolder.value = date.getTime();
  } else {
    if (field.value != "") {
      dc._updatingField = true;
      try {
        field.value = "";
      } finally {
        dc._updatingField = false;
      }
      if (dc.onchange)
        q__sendEvent(dc, "change");
    }

  }
  //  if (valueHolder.value != oldValue && dc._onValueChange) {
  //    dc._onValueChange();
  //  }
  if (q__isOpera()) {
    var body = document.getElementsByTagName("body")[0];
    body.style.visibility = "hidden";
    body.style.visibility = "visible";
  }
}

function q__getDate(dcId) {
  var dc = q__getControl(dcId);
  var date = q_getSelectedDate(dc._calendar.id);
  return date;
}

function q__setDate(dcId, date) {
  var dc = q__getControl(dcId);
  q_setSelectedDate(dc._calendar.id, date);
}

function q__dateChooser_checkCalendarWidth(dcId) {
  var dc = q__getControl(dcId);
  var cal = dc._calendar;
  if (cal.offsetWidth != 0) {
    dc.style.width = cal.offsetWidth + "px";
    dc.style.visibility = "visible";
    q__repaintAreaForOpera(dc, true);
  } else {
    setTimeout(function() {
      q__dateChooser_checkCalendarWidth(dcId)
    }, 100);
  }
}

////DateChooser inputted value validator, formatter and parser object
//
//function DateChooserAjaxDateFormatter() {
//}
//
//DateChooserAjaxDateFormatter.prototype.validateAndParse = function(inputtedValue) {
//  alert(inputtedValue);
//  try {
//    var requestHelper = new RequestHelper();
//
//    var param = {
//      value: inputtedValue
//    };
//    var result = requestHelper.call("?validator=dateTimeConverter", param, [{name:'teamdev_ajax_datechooser_VALIDATOR',value:'values'}]);
//    alert(result);
//  } catch (x) {
//  }
//  return result;
//}