/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

//todo: only date formatting supported
function DateTimeFormat(month, shortMonth, weekdays, shortWeekdays) {
  this.PATTERN_CHARS = "GyMdkHmsSEDFwWahKzZ";
  this.CURRENTLY_SUPPORTED_PATTERN_CHARS = 'yMdE';
  //todo: ideally, PARENT_CHARS chars should be supported for full featured formatting

  this.MONTHS = month;
  this.SHORT_MONTHS = shortMonth;
  this.WEEKDAYS = weekdays;
  this.SHORT_WEEKDAYS = shortWeekdays;

}

DateTimeFormat.prototype.parse = function(val, format, currentValue) {
  if (val != null && val.length == 0) return null;
  var date;
  var dateComplete = false;
  var month;
  var monthComplete = false;
  var year;
  var yearComplete = false;
  var sDate = val;

  var oldDate = new Date();
  if (currentValue && currentValue != "") {
    oldDate.setTime(currentValue);
  }

  //1. transform '[]' parts to [] parts
  var tempFormat = format;
  var re = /'(.+?)'/
  while (re.test(tempFormat)) {
    tempFormat = tempFormat.replace(re, RegExp.$1);
  }
  //2. try to find date by pattern

  var foundMatches = new Array();
  var iterator = 0;
  for (var i = 0; i < this.CURRENTLY_SUPPORTED_PATTERN_CHARS.length; i ++) {
    var letter = this.CURRENTLY_SUPPORTED_PATTERN_CHARS.charAt(i);
    var regexp = new RegExp('(' + letter + '+)');
    while (regexp.test(tempFormat)) {
      foundMatches[iterator] = RegExp.$1;
      tempFormat = tempFormat.replace(foundMatches[iterator], '[' + iterator + ']');
      iterator ++;
    }
  }

  var regexp = new RegExp('\\[(.+?)\\]');
  var matchCounter = 0;
  while (matchCounter < foundMatches.length) {
    var match = regexp.exec(tempFormat);
    if (match) {
      var prefix = tempFormat.substring(0, match.index);
      if (prefix) {
        var prefLen = prefix.length;
        var prefix_sDate = sDate.substring(0, match.index);
        if (prefix.toLowerCase() != prefix_sDate.toLowerCase()) {
//          alert("Incorrect format " + format + " for date " + val);
          alert("The entered date " + val + " is incorrectly formatted. It must have the following format: " + format);
          return null;
        }
        tempFormat = tempFormat.substring(prefLen);
        sDate = sDate.substring(prefLen);
      }
      var fmIndex = match[1];
      var pat = foundMatches[fmIndex];
      if (pat.charAt(0) == 'y') {
        if (pat.length < 3) {
          var currentYear = new Date().getFullYear();

          var curYearPref = currentYear.toString().substring(0, 2);
          var cys = parseInt(currentYear.toString().substring(2));
          var cyp = parseInt(curYearPref);
          var yearPart = sDate.substring(0, 2);
          try {
            var iyearPart = parseInt(yearPart);
            var absValue = Math.abs(cys - iyearPart);
            if (absValue > 20) {
              currentYear = currentYear - iyearPart;
              curYearPref = currentYear.toString().substring(0, 2);
            }
          } catch (e) {
//            alert("Incorrect format " + format + " for date " + val);
            alert("The entered date " + val + " is incorrectly formatted. It must have the following format: " + format);
            return null;
          }
          year = curYearPref + yearPart;
          sDate = sDate.substring(2);
        } else {
          year = sDate.substring(0, 4);
          sDate = sDate.substring(4);
        }
        yearComplete = true;
      } else if (pat.charAt(0) == 'M') {
        if (pat.length < 3) {
          month = sDate.substring(0, 2);
          sDate = sDate.substring(month.length);
          month = month - 1;
          monthComplete = true;
        } else if (pat.length == 3) {
          for (var i = 0; i < this.SHORT_MONTHS.length; i ++) {
            var _m = this.unescapeHtml(this.SHORT_MONTHS[i]);
            var _sDate_month = sDate.substring(0, _m.length);
            if (_sDate_month.toLowerCase() == _m.toLowerCase()) {
              sDate = sDate.substring(_sDate_month.length);
              month = i;
              monthComplete = true;
              break;
            } else {
              monthComplete = false;
            }
          }
        } else if (pat.length > 3) {
          for (var i = 0; i < this.MONTHS.length; i ++) {
            var _m = this.unescapeHtml(this.MONTHS[i]);
            var _sDate_month = sDate.substring(0, _m.length);
            if (_sDate_month.toLowerCase() == _m.toLowerCase()) {
              sDate = sDate.substring(_sDate_month.length);
              month = i;
              monthComplete = true;
              break;
            } else {
              monthComplete = false;
            }
          }
        }
      } else if (pat.charAt(0) == 'd') {
        date = sDate.substring(0, 2);
        sDate = sDate.substring(2);
        dateComplete = true;
      } else {
        if (pat.charAt(0) == 'E') {
          var found = false;
          if (pat.length < 4) {
            for (var i = 0; i < this.SHORT_WEEKDAYS.length; i ++) {
              var _weekDay = this.unescapeHtml(this.SHORT_WEEKDAYS[i]);
              if (sDate.toLowerCase().indexOf(_weekDay.toLowerCase()) > -1) {
                sDate = sDate.substring(_weekDay.length);
                found = true;
                break;
              }
            }
          } else {
            for (var i = 0; i < this.WEEKDAYS.length; i ++) {
              var _weekDay = this.unescapeHtml(this.WEEKDAYS[i]);
              if (sDate.toLowerCase().indexOf(_weekDay.toLowerCase()) > -1) {
                sDate = sDate.substring(_weekDay.length);
                found = true;
                break;
              }
            }
          }
          if (!found) {
//            alert("Incorrect format " + format + " for date " + val);
            alert("The entered date " + val + " is incorrectly formatted. It must have the following format: " + format);
            return null;
          }
        }
      }
      tempFormat = tempFormat.substring(match[0].length)
    } else {
//      alert("Incorrect format " + format + " for date " + val);
      alert("The entered date " + val + " is incorrectly formatted. It must have the following format: " + format);
      return null;
    }
    matchCounter ++;
  }

  var parsedDate = new Date();

  if (dateComplete) {
    parsedDate.setDate(date);
  } else {
    parsedDate.setDate(oldDate.getDate());
  }
  if (monthComplete) {
    parsedDate.setMonth(month);
  } else {
    parsedDate.setMonth(oldDate.getMonth());
  }
  if (yearComplete) {
    parsedDate.setFullYear(year);
  } else {
    parsedDate.setFullYear(oldDate.getFullYear());
  }
  return parsedDate;
}

DateTimeFormat.prototype.format = function(dDate, format) {
  var day = dDate.getDay();
  var date = dDate.getDate();
  var month = dDate.getMonth();
  var year = dDate.getFullYear();
  var hours = dDate.getHours();
  var minutes = dDate.getMinutes();
  var seconds = dDate.getSeconds();
  var millis = dDate.getMilliseconds();

  var foundMatches = new Array();
  var iterator = 0;
  for (var i = 0; i < this.CURRENTLY_SUPPORTED_PATTERN_CHARS.length; i ++) {
    var letter = this.CURRENTLY_SUPPORTED_PATTERN_CHARS.charAt(i);
    var regexp = new RegExp('(' + letter + '+)');
    while (regexp.test(format)) {
      foundMatches[iterator] = RegExp.$1;
      format = format.replace(foundMatches[iterator], '[' + iterator + ']');
      iterator ++;
    }
  }

  for (var i = 0; i < foundMatches.length; i ++) {
    var match = foundMatches[i];
    var re = '\\[' + i + '\\]';
    var toReplace = new RegExp(re, "g");
    if (match.charAt(0) == 'y') {
      if (match.length < 3) {
        format = format.replace(toReplace, year.toString().substring(2))
      } else {
        format = format.replace(toReplace, year.toString());
      }
    } else if (match.charAt(0) == 'M') {
      if (match.length < 3) {
        var mn = month + 1;
        if (mn.toString().length == 1) {
          format = format.replace(toReplace, "0" + mn);
        } else {
          format = format.replace(toReplace, mn);
        }
      } else if (match.length == 3) {
        format = format.replace(toReplace, this.SHORT_MONTHS[month]);
      } else {
        format = format.replace(toReplace, this.MONTHS[month]);
      }
    } else if (match.charAt(0) == 'd') {
      if (date.toString().length == 1) {
        format = format.replace(toReplace, "0" + date);
      } else {
        format = format.replace(toReplace, date);
      }
    } else if (match.charAt(0) == 'E') {
      if (match.length < 4) {
        format = format.replace(toReplace, this.SHORT_WEEKDAYS[day]);
      } else {
        format = format.replace(toReplace, this.WEEKDAYS[day]);
      }
    } else {
      //todo: other formattings
    }
  }
  //transform html special character codes to ordinal characters
  format = this.unescapeHtml(format);

  re = /'(.+?)'/
  while (re.test(format)) {
    format = format.replace(re, RegExp.$1);
  }
  return format;
}

DateTimeFormat.prototype.unescapeHtml = function(val) {
  var re = /\&\#(\d+)\;/
  while (re.test(val)) {
    val = val.replace(re, String.fromCharCode(RegExp.$1));
  }
  return val;
}

DateTimeFormat.prototype.getMonths = function() {
  return this.MONTHS;
}

DateTimeFormat.prototype.getShortMonths = function () {
  return this.SHORT_MONTHS;
}

DateTimeFormat.prototype.getWeekdays = function() {
  return this.WEEKDAYS;
}

DateTimeFormat.prototype.getShortWeekdays = function() {
  return this.SHORT_WEEKDAYS;
}