/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeriesDataItemTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TimeSeriesDataItemTests.class);
    }

    public TimeSeriesDataItemTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        TimeSeriesDataItem item = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItemTests.assertTrue((boolean)item.equals(item));
    }

    public void testEquals() {
        TimeSeriesDataItem item1 = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItem item2 = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItemTests.assertTrue((boolean)item1.equals(item2));
        TimeSeriesDataItemTests.assertTrue((boolean)item2.equals(item1));
        item1.setValue(new Integer(5));
        TimeSeriesDataItemTests.assertFalse((boolean)item1.equals(item2));
        item2.setValue(new Integer(5));
        TimeSeriesDataItemTests.assertTrue((boolean)item1.equals(item2));
    }

    public void testSerialization() {
        TimeSeriesDataItem item1 = new TimeSeriesDataItem((RegularTimePeriod)new Day(23, 9, 2001), 99.7);
        TimeSeriesDataItem item2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(item1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            item2 = (TimeSeriesDataItem)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TimeSeriesDataItemTests.assertEquals((Object)item1, item2);
    }
}

