/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.Year;

public class TimePeriodValuesTests
extends TestCase {
    private TimePeriodValues seriesA;
    private TimePeriodValues seriesB;
    private TimePeriodValues seriesC;

    public static Test suite() {
        return new TestSuite(TimePeriodValuesTests.class);
    }

    public TimePeriodValuesTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.seriesA = new TimePeriodValues("Series A");
        try {
            this.seriesA.add((TimePeriod)new Year(2000), new Integer(102000));
            this.seriesA.add((TimePeriod)new Year(2001), new Integer(102001));
            this.seriesA.add((TimePeriod)new Year(2002), new Integer(102002));
            this.seriesA.add((TimePeriod)new Year(2003), new Integer(102003));
            this.seriesA.add((TimePeriod)new Year(2004), new Integer(102004));
            this.seriesA.add((TimePeriod)new Year(2005), new Integer(102005));
        }
        catch (SeriesException e) {
            System.err.println("Problem creating series.");
        }
        this.seriesB = new TimePeriodValues("Series B");
        try {
            this.seriesB.add((TimePeriod)new Year(2006), new Integer(202006));
            this.seriesB.add((TimePeriod)new Year(2007), new Integer(202007));
            this.seriesB.add((TimePeriod)new Year(2008), new Integer(202008));
        }
        catch (SeriesException e) {
            System.err.println("Problem creating series.");
        }
        this.seriesC = new TimePeriodValues("Series C");
        try {
            this.seriesC.add((TimePeriod)new Year(1999), new Integer(301999));
            this.seriesC.add((TimePeriod)new Year(2000), new Integer(302000));
            this.seriesC.add((TimePeriod)new Year(2002), new Integer(302002));
        }
        catch (SeriesException e) {
            System.err.println("Problem creating series.");
        }
    }

    public void testClone() {
        TimePeriodValues series = new TimePeriodValues("Test Series");
        Day jan1st2002 = new Day(1, 1, 2002);
        try {
            series.add((TimePeriod)jan1st2002, new Integer(42));
        }
        catch (SeriesException e) {
            System.err.println("Problem adding to collection.");
        }
        TimePeriodValues clone = null;
        try {
            clone = (TimePeriodValues)series.clone();
            clone.setKey((Comparable)((Object)"Clone Series"));
            try {
                clone.update(0, new Integer(10));
            }
            catch (SeriesException e) {
                System.err.println("Problem updating series.");
            }
        }
        catch (CloneNotSupportedException e) {
            TimePeriodValuesTests.assertTrue((boolean)false);
        }
        int seriesValue = series.getValue(0).intValue();
        int cloneValue = clone.getValue(0).intValue();
        TimePeriodValuesTests.assertEquals((int)42, (int)seriesValue);
        TimePeriodValuesTests.assertEquals((int)10, (int)cloneValue);
        TimePeriodValuesTests.assertEquals((Object)"Test Series", (Object)series.getKey());
        TimePeriodValuesTests.assertEquals((Object)"Clone Series", (Object)clone.getKey());
    }

    public void testAddValue() {
        TimePeriodValues tpvs = new TimePeriodValues("Test");
        try {
            tpvs.add((TimePeriod)new Year(1999), new Integer(1));
        }
        catch (SeriesException e) {
            System.err.println("Problem adding to series.");
        }
        int value = tpvs.getValue(0).intValue();
        TimePeriodValuesTests.assertEquals((int)1, (int)value);
    }

    public void testSerialization() {
        TimePeriodValues s1 = new TimePeriodValues("A test");
        s1.add((TimePeriod)new Year(2000), 13.75);
        s1.add((TimePeriod)new Year(2001), 11.9);
        s1.add((TimePeriod)new Year(2002), null);
        s1.add((TimePeriod)new Year(2005), 19.32);
        s1.add((TimePeriod)new Year(2007), 16.89);
        TimePeriodValues s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(s1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            s2 = (TimePeriodValues)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TimePeriodValuesTests.assertTrue((boolean)s1.equals(s2));
    }

    public void testEquals() {
        TimePeriodValues s1 = new TimePeriodValues("Time Series 1");
        TimePeriodValues s2 = new TimePeriodValues("Time Series 2");
        boolean b1 = s1.equals(s2);
        TimePeriodValuesTests.assertFalse((String)"b1", (boolean)b1);
        s2.setKey((Comparable)((Object)"Time Series 1"));
        boolean b2 = s1.equals(s2);
        TimePeriodValuesTests.assertTrue((String)"b2", (boolean)b2);
        Day p1 = new Day();
        RegularTimePeriod p2 = ((RegularTimePeriod)p1).next();
        s1.add((TimePeriod)p1, 100.0);
        s1.add((TimePeriod)p2, 200.0);
        boolean b3 = s1.equals(s2);
        TimePeriodValuesTests.assertFalse((String)"b3", (boolean)b3);
        s2.add((TimePeriod)p1, 100.0);
        s2.add((TimePeriod)p2, 200.0);
        boolean b4 = s1.equals(s2);
        TimePeriodValuesTests.assertTrue((String)"b4", (boolean)b4);
    }

    public void test1161329() {
        TimePeriodValues tpv = new TimePeriodValues("Test");
        RegularTimePeriod t = new Day();
        tpv.add((TimePeriod)t, 1.0);
        t = ((RegularTimePeriod)t).next();
        tpv.add((TimePeriod)t, 2.0);
        tpv.delete(0, 1);
        TimePeriodValuesTests.assertEquals((int)0, (int)tpv.getItemCount());
        tpv.add((TimePeriod)t, 2.0);
        TimePeriodValuesTests.assertEquals((int)1, (int)tpv.getItemCount());
    }
}

